/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.video;

import com.trs.components.video.IConfigManager;
import com.trs.components.video.system.Version;
import com.trs.dl.util.LangUtil;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.Config;
import com.trs.infra.support.config.ConfigServer;
import org.apache.log4j.Logger;

public class WCMConfigServerBasedManager
implements IConfigManager {
    private Version version = new Version();
    private static Logger s_logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.components.video.WCMConfigServerBasedManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    public void reloadConfigs() {
    }

    public String getUploadFMSAppUrl() {
        return this.getURL("wcmvideo.uploadFMSAppUrl");
    }

    public void setUploadFMSAppUrl(String url) {
        String key = "wcmvideo.uploadFMSAppUrl";
        this.creatOrUpdateConfig(key, url);
    }

    public String getDownloadHomeUrl() {
        String value = this.getValue("wcmvideo.downloadHomeUrl");
        if (value == null) {
            throw new IllegalStateException("the property wcmvideo.downloadHomeUrl not configed!");
        }
        if ((value = value.trim()).length() == 0) {
            throw new IllegalStateException("the property wcmvideo.downloadHomeUrl configed is empty!");
        }
        if (!value.endsWith("/")) {
            value = String.valueOf(value) + "/";
        }
        return value;
    }

    public String getFLVPlayerBase() {
        return this.getValue("wcmvideo.flvplayerBase");
    }

    public String getHighQualityIp() {
        return this.getValue("wcmvideo.highQualityIp");
    }

    public String getRecordFMSAppUrl() {
        return this.getURL("wcmvideo.recordFMSAppUrl");
    }

    public String getTRSMASVersion() {
        return this.getValue("trsmas.version");
    }

    public String getThumbsHomeUrl() {
        return this.getURL("wcmvideo.thumbsHomeUrl");
    }

    public String getURL(String key) {
        String value = null;
        try {
            value = ConfigServer.getServer().getSysConfigValue(key, null);
            if (value != null) {
                value = value.trim();
            }
        }
        catch (WCMException e) {
            s_logger.error((Object)"\u6ca1\u6709\u83b7\u53d6\u5230\u6b64\u914d\u7f6e", (Throwable)e);
        }
        return LangUtil.removeLastSlashChar((String)value);
    }

    public String getUploadJavaAppIntranetUrl() {
        String intranetUrl = this.getURL("wcmvideo.uploadJavaAppIntranetUrl");
        if (intranetUrl == null || intranetUrl.trim().length() == 0) {
            return this.getUploadJavaAppUrl();
        }
        return intranetUrl;
    }

    public String getUploadJavaAppUrl() {
        return this.getURL("wcmvideo.uploadJavaAppUrl");
    }

    public String getValue(String key) {
        String value = null;
        try {
            value = ConfigServer.getServer().getSysConfigValue(key, null);
            if (value != null) {
                value = value.trim();
            }
        }
        catch (WCMException e) {
            s_logger.error((Object)e.getMessage());
        }
        return value;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean isHighQualityIp(String ip) {
        if ("127.0.0.1".equals(ip) || "localhost".equals(ip)) {
            return true;
        }
        String highQualityIp = this.getHighQualityIp();
        if (highQualityIp == null || ip == null) {
            return false;
        }
        String ips = String.valueOf(ip.substring(0, ip.lastIndexOf(46))) + ".*";
        return highQualityIp.indexOf(ips) != -1 || highQualityIp.indexOf(ip) != -1;
    }

    public void setBitrates(String bit) {
        String key = "wcmvideo.bitrates";
        this.creatOrUpdateConfig(key, bit);
    }

    public void setDownloadHomeUrl(String url) {
        String key = "wcmvideo.downloadHomeUrl";
        this.creatOrUpdateConfig(key, url);
    }

    public void setFLVPlayerBase(String url) {
        String key = "wcmvideo.flvplayerBase";
        this.creatOrUpdateConfig(key, url);
    }

    public void setHighQualityIp(String ip) {
        String key = "wcmvideo.highQualityIp";
        this.creatOrUpdateConfig(key, ip);
    }

    public void setRecordFMSAppUrl(String url) {
        String key = "wcmvideo.recordFMSAppUrl";
        this.creatOrUpdateConfig(key, url);
    }

    public void setTRSMASVersion(String masVersion) {
        String key = "trsmas.version";
        this.creatOrUpdateConfig(key, masVersion);
    }

    public void setThumbsHomeUrl(String url) {
        String key = "wcmvideo.thumbsHomeUrl";
        this.creatOrUpdateConfig(key, url);
    }

    public void setUploadJavaAppIntranetUrl(String url) {
        String key = "wcmvideo.uploadJavaAppIntranetUrl";
        this.creatOrUpdateConfig(key, url);
    }

    public void setUploadJavaAppUrl(String url) {
        String key = "wcmvideo.uploadJavaAppUrl";
        this.creatOrUpdateConfig(key, url);
    }

    public void setMASIP(String ip) {
        String key = "trsmas.ip";
        this.creatOrUpdateConfig(key, ip);
    }

    private void creatOrUpdateConfig(String key, String value) {
        try {
            Config config = ConfigServer.getServer().getSysConfig(key);
            if (config == null) {
                Config currConfig = Config.createNewInstance();
                currConfig.setNextId();
                currConfig.setConfigKey(key);
                currConfig.setValue(value);
                currConfig.setType(20);
                currConfig.setProperty("encrypted", 0L);
                currConfig.save();
            } else {
                config.setValue(value);
                config.save();
            }
        }
        catch (WCMException e) {
            s_logger.error((Object)e.getMessage());
        }
    }

    public String getChnId() {
        return this.getValue("wcmvideo.receiveid");
    }

    public String getAppKey() {
        return this.getValue("appkey");
    }

    public String getMASIP() {
        return this.getValue("trsmas.ip");
    }

    public String getThumbRootUrl() {
        return this.getValue("wcmvideo.thumbrooturl");
    }

    public void setThumbRootUrl(String url) {
        String key = "wcmvideo.thumbrooturl";
        this.creatOrUpdateConfig(key, url);
    }

    public String getVideoRootUrl() {
        return this.getValue("wcmvideo.videorooturl");
    }

    public void setChnId(String id) {
        String key = "wcmvideo.receiveid";
        this.creatOrUpdateConfig(key, id);
    }

    public void setAppKey(String appkey) {
        String key = "appkey";
        this.creatOrUpdateConfig(key, appkey);
    }

    public void setVideoRootUrl(String url) {
        String key = "wcmvideo.videorooturl";
        this.creatOrUpdateConfig(key, url);
    }

    public String getMaxPostSize() {
        return this.getValue("wcmvideo.maxpostsize");
    }

    public void setMaxPostSize(String size) {
        String key = "wcmvideo.maxpostsize";
        this.creatOrUpdateConfig(key, size);
    }

    public void setExtUpload(String upload) {
        String key = "wcmvideo.extupload";
        this.creatOrUpdateConfig(key, upload);
    }

    public String getExtUpload() {
        return this.getValue("wcmvideo.extupload");
    }

    public void setFckPlayerHeight(String height) {
        String key = "wcmvideo.fckPlayerHeight";
        this.creatOrUpdateConfig(key, height);
    }

    public void setFckPlayerWidth(String width) {
        String key = "wcmvideo.fckPlayerWidth";
        this.creatOrUpdateConfig(key, width);
    }

    public void setFckPlayerLOGO(String logo) {
        String key = "wcmvideo.fckPlayerLogo";
        this.creatOrUpdateConfig(key, logo);
    }

    public void setFckPlayerAutoplay(String autoplay) {
        String key = "wcmvideo.fckPlayerAutoplay";
        this.creatOrUpdateConfig(key, autoplay);
    }

    public String getFckPlayerHeight() {
        return this.getValue("wcmvideo.fckPlayerHeight");
    }
}

