/*
 * Decompiled with CFR 0.152.
 */
package com.trsupdate;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.RightCacheMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Right;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyBitsValue;
import com.trs.infra.util.DebugTimer;
import com.trsupdate.InheritInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class WCM52InheritRight2WCM65Updater {
    private RightCacheMgr rightCacheMgr = (RightCacheMgr)DreamFactory.createObjectById("RightCacheMgr");
    private List m_listInheritInfo = null;
    private static Logger logger = Logger.getLogger(WCM52InheritRight2WCM65Updater.class);
    private User m_oUser = null;
    private boolean m_bInsertDB = true;

    public WCM52InheritRight2WCM65Updater(List list) {
        this.m_listInheritInfo = list;
    }

    public List update() throws WCMException {
        logger.warn((Object)"The system begin to create rights.....");
        this.m_oUser = User.findByName("admin");
        ArrayList arrayList = new ArrayList();
        DebugTimer debugTimer = new DebugTimer();
        debugTimer.start();
        DebugTimer debugTimer2 = new DebugTimer();
        int n = this.m_listInheritInfo.size();
        for (int i = 0; i < n; ++i) {
            InheritInfo inheritInfo = (InheritInfo)this.m_listInheritInfo.get(i);
            Users users = inheritInfo.getUsers();
            debugTimer2.start();
            Roles roles = new Roles(null);
            Groups groups = new Groups(null);
            int n2 = users.size();
            for (int j = 0; j < n2; ++j) {
                User user = (User)users.getAt(j);
                this.makeInheritRights(user, inheritInfo.getChannel(), arrayList, roles, groups);
            }
            debugTimer2.stop();
        }
        debugTimer.stop();
        logger.warn((Object)("The system end to create rights!use[" + debugTimer.getTime() + "]ms"));
        return arrayList;
    }

    private List makeInheritRights(User user, Channel channel, List list, Roles roles, Groups groups) throws WCMException {
        Groups groups2 = user.getGroups();
        Roles roles2 = user.getRoles();
        boolean bl = false;
        for (BaseChannel baseChannel = channel.getHost(); baseChannel != null; baseChannel = baseChannel.getHost()) {
            Right right;
            CMSObj cMSObj;
            int n;
            long l = this.makeRightValue(baseChannel, user);
            if (l != -1L) {
                Right right2 = new Right();
                right2.setValue(l);
                right2.setOperator(user);
                this.saveRight(right2, channel);
                list.add(right2);
                return list;
            }
            int n2 = groups2.size();
            for (n = 0; n < n2; ++n) {
                cMSObj = (Group)groups2.getAt(n);
                l = this.makeRightValue(baseChannel, cMSObj);
                if (l == -1L) continue;
                bl = true;
                if (groups.indexOf(cMSObj) >= 0) continue;
                groups.addElement(cMSObj);
                right = new Right();
                right.setValue(l);
                right.setOperator(cMSObj);
                this.saveRight(right, channel);
                list.add(right);
            }
            n2 = roles2.size();
            for (n = 0; n < n2; ++n) {
                cMSObj = (Role)roles2.getAt(n);
                l = this.makeRightValue(baseChannel, cMSObj);
                if (l == -1L) continue;
                bl = true;
                if (roles.indexOf(cMSObj) >= 0) continue;
                roles.addElement(cMSObj);
                right = new Right();
                right.setValue(l);
                right.setOperator(cMSObj);
                this.saveRight(right, channel);
                list.add(right);
            }
            if (!bl) continue;
            return list;
        }
        throw new WCMException("\u8ba1\u7b97\u9519\u8bef\uff0c\u4e0d\u53ef\u80fd\u6ca1\u6709\u4efb\u4f55\u7ee7\u627f\u7684\u6743\u9650\uff01User=[" + user + "] Channel=[" + channel + "]");
    }

    private void saveRight(Right right, Channel channel) throws WCMException {
        if (this.m_bInsertDB) {
            try {
                right.setObject(101, channel.getId());
                right.insert(this.m_oUser);
            }
            catch (Exception exception) {
                logger.error((Object)("Error to save right![ChannelId=" + channel.getId() + "][OprType" + right.getOperatorType() + ", OprId=" + right.getOperatorId() + "]"), (Throwable)exception);
            }
        }
    }

    private long makeRightValue(BaseChannel baseChannel, CMSObj cMSObj) throws WCMException {
        long l = this.rightCacheMgr.getRightValue(baseChannel.getWCMType(), baseChannel.getId(), cMSObj.getWCMType(), cMSObj.getId(), -1L);
        if (l == -1L) {
            return l;
        }
        CMyBitsValue cMyBitsValue = new CMyBitsValue(l);
        for (int i = 0; i < 11; ++i) {
            cMyBitsValue.setBit(i, false);
        }
        long l2 = cMyBitsValue.getValue();
        if (l2 == 0L) {
            return -1L;
        }
        return l2;
    }
}

