/*
 * Decompiled with CFR 0.152.
 */
package com.trsupdate;

import com.trs.DreamFactory;
import com.trs.cms.auth.config.OperationConfig;
import com.trs.cms.auth.config.OperationRelatedConfig;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Right;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.Rights;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObjDefaultImpl;
import com.trs.components.wcm.content.domain.SiteMemberMgr;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.ConfigConstants;
import com.trs.infra.config.XMLConfigServer;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.CMyResultSet;
import com.trs.infra.persistent.CMyResultSets;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyBitsValue;
import com.trs.infra.util.WCMDiscoveryFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RightUpdaterForUser {
    private static Logger logger = Logger.getLogger(RightUpdaterForUser.class);
    private static boolean IS_DEBUG = false;
    private static final long IGNORE_RIGHTVALUE_OF_SITE = -68170725458047L;
    private User m_oCurrUser = null;
    private Map m_mapChannelDefineRightCache = null;
    private String m_sTableNameOfWCM52Right = null;
    private Groups m_oGroupsOfUser = null;
    private Roles m_oRolesOfUser = null;
    private HashMap m_oSiteRightValueCache = new HashMap(70);
    private static HashMap m_hsDependIndexs = null;
    private static HashMap m_hsV6Mapping52Indexs = null;
    private static HashMap m_hsChnlValues;

    public RightUpdaterForUser(User user, String string) {
        this.m_oCurrUser = user;
        this.m_sTableNameOfWCM52Right = string;
    }

    private static void initMappingIndexs() {
        m_hsV6Mapping52Indexs = new HashMap();
        ArrayList<Integer> arrayList = null;
        arrayList = new ArrayList<Integer>();
        m_hsV6Mapping52Indexs.put(new Integer(24), arrayList);
        arrayList.add(new Integer(21));
        arrayList.add(new Integer(25));
        arrayList = new ArrayList();
        m_hsV6Mapping52Indexs.put(new Integer(25), arrayList);
        arrayList.add(new Integer(24));
        arrayList = new ArrayList();
        m_hsV6Mapping52Indexs.put(new Integer(29), arrayList);
        arrayList.add(new Integer(24));
    }

    private static void initSomeDependIndexs() {
        ArrayList<Integer> arrayList = null;
        arrayList = new ArrayList<Integer>();
        m_hsDependIndexs.put(new Integer(23), arrayList);
        arrayList.add(new Integer(24));
        arrayList = new ArrayList();
        m_hsDependIndexs.put(new Integer(15), arrayList);
        arrayList.add(new Integer(28));
        arrayList = new ArrayList();
        m_hsDependIndexs.put(new Integer(17), arrayList);
        arrayList.add(new Integer(28));
        arrayList = new ArrayList();
        m_hsDependIndexs.put(new Integer(40), arrayList);
        arrayList.add(new Integer(54));
        arrayList = new ArrayList();
        m_hsDependIndexs.put(new Integer(1), arrayList);
        arrayList.add(new Integer(7));
        arrayList = new ArrayList();
        m_hsDependIndexs.put(new Integer(13), arrayList);
        arrayList.add(new Integer(8));
        arrayList.add(new Integer(55));
        arrayList = new ArrayList();
        m_hsDependIndexs.put(new Integer(33), arrayList);
        arrayList.add(new Integer(56));
        arrayList = new ArrayList();
        m_hsDependIndexs.put(new Integer(24), arrayList);
        arrayList.add(new Integer(14));
        arrayList = new ArrayList();
        m_hsDependIndexs.put(new Integer(14), arrayList);
        arrayList.add(new Integer(53));
    }

    private static RightValue renderDiffIdxRight(RightValue rightValue) {
        Object object;
        ArrayList<RightValue> arrayList = new ArrayList<RightValue>();
        for (int i = 0; i < 64; ++i) {
            object = (List)m_hsV6Mapping52Indexs.get(new Integer(i));
            if (object == null || !rightValue.getBit(i)) continue;
            RightValue rightValue2 = new RightValue();
            rightValue2.setValue(0L);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                rightValue2.setBit(n, true);
            }
            arrayList.add(rightValue2);
        }
        if (arrayList != null && arrayList.size() > 0) {
            RightValue rightValue3 = new RightValue();
            rightValue3.setValue(rightValue.getValue());
            object = m_hsV6Mapping52Indexs.keySet().iterator();
            while (object.hasNext()) {
                int n = (Integer)object.next();
                rightValue3.setBit(n, false);
            }
            for (RightValue rightValue4 : arrayList) {
                rightValue3.or(rightValue4);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("_rightValue:" + rightValue));
                logger.debug((Object)("mergeValues:" + arrayList));
                logger.debug((Object)("oRightValue:" + rightValue3));
            }
            return rightValue3;
        }
        return rightValue;
    }

    private static void initDependIndexs() {
        m_hsDependIndexs = new HashMap();
        RightUpdaterForUser.initSomeDependIndexs();
        XMLConfigServer xMLConfigServer = XMLConfigServer.getInstance();
        List list = xMLConfigServer.getConfigObjects(OperationConfig.class);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            OperationConfig operationConfig = (OperationConfig)list.get(i);
            if (operationConfig == null) continue;
            Integer n2 = new Integer(operationConfig.getIndex());
            ArrayList arrayList = (ArrayList)m_hsDependIndexs.get(n2);
            List list2 = RightUpdaterForUser.getDependIndexs(operationConfig);
            if (arrayList != null) {
                list2.addAll(arrayList);
            }
            m_hsDependIndexs.put(n2, list2);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("m_hsDependIndexs:" + m_hsDependIndexs));
        }
    }

    private static List getDependIndexs(OperationConfig operationConfig) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        OperationRelatedConfig operationRelatedConfig = operationConfig.getDepends();
        if (operationRelatedConfig == null) {
            return arrayList;
        }
        ArrayList arrayList2 = operationRelatedConfig.getOperations();
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            OperationConfig operationConfig2 = (OperationConfig)arrayList2.get(i);
            if (operationConfig2 == null) continue;
            arrayList.add(new Integer(operationConfig2.getIndex()));
        }
        return arrayList;
    }

    private static CMyBitsValue renderRelatedRight(CMyBitsValue cMyBitsValue) {
        logger.debug((Object)("before:" + cMyBitsValue.toString()));
        Long l = new Long(cMyBitsValue.getValue());
        Object v = m_hsChnlValues.get(l);
        if (v != null) {
            cMyBitsValue = (CMyBitsValue)v;
        } else {
            cMyBitsValue = RightUpdaterForUser.renderRelatedRight(cMyBitsValue, 0);
            m_hsChnlValues.put(l, cMyBitsValue);
        }
        logger.debug((Object)("after:" + cMyBitsValue.toString()));
        return cMyBitsValue;
    }

    private static CMyBitsValue renderRelatedRight(CMyBitsValue cMyBitsValue, int n) {
        if (n >= 64 || n < 0) {
            return cMyBitsValue;
        }
        if (!cMyBitsValue.getBit(n)) {
            return RightUpdaterForUser.renderRelatedRight(cMyBitsValue, n + 1);
        }
        List list = (List)m_hsDependIndexs.get(new Integer(n));
        if (list == null || list.size() == 0) {
            return RightUpdaterForUser.renderRelatedRight(cMyBitsValue, n + 1);
        }
        for (int i = 0; i < list.size(); ++i) {
            int n2 = (Integer)list.get(i);
            if (cMyBitsValue.getBit(n2)) continue;
            cMyBitsValue.setBit(n2, true);
            cMyBitsValue = RightUpdaterForUser.renderRelatedRight(cMyBitsValue, n2);
        }
        return RightUpdaterForUser.renderRelatedRight(cMyBitsValue, n + 1);
    }

    public int doResetRight() throws WCMException {
        Cloneable cloneable;
        if (this.m_oCurrUser.isAdministrator()) {
            return 0;
        }
        if (IS_DEBUG) {
            logger.fatal((Object)(I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label1", "\u5f53\u524d\u5904\u7406\u7684\u7528\u6237\u662f\uff1a") + this.m_oCurrUser));
        }
        this.m_oGroupsOfUser = this.m_oCurrUser.getGroups();
        this.m_oRolesOfUser = this.m_oCurrUser.getRoles();
        this.m_oRolesOfUser.addElement(Role.findById(2));
        SiteMemberMgr siteMemberMgr = (SiteMemberMgr)DreamFactory.createObjectById("SiteMemberMgr");
        WebSites webSites = WebSites.openWCMObjs(null, null);
        for (int i = webSites.size() - 1; i >= 0; --i) {
            cloneable = (WebSite)webSites.getAt(i);
            if (cloneable == null || siteMemberMgr.isVisible(this.m_oCurrUser, (WebSite)cloneable)) continue;
            webSites.removeAt(i, false);
        }
        HashMap<Integer, Long> hashMap = new HashMap<Integer, Long>();
        cloneable = new WCMFilter("WCMCHANNEL", "SiteId in(" + webSites.getIdListAsString() + ")", "ChannelId");
        Channels channels = Channels.openWCMObjs(null, (WCMFilter)cloneable);
        int n = 0;
        int n2 = channels.size();
        for (int i = 0; i < n2; ++i) {
            Channel channel;
            int n3 = channels.getIdAt(i);
            if (this.getChannelRightValue(n3) != null || (channel = (Channel)channels.getAt(i)) == null) continue;
            CMyBitsValue cMyBitsValue = null;
            for (Channel channel2 = channel.getParent(); channel2 != null && (cMyBitsValue = this.getRightValueHasDefine(channel2)) == null; channel2 = channel2.getParent()) {
            }
            if (cMyBitsValue == null) {
                cMyBitsValue = this.getSiteRightValue(channel.getSiteId());
            }
            if (cMyBitsValue == null || cMyBitsValue.getValue() == 0L) continue;
            ++n;
            if (IS_DEBUG) {
                logger.fatal((Object)(I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label2", "\u5f53\u524d\u680f\u76ee[") + channel + I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label3", "]\u7684\u6743\u9650\u662f[") + cMyBitsValue.getValue() + "]"));
                continue;
            }
            this.saveCurrRightValue(this.m_oCurrUser, 101, channel.getId(), cMyBitsValue.getValue());
            hashMap.put(new Integer(channel.getId()), new Long(cMyBitsValue.getValue()));
        }
        HashMap<Integer, String> hashMap2 = new HashMap<Integer, String>();
        HashMap<Integer, String> hashMap3 = new HashMap<Integer, String>();
        CMyBitsValue cMyBitsValue = new CMyBitsValue(0L);
        cMyBitsValue.setBit(14, true);
        long l = cMyBitsValue.getValue();
        int n4 = channels.size();
        for (int i = 0; i < n4; ++i) {
            Cloneable cloneable2;
            Channel channel;
            int n5 = channels.getIdAt(i);
            Integer n6 = new Integer(n5);
            if (hashMap3.containsKey(n6) || this.getChannelRightValue(n5) == null || (channel = (Channel)channels.getAt(i)) == null) continue;
            CMyBitsValue cMyBitsValue2 = null;
            Channel channel3 = channel.getParent();
            while (channel3 != null && ((cMyBitsValue2 = this.getRightValueHasDefine(channel3)) == null || cMyBitsValue2.getValue() == 0L)) {
                n6 = new Integer(channel3.getId());
                if (hashMap3.containsKey(n6)) {
                    channel3 = channel3.getParent();
                    continue;
                }
                hashMap3.put(n6, "");
                if (hashMap.containsKey(n6)) {
                    cloneable2 = new CMyBitsValue((Long)hashMap.get(n6));
                    ((CMyBitsValue)cloneable2).setBit(14, true);
                    if (IS_DEBUG) {
                        logger.fatal((Object)(I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label2", "\u5f53\u524d\u680f\u76ee[") + channel3 + I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label3", "]\u7684\u6743\u9650\u662f[") + ((CMyBitsValue)cloneable2).getValue() + "]"));
                        continue;
                    }
                    this.onlyUpdateCurrRightValue(this.m_oCurrUser, 101, channel3.getId(), ((CMyBitsValue)cloneable2).getValue());
                    continue;
                }
                ++n;
                if (IS_DEBUG) {
                    logger.fatal((Object)(I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label2", "\u5f53\u524d\u680f\u76ee[") + channel3 + I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label3", "]\u7684\u6743\u9650\u662f[") + l + "]"));
                } else {
                    this.saveCurrRightValue(this.m_oCurrUser, 101, channel3.getId(), l);
                }
                channel3 = channel3.getParent();
            }
            cloneable2 = channel.getSite();
            cMyBitsValue2 = this.getRightValueHasDefine((BaseChannel)cloneable2);
            if (cMyBitsValue2 != null && cMyBitsValue2.getValue() != 0L || !hashMap2.containsKey(n6 = new Integer(((BaseObj)cloneable2).getId()))) continue;
            hashMap2.put(n6, "");
            ++n;
            if (IS_DEBUG) {
                logger.fatal((Object)(I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label2", "\u5f53\u524d\u680f\u76ee[") + cloneable2 + I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label3", "]\u7684\u6743\u9650\u662f[") + l + "]"));
                continue;
            }
            this.saveCurrRightValue(this.m_oCurrUser, 103, ((BaseObj)cloneable2).getId(), l);
        }
        logger.fatal((Object)(I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label4", "\u7528\u6237[") + this.m_oCurrUser + I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label5", "]\u9700\u8981\u65b0\u589e\u3010") + n + I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label6", "\u3011\u6761\u6743\u9650\uff01")));
        return n;
    }

    private static void renderOldRights() throws WCMException {
        Rights rights = Rights.openWCMObjs(null, null);
        int n = rights.size();
        for (int i = 0; i < n; ++i) {
            Right right = (Right)rights.getAt(i);
            RightValue rightValue = right.getValue();
            if (right == null || right.getObjType() != 605 && right.getObjType() != 101 && right.getObjType() != 103) continue;
            long l = right.getValueAsLong();
            long l2 = 0L;
            rightValue = RightUpdaterForUser.renderDiffIdxRight(rightValue);
            l2 = (rightValue = (RightValue)RightUpdaterForUser.renderRelatedRight(rightValue)).getValue();
            if (l2 == l) continue;
            right.canEdit(User.getSystem());
            right.setValue(l2);
            right.save();
        }
    }

    private void saveCurrRightValue(User user, int n, int n2, long l) throws WCMException {
        CMSObjDefaultImpl cMSObjDefaultImpl = new CMSObjDefaultImpl("WCMRIGHT", "RIGHTID");
        try {
            cMSObjDefaultImpl.setProperty("ObjType", n);
            cMSObjDefaultImpl.setProperty("ObjId", n2);
            cMSObjDefaultImpl.setProperty("OprType", 204L);
            cMSObjDefaultImpl.setProperty("OprId", user.getId());
            cMSObjDefaultImpl.setProperty("RightValue", l);
            cMSObjDefaultImpl.save(this.m_oCurrUser);
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label7", "\u4fdd\u5b58\u7528\u6237\u6743\u9650\u503c\u65f6\u5931\u8d25"), wCMException);
        }
        catch (Exception exception) {
            throw new WCMException(0, I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label7", "\u4fdd\u5b58\u7528\u6237\u6743\u9650\u503c\u65f6\u5931\u8d25"), exception);
        }
    }

    private void onlyUpdateCurrRightValue(User user, int n, int n2, long l) throws WCMException {
        try {
            Right right = Right.findBy(n, n2, 204, user.getId());
            if (right == null) {
                return;
            }
            right.setProperty("RightValue", l);
            right.save(this.m_oCurrUser);
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label7", "\u4fdd\u5b58\u7528\u6237\u6743\u9650\u503c\u65f6\u5931\u8d25"), wCMException);
        }
        catch (Exception exception) {
            throw new WCMException(0, I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label7", "\u4fdd\u5b58\u7528\u6237\u6743\u9650\u503c\u65f6\u5931\u8d25"), exception);
        }
    }

    private CMyBitsValue getChannelRightValue(int n) throws WCMException {
        if (this.m_mapChannelDefineRightCache == null) {
            this.initChannelRightCache();
        }
        return (CMyBitsValue)this.m_mapChannelDefineRightCache.get(new Integer(n));
    }

    private CMyBitsValue getSiteRightValue(int n) throws WCMException {
        Integer n2 = new Integer(n);
        CMyBitsValue cMyBitsValue = (CMyBitsValue)this.m_oSiteRightValueCache.get(n2);
        if (cMyBitsValue == null) {
            cMyBitsValue = this.makeSiteRightValue(n);
            if (cMyBitsValue == null) {
                cMyBitsValue = new CMyBitsValue(0L);
            }
            this.m_oSiteRightValueCache.put(n2, cMyBitsValue);
        }
        return cMyBitsValue;
    }

    private CMyBitsValue getRightValueHasDefine(BaseChannel baseChannel) throws WCMException {
        if (baseChannel.isSite()) {
            return this.getSiteRightValue(baseChannel.getId());
        }
        return this.getChannelRightValue(baseChannel.getId());
    }

    private CMyBitsValue makeSiteRightValue(int n) throws WCMException {
        CMyResultSets cMyResultSets = new CMyResultSets();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(4);
        arrayList.add(new Integer(204));
        arrayList.add(new Integer(this.m_oCurrUser.getId()));
        arrayList.add(new Integer(103));
        arrayList.add(new Integer(n));
        String string = "ObjType=? and ObjId=?";
        cMyResultSets.open("select RightId,RightValue from " + this.m_sTableNameOfWCM52Right + " where OprType=? and OprId=? and " + string, arrayList, "RightId");
        if (!cMyResultSets.isEmpty()) {
            CMyResultSet cMyResultSet = (CMyResultSet)cMyResultSets.getAt(0);
            return new CMyBitsValue(cMyResultSet.getPropertyAsLong("RightValue", 0L));
        }
        arrayList = new ArrayList(4 + this.m_oGroupsOfUser.size() + this.m_oRolesOfUser.size());
        String string2 = this.makeOprWhereContainsGroupRole(arrayList);
        arrayList.add(new Integer(103));
        arrayList.add(new Integer(n));
        String string3 = "(" + string2 + ") and (" + string + ")";
        cMyResultSets.open("select RightId,RightValue from " + this.m_sTableNameOfWCM52Right + " where " + string3, arrayList, "RightId");
        if (cMyResultSets.isEmpty()) {
            return null;
        }
        return this.mergeRightValue(cMyResultSets);
    }

    private synchronized void initChannelRightCache() throws WCMException {
        Object object;
        if (this.m_mapChannelDefineRightCache != null) {
            return;
        }
        HashMap<Integer, CMyBitsValue> hashMap = new HashMap<Integer, CMyBitsValue>();
        CMyResultSets cMyResultSets = new CMyResultSets();
        ArrayList<Integer> arrayList = null;
        arrayList = new ArrayList<Integer>(7);
        String string = "OprType=? and OprId=? ";
        arrayList.add(new Integer(204));
        arrayList.add(new Integer(this.m_oCurrUser.getId()));
        String string2 = "ObjType=?";
        arrayList.add(new Integer(101));
        String string3 = "(" + string + ") and (" + string2 + ")";
        cMyResultSets = new CMyResultSets();
        cMyResultSets.open("select RightId,RightValue,ObjId from " + this.m_sTableNameOfWCM52Right + " where " + string3 + " order by ObjId", arrayList, "RightId");
        int n = cMyResultSets.size();
        for (int i = 0; i < n; ++i) {
            CMyResultSet cMyResultSet = (CMyResultSet)cMyResultSets.getAt(i);
            if (cMyResultSet == null) continue;
            object = new Integer(cMyResultSet.getPropertyAsInt("ObjId", 0));
            CMyBitsValue cMyBitsValue = new CMyBitsValue(cMyResultSet.getPropertyAsLong("RightValue", 0L));
            hashMap.put((Integer)object, cMyBitsValue);
        }
        arrayList = new ArrayList(7 + this.m_oGroupsOfUser.size() + this.m_oRolesOfUser.size());
        string = this.makeOprWhereContainsGroupRole(arrayList);
        string2 = "ObjType=?";
        arrayList.add(new Integer(101));
        string3 = "(" + string + ") and (" + string2 + ")";
        cMyResultSets = new CMyResultSets();
        String string4 = "select RightId,RightValue,ObjId from " + this.m_sTableNameOfWCM52Right + " where " + string3 + " order by ObjId";
        cMyResultSets.open(string4, arrayList, "RightId");
        int n2 = cMyResultSets.size();
        for (n = 0; n < n2; ++n) {
            int n3;
            Integer n4;
            object = (CMyResultSet)cMyResultSets.getAt(n);
            if (object == null || hashMap.containsKey(n4 = new Integer(n3 = ((BaseObj)object).getPropertyAsInt("ObjId", 0)))) continue;
            CMyBitsValue cMyBitsValue = new CMyBitsValue(0L);
            while (n < n2) {
                object = (CMyResultSet)cMyResultSets.getAt(n);
                if (object != null) {
                    if (((BaseObj)object).getPropertyAsInt("ObjId", 0) != n3) break;
                    cMyBitsValue.or(new CMyBitsValue(((BaseObj)object).getPropertyAsLong("RightValue", 0L)));
                }
                ++n;
            }
            hashMap.put(n4, cMyBitsValue);
            --n;
        }
        this.m_mapChannelDefineRightCache = hashMap;
    }

    private CMyBitsValue mergeRightValue(CMyResultSets cMyResultSets) {
        CMyBitsValue cMyBitsValue = new CMyBitsValue(0L);
        int n = cMyResultSets.size();
        for (int i = 0; i < n; ++i) {
            CMyResultSet cMyResultSet = (CMyResultSet)cMyResultSets.getAt(i);
            if (cMyResultSet == null) continue;
            cMyBitsValue.or(new CMyBitsValue(cMyResultSet.getPropertyAsLong("RightValue", 0L)));
        }
        return cMyBitsValue;
    }

    private String makeOprWhereContainsGroupRole(ArrayList arrayList) {
        arrayList.add(new Integer(203));
        StringBuffer stringBuffer = new StringBuffer(this.m_oRolesOfUser.size() * 2);
        int n = this.m_oRolesOfUser.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("?,");
            arrayList.add(new Integer(this.m_oRolesOfUser.getIdAt(i)));
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        String string = "(OprType=? and OprId in(" + stringBuffer + "))";
        if (!this.m_oGroupsOfUser.isEmpty()) {
            arrayList.add(new Integer(201));
            stringBuffer = new StringBuffer(this.m_oGroupsOfUser.size() * 2);
            int n2 = this.m_oGroupsOfUser.size();
            for (n = 0; n < n2; ++n) {
                stringBuffer.append("?,");
                arrayList.add(new Integer(this.m_oGroupsOfUser.getIdAt(n)));
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            string = string + " or (OprType=? and OprId in(" + stringBuffer + "))";
        }
        return string;
    }

    public void clear() {
        if (this.m_mapChannelDefineRightCache != null) {
            this.m_mapChannelDefineRightCache.clear();
            this.m_mapChannelDefineRightCache = null;
        }
        if (this.m_oSiteRightValueCache != null) {
            this.m_oSiteRightValueCache.clear();
            this.m_oSiteRightValueCache = null;
        }
    }

    public static void main(String[] stringArray) {
        String string = "wfj";
        String string2 = "0";
        int n = 0;
        if (stringArray != null && stringArray.length > 0) {
            string2 = stringArray[0];
            if (stringArray.length > 1) {
                n = Integer.parseInt(stringArray[1]);
            }
            if (stringArray.length > 2) {
                IS_DEBUG = "DEBUG".equalsIgnoreCase(stringArray[2].trim());
            }
        }
        try {
            logger.debug((Object)ConfigConstants.DIR_APPROOT);
            logger.debug((Object)ConfigConstants.DIR_CLASSROOT);
            File[] fileArray = new File[]{new File(ConfigConstants.DIR_APPROOT + "\\..\\lib\\wcm\\")};
            WCMDiscoveryFactory.initDiscovery(fileArray, null);
            DBManager.getDBManager();
            int n2 = 0;
            String string3 = "UserId>=" + string2;
            if (n > 0) {
                string3 = string3 + " and UserId<=" + n;
            }
            Users users = Users.openWCMObjs(null, new WCMFilter("", string3, "UserId"));
            int n3 = users.size();
            for (int i = 0; i < n3; ++i) {
                User user = (User)users.getAt(i);
                if (user == null) continue;
                RightUpdaterForUser rightUpdaterForUser = new RightUpdaterForUser(user, "WCMRightBak01");
                n2 += rightUpdaterForUser.doResetRight();
            }
            RightUpdaterForUser.renderOldRights();
            logger.fatal((Object)(I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label8", "\u6743\u9650\u5347\u7ea7\u5b8c\u6210:\u5171\u65b0\u589e\u4e86\u3010") + n2 + I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label6", "\u3011\u6761\u6743\u9650\uff01")));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        RightUpdaterForUser.initDependIndexs();
        RightUpdaterForUser.initMappingIndexs();
        m_hsChnlValues = new HashMap();
    }
}

