/*
 * Decompiled with CFR 0.152.
 */
package com.trsupdate;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.IObjectMemberMgr;
import com.trs.cms.auth.domain.RightCacheMgr;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyBitsValue;
import com.trs.infra.util.DebugTimer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AccessRightUpdater {
    private static Logger logger = Logger.getLogger(AccessRightUpdater.class);
    private RightCacheMgr m_oRightCacheMgr = (RightCacheMgr)DreamFactory.createObjectById("RightCacheMgr");
    private IObjectMemberMgr m_oObjectMemberMgr = (IObjectMemberMgr)DreamFactory.createObjectById("IObjectMemberMgr");
    private Map m_hOperatorsForObjCache = null;
    private long m_lOnlyVistValue = 0L;
    private User m_oCurrUser = null;

    public AccessRightUpdater(User user) {
        CMyBitsValue cMyBitsValue = new CMyBitsValue();
        cMyBitsValue.setBit(14, true);
        this.m_lOnlyVistValue = cMyBitsValue.getValue();
        this.m_oCurrUser = user;
    }

    public void updateAccessRight() throws WCMException {
        logger.warn((Object)"The system begin to create acccess rights.....");
        DebugTimer debugTimer = new DebugTimer();
        debugTimer.start();
        this.initCache();
        WCMFilter wCMFilter = new WCMFilter("WCMChannel a", "not exists(select 1 from WCMChannel b where a.ChannelId=b.ParentId)", "ParentId", "");
        Channels channels = Channels.openWCMObjs(null, wCMFilter);
        this.updateAccessRightOnSameLevel(channels);
        WebSites webSites = WebSites.openWCMObjs(null, null);
        int n = webSites.size();
        for (int i = 0; i < n; ++i) {
            this.updateAccessRight((WebSite)webSites.getAt(i));
        }
        debugTimer.stop();
        logger.warn((Object)("The system end to create access rights!use[" + debugTimer.getTime() + "]ms"));
    }

    private void updateAccessRightOnSameLevel(Channels channels) throws WCMException {
        if (channels.isEmpty()) {
            return;
        }
        Channels channels2 = new Channels(null);
        int n = channels.size();
        for (int i = 0; i < n; ++i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null) {
                logger.error((Object)("Channel not exists![ID=" + channels.getIdAt(i) + "]!"));
                continue;
            }
            this.updateAccessRight(channel);
            int n2 = channel.getParentId();
            if (n2 == 0) continue;
            channels2.addElement(n2);
        }
        this.updateAccessRightOnSameLevel(channels2);
    }

    private void updateAccessRight(BaseChannel baseChannel) throws WCMException {
        int[] nArray = new int[]{201, 203, 204};
        for (int i = 0; i < nArray.length; ++i) {
            this.updateAccessRight(baseChannel, nArray[i]);
        }
    }

    private void updateAccessRight(BaseChannel baseChannel, int n) throws WCMException {
        BaseObjs baseObjs = (BaseObjs)this.m_hOperatorsForObjCache.get(this.makeCacheKey(baseChannel.getWCMType(), baseChannel.getId(), n));
        this.synMember(baseChannel, n, baseObjs);
        List list = baseChannel.getChildren(null);
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            Channel channel = (Channel)list.get(i);
            if (channel == null) continue;
            baseObjs = (BaseObjs)this.m_hOperatorsForObjCache.get(this.makeCacheKey(channel.getWCMType(), channel.getId(), n));
            this.synMember(baseChannel, n, baseObjs, true);
        }
    }

    private void synMember(BaseChannel baseChannel, int n, BaseObjs baseObjs) throws WCMException {
        this.synMember(baseChannel, n, baseObjs, false);
    }

    private void synMember(BaseChannel baseChannel, int n, BaseObjs baseObjs, boolean bl) throws WCMException {
        if (baseObjs == null) {
            return;
        }
        int n2 = baseObjs.size();
        for (int i = 0; i < n2; ++i) {
            BaseObj baseObj = baseObjs.getAt(i);
            if (baseObj == null) continue;
            boolean bl2 = bl;
            if (!bl2) {
                long l = this.m_oRightCacheMgr.getRightValue(baseChannel.getWCMType(), baseChannel.getId(), n, baseObj.getId(), 0L);
                boolean bl3 = bl2 = (l ^ this.m_lOnlyVistValue) == 0L;
            }
            if (bl2) {
                this.m_oObjectMemberMgr.addVisible(this.m_oCurrUser, n, baseObj.getId(), baseChannel.getWCMType(), baseChannel.getId());
                continue;
            }
            this.m_oObjectMemberMgr.addOperation(this.m_oCurrUser, n, baseObj.getId(), baseChannel.getWCMType(), baseChannel.getId());
        }
    }

    /*
     * Loose catch block
     */
    private void initCache() throws WCMException {
        block20: {
            Exception exception2222;
            DBManager dBManager;
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            Connection connection;
            block18: {
                this.m_hOperatorsForObjCache = new HashMap(500);
                connection = null;
                preparedStatement = null;
                resultSet = null;
                dBManager = DBManager.getDBManager();
                connection = dBManager.getConnection();
                preparedStatement = connection.prepareStatement("select ObjType, ObjId, OprType, OprId from WCMRight order by ObjType, ObjId, OprType");
                preparedStatement.setFetchSize(2000);
                resultSet = preparedStatement.executeQuery();
                String string = null;
                while (resultSet.next()) {
                    int n = resultSet.getInt(1);
                    int n2 = resultSet.getInt(2);
                    int n3 = resultSet.getInt(3);
                    int n4 = resultSet.getInt(4);
                    String string2 = this.makeCacheKey(n, n2, n3);
                    BaseObjs baseObjs = null;
                    if (string2.equals(string)) {
                        baseObjs = (BaseObjs)this.m_hOperatorsForObjCache.get(string2);
                    }
                    if (baseObjs == null) {
                        baseObjs = this.makeOprObjs(n3);
                        this.m_hOperatorsForObjCache.put(string2, baseObjs);
                    }
                    baseObjs.addElement(n4);
                    string = string2;
                }
                Object var14_13 = null;
                if (resultSet == null) break block18;
                try {
                    resultSet.close();
                }
                catch (Exception exception2222) {
                    logger.error((Object)"Failed to close result", (Throwable)exception2222);
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception2222) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)exception2222);
                }
            }
            if (connection != null) {
                dBManager.freeConnection(connection);
            }
            break block20;
            {
                catch (Exception exception3) {
                    throw new WCMException(1100, "Failed to Desc!", exception3);
                }
            }
            catch (Throwable throwable) {
                Exception exception42222;
                Object var14_14 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception42222) {
                        logger.error((Object)"Failed to close result", (Throwable)exception42222);
                    }
                }
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception42222) {
                        logger.error((Object)"Failed to close prepared statement", (Throwable)exception42222);
                    }
                }
                if (connection != null) {
                    dBManager.freeConnection(connection);
                }
                throw throwable;
            }
        }
    }

    private String makeCacheKey(int n, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append(n).append(".").append(n2).append(".").append(n3);
        return stringBuffer.toString();
    }

    private BaseObjs makeOprObjs(int n) throws WCMException {
        CMSBaseObjs cMSBaseObjs = null;
        switch (n) {
            case 201: {
                cMSBaseObjs = new Groups(null, 1, 1);
                break;
            }
            case 203: {
                cMSBaseObjs = new Roles(null, 1, 1);
                break;
            }
            case 204: {
                cMSBaseObjs = new Users(null, 1, 1);
                break;
            }
            default: {
                throw new WCMException("\u672a\u77e5\u64cd\u4f5c\u8005\uff01[Type=" + n + "]");
            }
        }
        return cMSBaseObjs;
    }
}

