/*
 * Decompiled with CFR 0.152.
 */
package com.trs.weblet.util.verfiycode;

import com.trs.weblet.util.verfiycode.VerifyCode;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Random;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class VerifyCodeServlet
extends HttpServlet {
    private static final String SYS_VERIFY_DIGIT = "/digit.24x32.bmp";
    private static final long serialVersionUID = 1L;
    private VerifyCode m_oVerifyCode;
    private Random m_oRandomMake;
    private int m_iDigitLimit;

    public void init() throws ServletException {
        String string = this.getDigitImagePath();
        if (string == null) {
            return;
        }
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        string = file.getAbsolutePath();
        int n = 4;
        int n2 = 3;
        this.m_oVerifyCode = new VerifyCode(string, n);
        this.m_oVerifyCode.setNoiseLevel(n2);
        if (this.m_oVerifyCode.getErrMessage() != null) {
            this.m_oVerifyCode = null;
            return;
        }
        this.m_iDigitLimit = 1;
        for (int i = 0; i < n; ++i) {
            this.m_iDigitLimit *= 10;
        }
        this.m_oRandomMake = new Random(System.currentTimeMillis());
    }

    private String getDigitImagePath() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        URL uRL = clazz.getResource(SYS_VERIFY_DIGIT);
        if (uRL == null) {
            throw new RuntimeException("\u9a8c\u8bc1\u7801\u6240\u9700\u56fe\u7247\u6e90[/digit.24x32.bmp]\u5728\u5f53\u524d\u5e94\u7528\u73af\u5883\u4e0b\u6ca1\u6709\u627e\u5230\uff01");
        }
        String string = uRL.getPath();
        return string;
    }

    public void destroy() {
        this.m_iDigitLimit = 10000;
        this.m_oVerifyCode = null;
        this.m_oRandomMake = null;
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.addHeader("P3P", "CP=CAO PSA OUR");
        if (this.m_oVerifyCode == null) {
            httpServletResponse.setStatus(404);
            return;
        }
        int n = this.makeVerifyNumber();
        httpServletRequest.getSession(true).setAttribute("rand", (Object)String.valueOf(n));
        httpServletResponse.setContentType("image/bmp");
        httpServletResponse.setContentLength(this.m_oVerifyCode.getCommonSize());
        httpServletResponse.setHeader("Cache-control", "no-cache");
        this.m_oVerifyCode.writeImageTo(n, (OutputStream)httpServletResponse.getOutputStream());
    }

    private int makeVerifyNumber() {
        int n = (this.m_oRandomMake.nextInt() & Integer.MAX_VALUE) % this.m_iDigitLimit;
        if (n < 0) {
            n = 1;
        }
        if (n * 10 < this.m_iDigitLimit) {
            n = this.m_iDigitLimit / 10 + n;
        }
        return n;
    }
}

