/*
 * Decompiled with CFR 0.152.
 */
package com.trs.weblet.util.verfiycode;

import com.trs.weblet.util.verfiycode.BitMapData;
import com.trs.weblet.util.verfiycode.BitMapInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;

public class VerifyCode {
    private final String m_sDigitImage;
    private final int m_iDigitCount;
    private final int m_iDigitWidth;
    private final int m_iDigitBytes;
    private final int m_iImageWidth;
    private final int m_iImageHeigh;
    private final int m_iBytesWidth;
    private final int m_iBytesHeigh;
    private final BitMapData m_bmpMaterial;
    private final int m_iCommonSize;
    private final byte[] m_aCommonHead;
    private final Random m_oNoiseMaker;
    private Exception m_eErrMessage;
    private int m_iNoiseLevel;

    public VerifyCode(String string, int n) {
        this.m_sDigitImage = string;
        this.m_iDigitCount = n;
        this.m_bmpMaterial = this.loadMaterial();
        this.m_iDigitWidth = this.m_bmpMaterial.getWidth() / 10;
        this.m_iDigitBytes = this.m_iDigitWidth / 8;
        this.m_iImageWidth = this.m_iDigitWidth * this.m_iDigitCount;
        this.m_iImageHeigh = this.m_bmpMaterial.getHeight();
        this.m_iBytesWidth = this.m_iImageWidth + 31 >> 5 << 2;
        this.m_iBytesHeigh = this.m_iImageHeigh;
        this.m_aCommonHead = new byte[62];
        this.m_iCommonSize = this.prepareHead();
        this.m_oNoiseMaker = new Random(System.currentTimeMillis());
        this.m_iNoiseLevel = 3;
    }

    private BitMapData loadMaterial() {
        String string = this.m_sDigitImage;
        try {
            BitMapData bitMapData = new BitMapData();
            BitMapInputStream bitMapInputStream = new BitMapInputStream(new FileInputStream(string));
            bitMapData.load(bitMapInputStream);
            bitMapInputStream.close();
            return bitMapData;
        }
        catch (Exception exception) {
            this.m_eErrMessage = exception;
            return null;
        }
    }

    private final int prepareHead() {
        byte[] byArray = this.m_aCommonHead;
        BitMapData bitMapData = this.m_bmpMaterial;
        int n = this.m_iDigitCount;
        try {
            BitMapData bitMapData2 = new BitMapData();
            bitMapData2.setHeight(bitMapData.getHeight());
            bitMapData2.setWidth(bitMapData.getWidth() / 10 * n);
            bitMapData2.setPalette(bitMapData.getPalette());
            byte[] byArray2 = bitMapData2.getFileData();
            System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
            return bitMapData2.getFileSize();
        }
        catch (Exception exception) {
            this.m_eErrMessage = exception;
            return 0;
        }
    }

    private int getNoiseByte() {
        if (this.m_iNoiseLevel > 0) {
            int n = this.m_oNoiseMaker.nextInt();
            switch (this.m_iNoiseLevel) {
                case 4: {
                    n &= n >> 8;
                }
                case 3: {
                    n &= n >> 8;
                }
                case 2: {
                    n &= n >> 8;
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return n;
        }
        return 0;
    }

    public static void main(String[] stringArray) {
        VerifyCode verifyCode = new VerifyCode("E:\\temp\\digit.24x32.bmp", 4);
        verifyCode.setNoiseLevel(4);
        try {
            System.out.println(verifyCode.getCommonSize());
            FileOutputStream fileOutputStream = new FileOutputStream("E:\\temp\\test.bmp");
            fileOutputStream.write(verifyCode.getImageData(123456789));
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Exception getErrMessage() {
        return this.m_eErrMessage;
    }

    public int getDigitCount() {
        return this.m_iDigitCount;
    }

    public String getDigitImage() {
        return this.m_sDigitImage;
    }

    public int getNoiseLevel() {
        return this.m_iNoiseLevel;
    }

    public void setNoiseLevel(int n) {
        if (n > 4) {
            n = 4;
        }
        this.m_iNoiseLevel = n;
    }

    public int getCommonSize() {
        return this.m_iCommonSize;
    }

    public byte[] getImageData(int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.m_iCommonSize + 16);
        this.writeImageTo(n, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void writeImageTo(int n, OutputStream outputStream) throws IOException {
        if (this.m_bmpMaterial == null) {
            throw new IllegalStateException("see VerifyCode.getErrMessage()");
        }
        outputStream.write(this.m_aCommonHead);
        int[] nArray = new int[this.m_iDigitCount];
        for (int i = this.m_iDigitCount - 1; i >= 0; --i) {
            nArray[i] = n % 10;
            n /= 10;
        }
        byte[][] byArray = this.m_bmpMaterial.getDataBuff();
        for (int i = 0; i < this.m_iBytesHeigh; ++i) {
            int n2;
            int n3;
            byte[] byArray2 = byArray[i];
            for (n3 = 0; n3 < this.m_iDigitCount; ++n3) {
                if (this.m_iDigitBytes == 1) {
                    outputStream.write(byArray2[nArray[n3]] ^ this.getNoiseByte());
                    continue;
                }
                n2 = nArray[n3] * this.m_iDigitBytes;
                for (int j = 0; j < this.m_iDigitBytes; ++j) {
                    outputStream.write(byArray2[n2++] ^ this.getNoiseByte());
                }
            }
            n3 = this.m_iDigitCount * this.m_iDigitBytes & 3;
            if (n3 == 0) continue;
            for (n2 = n3; n2 < 4; ++n2) {
                outputStream.write(0);
            }
        }
    }

    public void fastWriteImageTo(int n, OutputStream outputStream) throws IOException {
    }
}

