/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.xmlserver.server;

import com.trs.webframework.exception.ServiceInvocationException;
import com.trs.webframework.xmlserver.parser.XMLParsingInfoHolder;
import com.trs.webframework.xmlserver.server.IObserver;
import com.trs.webframework.xmlserver.server.IObserverable;
import com.trs.webframework.xmlserver.server.XMLParsingPausedException;
import java.util.ArrayList;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class XMLDataProcessingHandler
extends DefaultHandler
implements IObserverable {
    private static Logger logger = Logger.getLogger(XMLDataProcessingHandler.class);
    public static final int TAG_ROOT = "post-data".hashCode();
    public static final int TAG_METHOD = "method".hashCode();
    public static final int ATTR_TYPE = "type".hashCode();
    public static final int TAG_PARAMS = "parameters".hashCode();
    public static final int TAG_PARAM = "parameter".hashCode();
    private static final int TAG_ELEMENT = "element".hashCode();
    private Stack m_stkTagName = null;
    private boolean m_bUnderMethodAnalyzing = false;
    private boolean m_bUnderParametersAnalyzing = false;
    private ArrayList m_arObservers = null;
    private XMLParsingInfoHolder m_oParsingInfo = null;
    private int m_nParsingStatus;
    private Object[] m_pResult = new Object[100];
    private int m_nCurrResultIndex = 0;
    private Object m_oHanderArg = null;
    StringBuffer m_sbCurrentElementVal = new StringBuffer();

    public XMLDataProcessingHandler() {
        this(null);
    }

    public XMLDataProcessingHandler(Object object) {
        this.m_arObservers = new ArrayList(5);
        this.m_oHanderArg = object;
    }

    public void clear() {
        this.m_bUnderMethodAnalyzing = false;
        this.m_bUnderParametersAnalyzing = false;
        this.m_nParsingStatus = 0;
        this.m_oParsingInfo = new XMLParsingInfoHolder();
        this.m_stkTagName.clear();
        for (int i = 0; i < this.m_arObservers.size(); ++i) {
            IObserver iObserver = (IObserver)this.m_arObservers.get(i);
            iObserver.clear();
        }
    }

    public void startDocument() {
        this.m_stkTagName = new Stack();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        int n;
        String string4 = string3.toLowerCase().trim();
        this.m_stkTagName.push(string4);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(">> begin to parse<" + string3 + ">"));
        }
        if ((n = string4.hashCode()) == TAG_ROOT) {
            this.m_oParsingInfo = new XMLParsingInfoHolder();
        } else if (n == TAG_METHOD) {
            String string5 = attributes.getValue("type");
            this.m_oParsingInfo.setMethodName(string5);
            this.notifyObservers(this, 1);
            this.m_bUnderMethodAnalyzing = true;
        } else if (n == TAG_PARAMS) {
            this.m_bUnderParametersAnalyzing = true;
        } else if (n == TAG_ELEMENT) {
            // empty if block
        }
    }

    public void endElement(String string, String string2, String string3) {
        this.notifyWhenParamParsingEnd(this.m_sbCurrentElementVal.toString(), string3);
        int n = string3.toLowerCase().trim().hashCode();
        if (n == TAG_METHOD) {
            this.m_bUnderMethodAnalyzing = false;
        } else if (n == TAG_PARAMS) {
            this.m_bUnderParametersAnalyzing = false;
        } else if (n == TAG_ELEMENT) {
            // empty if block
        }
        if (!this.m_stkTagName.isEmpty()) {
            this.m_stkTagName.pop();
        }
        if (this.m_sbCurrentElementVal != null) {
            this.m_sbCurrentElementVal.setLength(0);
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        if (n2 <= 0) {
            return;
        }
        this.m_sbCurrentElementVal.append(cArray, n, n2);
    }

    private void notifyWhenParamParsingEnd(String string, String string2) {
        int n = string2.toLowerCase().trim().hashCode();
        if (n == TAG_ELEMENT || n == TAG_PARAMS) {
            this.notifyObservers(this, 3);
            return;
        }
        if (string == null) {
            return;
        }
        if (this.m_bUnderMethodAnalyzing) {
            if (this.m_oParsingInfo.getInvocationId() == null) {
                this.m_oParsingInfo.setInvocationId(string);
                this.notifyObservers(this, 2);
            }
        } else if (this.m_bUnderParametersAnalyzing && !this.m_oParsingInfo.containsNamedParam(string2)) {
            this.m_oParsingInfo.appendNamedParam(string2, string);
            return;
        }
    }

    public void endDocument() {
    }

    public XMLParsingInfoHolder getParsingInfo() {
        return this.m_oParsingInfo;
    }

    public int getParsingStatus() {
        return this.m_nParsingStatus;
    }

    public Object getResult() {
        int n = 0;
        int n2 = 0;
        int n3 = 100;
        for (int i = 0; i < this.m_pResult.length; ++i) {
            if (this.m_pResult[i] == null) continue;
            ++n;
            n2 = i;
            if (!(this.m_pResult[i] instanceof String)) continue;
            n3 += ((String)this.m_pResult[i]).length();
        }
        if (n == 1) {
            return this.m_pResult[n2];
        }
        StringBuffer stringBuffer = new StringBuffer(n3);
        stringBuffer.append("<MultiResult>\n");
        for (int i = 0; i < this.m_pResult.length; ++i) {
            if (this.m_pResult[i] == null || !(this.m_pResult[i] instanceof String)) continue;
            stringBuffer.append(this.m_pResult[i]);
            stringBuffer.append("\n");
        }
        stringBuffer.append("</MultiResult>");
        return stringBuffer.toString();
    }

    public void notifyObservers(IObserverable iObserverable, int n) {
        if (this.m_arObservers.size() == 0) {
            return;
        }
        this.m_nParsingStatus = n;
        for (int i = 0; i < this.m_arObservers.size(); ++i) {
            IObserver iObserver = (IObserver)this.m_arObservers.get(i);
            iObserver.update(iObserverable, this.m_oHanderArg);
        }
    }

    public void attachObserver(IObserver iObserver) {
        if (this.m_arObservers.contains(iObserver)) {
            return;
        }
        this.m_arObservers.add(iObserver);
    }

    public void detachObserver(IObserver iObserver) {
        if (!this.m_arObservers.contains(iObserver)) {
            return;
        }
        this.m_arObservers.remove(iObserver);
    }

    public void stopOnParsingError(ServiceInvocationException serviceInvocationException) {
        throw serviceInvocationException;
    }

    public void stopOnParsingCompleted(Object object) throws XMLParsingPausedException {
        this.m_pResult[this.m_nCurrResultIndex++] = object;
        this.clear();
    }
}

