/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.controler;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.XmlCharCheckedInputStream;
import com.trs.webframework.WebServiceHelper;
import com.trs.webframework.config.MethodConfig;
import com.trs.webframework.config.ServiceConfig;
import com.trs.webframework.config.ServiceConfigHelper;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.controler.JSPRequestParmasValidator;
import com.trs.webframework.controler.JSPServiceContext;
import com.trs.webframework.controler.PostDataParser;
import com.trs.webframework.exception.ServiceInvocationException;
import com.trs.webframework.xmlserver.parser.StreamBuddy;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xml.sax.InputSource;

public class JSPRequestProcessor {
    HttpServletRequest request = null;
    HttpServletResponse response = null;
    private String[] m_pSelectParameters = null;
    private String[] m_pEscapeParameters = null;
    private String[] m_pAppendParameters = null;
    private PostDataParser m_oPostDataParser = null;
    private JSPServiceContext m_oDefaultServiceContext = null;
    private BaseObj m_oCurrHost = null;
    private Map m_oContextCacheData = null;

    public JSPRequestProcessor() {
    }

    public JSPRequestProcessor(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        if (httpServletRequest != null) {
            this.m_oDefaultServiceContext = new JSPServiceContext(this.request, this.response);
        }
    }

    public void setSelectParameters(String[] stringArray) {
        this.m_pSelectParameters = stringArray;
    }

    public void setSelectParameters(String[] stringArray, boolean bl) {
        this.m_pSelectParameters = stringArray;
        if (bl && this.m_pAppendParameters != null) {
            if (this.m_pSelectParameters == null) {
                this.m_pSelectParameters = this.m_pAppendParameters;
                return;
            }
            String[] stringArray2 = new String[this.m_pAppendParameters.length + this.m_pSelectParameters.length];
            System.arraycopy(this.m_pSelectParameters, 0, stringArray2, 0, this.m_pSelectParameters.length);
            System.arraycopy(this.m_pAppendParameters, 0, stringArray2, this.m_pSelectParameters.length, this.m_pAppendParameters.length);
            this.m_pSelectParameters = stringArray2;
        }
    }

    public void setEscapeParameters(String[] stringArray) throws WCMException {
        if (stringArray != null && stringArray.length % 2 != 0) {
            throw new WCMException(I18NMessage.get(JSPRequestProcessor.class, "JSPRequestProcessor.label1", "\u8f6c\u4e49\u7684\u53c2\u6570\u4e0d\u662f\u6210\u5bf9\u51fa\u73b0\uff01"));
        }
        this.m_pEscapeParameters = stringArray;
    }

    public void setAppendParameters(String[] stringArray) throws WCMException {
        if (stringArray != null && stringArray.length % 2 != 0) {
            throw new WCMException(I18NMessage.get(JSPRequestProcessor.class, "JSPRequestProcessor.label2", "\u8ffd\u52a0\u7684\u53c2\u6570\u4e0d\u662f\u6210\u5bf9\u51fa\u73b0\uff01"));
        }
        this.m_pAppendParameters = stringArray;
    }

    public void reset() {
        this.m_pAppendParameters = null;
        this.m_pEscapeParameters = null;
        this.m_pSelectParameters = null;
    }

    public Object excute(String string, String string2) throws WCMException {
        return this.excute(string, string2, null);
    }

    public Object excute(String string, String string2, HashMap hashMap) throws WCMException {
        ServiceConfig serviceConfig;
        String string3 = string;
        String string4 = string2;
        if (string3.indexOf(95) == -1) {
            string3 = "wcm6_" + string3;
        }
        if ((serviceConfig = ServiceConfigHelper.findServiceConfig(string3)) == null) {
            throw new WCMException(I18NMessage.get(JSPRequestProcessor.class, "JSPRequestProcessor.label3", "\u670d\u52a1[") + string3 + I18NMessage.get(JSPRequestProcessor.class, "JSPRequestProcessor.label4", "]\u7684\u914d\u7f6e\u4fe1\u606f\u6ca1\u6709\u627e\u5230\uff0c\u662f\u5426\u662f\u6587\u4ef6") + ServiceConfigHelper.getSevicesConfigFileName(string3) + I18NMessage.get(JSPRequestProcessor.class, "JSPRequestProcessor.label5", "\u4e0d\u5b58\u5728!"));
        }
        MethodConfig methodConfig = ServiceConfigHelper.findMethodConfig(string3, string4);
        if (methodConfig == null) {
            throw new WCMException(I18NMessage.get(JSPRequestProcessor.class, "JSPRequestProcessor.label6", "\u662f\u5426\u5728\u6587\u4ef6[") + ServiceConfigHelper.getSevicesConfigFileName(string3) + I18NMessage.get(JSPRequestProcessor.class, "JSPRequestProcessor.label7", "]\u4e2d\u6ca1\u6709\u5b9a\u4e49\u65b9\u6cd5[") + string4 + "]?");
        }
        try {
            JSPServiceContext jSPServiceContext = null;
            if (hashMap != null) {
                if (this.m_oDefaultServiceContext == null) {
                    this.m_oDefaultServiceContext = jSPServiceContext = new JSPServiceContext(hashMap);
                } else {
                    jSPServiceContext = new JSPServiceContext(this.m_oDefaultServiceContext);
                    jSPServiceContext.setMapParameters(hashMap);
                }
            } else if (this.m_pSelectParameters != null && this.m_pSelectParameters.length > 0 || this.m_pEscapeParameters != null && this.m_pEscapeParameters.length > 0 || this.m_pAppendParameters != null && this.m_pAppendParameters.length > 0) {
                jSPServiceContext = new JSPServiceContext(this.m_oDefaultServiceContext);
                jSPServiceContext.setMapParameters(this.getNewParameters());
            } else {
                jSPServiceContext = this.m_oDefaultServiceContext;
            }
            MethodContext methodContext = new JSPRequestParmasValidator(jSPServiceContext, methodConfig).getMethodContext();
            methodContext.setServiceContext(jSPServiceContext);
            if (this.m_oCurrHost != null) {
                methodContext.setCurrHost(this.m_oCurrHost);
            }
            if (this.m_oContextCacheData != null) {
                methodContext.putContextCacheData(this.m_oContextCacheData);
            }
            return WebServiceHelper.execute(methodConfig, methodContext, true);
        }
        catch (Throwable throwable) {
            int n;
            int n2 = 1100;
            if (throwable instanceof CMyException) {
                n2 = ((CMyException)throwable).getErrNo();
            } else if (throwable instanceof ServiceInvocationException) {
                n2 = Integer.parseInt(((ServiceInvocationException)throwable).getErrorCode());
            }
            String string5 = throwable.getMessage();
            if (string5 != null && (n = string5.indexOf("[ERR-")) >= 0 && (n = string5.indexOf(93, n + 1)) > 0) {
                string5 = string5.substring(n + 1);
            }
            throw new WCMException(n2, string5, throwable);
        }
    }

    public Object excuteMult(String string, String string2) throws WCMException {
        HashMap hashMap;
        String string3;
        if (this.m_oPostDataParser == null) {
            this.initPostDataParser();
        }
        if ((string3 = string).indexOf("_") < 0) {
            string3 = "wcm6_" + string3;
        }
        if ((hashMap = this.m_oPostDataParser.findParameters(string3, string2)) == null) {
            return null;
        }
        return this.excute(string3, string2, this.makeMultParameters(hashMap));
    }

    public Object[] excuteArrayMult(String string, String string2) throws WCMException {
        HashMap[] hashMapArray;
        String string3;
        if (this.m_oPostDataParser == null) {
            this.initPostDataParser();
        }
        if ((string3 = string).indexOf("_") < 0) {
            string3 = "wcm6_" + string3;
        }
        if ((hashMapArray = this.m_oPostDataParser.findArrayParameters(string3, string2)) == null) {
            throw new WCMException(I18NMessage.get(JSPRequestProcessor.class, "JSPRequestProcessor.label10", "\u6307\u5b9a\u670d\u52a1\u7684\u53c2\u6570\u4e0d\u5b58\u5728![ServiceId=") + string + ", MethodName=" + string2 + "]");
        }
        Object[] objectArray = new Object[hashMapArray.length];
        for (int i = 0; i < hashMapArray.length; ++i) {
            objectArray[i] = this.excute(string3, string2, this.makeMultParameters(hashMapArray[i]));
        }
        return objectArray;
    }

    private HashMap makeMultParameters(HashMap hashMap) {
        Object object;
        if (this.m_pAppendParameters != null && this.m_pAppendParameters.length > 0) {
            for (int i = 0; i < this.m_pAppendParameters.length; i += 2) {
                object = this.m_pAppendParameters[i];
                hashMap.put(((String)object).toUpperCase(), this.m_pAppendParameters[i + 1]);
            }
        }
        Iterator iterator = hashMap.keySet().iterator();
        object = new HashMap();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!this.isSelectParameter(string)) continue;
            String[] stringArray = this.toEscapeParameters(string);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                ((HashMap)object).put(string2, hashMap.get(string));
            }
        }
        return object;
    }

    public Object excuteMult(int n) throws WCMException {
        HashMap hashMap;
        if (this.m_oPostDataParser == null) {
            this.initPostDataParser();
        }
        if ((hashMap = this.m_oPostDataParser.findParameters(n)) == null) {
            throw new WCMException(I18NMessage.get(JSPRequestProcessor.class, "JSPRequestProcessor.label11", "\u6307\u5b9a\u670d\u52a1\u7684\u53c2\u6570\u4e0d\u5b58\u5728![ServiceIndex=") + n + "]");
        }
        String string = this.m_oPostDataParser.findServiceId(n);
        String string2 = this.m_oPostDataParser.findMethodName(n);
        return this.excute(string, string2, this.makeMultParameters(hashMap));
    }

    private void initPostDataParser() throws WCMException {
        try {
            InputStream inputStream = StreamBuddy.copyRequestInputStream(new XmlCharCheckedInputStream((InputStream)this.request.getInputStream()));
            InputSource inputSource = StreamBuddy.getInputSource(inputStream, "UTF-8");
            this.m_oPostDataParser = new PostDataParser();
            this.m_oPostDataParser.parse(inputSource);
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(JSPRequestProcessor.class, "JSPRequestProcessor.label12", "\u89e3\u6790\u4f20\u5165\u7684\u6570\u636e\u5931\u8d25\uff01"));
        }
    }

    private boolean isSelectParameter(String string) {
        if (this.m_pSelectParameters == null || this.m_pSelectParameters.length <= 0) {
            return true;
        }
        for (int i = 0; i < this.m_pSelectParameters.length; ++i) {
            String string2 = this.m_pSelectParameters[i];
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    private String[] toEscapeParameters(String string) {
        if (this.m_pEscapeParameters == null || this.m_pEscapeParameters.length <= 0) {
            return new String[]{string};
        }
        String[] stringArray = new String[]{};
        for (int i = 0; i < this.m_pEscapeParameters.length; i += 2) {
            String string2 = this.m_pEscapeParameters[i];
            if (!string.equalsIgnoreCase(string2)) continue;
            String string3 = this.m_pEscapeParameters[i + 1];
            String[] stringArray2 = new String[stringArray.length + 1];
            if (stringArray2.length > 1) {
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            }
            stringArray2[stringArray.length] = string3;
            stringArray = stringArray2;
        }
        if (stringArray.length <= 0) {
            return new String[]{string};
        }
        return stringArray;
    }

    private HashMap getNewParameters() {
        String string;
        int n;
        String[] stringArray;
        Object object;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Enumeration enumeration = this.request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!this.isSelectParameter(string2)) continue;
            object = this.getParameterValues(string2);
            if (object == null || ((String[])object).length == 0) break;
            stringArray = this.toEscapeParameters(string2);
            for (n = 0; n < stringArray.length; ++n) {
                string = stringArray[n];
                if (((String[])object).length == 1) {
                    hashMap.put(string, object[0]);
                    continue;
                }
                hashMap.put(string, object);
            }
        }
        if (this.m_pAppendParameters != null && this.m_pAppendParameters.length > 0) {
            for (int i = 0; i < this.m_pAppendParameters.length; i += 2) {
                object = this.m_pAppendParameters[i];
                if (!this.isSelectParameter((String)object)) continue;
                stringArray = this.toEscapeParameters((String)object);
                for (n = 0; n < stringArray.length; ++n) {
                    string = stringArray[n];
                    hashMap.put(string, this.m_pAppendParameters[i + 1]);
                }
            }
        }
        return hashMap;
    }

    public HashMap getServiceParameters() {
        return this.getNewParameters();
    }

    private String[] getParameterValues(String string) {
        String[] stringArray;
        Object object;
        if (this.m_pAppendParameters != null && this.m_pAppendParameters.length > 0) {
            for (int i = 0; i < this.m_pAppendParameters.length; i += 2) {
                object = this.m_pAppendParameters[i];
                if (!string.equalsIgnoreCase((String)object)) continue;
                return new String[]{this.m_pAppendParameters[i + 1]};
            }
        }
        if ((stringArray = this.request.getParameterValues(string)) == null) {
            return new String[0];
        }
        object = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            object[i] = CMyString.getStr(stringArray[i]);
        }
        return object;
    }

    public boolean getParam(String string, boolean bl) {
        return this.m_oDefaultServiceContext.getParam(string, bl);
    }

    public CMyDateTime getParam(String string, CMyDateTime cMyDateTime) {
        return this.m_oDefaultServiceContext.getParam(string, cMyDateTime);
    }

    public double getParam(String string, double d) {
        return this.m_oDefaultServiceContext.getParam(string, d);
    }

    public float getParam(String string, float f) {
        return this.m_oDefaultServiceContext.getParam(string, f);
    }

    public int getParam(String string, int n) {
        return this.m_oDefaultServiceContext.getParam(string, n);
    }

    public long getParam(String string, long l) {
        return this.m_oDefaultServiceContext.getParam(string, l);
    }

    public String getParam(String string) {
        return this.m_oDefaultServiceContext.getParam(string);
    }

    public void setCurrHost(BaseObj baseObj) {
        this.m_oCurrHost = baseObj;
    }

    public BaseObj getCurrHost() {
        return this.m_oCurrHost;
    }

    public void putContextCacheData(Map map) {
        this.getContextCacheData().putAll(map);
    }

    public void putContextCacheData(Object object, Object object2) {
        if (object2 == null) {
            return;
        }
        this.getContextCacheData().put(object, object2);
    }

    public Object getContextCacheData(Object object) {
        if (object == null) {
            return null;
        }
        return this.getContextCacheData().get(object);
    }

    private Map getContextCacheData() {
        if (this.m_oContextCacheData == null) {
            this.m_oContextCacheData = new HashMap(1);
        }
        return this.m_oContextCacheData;
    }

    public boolean exists(String string, String string2) throws WCMException {
        String string3;
        if (this.m_oPostDataParser == null) {
            this.initPostDataParser();
        }
        if ((string3 = string).indexOf("_") < 0) {
            string3 = "wcm6_" + string3;
        }
        return this.m_oPostDataParser.findParameters(string3, string2) != null;
    }
}

