/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.context;

import com.trs.cms.ContextHelper;
import com.trs.infra.util.CMyString;
import com.trs.webframework.xmlserver.parser.ServletInputStreamWrapper;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServiceContext {
    public static boolean IS_CONSOLE_TEST = false;
    private boolean m_bReturnJSON = false;
    private boolean m_bReturnHTML = false;
    private Map m_mapParameterNames = null;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private static ServiceContext currInstance;
    private ServletInputStreamWrapper m_oInputStreamWrapper;

    public ServiceContext() {
    }

    public ServiceContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        currInstance = ServiceContext.create(httpServletRequest, httpServletResponse);
    }

    public static ServiceContext create(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.request = httpServletRequest;
        serviceContext.response = httpServletResponse;
        return serviceContext;
    }

    public static ServiceContext getCurrentServiceContext() {
        if (currInstance == null) {
            currInstance = new ServiceContext();
        }
        return currInstance;
    }

    public String[] getParameterValues(String string) {
        String string2 = this.getRequestParameterName(string);
        if (string2 == null) {
            return new String[0];
        }
        String[] stringArray = this.request.getParameterValues(string2);
        if (stringArray == null) {
            return new String[0];
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = CMyString.getStr(stringArray[i]);
        }
        return stringArray2;
    }

    public String getParameterValue(String string) {
        String string2 = this.getRequestParameterName(string);
        if (string2 == null) {
            return null;
        }
        String[] stringArray = this.getParameterValues(string2);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return stringArray[0];
    }

    private String getRequestParameterName(String string) {
        if (this.m_mapParameterNames == null) {
            this.m_mapParameterNames = new HashMap();
            Enumeration enumeration = this.request.getParameterNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                this.m_mapParameterNames.put(string2.toUpperCase(), string2);
            }
        }
        return (String)this.m_mapParameterNames.get(string.toUpperCase());
    }

    public Enumeration getParameterNames() {
        return this.request.getParameterNames();
    }

    public Map getParameters() {
        return this.request.getParameterMap();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ServletInputStreamWrapper getInputStreamWrapper() {
        return this.m_oInputStreamWrapper;
    }

    public void setInputStreamWrapper(ServletInputStreamWrapper servletInputStreamWrapper) {
        this.m_oInputStreamWrapper = servletInputStreamWrapper;
    }

    public InputStream getInputStream() {
        if (this.m_oInputStreamWrapper == null) {
            return null;
        }
        return this.m_oInputStreamWrapper.getInputSteam();
    }

    public void setContentTypeIsHTML() {
        this.setContentType("test/html;charset=UTF-8");
    }

    public void setContentType(String string) {
        if (this.response == null || CMyString.isEmpty(string)) {
            return;
        }
        this.response.setContentType(string);
        this.response.setHeader("SelfDefinedContentType", "1");
    }

    public Object getSessionValue(String string) {
        if (IS_CONSOLE_TEST) {
            return ContextHelper.getLoginUser();
        }
        return this.request.getSession().getAttribute(string);
    }

    public boolean isReturnJSON() {
        return this.m_bReturnJSON;
    }

    public void setReturnJSON(boolean bl) {
        this.m_bReturnJSON = bl;
    }

    public boolean isReturnHTML() {
        return this.m_bReturnHTML;
    }

    public void setReturnHTML(boolean bl) {
        this.m_bReturnHTML = bl;
    }
}

