/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.config;

import com.trs.infra.I18NMessage;
import com.trs.infra.config.TRSConfigServer;
import com.trs.infra.support.config.ConfigServer;
import com.trs.webframework.FrameworkConstants;
import com.trs.webframework.config.MethodConfig;
import com.trs.webframework.config.ServiceConfig;
import com.trs.webframework.config.ServiceConfigStartServer;
import com.trs.webframework.config.ServiceFilterConfig;
import com.trs.webframework.config.ServiceListenerConfig;
import com.trs.webframework.exception.NoSuchServiceException;
import com.trs.webframework.exception.ServiceCreationFailException;
import com.trs.webframework.provider.IDeleteServiceProvider;
import com.trs.webframework.provider.IFindByIdServiceProvider;
import com.trs.webframework.provider.IFindByIdsServiceProvider;
import com.trs.webframework.provider.IQueryServiceProvider;
import com.trs.webframework.provider.ISaveServiceProvider;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import com.trs.webframework.provider.IServiceProvider;
import java.io.File;
import org.apache.log4j.Logger;

public class ServiceConfigHelper {
    private static Logger logger = Logger.getLogger(ServiceConfigHelper.class);

    public static String getSeviceConfigRootPath() {
        ServiceConfigStartServer serviceConfigStartServer = (ServiceConfigStartServer)TRSConfigServer.findConfigServerById("service");
        if (serviceConfigStartServer == null) {
            return null;
        }
        return serviceConfigStartServer.getConfigPath();
    }

    public static String getSevicesConfigFileName(String string) {
        StringBuffer stringBuffer = new StringBuffer(256);
        if (ConfigServer.getServer().isShowDetailErrorInfo()) {
            stringBuffer.append(ServiceConfigHelper.getSeviceConfigRootPath());
        }
        stringBuffer.append(string.replace('_', File.separatorChar));
        stringBuffer.append(".xml");
        return stringBuffer.toString();
    }

    public static MethodConfig findMethodConfig(String string, String string2) {
        ServiceConfig serviceConfig = ServiceConfigHelper.findServiceConfig(string);
        if (serviceConfig == null) {
            return null;
        }
        return serviceConfig.findMethodByName(string2);
    }

    public static ServiceConfig findServiceConfig(String string) {
        ServiceConfigStartServer serviceConfigStartServer = (ServiceConfigStartServer)TRSConfigServer.findConfigServerById("service");
        if (serviceConfigStartServer == null) {
            return null;
        }
        ServiceConfig serviceConfig = serviceConfigStartServer.findServiceConfigById(string);
        if (serviceConfig == null) {
            return null;
        }
        return serviceConfig;
    }

    public static IServiceProvider makeProvider(String string, String string2) {
        try {
            IServiceProvider iServiceProvider = (IServiceProvider)Class.forName(string).newInstance();
            if (string2 != null && string2.trim().length() != 0) {
                IServiceProvider iServiceProvider2 = ServiceConfigHelper.makeDecorator(string2, iServiceProvider);
                return iServiceProvider2;
            }
            return iServiceProvider;
        }
        catch (InstantiationException instantiationException) {
            throw new ServiceCreationFailException(I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label1", "\u65e0\u6cd5\u6b63\u786e\u521b\u5efa\u540d\u4e3a[") + string + I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label2", "]\u7684Provider"), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ServiceCreationFailException(I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label3", "\u65e0\u6cd5\u8bbf\u95ee\u540d\u4e3a[") + string + I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label4", "]\u7684Provider\u7684\u6784\u9020\u5668\uff01"), illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoSuchServiceException(I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label5", "\u6307\u5b9a\u7684Provider[") + string + I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label6", "]\u6ca1\u6709\u627e\u5230\uff01"), classNotFoundException);
        }
    }

    public static ServiceFilterConfig[] findServiceFilterConfigs(String string, String string2) {
        ServiceConfigStartServer serviceConfigStartServer = (ServiceConfigStartServer)TRSConfigServer.findConfigServerById("service");
        if (serviceConfigStartServer == null) {
            return new ServiceFilterConfig[0];
        }
        return serviceConfigStartServer.findServiceFilterConfigs(string, string2);
    }

    public static ServiceListenerConfig[] findServiceListenerConfigs(String string, String string2) {
        ServiceConfigStartServer serviceConfigStartServer = (ServiceConfigStartServer)TRSConfigServer.findConfigServerById("service");
        if (serviceConfigStartServer == null) {
            return new ServiceListenerConfig[0];
        }
        return serviceConfigStartServer.findServiceListenerConfigs(string, string2);
    }

    private static IServiceProvider makeDecorator(String string, IServiceProvider iServiceProvider) {
        IServiceProvider iServiceProvider2 = null;
        try {
            Class[] classArray = new Class[]{IServiceProvider.class};
            Object[] objectArray = new Object[]{iServiceProvider};
            iServiceProvider2 = (IServiceProvider)Class.forName(string).getConstructor(classArray).newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
            throw new ServiceCreationFailException(I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label1", "\u65e0\u6cd5\u6b63\u786e\u521b\u5efa\u540d\u4e3a[") + string + I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label7", "]\u7684Decorator"), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ServiceCreationFailException(I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label3", "\u65e0\u6cd5\u8bbf\u95ee\u540d\u4e3a[") + string + I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label8", "]\u7684Decorator\u7684\u6784\u9020\u5668\uff01"), illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoSuchServiceException(I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label9", "\u6307\u5b9a\u7684Decorator[") + string + I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label6", "]\u6ca1\u6709\u627e\u5230\uff01"), classNotFoundException);
        }
        catch (Exception exception) {
            throw new NoSuchServiceException(I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label10", "\u6784\u9020[") + string + I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label11", "]\u65f6\u53d1\u751f\u9519\u8bef\uff01Caused by: \n") + exception, exception);
        }
        return iServiceProvider2;
    }

    public static IServiceProvider makeProvider(String string) {
        return ServiceConfigHelper.makeProvider(string, null);
    }

    public static IServiceProvider validateProvider(int n, IServiceProvider iServiceProvider) {
        String string = iServiceProvider.getClass().getName();
        switch (n) {
            case 107944136: {
                if (iServiceProvider instanceof IQueryServiceProvider) break;
                logger.error((Object)(I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label12", "Service\u7c7b\u578b\u4e0d\u5339\u914d! IQueryServiceProvider [Class=") + string + "]"));
                return null;
            }
            case 3522941: {
                if (iServiceProvider instanceof ISaveServiceProvider) break;
                logger.error((Object)(I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label13", "Service\u7c7b\u578b\u4e0d\u5339\u914d! \u6ca1\u6709\u5b9e\u73b0 ISaveServiceProvider [Class=") + string + "]"));
                return null;
            }
            case -1335458389: {
                if (iServiceProvider instanceof IDeleteServiceProvider) break;
                logger.error((Object)(I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label14", "Service\u7c7b\u578b\u4e0d\u5339\u914d! \u6ca1\u6709\u5b9e\u73b0 IDeleteServiceProvider [Class=") + string + "]"));
                return null;
            }
            case 433016040: {
                if (iServiceProvider instanceof IFindByIdsServiceProvider) break;
                logger.error((Object)(I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label15", "Service\u7c7b\u578b\u4e0d\u5339\u914d! \u6ca1\u6709\u5b9e\u73b0 IFindByIdsServiceProvider [Class=") + string + "]"));
                return null;
            }
            case -678768405: {
                if (iServiceProvider instanceof IFindByIdServiceProvider) break;
                logger.error((Object)(I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label16", "Service\u7c7b\u578b\u4e0d\u5339\u914d! \u6ca1\u6709\u5b9e\u73b0 IFindByIdServiceProvider [Class=") + string + "]"));
                return null;
            }
            default: {
                if (iServiceProvider instanceof ISelfDefinedServiceProvider) break;
                logger.error((Object)(I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label17", "Service\u7c7b\u578b\u4e0d\u5339\u914d! \u6ca1\u6709\u5b9e\u73b0 IWebServiceUserDefine [Class=") + string + "]"));
                return null;
            }
        }
        return iServiceProvider;
    }

    public static boolean isSelfDefinedMethodName(String string) {
        return ServiceConfigHelper.isSelfDefinedMethodName(string.toLowerCase().hashCode());
    }

    public static boolean isSelfDefinedMethodName(int n) {
        for (int i = 0; i < FrameworkConstants.METHOD_TYPES.length; ++i) {
            if (n != FrameworkConstants.METHOD_TYPES[i]) continue;
            return false;
        }
        return true;
    }
}

