/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.BaseContextHelper;
import com.trs.infra.common.ContextParameters;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.support.log.Log;
import com.trs.infra.support.log.LogServer;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.webframework.AbstractLogger;
import com.trs.webframework.ServiceExcuteLogger;
import com.trs.webframework.config.MethodConfig;
import com.trs.webframework.context.MethodContext;
import org.apache.log4j.Logger;

public class DefaultSaveLogger
extends AbstractLogger
implements ServiceExcuteLogger {
    private static final Logger LOG = Logger.getLogger(DefaultSaveLogger.class);
    private static final int LOGDESC_MAX_BYTE_LENGTH = 3000;
    private static final int LOGDESC_MAX_LENGTH = 1500;

    public int startLog(MethodConfig methodConfig, MethodContext methodContext) {
        try {
            String string = methodConfig.getLogObjClassName();
            if (CMyString.isEmpty(string)) {
                LOG.warn((Object)"no objklass provide ,execute log fail!");
                return 0;
            }
            Class<?> clazz = Class.forName(string);
            BaseObj baseObj = null;
            boolean bl = methodContext.getObjectId() == 0;
            String string2 = null;
            if (bl) {
                baseObj = (BaseObj)clazz.newInstance();
                string2 = I18NMessage.get(DefaultSaveLogger.class, "DefaultSaveLogger.label1", "\u65b0\u5efa");
                string2 = string2 + WCMTypes.getObjName(baseObj.getWCMType(), true);
            } else {
                baseObj = BaseObj.findById(clazz, methodContext.getObjectId());
                string2 = I18NMessage.get(DefaultSaveLogger.class, "DefaultSaveLogger.label2", "\u4fee\u6539");
                string2 = string2 + baseObj;
            }
            return this.log(methodConfig, string2, baseObj);
        }
        catch (Exception exception) {
            LOG.error((Object)"execute log fail", (Throwable)exception);
            return 0;
        }
    }

    public void endLog(int n) {
        int n2 = 0;
        try {
            n2 = (Integer)ContextParameters.get(6);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n2 > 0) {
            try {
                Log log = new Log();
                log.loadById(n, "LOGID,TOPID,STIMEMILLIS,LOGOBJTYPE");
                long l = System.currentTimeMillis();
                log.setEndTimeMillis(l);
                log.setExecTime(l - log.getStartTimeMillis());
                log.setResult(1);
                log.setLogType(3);
                log.setObj(BaseObj.findById(log.getObjType(), n2));
                if (log.getTopLogId() == 0) {
                    BaseContextHelper.setArg(LogServer.CONTEXT_INDEX_TOPID, null);
                }
                log.save();
            }
            catch (Exception exception) {
                LOG.error((Object)"Failed to finish a log", (Throwable)exception);
            }
        } else {
            LogServer.endRecordSucceedOperation(n);
        }
    }

    public void endLogWithFaliure(int n, Throwable throwable) {
        int n2 = 0;
        try {
            n2 = (Integer)ContextParameters.get(6);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n2 > 0) {
            try {
                Log log = Log.findById(n);
                long l = System.currentTimeMillis();
                log.setEndTimeMillis(l);
                log.setExecTime(l - log.getStartTimeMillis());
                log.setResult(1);
                log.setLogType(3);
                log.setObj(BaseObj.findById(log.getObjType(), n2));
                String string = log.getDesc();
                string = string + "\n" + CMyException.getStackTraceText(throwable);
                if (string.getBytes().length > 3000) {
                    string = string.substring(0, 1500);
                }
                log.setDesc(string);
                if (log.getTopLogId() == 0) {
                    BaseContextHelper.setArg(LogServer.CONTEXT_INDEX_TOPID, null);
                }
                log.save();
            }
            catch (Exception exception) {
                LOG.error((Object)"Failed to finish a log", (Throwable)exception);
            }
        } else {
            LogServer.endRecordFailedOperation(n, throwable);
        }
    }
}

