/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.trsserver.task;

import com.eprobiti.trs.TRSConnection;
import com.eprobiti.trs.TRSDataBase;
import com.eprobiti.trs.TRSDataBaseColumn;
import com.eprobiti.trs.TRSException;
import com.trs.cms.auth.persistent.User;
import com.trs.gateway.client.GWConnection;
import com.trs.gateway.client.GWManager;
import com.trs.gateway.client.GWTaskStatus;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.ConnectPasswordEncrypter;
import com.trs.infra.persistent.db.DBConnectionConfig;
import com.trs.infra.persistent.db.DBManager;
import com.trs.wcm.trsserver.task.DBHelper;
import com.trs.wcm.trsserver.task.ISearchTaskMgr;
import com.trs.wcm.trsserver.task.SearchTaskConstants;
import com.trs.wcm.trsserver.task.persistent.SearchTask;
import com.trs.wcm.trsserver.task.persistent.SearchTasks;
import com.trs.wcm.trsserver.task.persistent.TRSGateway;
import com.trs.wcm.trsserver.task.persistent.TRSServer;
import java.util.HashMap;
import java.util.Properties;

public class SearchTaskMgr
implements ISearchTaskMgr {
    public SearchTasks queryTasks(WCMFilter wCMFilter) throws WCMException {
        return SearchTasks.openWCMObjs(null, wCMFilter);
    }

    public SearchTask saveTask(User user, SearchTask searchTask) throws WCMException {
        String string = searchTask.getViewName().trim();
        String string2 = this.createDBViewNameNotUsed(searchTask.getViewType(), string);
        if (!string2.equalsIgnoreCase(string) && searchTask.isAddMode()) {
            searchTask.setViewName(string2);
        }
        this.createViewOnDB(searchTask);
        this.createTableOnTRSServerFrom(searchTask);
        String string3 = this.createTaskOnGateway(searchTask);
        searchTask.setTRSGWTaskName(string3);
        searchTask.save(user);
        return searchTask;
    }

    public void createViewOnDB(SearchTask searchTask) throws WCMException {
        String string = this.createDBViewSQL(searchTask);
        DBManager dBManager = DBManager.getDBManager();
        dBManager.sqlExecuteUpdate(string);
    }

    public void deleteViewOnDB(SearchTask searchTask) throws WCMException {
        String string = "drop view " + searchTask.getViewName();
        DBManager dBManager = DBManager.getDBManager();
        dBManager.sqlExecuteUpdate(string);
    }

    public int queryTaskStatus(SearchTask searchTask) throws WCMException {
        TRSGateway tRSGateway = searchTask.getTRSGateway();
        try {
            Properties properties = new Properties();
            properties.setProperty("property_gw_host", tRSGateway.getIP());
            properties.setProperty("property_gw_port", String.valueOf(tRSGateway.getPort()));
            properties.setProperty("property_gw_username", tRSGateway.getUserName());
            properties.setProperty("property_gw_password", tRSGateway.getPassword());
            GWConnection gWConnection = GWManager.getConnection((Properties)properties);
            GWTaskStatus gWTaskStatus = gWConnection.getTaskStatus(searchTask.getTRSGWTaskName());
            return gWTaskStatus.isRunning() ? 2 : 3;
        }
        catch (Exception exception) {
            throw new WCMException("\u521b\u5efaGateway\u8fde\u63a5\u5931\u8d25\uff01", exception);
        }
    }

    public boolean deleteTask(SearchTask searchTask) throws WCMException {
        this.deleteTaskOnGateway(searchTask);
        this.deleteTableOnTRSServerFrom(searchTask);
        this.deleteViewOnDB(searchTask);
        return true;
    }

    public String createDBViewSQL(SearchTask searchTask) throws WCMException {
        String string;
        String string2 = null;
        string2 = !searchTask.isAddMode() && searchTask.isChangeProperty("FIELDS") ? searchTask.getNewPropertyAsString("FIELDS") : searchTask.getFields();
        String[] stringArray = string2.split(",");
        StringBuffer stringBuffer = new StringBuffer(string2.length() + 100);
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            if ((string = string.trim()).length() == 0) continue;
            if (!searchTask.getMainTableName().equalsIgnoreCase("wcmchnldoc")) {
                stringBuffer.append(SearchTaskMgr.createSelectExpress(string));
            } else {
                stringBuffer.append(string);
            }
            stringBuffer.append(",");
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        String string3 = "create";
        if (!searchTask.isAddMode()) {
            string = "drop view " + searchTask.getViewName();
            DBManager dBManager = DBManager.getDBManager();
            dBManager.sqlExecuteUpdate(string);
        }
        string3 = string3 + " view " + searchTask.getViewName() + " as \n" + "select  " + stringBuffer + "\n from " + searchTask.getFrom() + "\n where " + searchTask.getWhere();
        return string3;
    }

    public String createDBViewNameNotUsed(int n, String string) throws WCMException {
        String string2 = string;
        DBManager dBManager = DBManager.getDBManager();
        String string3 = string2;
        int n2 = 1;
        while (true) {
            ++n2;
            WCMFilter wCMFilter = new WCMFilter("", "TName=?", "");
            wCMFilter.addSearchValues(string3);
            SearchTasks searchTasks = SearchTasks.openWCMObjs(null, wCMFilter);
            if (searchTasks.isEmpty()) {
                try {
                    dBManager.sqlExecuteIntQuery("select 1 from " + string3);
                }
                catch (Exception exception) {
                    return string3;
                }
            }
            string3 = string2 + n2;
        }
    }

    public static final String createSelectExpress(String string) {
        String string2 = string.trim();
        for (int i = 0; i < SearchTaskConstants.LOGIC_FIELDS.length; ++i) {
            if (!SearchTaskConstants.LOGIC_FIELDS[i].equalsIgnoreCase(string2)) continue;
            return SearchTaskConstants.LOGIC_FIELD_SELECT_EXPRESS[i];
        }
        return string;
    }

    public String createTaskOnGateway(SearchTask searchTask) throws WCMException {
        DBConnectionConfig dBConnectionConfig = DBManager.getDBManager().getDBConnConfig();
        TRSServer tRSServer = searchTask.getTRSServer();
        TRSGateway tRSGateway = searchTask.getTRSGateway();
        try {
            String string;
            Properties properties = new Properties();
            properties.setProperty("property_gw_host", tRSGateway.getIP());
            properties.setProperty("property_gw_port", String.valueOf(tRSGateway.getPort()));
            properties.setProperty("property_gw_username", tRSGateway.getUserName());
            properties.setProperty("property_gw_password", tRSGateway.getPassword());
            System.out.println(properties);
            GWConnection gWConnection = null;
            gWConnection = GWManager.getConnection((Properties)properties);
            Properties properties2 = new Properties();
            properties2.put("property_rdb_url", dBConnectionConfig.getConnectionURL());
            properties2.put("property_product_name", "wcm");
            properties2.put("property_rdb_username", dBConnectionConfig.getConnectionUser());
            properties2.put("property_rdb_password", ConnectPasswordEncrypter.deEncrypt(dBConnectionConfig.getConnectionPassword()));
            properties2.put("property_rdb_viewname", searchTask.getViewName());
            properties2.put("property_rdb_view_primarykey", searchTask.getViewIDName());
            properties2.put("property_rdb_tablename", searchTask.getMainTableName());
            properties2.put("property_rdb_primarykey", searchTask.getMainIDName());
            properties2.put("property_trs_host", tRSServer.getIP());
            properties2.put("property_trs_port", String.valueOf(tRSServer.getPort()));
            properties2.put("property_trs_username", tRSServer.getUserName());
            properties2.put("property_trs_password", tRSServer.getPassword());
            properties2.put("property_trs_database", searchTask.getViewName());
            System.out.println(properties2);
            HashMap hashMap = new HashMap();
            if (!searchTask.isAddMode()) {
                string = searchTask.getTRSGWTaskName();
                gWConnection.deleteTask(string);
            }
            if ((string = gWConnection.createTask(properties2, hashMap)) != null) {
                System.out.println("\u521b\u5efa\u4efb\u52a1\uff1a" + string);
            }
            return string;
        }
        catch (Exception exception) {
            throw new WCMException("\u521b\u5efaGateway\u8fde\u63a5\u5931\u8d25\uff01", exception);
        }
    }

    public void deleteTaskOnGateway(SearchTask searchTask) throws WCMException {
        TRSGateway tRSGateway = searchTask.getTRSGateway();
        try {
            Properties properties = new Properties();
            properties.setProperty("property_gw_host", tRSGateway.getIP());
            properties.setProperty("property_gw_port", String.valueOf(tRSGateway.getPort()));
            properties.setProperty("property_gw_username", tRSGateway.getUserName());
            properties.setProperty("property_gw_password", tRSGateway.getPassword());
            GWConnection gWConnection = null;
            gWConnection = GWManager.getConnection((Properties)properties);
            gWConnection.deleteTask(searchTask.getTRSGWTaskName());
        }
        catch (Exception exception) {
            throw new WCMException("\u5220\u9664Gateway\u4efb\u52a1\u5931\u8d25\uff01", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createTableOnTRSServerFrom(SearchTask searchTask) throws WCMException {
        TRSServer tRSServer = null;
        if (searchTask.isAddMode()) {
            tRSServer = searchTask.getTRSServer();
        } else {
            tRSServer = TRSServer.findById(searchTask.getNewPropertyAsInt("TRSERVERID", 0));
            if (tRSServer == null) {
                throw new WCMException("\u6307\u5b9a\u7684TRSServer\u4e0d\u5b58\u5728[ID=" + searchTask.getNewPropertyAsInt("TRSERVERID", 0) + "]");
            }
        }
        TRSConnection tRSConnection = null;
        try {
            try {
                tRSConnection = new TRSConnection();
                tRSConnection.connect(tRSServer.getIP(), String.valueOf(tRSServer.getPort()), tRSServer.getUserName(), tRSServer.getPassword());
                String string = searchTask.getViewName();
                TRSDataBase tRSDataBase = new TRSDataBase(tRSConnection, searchTask.getViewName());
                if (!searchTask.isAddMode()) {
                    tRSDataBase.delete();
                    tRSDataBase = new TRSDataBase(tRSConnection, searchTask.getViewName());
                }
                tRSDataBase.setProperty("FIRSTTEXTCOL", searchTask.getDefaultSearchName());
                String string2 = searchTask.getViewIDName();
                DBHelper.DBFieldInfo[] dBFieldInfoArray = DBHelper.queryDBFields(searchTask.getViewName());
                TRSDataBaseColumn[] tRSDataBaseColumnArray = new TRSDataBaseColumn[dBFieldInfoArray.length];
                for (int i = 0; i < dBFieldInfoArray.length; ++i) {
                    tRSDataBaseColumnArray[i] = this.makeTRSColumn(string, string2, dBFieldInfoArray[i]);
                }
                tRSDataBase.addColumn(tRSDataBaseColumnArray);
                tRSDataBase.create();
            }
            catch (Exception exception) {
                throw new WCMException("\u64cd\u4f5cTRSserver\u5931\u8d25\uff01TaskId=" + searchTask.getId(), exception);
            }
            Object var11_11 = null;
            if (tRSConnection == null) return;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (tRSConnection != null) {
                tRSConnection.close();
                tRSConnection = null;
            }
            throw throwable;
        }
        tRSConnection.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteTableOnTRSServerFrom(SearchTask searchTask) throws WCMException {
        TRSServer tRSServer = searchTask.getTRSServer();
        TRSConnection tRSConnection = null;
        try {
            try {
                tRSConnection = new TRSConnection();
                tRSConnection.connect(tRSServer.getIP(), String.valueOf(tRSServer.getPort()), tRSServer.getUserName(), tRSServer.getPassword());
                TRSDataBase[] tRSDataBaseArray = tRSConnection.getDataBases(searchTask.getViewName());
                tRSDataBaseArray[0].delete();
            }
            catch (Exception exception) {
                throw new WCMException("\u64cd\u4f5cTRSserver\u5931\u8d25\uff01TaskId=" + searchTask.getId(), exception);
            }
            Object var6_6 = null;
            if (tRSConnection == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (tRSConnection != null) {
                tRSConnection.close();
                tRSConnection = null;
            }
            throw throwable;
        }
        tRSConnection.close();
    }

    private TRSDataBaseColumn makeTRSColumn(String string, String string2, DBHelper.DBFieldInfo dBFieldInfo) throws TRSException {
        TRSDataBaseColumn tRSDataBaseColumn = new TRSDataBaseColumn(string, dBFieldInfo.getName());
        switch (dBFieldInfo.getType()) {
            case 2005: {
                tRSDataBaseColumn.setIntProperty("TYPE", 68);
                tRSDataBaseColumn.setIntProperty("RELEVANCE", 1);
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                tRSDataBaseColumn.setIntProperty("TYPE", 64);
                tRSDataBaseColumn.setIntProperty("CACHEDATA", 1);
                break;
            }
            case -5: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 16: {
                tRSDataBaseColumn.setIntProperty("TYPE", 65);
                if (!dBFieldInfo.getName().equalsIgnoreCase(string2)) break;
                tRSDataBaseColumn.setIntProperty("UNIQUEVALUE", 1);
                break;
            }
            default: {
                if (dBFieldInfo.getName().equalsIgnoreCase("CHNLNAME") || dBFieldInfo.getName().equalsIgnoreCase("SITENAME") || dBFieldInfo.getName().equalsIgnoreCase("DOCPUBURL")) {
                    tRSDataBaseColumn.setIntProperty("TYPE", 66);
                } else {
                    tRSDataBaseColumn.setIntProperty("TYPE", 67);
                }
                tRSDataBaseColumn.setIntProperty("RELEVANCE", 1);
                if (!dBFieldInfo.getName().equalsIgnoreCase("DOCKEYWORDS")) break;
                tRSDataBaseColumn.setIntProperty("MULTIVALUE", 1);
            }
        }
        return tRSDataBaseColumn;
    }
}

