/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.photo.publish;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FileHelper;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlUtil;
import com.trs.wcm.photo.IImageLibConfig;
import com.trs.wcm.photo.ImageLibHelper;
import java.io.File;

public class WCMTagParserImage
extends BaseTagParser {
    IImageLibConfig m_oImageLibConfig = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
    private static TagBeanInfo s_TagBeanInfo = null;

    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tagBeanAttrInfo = null;
            TagBeanInfo tagBeanInfo = new TagBeanInfo();
            tagBeanInfo.setName("TRS_IMAGE");
            tagBeanInfo.setDesc("TRS_IMAGE");
            tagBeanInfo.setType(TagBeanInfo.BodyType.IGNORE);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("FIELD");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("IMAGE");
            tagBeanAttrInfo.setEnumValue(new String[]{"IMAGE", "_RECURL", "UPLOADALL"});
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("INDEX");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("SIZE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanAttrInfo.setDefaultValue("75");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("EXTRA");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("WIDTH");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("HEIGHT");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("UPLOAD");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("RETURNFILESIZE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("false");
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("UPLOADALL");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("AUTOLINK");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("false");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("TARGET");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("_self");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("ORIGINAL");
            tagBeanAttrInfo.setDesc(I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label1", "\u83b7\u53d6\u539f\u56fe"));
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("false");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("URLISABS");
            tagBeanAttrInfo.setDesc(I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label2", "\u662f\u5426\u4f7f\u7528\u7edd\u5bf9\u8def\u5f84"));
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("false");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            s_TagBeanInfo = tagBeanInfo;
        }
        return s_TagBeanInfo;
    }

    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        Object object;
        Object object2;
        IPublishElement iPublishElement = publishTagContext.getUpperHost();
        if (iPublishElement.isFolder()) {
            throw new WCMException(I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label3", "TRS_IMAGE\u7f6e\u6807\u4e0d\u80fd\u5e94\u7528\u5230\u680f\u76ee[") + iPublishElement.getInfo() + I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label4", "]\u4e0a\uff01"));
        }
        if (!(iPublishElement.getSubstance() instanceof Document)) {
            throw new WCMException(I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label5", "TRS_IMAGE\u7f6e\u6807\u76ee\u524d\u53ea\u80fd\u7528\u5230\u6587\u6863\u5bf9\u8c61\u4e0a\uff0c\u4e0d\u80fd\u7528\u5230\u5176\u5b83\u5bf9\u8c61[") + iPublishElement.getInfo() + I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label4", "]\u4e0a\uff01"));
        }
        Document document = (Document)iPublishElement.getSubstance();
        String string = publishTagContext.getAttribute("FIELD");
        if ("UPLOADALL".equalsIgnoreCase(string)) {
            String[] stringArray = ImageLibHelper.getAllImageFiles(document);
            for (int i = 0; i < stringArray.length; ++i) {
                this.distributeImageFile(publishTagContext, iPublishElement, stringArray[i]);
            }
            if ("true".equalsIgnoreCase(publishTagContext.getAttribute("ORIGINAL"))) {
                String string2 = document.getAttributeValue("SRCFILE");
                this.distributeImageFile(publishTagContext, iPublishElement, string2);
            }
            return null;
        }
        String string3 = null;
        if ("true".equals(publishTagContext.getAttribute("ORIGINAL"))) {
            string3 = document.getAttributeValue("SRCFILE");
        } else {
            object2 = this.m_oImageLibConfig.getScaleSizes();
            int n = publishTagContext.getAttribute("INDEX", -1);
            int n2 = publishTagContext.getAttribute("SIZE", -1);
            if (n >= ((int[])object2).length) {
                n = ((Object)object2).length - 1;
            }
            if (n < 0) {
                n2 = this.makeNewSize((int[])object2, n2);
            }
            if (n == -1) {
                if (n2 <= 0) {
                    throw new WCMException(I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label6", "TRS_IMAGE\u7f6e\u6807\u4e0a\u5fc5\u987b\u6307\u5b9aIndex\u6216\u8005Size!"));
                }
                string3 = ImageLibHelper.getImageFileNameByScale(document, n2);
            } else {
                string3 = ImageLibHelper.getImageFileNameByScaleIndex(document, n);
            }
            if (string3 == null || string3.length() <= 0) {
                object = ImageLibHelper.getAllImageFiles(document);
                if (object == null || ((String[])object).length <= 0) {
                    return null;
                }
                string3 = object[((String[])object).length - 1];
            }
            if (string3 == null || string3.length() <= 0) {
                publishTagContext.addWarning(I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label7", "\u6839\u636eTRS_IMAGE\u7f6e\u6807\u4e0a\u627e\u4e0d\u5230[") + document + I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label8", "]\u6307\u5b9aIndex[") + n + I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label9", "]\u6216\u8005Size[") + n2 + I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label10", "]\u627e\u4e0d\u5230\u56fe\u7247!"));
                return null;
            }
        }
        if ("IMAGE".equalsIgnoreCase(string) || publishTagContext.getAttribute("UPLOAD", false) || CMyString.isEmpty(string)) {
            this.distributeImageFile(publishTagContext, iPublishElement, string3);
        }
        object2 = publishTagContext.getPathCompass();
        String string4 = ((PublishPathCompass)object2).getAbsoluteHttpPath(iPublishElement);
        if (publishTagContext.getAttribute("RETURNFILESIZE", false)) {
            FilesMan filesMan = FilesMan.getFilesMan();
            object = filesMan.mapFilePath(string3, 0);
            File file = new File((String)object + string3);
            return new String[]{FileHelper.convertFileSize(file.length())};
        }
        if (!publishTagContext.getAttribute("URLISABS", false)) {
            string4 = HtmlUtil.calRelativePath(string4, publishTagContext.getPageHttpPath());
        }
        string4 = string4 + string3;
        if ("_RECURL".equalsIgnoreCase(string)) {
            return new String[]{string4};
        }
        Document document2 = (Document)iPublishElement.getSubstance();
        object = document2.getTitle();
        String string5 = publishTagContext.getAttribute("EXTRA");
        String string6 = HtmlUtil.renderImage(string4, (String)object, string5, publishTagContext.getAttribute("WIDTH"), publishTagContext.getAttribute("HEIGHT"));
        if (publishTagContext.getAttribute("AUTOLINK", true)) {
            string6 = WCMTagParserImage.addAutoLink(string6, publishTagContext);
        }
        return new String[]{string6};
    }

    private int makeNewSize(int[] nArray, int n) {
        int n2;
        boolean bl = false;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] != n) continue;
            bl = true;
            break;
        }
        for (n2 = nArray.length - 1; !bl && n2 >= 0; --n2) {
            if (nArray[n2] >= n) continue;
            if (n2 == nArray.length - 1) {
                n = nArray[n2];
                break;
            }
            int n3 = nArray[n2 + 1] - n;
            int n4 = n - nArray[n2];
            if (n3 > n4) {
                n = nArray[n2];
                break;
            }
            n = nArray[n2 + 1];
            break;
        }
        return n;
    }

    private void distributeImageFile(PublishTagContext publishTagContext, IPublishElement iPublishElement, String string) throws WCMException {
        String string2 = string;
        String string3 = FilesMan.getFilesMan().mapFilePath(string2, 0) + string2;
        if (!CMyFile.fileExists(string3)) {
            publishTagContext.addWarning(iPublishElement.getInfo() + I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label11", "-\u56fe\u7247"), iPublishElement.getId(), I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label12", "\u5728\u78c1\u76d8\u4e0a\u6ca1\u6709\u627e\u5230(") + iPublishElement.getInfo() + I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label13", ")\u7684\u56fe\u7247[") + string2 + "]");
            return;
        }
        PublishPathCompass publishPathCompass = publishTagContext.getPathCompass();
        boolean bl = publishTagContext.isPreview();
        String string4 = CMyString.setStrEndWith(publishPathCompass.getLocalPath(iPublishElement, bl), File.separatorChar);
        PublishSyncGlobalTuner.insureLocalPathExists(string4);
        try {
            CMyFile.copyFile(string3, string4 + string2);
        }
        catch (CMyException cMyException) {
            cMyException.printStackTrace();
            publishTagContext.addWarning(iPublishElement.getInfo() + I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label11", "-\u56fe\u7247"), iPublishElement.getId(), I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label14", "\u62f7\u8d1d(") + iPublishElement.getInfo() + I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label13", ")\u7684\u56fe\u7247[") + string2 + I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label15", "]\u53d1\u751f\u5f02\u5e38:") + CMyException.getStackTraceText(cMyException));
        }
        if (!bl) {
            IPublishFolder iPublishFolder;
            if (iPublishElement instanceof IPublishContent && (iPublishFolder = iPublishElement.getFolder()) == null) {
                IPublishContent iPublishContent = (IPublishContent)iPublishElement;
                iPublishContent.setFolder(iPublishContent.getOriginalHome());
                iPublishElement = iPublishContent;
            }
            publishTagContext.getFileDistributeShip().distributeFile(string3, iPublishElement);
        }
    }

    protected static String addAutoLink(String string, PublishTagContext publishTagContext) throws WCMException {
        String string2 = publishTagContext.getAttribute("TARGET");
        String string3 = "";
        String string4 = publishTagContext.getAttribute("LINKTEXT");
        String string5 = null;
        String string6 = WCMTagParserImage.getAutoLinkUrl(publishTagContext);
        if (!publishTagContext.getUpperHost().isLink()) {
            string6 = HtmlUtil.calRelativePath(string6, publishTagContext.getPageHttpPath());
        }
        return HtmlUtil.renderLink(string6, string2, string5, string3, string, string4);
    }

    protected static String getAutoLinkUrl(PublishTagContext publishTagContext) throws WCMException {
        IPublishElement iPublishElement = publishTagContext.getUpperHost();
        if (iPublishElement == null) {
            throw new WCMException(I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label16", "\u6ca1\u6709\u627e\u5230UpperHost\u5bf9\u8c61!"));
        }
        if (!(iPublishElement instanceof IPublishContent)) {
            throw new WCMException(I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label17", "\u5f53\u524dUpperHost[") + iPublishElement.getInfo() + I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label18", "]\u4e0d\u662fIPublishContent\u5bf9\u8c61"));
        }
        IPublishContent iPublishContent = (IPublishContent)iPublishElement;
        PublishPathCompass publishPathCompass = publishTagContext.getPathCompass();
        switch (iPublishContent.getBodyType()) {
            case 40: {
                String string = iPublishContent.getFileName();
                return publishPathCompass.getAbsoluteHttpPath(publishTagContext.getUpperHost()) + string;
            }
            case 30: {
                return iPublishContent.getLinkUrl();
            }
        }
        return publishPathCompass.getHttpUrl((IPublishContent)publishTagContext.getUpperHost(), 0);
    }
}

