/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.photo.impl;

import com.trs.DreamFactory;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.XmlDocWithDom4j;
import com.trs.wcm.photo.IImageLibConfig;
import com.trs.wcm.photo.impl.MagicImageImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class PhotoImporter {
    private static final String PROP_PICFILE = "_PICFILE_";
    private static final Logger logger = Logger.getLogger(PhotoImporter.class);
    private static DocumentMgr m_oDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
    private static IImageLibConfig m_oImageLibConfig = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
    private FilesMan m_oFileMan = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importViaZipFile(String string, Channel channel) throws WCMException {
        File file = new File(string);
        if (!file.exists()) {
            throw new WCMException(55, I18NMessage.get(PhotoImporter.class, "PhotoImporter.label1", "\u6587\u4ef6[") + string + I18NMessage.get(PhotoImporter.class, "PhotoImporter.label2", "]\u4e0d\u5b58\u5728\uff01"));
        }
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(file.getParent());
        stringBuffer.append(File.separator);
        stringBuffer.append("temp").append(System.currentTimeMillis());
        stringBuffer.append(File.separator);
        String string2 = stringBuffer.toString();
        CMyUnZipFile cMyUnZipFile = new CMyUnZipFile(string, string2);
        try {
            cMyUnZipFile.addFileExtFilters("xml");
            cMyUnZipFile.doUnZipAnd();
            if (!logger.isDebugEnabled()) {
                file.delete();
            }
        }
        catch (CMyException cMyException) {
            throw new WCMException(200, I18NMessage.get(PhotoImporter.class, "PhotoImporter.label3", "Zip\u6587\u4ef6\u89e3\u538b\u5931\u8d25!"), cMyException);
        }
        ArrayList arrayList = cMyUnZipFile.getFilteredFiles();
        String string3 = null;
        Document document = null;
        List list = null;
        Iterator iterator = null;
        Iterator iterator2 = null;
        Element element3 = null;
        com.trs.components.wcm.content.persistent.Document document2 = null;
        String string4 = null;
        String string5 = null;
        Element element2 = null;
        try {
            this.m_oFileMan = FilesMan.getFilesMan();
            if (arrayList != null && arrayList.size() > 0) {
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    string3 = (String)arrayList.get(i);
                    try {
                        document = XmlDocWithDom4j.parse(string3);
                    }
                    catch (DocumentException documentException) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)"parse fail!", (Throwable)documentException);
                        continue;
                    }
                    list = document.selectNodes("//WCMDOCUMENTS/WCMDOCUMENT");
                    if (list == null || list.isEmpty()) continue;
                    for (Element element3 : list) {
                        document2 = new com.trs.components.wcm.content.persistent.Document();
                        iterator2 = element3.elementIterator();
                        while (iterator2.hasNext()) {
                            element2 = (Element)iterator2.next();
                            string4 = element2.getName();
                            string5 = element2.getText();
                            if (PROP_PICFILE.equals(string4)) {
                                string4 = "DOCRELWORDS";
                                string5 = this.processPic(string2 + string5);
                            }
                            document2.setPropertyWithString(string4, string5);
                        }
                        if (channel != null) {
                            document2.setChannel(channel);
                        }
                        m_oDocumentMgr.save(document2);
                    }
                }
            }
            Object var21_21 = null;
        }
        catch (Throwable throwable) {
            Object var21_22 = null;
            CMyFile.deleteDir(string2);
            throw throwable;
        }
        CMyFile.deleteDir(string2);
    }

    private String processPic(String string) throws WCMException {
        CharSequence charSequence;
        File file = new File(string);
        if (!file.exists()) {
            throw new WCMException(55, I18NMessage.get(PhotoImporter.class, "PhotoImporter.label4", "\u56fe\u7247[") + string + I18NMessage.get(PhotoImporter.class, "PhotoImporter.label2", "]\u4e0d\u5b58\u5728\uff01"));
        }
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        String string3 = this.m_oFileMan.getNextFilePathName("P0", string2);
        file.renameTo(new File(string3));
        int[] nArray = m_oImageLibConfig.getScaleSizes();
        MagicImageImpl magicImageImpl = new MagicImageImpl();
        try {
            magicImageImpl.initMagicImage(string3);
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(PhotoImporter.class, "PhotoImporter.label5", "\u521d\u59cb\u5316\u539f\u59cb\u56fe\u7247\u5931\u8d25\uff01[File=") + string3 + "]", exception);
        }
        if ("bmp".equalsIgnoreCase(string2)) {
            charSequence = "gif";
            try {
                magicImageImpl.initMagicImage(string3);
                magicImageImpl.convertImageFormat((String)charSequence);
                string3 = magicImageImpl.writeImageToWCMData("W0");
            }
            catch (Exception exception) {
                throw new WCMException(I18NMessage.get(PhotoImporter.class, "PhotoImporter.label6", "\u8f6c\u6362\u56fe\u7247[") + string3 + I18NMessage.get(PhotoImporter.class, "PhotoImporter.label7", "]\u4e3a[") + (String)charSequence + I18NMessage.get(PhotoImporter.class, "PhotoImporter.label8", "]\u5931\u8d25"), exception);
            }
        }
        charSequence = new StringBuffer(24 * (nArray.length + 1));
        try {
            magicImageImpl.scaleImage(75, 75);
            String string4 = magicImageImpl.writeImageToWCMData("W0");
            ((StringBuffer)charSequence).append(string4);
            int n = (int)magicImageImpl.getWidth();
            int n2 = (int)magicImageImpl.getHeight();
            boolean bl = n > n2;
            int n3 = bl ? n : n2;
            int n4 = 0;
            int n5 = nArray.length;
            for (int i = 1; i < n5 && (n4 = nArray[i]) <= n3; ++i) {
                if (bl) {
                    magicImageImpl.scaleImage(n4, 0);
                } else {
                    magicImageImpl.scaleImage(0, n4);
                }
                string4 = magicImageImpl.writeImageToWCMData("W0");
                ((StringBuffer)charSequence).append(",").append(string4);
            }
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(PhotoImporter.class, "PhotoImporter.label9", "\u7f29\u653e\u56fe\u7247\u5931\u8d25\uff01"), exception);
        }
        return ((StringBuffer)charSequence).toString();
    }
}

