/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.photo.impl;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyFileX;
import com.trs.wcm.photo.IMagicImage;
import com.trs.wcm.photo.impl.JImageMarkUtil;
import java.awt.Dimension;
import java.awt.Rectangle;
import magick.ImageInfo;
import magick.MagickImage;
import magick.MontageInfo;
import magick.PixelPacket;

public class MagicImageImpl
implements IMagicImage {
    private byte[] m_btTempImageContent = null;
    private String m_sSrcFileName = null;
    private MagickImage m_oSrcMagickImage = null;
    private ImageInfo m_oSrcImageInfo = null;
    private Dimension m_oSrcImageDimension = null;
    private String m_sImageFileExt = null;

    public byte[] addWaterMark(String string, int[] nArray) throws Exception {
        String string2 = CMyFileX.autoToAbsoluteFilePath(string);
        this.m_btTempImageContent = JImageMarkUtil.addImageMark(this.m_sSrcFileName, string2, nArray);
        return this.m_btTempImageContent;
    }

    public byte[] borderImage(String string, int n, int n2) throws Exception {
        this.m_oSrcMagickImage.setBorderColor(PixelPacket.queryColorDatabase((String)string));
        MagickImage magickImage = this.m_oSrcMagickImage.borderImage(new Rectangle(0, 0, n, n2));
        this.m_btTempImageContent = magickImage.imageToBlob(this.m_oSrcImageInfo);
        return this.m_btTempImageContent;
    }

    public double getHeight() throws Exception {
        return this.m_oSrcImageDimension.getHeight();
    }

    public double getWidth() throws Exception {
        return this.m_oSrcImageDimension.getWidth();
    }

    public void montageImages(String[] stringArray, String string, String string2, String string3, String string4, int n) throws Exception {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        MagickImage[] magickImageArray = new MagickImage[stringArray.length];
        for (int i = 0; i < magickImageArray.length; ++i) {
            magickImageArray[i] = this.createMagickImage(stringArray[i]);
        }
        MagickImage magickImage = new MagickImage(magickImageArray);
        MontageInfo montageInfo = new MontageInfo(new ImageInfo());
        if (string != null) {
            montageInfo.setTitle(string);
        }
        montageInfo.setBackgroundColor(PixelPacket.queryColorDatabase((String)string3));
        montageInfo.setBorderColor(PixelPacket.queryColorDatabase((String)string4));
        montageInfo.setBorderWidth(n);
        MagickImage magickImage2 = magickImage.montageImages(montageInfo);
        magickImage2.setFileName(string2);
        magickImage2.writeImage(new ImageInfo());
    }

    public byte[] raiseImage(int n, int n2, boolean bl) throws Exception {
        MagickImage magickImage = new MagickImage(this.m_oSrcImageInfo);
        magickImage.raiseImage(new Rectangle(0, 0, n, n2), bl);
        this.m_btTempImageContent = magickImage.imageToBlob(this.m_oSrcImageInfo);
        return this.m_btTempImageContent;
    }

    public byte[] rotateImage(double d) throws Exception {
        MagickImage magickImage = this.m_oSrcMagickImage.rotateImage(d);
        this.m_btTempImageContent = magickImage.imageToBlob(this.m_oSrcImageInfo);
        return this.m_btTempImageContent;
    }

    public byte[] scaleImage(int n, int n2) throws Exception {
        int n3;
        if (n2 <= 0 && n <= 0) {
            throw new WCMException(I18NMessage.get(MagicImageImpl.class, "MagicImageImpl.label1", "\u53c2\u6570\u4f20\u5165\u6709\u8bef\uff01"));
        }
        int n4 = n;
        if (n4 <= 0) {
            n4 = this.m_oSrcImageDimension.width * n2 / this.m_oSrcImageDimension.height;
        }
        if (n4 == 0) {
            n4 = 1;
        }
        if ((n3 = n2) <= 0) {
            n3 = this.m_oSrcImageDimension.height * n / this.m_oSrcImageDimension.width;
        }
        if (n3 == 0) {
            n3 = 1;
        }
        MagickImage magickImage = this.m_oSrcMagickImage.scaleImage(n4, n3);
        this.m_oSrcImageInfo.setQuality(70);
        this.m_btTempImageContent = magickImage.imageToBlob(this.m_oSrcImageInfo);
        return this.m_btTempImageContent;
    }

    public void setBackgroundColor(String string) throws Exception {
        this.m_oSrcMagickImage.setBackgroundColor(PixelPacket.queryColorDatabase((String)string));
    }

    public byte[] convertImageFormat(String string) throws Exception {
        this.m_oSrcMagickImage.setMagick(string);
        this.m_sImageFileExt = string;
        this.m_btTempImageContent = this.m_oSrcMagickImage.imageToBlob(new ImageInfo());
        return this.m_btTempImageContent;
    }

    public void initMagicImage(String string) throws Exception {
        this.m_btTempImageContent = null;
        this.m_sImageFileExt = null;
        this.m_sSrcFileName = CMyFileX.autoToAbsoluteFilePath(string);
        this.m_oSrcImageInfo = new ImageInfo(this.m_sSrcFileName);
        this.m_oSrcMagickImage = new MagickImage(this.m_oSrcImageInfo);
        this.m_oSrcImageDimension = this.m_oSrcMagickImage.getDimension();
    }

    public void setImageAttribute(String string, String string2) throws Exception {
        this.m_oSrcMagickImage.setImageAttribute(string, string2);
    }

    public byte[] sharpenImage(double d, double d2) throws Exception {
        MagickImage magickImage = this.m_oSrcMagickImage.sharpenImage(d, d2);
        this.m_btTempImageContent = magickImage.imageToBlob(this.m_oSrcImageInfo);
        return this.m_btTempImageContent;
    }

    public void writeImage() throws Exception {
        this.writeImage(this.m_sSrcFileName);
    }

    public void writeImage(String string) throws Exception {
        if (this.m_btTempImageContent != null) {
            CMyFileX.writeFile(string, this.m_btTempImageContent);
            return;
        }
        if (this.m_oSrcMagickImage != null) {
            this.m_oSrcMagickImage.setFileName(string);
            this.m_oSrcMagickImage.writeImage(this.m_oSrcImageInfo);
        }
    }

    public String writeImageToSystemTemp() throws Exception {
        FilesMan filesMan = FilesMan.getFilesMan();
        String string = filesMan.getNextFileName("ST", this.getOutputImageFileExt());
        String string2 = filesMan.mapFilePath(string, 0) + string;
        this.writeImage(string2);
        return string2;
    }

    private String getOutputImageFileExt() {
        if (this.m_sImageFileExt != null) {
            return this.m_sImageFileExt;
        }
        if (this.m_sSrcFileName == null) {
            return "jpg";
        }
        return CMyFile.extractFileExt(this.m_sSrcFileName);
    }

    public int getSize() throws Exception {
        return this.m_oSrcMagickImage.sizeBlob();
    }

    private MagickImage createMagickImage(String string) throws Exception {
        ImageInfo imageInfo = new ImageInfo(string);
        return new MagickImage(imageInfo);
    }

    public void setOutputImageFileExt(String string) {
        this.m_sImageFileExt = string;
    }

    public String writeImageToWCMData(String string) throws Exception {
        FilesMan filesMan = FilesMan.getFilesMan();
        String string2 = filesMan.getNextFileName(string, this.getOutputImageFileExt());
        String string3 = filesMan.mapFilePath(string2, 0) + string2;
        this.writeImage(string3);
        return string2;
    }

    public String getSrcImageFileName() {
        return this.m_sSrcFileName;
    }

    public void scaleImage(int n, int n2, String string) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cropImage(int n, int n2, int n3, int n4, String string) throws Exception {
        MagickImage magickImage = null;
        try {
            MagickImage magickImage2 = new MagickImage(this.m_oSrcImageInfo);
            magickImage = magickImage2.cropImage(new Rectangle(n, n2, n3, n4));
            magickImage.setFileName(string);
            magickImage.writeImage(this.m_oSrcImageInfo);
            Object var9_8 = null;
            if (magickImage == null) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (magickImage == null) throw throwable;
            magickImage.destroyImages();
            throw throwable;
        }
        magickImage.destroyImages();
    }
}

