/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.photo.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyFileX;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlElement;
import com.trs.infra.util.html.HtmlElementFinder;
import com.trs.wcm.photo.IImageLibConfig;
import com.trs.wcm.photo.IImageLibMgr;
import com.trs.wcm.photo.IMagicImage;
import com.trs.wcm.photo.ImageInfo;
import com.trs.wcm.photo.ImageLibHelper;
import com.trs.wcm.photo.impl.ImageMagickCmd;
import com.trs.wcm.photo.impl.MagicImageImpl;
import org.apache.log4j.Logger;

public class ImageLibMgrImpl
implements IImageLibMgr {
    private DBManager m_oDBMgr = DBManager.getDBManager();
    static final String SQL_DELETE_DOC_QUOTE_IMGS = "delete from WCMDocQuoteImage where DocId=?";
    static final String SQL_GET_QUOTE_DOCUMENTS = "EXISTS(SELECT WCMDocQuoteImage.DocId from WCMDocQuoteImage where WCMDocQuoteImage.QuoteImageId=? and WCMDocument.DocId=WCMDocQuoteImage.DocId)";
    static final String SQL_INSERT_DOC_QUOTE_IMG = "insert into WCMDocQuoteImage(DocId, QuoteImageId) values(?, ?)";
    static final String SQL_EXISTS_DOC_QUOTE_IMG = "SELECT DOCID FROM WCMDocQuoteImage WHERE DocId=? AND QuoteImageId=?";
    private static Logger logger = Logger.getLogger(ImageLibMgrImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageInfo saveImageInfo(ImageInfo imageInfo) throws WCMException {
        Object object;
        if (imageInfo == null) {
            throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label1", "\u4f20\u5165\u7684ImageInfo\u4e3a\u7a7a\uff01"));
        }
        DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        Document document = null;
        String string = null;
        try {
            int n;
            if (imageInfo.isAddMode()) {
                document = Document.createNewInstance();
                document.setType(10);
                document.setContent(imageInfo.getImageTitle());
                string = this.saveImageFileToServer(imageInfo.getImageFileName(), "P0");
                document.setAttribute("SRCFILE", string);
                document.setReleaseTime(CMyDateTime.now());
            } else {
                document = Document.findById(imageInfo.getId());
                document.canEdit(ContextHelper.getLoginUser());
                string = document.getAttributeValue("SRCFILE");
                if (!string.equalsIgnoreCase(imageInfo.getImageFileName()) && imageInfo.getImageFileName() != null && imageInfo.getImageFileName().length() > 0) {
                    try {
                        CMyFile.deleteFile(this.convertToAbsolutePath(string));
                        string = this.saveImageFileToServer(imageInfo.getImageFileName(), "P0");
                        document.setAttribute("SRCFILE", string);
                    }
                    catch (CMyException cMyException) {
                        throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label2", "\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25\uff01"), cMyException);
                    }
                }
            }
            try {
                this.markOriginalImg(document, string, imageInfo);
            }
            catch (WCMException wCMException) {
                throw wCMException;
            }
            catch (Exception exception) {
                throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label2", "\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25\uff01"), exception);
            }
            imageInfo.setImageFileName(string);
            String string2 = this.scaleImage0(imageInfo, document);
            this.addWaterMark(imageInfo, CMyString.split(string2, ","));
            document.setAttribute("WATERMARKFILE", imageInfo.getMarkImageFile());
            int[] nArray = imageInfo.getMarkPos();
            String string3 = "";
            if (nArray != null && nArray.length > 0) {
                for (n = 0; n < nArray.length; ++n) {
                    string3 = string3 + nArray[n] + ",";
                }
            }
            document.setAttribute("WATERMAREKPOS", string3);
            n = imageInfo.getImageKindId();
            if (imageInfo.isAddMode()) {
                object = Channel.findById(n);
                if (object == null) {
                    throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label3", "\u6307\u5b9a\u7684\u4e3b\u5206\u7c7b[ID=") + n + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label4", "]\u4e0d\u5b58\u5728\uff01"));
                }
                document.setChannel((Channel)object);
            }
            if (imageInfo.isAddMode()) {
                document.setTitle(imageInfo.getImageTitle());
            }
            document = documentMgr.save(document);
            if (imageInfo.isAddMode()) {
                object = imageInfo.getOtherImageKinedId();
                for (int i = 0; i < ((Object)object).length; ++i) {
                    if (object[i] == n) continue;
                    Channel channel = Channel.findById((int)object[i]);
                    if (channel == null) {
                        throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label5", "\u6307\u5b9a\u5206\u7c7b[ID=") + (int)object[i] + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label4", "]\u4e0d\u5b58\u5728\uff01"));
                    }
                    documentMgr.quoteTo(document, channel);
                }
            }
            imageInfo.setId(document.getId());
            object = imageInfo;
            Object var13_15 = null;
        }
        catch (Throwable throwable) {
            block20: {
                Object var13_16 = null;
                if (imageInfo.isAddMode() || document == null || !document.isLocked()) break block20;
                document.cancelUpdate(ContextHelper.getLoginUser());
            }
            throw throwable;
        }
        if (!imageInfo.isAddMode() && document != null && document.isLocked()) {
            document.cancelUpdate(ContextHelper.getLoginUser());
        }
        return object;
    }

    private void markOriginalImg(Document document, String string, ImageInfo imageInfo) throws Exception {
        IImageLibConfig iImageLibConfig = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
        if (!iImageLibConfig.isOriginalMarked()) {
            return;
        }
        String string2 = document.getAttributeValue("SRCFILEMARKED");
        FilesMan filesMan = FilesMan.getFilesMan();
        Object object = CMyFile.extractFileExt(string);
        if (CMyString.isEmpty(string2)) {
            string2 = filesMan.copyWCMFile(string, "W0");
        } else {
            CMyFile.copyFile(CMyFileX.autoToAbsoluteFilePath(string), CMyFileX.autoToAbsoluteFilePath(string2));
        }
        int[] nArray = iImageLibConfig.getScaleSizes();
        if (iImageLibConfig.isCmdUsed()) {
            Object object2;
            ImageMagickCmd.ImageObj imageObj = new ImageMagickCmd.ImageObj(string2);
            if ("bmp".equals(((String)object).toLowerCase()) && !CMyString.isEmpty((String)(object2 = imageInfo.getConvertToImageType())) && !"bmp".equals(object2)) {
                try {
                    ImageMagickCmd.convertBmp(imageObj, (String)object2);
                    object = object2;
                    string2 = CMyFile.extractFileName(imageObj.filename);
                }
                catch (Exception exception) {
                    throw new WCMException("\u8f6c\u6362\u56fe\u7247[" + string2 + "]\u4e3a[" + (String)object2 + "]\u5931\u8d25", exception);
                }
            }
            if (imageInfo.isAddMark()) {
                object2 = imageInfo.getMarkPos();
                String string3 = imageInfo.getMarkImageFile();
                ImageMagickCmd.ImageObj imageObj2 = new ImageMagickCmd.ImageObj();
                imageObj2.setFilename(string3);
                string3 = filesMan.mapFilePath(string3, 0) + string3;
                String string4 = filesMan.getNextFileName("ST", CMyFile.extractFileExt(string3), CMyDateTime.now(), true);
                ImageMagickCmd.ImageObj imageObj3 = new ImageMagickCmd.ImageObj(string4, 0, 0);
                this.addWatermarkWithCmd(iImageLibConfig, nArray[nArray.length - 1], imageObj2, imageObj3, string3, string4, imageObj.filename, (int[])object2);
            }
        } else {
            int n;
            String string5;
            IMagicImage iMagicImage = (IMagicImage)DreamFactory.createObjectById("IMagicImage");
            if ("bmp".equals(((String)object).toLowerCase()) && !CMyString.isEmpty(string5 = imageInfo.getConvertToImageType()) && !"bmp".equals(string5)) {
                try {
                    iMagicImage.initMagicImage(string2);
                    iMagicImage.convertImageFormat(string5);
                    String string6 = iMagicImage.writeImageToWCMData("W0");
                    filesMan.deleteFile(string2);
                    string2 = string6;
                }
                catch (Exception exception) {
                    throw new WCMException("\u8f6c\u6362\u56fe\u7247[" + string2 + "]\u4e3a[" + string5 + "]\u5931\u8d25", exception);
                }
            }
            if (imageInfo.isAddMark() && (n = iImageLibConfig.getWaterMarkSize(nArray[nArray.length - 1])) > 0) {
                iMagicImage.initMagicImage(imageInfo.getMarkImageFile());
                this.addWaterMark(string2, iMagicImage, n, imageInfo.getMarkPos());
            }
        }
        document.setAttribute("SRCFILEMARKED", string2);
    }

    protected String scaleImage0(ImageInfo imageInfo, Document document) throws WCMException {
        CharSequence charSequence;
        String string;
        IImageLibConfig iImageLibConfig = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
        int[] nArray = iImageLibConfig.getScaleSizes();
        if (iImageLibConfig.isCmdUsed()) {
            this.scaleImageWithCmd(iImageLibConfig, imageInfo, document);
            return null;
        }
        String string2 = this.saveImageFileToServer(imageInfo.getImageFileName(), "W0");
        IMagicImage iMagicImage = (IMagicImage)DreamFactory.createObjectById("IMagicImage");
        try {
            iMagicImage.initMagicImage(string2);
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label6", "\u521d\u59cb\u5316\u539f\u59cb\u56fe\u7247\u5931\u8d25\uff01[File=") + string2 + "]", exception);
        }
        if (CMyFile.extractFileExt(imageInfo.getImageFileName()).equalsIgnoreCase("BMP") && !CMyString.isEmpty(string = imageInfo.getConvertToImageType()) && !"bmp".equals(string)) {
            try {
                iMagicImage.initMagicImage(string2);
                iMagicImage.convertImageFormat(string);
                charSequence = string2;
                string2 = iMagicImage.writeImageToWCMData("W0");
                CMyFile.deleteFile(this.convertToAbsolutePath((String)charSequence));
            }
            catch (Exception exception) {
                throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label7", "\u8f6c\u6362\u56fe\u7247[") + string2 + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label8", "]\u4e3a[") + string + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label9", "]\u5931\u8d25"), exception);
            }
        }
        string = null;
        if (!document.isAddMode() && !CMyString.isEmpty((String)(charSequence = document.getRelateWords()))) {
            this.deleteUnUsedImages((String)charSequence, document.getId());
        }
        charSequence = new StringBuffer(24 * (nArray.length + 1));
        try {
            try {
                iMagicImage.scaleImage(75, 75);
                String string3 = this.writeImage2File(iMagicImage, (String[])string, 0);
                ((StringBuffer)charSequence).append(string3);
                int n = (int)iMagicImage.getWidth();
                int n2 = (int)iMagicImage.getHeight();
                boolean bl = "width".equals(iImageLibConfig.getScaleStyle()) || "auto".equalsIgnoreCase(iImageLibConfig.getScaleStyle()) && n > n2;
                int n3 = bl ? n : n2;
                int n4 = 0;
                int n5 = nArray.length;
                for (int i = 1; i < n5 && (n4 = nArray[i]) <= n3; ++i) {
                    if (bl) {
                        iMagicImage.scaleImage(n4, 0);
                    } else {
                        iMagicImage.scaleImage(0, n4);
                    }
                    string3 = this.writeImage2File(iMagicImage, (String[])string, i);
                    ((StringBuffer)charSequence).append(",").append(string3);
                }
                Object var18_21 = null;
            }
            catch (WCMException wCMException) {
                throw wCMException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label10", "\u7f29\u653e\u56fe\u7247\u5931\u8d25\uff01"), exception);
            }
        }
        catch (Throwable throwable) {
            Object var18_22 = null;
            CMyFile.deleteFile(this.convertToAbsolutePath(string2));
            throw throwable;
        }
        CMyFile.deleteFile(this.convertToAbsolutePath(string2));
        document.setRelateWords(((StringBuffer)charSequence).toString());
        return ((StringBuffer)charSequence).toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String scaleImageWithCmd(IImageLibConfig iImageLibConfig, ImageInfo imageInfo, Document document) throws WCMException {
        StringBuffer stringBuffer;
        String string;
        block19: {
            int n;
            int n2;
            int n3;
            ImageMagickCmd.ImageObj imageObj;
            String string2;
            String string3;
            ImageMagickCmd.ImageObj imageObj2;
            ImageMagickCmd.ImageObj imageObj3;
            ImageMagickCmd.ImageObj imageObj4;
            String string4;
            int[] nArray;
            boolean bl;
            Object object;
            FilesMan filesMan;
            String string5;
            block18: {
                string5 = imageInfo.getImageFileName();
                filesMan = FilesMan.getFilesMan();
                if (!document.isAddMode() && !CMyString.isEmpty((String)(object = document.getRelateWords()))) {
                    this.deleteUnUsedImages((String)object, document.getId());
                }
                object = iImageLibConfig.getScaleSizes();
                bl = imageInfo.isAddMark();
                nArray = imageInfo.getMarkPos();
                string4 = null;
                string = null;
                imageObj4 = null;
                imageObj3 = null;
                stringBuffer = new StringBuffer(24 * (((Object)object).length + 1));
                try {
                    try {
                        boolean bl2;
                        if (bl) {
                            string4 = imageInfo.getMarkImageFile();
                            imageObj4 = new ImageMagickCmd.ImageObj();
                            imageObj4.setFilename(string4);
                            string4 = filesMan.mapFilePath(string4, 0) + string4;
                            string = filesMan.getNextFileName("ST", CMyFile.extractFileExt(string4), CMyDateTime.now(), true);
                            imageObj3 = new ImageMagickCmd.ImageObj(string, 0, 0);
                        }
                        imageObj2 = new ImageMagickCmd.ImageObj();
                        imageObj2.setFilename(string5);
                        string3 = CMyFile.extractFileExt(string5);
                        if ("bmp".equals(string3.toLowerCase()) && !CMyString.isEmpty(string2 = imageInfo.getConvertToImageType()) && !"bmp".equals(string2)) {
                            try {
                                ImageMagickCmd.convertBmp(imageObj2, string2);
                                string3 = string2;
                            }
                            catch (Exception exception) {
                                throw new WCMException("\u8f6c\u6362\u56fe\u7247[" + string5 + "]\u4e3a[" + string2 + "]\u5931\u8d25", exception);
                            }
                        }
                        string2 = filesMan.getNextFileName("W0", string3, CMyDateTime.now(), true);
                        imageObj = new ImageMagickCmd.ImageObj(string2, 75, 75);
                        ImageMagickCmd.scale(imageObj2, imageObj);
                        stringBuffer.append(CMyFile.extractFileName(string2));
                        n3 = false;
                        boolean bl3 = bl2 = "width".equals(iImageLibConfig.getScaleStyle()) || "auto".equalsIgnoreCase(iImageLibConfig.getScaleStyle()) && imageObj2.width > imageObj2.height;
                        if (bl2) {
                            n2 = imageObj2.width;
                            imageObj.height = 0;
                            n = ((Object)object).length;
                            break block18;
                        }
                        int n4 = imageObj2.height;
                        imageObj.width = 0;
                        int n5 = ((Object)object).length;
                        for (int i = 1; i < n5 && (n3 = object[i]) <= n4; ++i) {
                            string2 = filesMan.getNextFileName("W0", string3, CMyDateTime.now(), true);
                            if (n3 == n4) {
                                stringBuffer.append(",").append(CMyFile.extractFileName(string2));
                                String string6 = FilesMan.getFilesMan().mapFilePath(string5, 0) + string5;
                                CMyFile.copyFile(string6, string2);
                                break block19;
                            }
                            imageObj.height = n3;
                            imageObj.filename = string2;
                            ImageMagickCmd.scale(imageObj2, imageObj);
                            if (bl) {
                                this.addWatermarkWithCmd(iImageLibConfig, n3, imageObj4, imageObj3, string4, string, string2, nArray);
                            }
                            stringBuffer.append(",").append(CMyFile.extractFileName(string2));
                        }
                        break block19;
                    }
                    catch (Exception exception) {
                        throw new WCMException("\u7f29\u653e\u56fe\u7247\u5931\u8d25\uff01", exception);
                    }
                }
                catch (Throwable throwable) {
                    Object var25_31 = null;
                    if (string != null) {
                        // empty if block
                    }
                    throw throwable;
                }
            }
            for (int i = 1; i < n && (n3 = object[i]) <= n2; ++i) {
                string2 = filesMan.getNextFileName("W0", string3, CMyDateTime.now(), true);
                if (n3 == n2) {
                    stringBuffer.append(",").append(CMyFile.extractFileName(string2));
                    String string7 = FilesMan.getFilesMan().mapFilePath(string5, 0) + string5;
                    CMyFile.copyFile(string7, string2);
                    break;
                }
                imageObj.width = n3;
                imageObj.filename = string2;
                ImageMagickCmd.scale(imageObj2, imageObj);
                if (bl) {
                    this.addWatermarkWithCmd(iImageLibConfig, n3, imageObj4, imageObj3, string4, string, string2, nArray);
                }
                stringBuffer.append(",").append(CMyFile.extractFileName(string2));
            }
        }
        Object var25_30 = null;
        if (string == null) {
            // empty if block
        }
        document.setRelateWords(stringBuffer.toString());
        return stringBuffer.toString();
    }

    private String getWebPic(String string) {
        String string2 = "";
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n >= 0) {
                string2 = string.substring(n + 1);
            } else if (string.startsWith("W0")) {
                string2 = string;
            }
        }
        return string2;
    }

    private void deleteUnUsedImages(String string, int n) throws WCMException {
        Cloneable cloneable;
        Object object;
        IImageLibMgr iImageLibMgr = (IImageLibMgr)DreamFactory.createObjectById("IImageLibMgr");
        Documents documents = iImageLibMgr.getDocumentsQuoteImage(n);
        Document document = null;
        String string2 = "";
        int n2 = documents.size();
        for (int i = 0; i < n2; ++i) {
            document = (Document)documents.getAt(i);
            if (document == null) continue;
            object = new HtmlElementFinder(document.getHtmlContent());
            cloneable = null;
            String string3 = null;
            while ((cloneable = ((HtmlElementFinder)object).findNextElement("img")) != null) {
                if (!"1".equals(((HtmlElement)cloneable).getAttributeValue("fromphoto")) || (string3 = this.getWebPic(((HtmlElement)cloneable).getAttributeValue("src"))).equals("")) continue;
                string2 = string2 + string3 + ",";
            }
        }
        String string4 = "RelatePhotoIds = ? AND APPFLAG = 20";
        WCMFilter wCMFilter = new WCMFilter("WCMAPPENDIX", string4, "");
        wCMFilter.addSearchValues(n + "");
        object = Appendixes.openWCMObjs(null, wCMFilter);
        cloneable = null;
        int n3 = ((BaseObjs)object).size();
        for (int i = 0; i < n3; ++i) {
            cloneable = (Appendix)((BaseObjs)object).getAt(i);
            if (cloneable == null || ((Appendix)cloneable).getFile() == null) continue;
            string2 = string2 + ((Appendix)cloneable).getFile() + ",";
        }
        String[] stringArray = string.split(",");
        FilesMan filesMan = FilesMan.getFilesMan();
        int n4 = stringArray.length;
        for (int i = 0; i < n4; ++i) {
            if (string2.indexOf(stringArray[i]) >= 0) continue;
            filesMan.deleteFile(stringArray[i]);
        }
    }

    private void addWatermarkWithCmd(IImageLibConfig iImageLibConfig, int n, ImageMagickCmd.ImageObj imageObj, ImageMagickCmd.ImageObj imageObj2, String string, String string2, String string3, int[] nArray) throws Exception {
        int n2 = iImageLibConfig.getWaterMarkSize(n);
        if (n2 <= 0) {
            return;
        }
        int n3 = imageObj.width;
        if (n3 > n2) {
            int n4 = imageObj.height;
            imageObj2.width = n2;
            imageObj2.height = n4 * n2 / n3 <= 10 ? n4 : 0;
            ImageMagickCmd.scale(imageObj, imageObj2);
            ImageMagickCmd.addWaterkmark(string2, string3, nArray);
        } else {
            ImageMagickCmd.addWaterkmark(string, string3, nArray);
        }
    }

    private String writeImage2File(IMagicImage iMagicImage, String[] stringArray, int n) throws Exception {
        String string = null;
        if (stringArray != null && stringArray.length > n) {
            string = stringArray[n];
            iMagicImage.writeImage(string);
            string = CMyFile.extractFileName(string);
        } else {
            string = iMagicImage.writeImageToWCMData("W0");
        }
        return string;
    }

    protected String scaleImage(ImageInfo imageInfo, Document document) throws WCMException {
        Object object;
        IMagicImage iMagicImage = (IMagicImage)DreamFactory.createObjectById("IMagicImage");
        IImageLibConfig iImageLibConfig = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
        String string = this.saveImageFileToServer(imageInfo.getImageFileName(), "W0");
        int[] nArray = iImageLibConfig.getScaleSizes();
        if (CMyFile.extractFileExt(imageInfo.getImageFileName()).equalsIgnoreCase("BMP") && !CMyString.isEmpty((String)(object = imageInfo.getConvertToImageType())) && !"bmp".equals(object)) {
            try {
                iMagicImage.initMagicImage(string);
                iMagicImage.convertImageFormat(imageInfo.getConvertToImageType());
                string = iMagicImage.writeImageToWCMData("W0");
            }
            catch (Exception exception) {
                throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label7", "\u8f6c\u6362\u56fe\u7247[") + string + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label8", "]\u4e3a[") + imageInfo.getConvertToImageType() + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label9", "]\u5931\u8d25"), exception);
            }
        }
        object = FilesMan.getFilesMan();
        StringBuffer stringBuffer = new StringBuffer(24 * (nArray.length + 1));
        String[] stringArray = null;
        if (!document.isAddMode()) {
            stringArray = ImageLibHelper.getAllImageFiles(document);
        }
        try {
            iMagicImage.initMagicImage(string);
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label6", "\u521d\u59cb\u5316\u539f\u59cb\u56fe\u7247\u5931\u8d25\uff01[File=") + string + "]", exception);
        }
        try {
            boolean bl = iMagicImage.getWidth() > iMagicImage.getHeight();
            for (int i = 0; i < nArray.length; ++i) {
                int n = (int)(bl ? iMagicImage.getWidth() : iMagicImage.getHeight());
                if (i == 0 || n >= nArray[i]) {
                    if (bl) {
                        iMagicImage.scaleImage(nArray[i], i == 0 ? 75 : 0);
                    } else {
                        iMagicImage.scaleImage(i == 0 ? 75 : 0, nArray[i]);
                    }
                    String string2 = null;
                    if (stringArray != null && stringArray.length > i) {
                        String string3 = ((FilesMan)object).mapFilePath(stringArray[i], 0) + stringArray[i];
                        iMagicImage.writeImage(string3);
                        string2 = stringArray[i];
                    } else {
                        string2 = iMagicImage.writeImageToWCMData("W0");
                    }
                    if (i > 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(string2);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label10", "\u7f29\u653e\u56fe\u7247\u5931\u8d25\uff01"), exception);
        }
        document.setRelateWords(stringBuffer.toString());
        return stringBuffer.toString();
    }

    private void addWaterMark(ImageInfo imageInfo, String[] stringArray) throws WCMException {
        if (stringArray == null || stringArray.length <= 0) {
            return;
        }
        if (!imageInfo.isAddMark()) {
            return;
        }
        MagicImageImpl magicImageImpl = new MagicImageImpl();
        try {
            magicImageImpl.initMagicImage(imageInfo.getMarkImageFile());
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label12", "\u8bfb\u53d6\u6c34\u5370\u6587\u4ef6[") + imageInfo.getMarkImageFile() + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label13", "]\u5931\u8d25\uff01"));
        }
        IImageLibConfig iImageLibConfig = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
        int[] nArray = iImageLibConfig.getScaleSizes();
        try {
            int n = stringArray.length;
            int n2 = 0;
            int[] nArray2 = imageInfo.getMarkPos();
            for (int i = 0; i < nArray.length && n > i; ++i) {
                n2 = iImageLibConfig.getWaterMarkSize(nArray[i]);
                if (n2 <= 0) continue;
                this.addWaterMark(stringArray[i], magicImageImpl, n2, nArray2);
            }
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label14", "\u56fe\u7247\u52a0\u6c34\u5370\u5931\u8d25\uff01"), exception);
        }
    }

    public void addWaterMark(String string, String string2, int[] nArray) throws Exception {
        int n;
        IImageLibConfig iImageLibConfig = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
        FilesMan filesMan = FilesMan.getFilesMan();
        int[] nArray2 = iImageLibConfig.getScaleSizes();
        if (iImageLibConfig.isCmdUsed()) {
            ImageMagickCmd.ImageObj imageObj = new ImageMagickCmd.ImageObj(string);
            int[] nArray3 = nArray;
            String string3 = string2;
            ImageMagickCmd.ImageObj imageObj2 = new ImageMagickCmd.ImageObj();
            imageObj2.setFilename(string3);
            string3 = filesMan.mapFilePath(string3, 0) + string3;
            String string4 = filesMan.getNextFileName("ST", CMyFile.extractFileExt(string3), CMyDateTime.now(), true);
            ImageMagickCmd.ImageObj imageObj3 = new ImageMagickCmd.ImageObj(string4, 0, 0);
            this.addWatermarkWithCmd(iImageLibConfig, nArray2[nArray2.length - 1], imageObj2, imageObj3, string3, string4, imageObj.filename, nArray3);
            return;
        }
        IMagicImage iMagicImage = (IMagicImage)DreamFactory.createObjectById("IMagicImage");
        IMagicImage iMagicImage2 = (IMagicImage)DreamFactory.createObjectById("IMagicImage");
        try {
            iMagicImage.initMagicImage(string);
            iMagicImage2.initMagicImage(string2);
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label15", "\u521d\u59cb\u5316\u56fe\u7247[") + string + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label13", "]\u5931\u8d25\uff01"), exception);
        }
        try {
            float f = Float.parseFloat(ConfigServer.getServer().getSysConfigValue("WATERMARK_SIZE_FOR_DOC_APPENDIX", "50"));
            double d = iMagicImage.getWidth();
            n = (int)(f >= 1.0f ? f : (float)Math.round(d * (double)f));
            if (n > (int)Math.round(d)) {
                n = Math.round(n) / 2;
            }
        }
        catch (Exception exception) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e\u548c\u6e90\u56fe\u7247\u7684\u5bbd\u5ea6\u5931\u8d25\uff01", exception);
        }
        this.addWaterMark(string, iMagicImage2, n, nArray);
    }

    private void addWaterMark(String string, IMagicImage iMagicImage, int n, int[] nArray) throws WCMException {
        IMagicImage iMagicImage2 = (IMagicImage)DreamFactory.createObjectById("IMagicImage");
        boolean bl = true;
        try {
            iMagicImage2.initMagicImage(string);
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label15", "\u521d\u59cb\u5316\u56fe\u7247[") + string + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label13", "]\u5931\u8d25\uff01"), exception);
        }
        String string2 = iMagicImage.getSrcImageFileName();
        try {
            int n2;
            if (!bl) {
                iMagicImage.rotateImage(90.0);
                string2 = iMagicImage.writeImageToSystemTemp();
                iMagicImage.initMagicImage(string2);
            }
            if ((n2 = (int)iMagicImage.getWidth()) > n) {
                iMagicImage.scaleImage(n, 0);
                string2 = iMagicImage.writeImageToSystemTemp();
            }
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label16", "\u6c34\u5370\u6587\u4ef6[") + string2 + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label17", "]\u7f29\u653e\u5931\u8d25\uff01"), exception);
        }
        String string3 = null;
        try {
            iMagicImage2.addWaterMark(string2, nArray);
            string3 = iMagicImage2.writeImageToSystemTemp();
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label18", "\u7ed9\u6587\u4ef6[") + string + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label19", "]\u6dfb\u52a0\u6c34\u5370[") + string2 + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label13", "]\u5931\u8d25\uff01"), exception);
        }
        try {
            iMagicImage2.initMagicImage(string3);
            CMyFile.moveFile(string3, CMyFileX.autoToAbsoluteFilePath(string));
        }
        catch (Exception exception) {
            logger.error((Object)(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label18", "\u7ed9\u6587\u4ef6[") + string + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label19", "]\u6dfb\u52a0\u6c34\u5370[") + string2 + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label13", "]\u5931\u8d25\uff01")), (Throwable)exception);
        }
    }

    private String saveImageFileToServer(String string, String string2) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        String string3 = this.convertToAbsolutePath(string);
        String string4 = filesMan.getNextFileName(string2, CMyFile.extractFileExt(string3));
        String string5 = filesMan.mapFilePath(string4, 0) + string4;
        try {
            CMyFile.copyFile(string3, string5);
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label20", "\u4fdd\u5b58\u6587\u4ef6[") + string3 + "]-->[" + string5 + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label13", "]\u5931\u8d25\uff01"), exception);
        }
        return string4;
    }

    private String convertToAbsolutePath(String string) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        String string2 = string;
        if (CMyFile.fileExists(string2)) {
            return string2;
        }
        try {
            string2 = filesMan.mapFilePath(string, 0) + string;
        }
        catch (WCMException wCMException) {
            // empty catch block
        }
        if (!CMyFile.fileExists(string2)) {
            throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label21", "\u6307\u5b9a\u7684\u56fe\u7247\u6587\u4ef6[") + string2 + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label4", "]\u4e0d\u5b58\u5728\uff01"));
        }
        return string2;
    }

    public void deleteDocumentQuoteImage(int n, int n2) throws WCMException {
        String[] stringArray = new String[]{"delete from WCMDocQuoteImage where DocId=? and QuoteImageId=?"};
        int[] nArray = new int[]{n, n2};
        this.m_oDBMgr.sqlExecuteUpdate(stringArray, nArray);
    }

    public void deleteDocumentQuoteImage(int n, String string) throws WCMException {
        boolean bl = string == null || string.length() == 0;
        String[] stringArray = new String[]{SQL_DELETE_DOC_QUOTE_IMGS + (bl ? "" : " and QuoteImageId not in(" + string + ")")};
        int[] nArray = new int[]{n};
        this.m_oDBMgr.sqlExecuteUpdate(stringArray, nArray);
    }

    public void deleteDocumentQuoteImage(int n) throws WCMException {
        String[] stringArray = new String[]{SQL_DELETE_DOC_QUOTE_IMGS};
        int[] nArray = new int[]{n};
        this.m_oDBMgr.sqlExecuteUpdate(stringArray, nArray);
    }

    public Documents getDocumentsQuoteImage(int n) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("WCMDOCUMENT", SQL_GET_QUOTE_DOCUMENTS, "");
        wCMFilter.addSearchValues(0, n);
        return Documents.openWCMObjs(null, wCMFilter);
    }

    public void recordDocumentQuoteImage(int n, int n2) throws WCMException {
        boolean bl;
        int[] nArray = new int[]{n, n2};
        boolean bl2 = bl = this.m_oDBMgr.sqlExecuteIntQuery(SQL_EXISTS_DOC_QUOTE_IMG, nArray) > 0;
        if (bl) {
            return;
        }
        this.m_oDBMgr.sqlExecuteUpdate(new String[]{SQL_INSERT_DOC_QUOTE_IMG}, nArray);
    }

    public Appendixes getImageAppendixes(WCMFilter wCMFilter, BaseChannel baseChannel, boolean bl) throws WCMException {
        int n = 0;
        WCMFilter wCMFilter2 = new WCMFilter("", null, "");
        wCMFilter2.addSearchValues(n++, 20);
        wCMFilter2.addSearchValues(n++, 30);
        String string = "AppFlag in(?, ?)";
        if (!bl) {
            string = string + " and IsImportToImageLib=?";
            wCMFilter2.addSearchValues(n++, 0);
        }
        if (baseChannel != null) {
            if (baseChannel.isSite()) {
                String string2 = "exists(select WCMChannel.ChannelId from WCMChannel where WCMChannel.SiteId=? and WCMChnlDoc.ChnlId=WCMChannel.ChannelId)";
                string = string + " and exists(select WCMChnlDoc.DocId from WCMChnlDoc where WCMChnlDoc.Modal=1 and " + string2 + " and WCMAppendix.AppDocId=WCMChnlDoc.DocId)";
            } else {
                string = string + " and exists(select WCMChnlDoc.DocId from WCMChnlDoc where WCMChnlDoc.Modal=1 and WCMChnlDoc.ChnlId=? and WCMAppendix.AppDocId=WCMChnlDoc.DocId)";
            }
            wCMFilter2.addSearchValues(n++, baseChannel.getId());
        }
        wCMFilter2.setWhere(string);
        wCMFilter2.mergeWith(wCMFilter);
        return Appendixes.openWCMObjs(null, wCMFilter2);
    }

    public ImageInfo importImageAppendix(User user, int n, ImageInfo imageInfo) throws WCMException {
        Appendix appendix = Appendix.findById(n);
        if (appendix == null) {
            logger.error((Object)(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label22", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u56fe\u7247\u9644\u4ef6\uff01[ID=") + n + "]"));
            return null;
        }
        if (appendix.getFlag() != 20 && appendix.getFlag() != 30) {
            logger.error((Object)(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label23", "\u6307\u5b9a\u7684\u9644\u4ef6[ID=") + n + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label24", "]\u4e0d\u662f\u56fe\u7247\uff01")));
            return null;
        }
        Document document = Document.findById(appendix.getDocId());
        if (document == null) {
            logger.error((Object)(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label25", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u56fe\u7247\u9644\u4ef6[ID=") + n + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label26", "]\u7684\u6240\u5c5e\u6587\u6863\uff01[DocId=") + appendix.getDocId() + "]"));
            return null;
        }
        int n2 = ImageLibHelper.getTypeQuotedImageLib(appendix);
        if (n2 != 0) {
            logger.error((Object)(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label27", "\u6307\u5b9a\u7684\u56fe\u7247\u9644\u4ef6[ID=") + n + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label28", "]\u662f\u5f15\u7528\u56fe\u7247\u5e93\u7684\u9644\u4ef6\uff01")));
            return null;
        }
        imageInfo.setImageTitle(document.getTitle());
        imageInfo.setImageFileName(appendix.getFile());
        imageInfo.setSrcFileName(appendix.getSrcFile());
        ImageInfo imageInfo2 = this.saveImageInfo(imageInfo);
        if (appendix.getPropertyAsInt("IsImportToImageLib", 0) == 0) {
            appendix.canEdit(user);
            appendix.setProperty("IsImportToImageLib", 1L);
            appendix.update(user);
        }
        return imageInfo2;
    }
}

