/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.photo.impl;

import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import com.trs.wcm.photo.IImageLibConfig;
import com.trs.wcm.photo.ImageLibConstants;
import com.trs.wcm.photo.impl.ImageMagickCmd;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.helpers.Loader;

public class ImageLibConfigImpl
implements IImageLibConfig {
    private static final String RELATED_CONVERT_TYPE = "RELATED_CONVERT_TYPE";
    private static final String WARTERMARK_POS = "WARTERMARK_POS";
    private static final String WATERMARK_ID = "WATERMARK_ID";
    private static final String RELATED_KINDID = "RELATED_KINDID";
    private static final String AUTO_ENABLE = "AUTO_ENABLE";
    private static final String RELATED_KINDIDS = "RELATED_KINDIDS";
    private int m_nRelateSiteId = 0;
    private String[] m_pScaleSizeDescs = new String[0];
    private int[] m_pScaleSizes = new int[0];
    private int m_nDefaultOutTemplateId = 0;
    private int m_nDefaultDetailTemplateId = 0;
    private Properties m_oConfigProperties = null;
    private HashMap m_mapWaterMarkScale = new HashMap();
    private boolean m_zCmdUsed = false;
    private boolean m_zMarkOriginal = false;
    private String m_sScaleStyle = "auto";

    public ImageLibConfigImpl() {
        this.m_mapWaterMarkScale.put(new Integer(240), new Integer(50));
        this.m_mapWaterMarkScale.put(new Integer(500), new Integer(100));
        this.m_mapWaterMarkScale.put(new Integer(640), new Integer(120));
    }

    public WebSite getRelateSite() throws WCMException {
        return WebSite.findById(this.getRelateSiteId());
    }

    public int getRelateSiteId() throws WCMException {
        if (this.m_oConfigProperties == null) {
            this.loadConfig();
        }
        return this.m_nRelateSiteId;
    }

    public Template getDefaultOutlineTemplate() throws WCMException {
        return Template.findById(this.getDefaultOutlineTemplateId());
    }

    public int getDefaultOutlineTemplateId() throws WCMException {
        if (this.m_oConfigProperties == null) {
            this.loadConfig();
        }
        return this.m_nDefaultOutTemplateId;
    }

    public Template getDefaultDetailTemplate() throws WCMException {
        if (this.m_oConfigProperties == null) {
            this.loadConfig();
        }
        return Template.findById(this.m_nDefaultDetailTemplateId);
    }

    public int getDefaultDetailTemplateId() throws WCMException {
        if (this.m_oConfigProperties == null) {
            this.loadConfig();
        }
        return this.m_nDefaultDetailTemplateId;
    }

    public int[] getScaleSizes() throws WCMException {
        this.loadConfig();
        return this.m_pScaleSizes;
    }

    public String[] getSupportImageFileExt() throws WCMException {
        return ConfigServer.getServer().getSysConfigValue("SupportImageFilesExts", "gif,jpg,jpeg,bmp,png").split(",");
    }

    private int[] findScaleSizes() throws WCMException {
        String string = ConfigServer.getServer().getSysConfigValue("ScaleSizes", "124, 133, 240, 500, 640");
        if (string == null || (string = string.trim()).length() <= 0) {
            throw new WCMException(I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label11", "\u56fe\u7247\u5e93\u914d\u7f6e\u9519\u8bef\uff1a\u7f29\u653e\u5c3a\u5bf8\uff08SCALE_SIZE\uff09\u6ca1\u6709\u914d\u7f6e\uff01"));
        }
        int[] nArray = CMyString.splitToInt(string, ",");
        Arrays.sort(nArray);
        int[] nArray2 = new int[nArray.length + 1];
        nArray2[0] = 75;
        System.arraycopy(nArray, 0, nArray2, 1, nArray.length);
        return nArray2;
    }

    public boolean isSupportImageFileExt(String string) throws WCMException {
        String[] stringArray = this.getSupportImageFileExt();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public String getDefaultConvertImageFileExt() throws WCMException {
        return ConfigServer.getServer().getSysConfigValue("DefaultConvertImageFileExt", "gif");
    }

    public boolean reloadConfig() throws WCMException {
        if (this.m_oConfigProperties != null) {
            this.m_oConfigProperties.clear();
        }
        this.m_oConfigProperties = null;
        return this.loadConfig();
    }

    private synchronized boolean loadConfig() throws WCMException {
        this.m_pScaleSizes = this.findScaleSizes();
        this.m_pScaleSizeDescs = this.findScaleSizeDescs();
        this.m_mapWaterMarkScale = this.findScaleRelateMark();
        if (this.m_oConfigProperties != null && !this.m_oConfigProperties.isEmpty()) {
            return true;
        }
        this.m_oConfigProperties = new Properties();
        URL uRL = Loader.getResource((String)"TRSWCMPhoto.properties");
        if (uRL == null) {
            throw new WCMException(I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label7", "\u6ca1\u6709\u627e\u5230\u56fe\u7247\u5e93\u7684\u914d\u7f6e\u6587\u4ef6\uff01[") + "TRSWCMPhoto.properties" + "]");
        }
        try {
            this.m_oConfigProperties.load(uRL.openStream());
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label8", "\u8bfb\u53d6\u56fe\u7247\u5e93\u914d\u7f6e\u6587\u4ef6[") + uRL.getPath() + I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label9", "]\u5931\u8d25\uff01"), exception);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        String string = this.m_oConfigProperties.getProperty("CMD_COMPOSITE");
        if (string != null) {
            hashMap.put("CMD_COMPOSITE", string);
            string = this.m_oConfigProperties.getProperty("CMD_CONVERT");
            hashMap.put("CMD_CONVERT", string);
            string = this.m_oConfigProperties.getProperty("CMD_IDENTIFY");
            hashMap.put("CMD_IDENTIFY", string);
            ImageMagickCmd.setCmds(hashMap);
            this.m_zCmdUsed = true;
        }
        this.m_zMarkOriginal = "true".equals(this.m_oConfigProperties.getProperty("MARKORIGINAL"));
        this.m_sScaleStyle = this.m_oConfigProperties.getProperty("SCALE_STYLE", "auto");
        return true;
    }

    private HashMap findScaleRelateMark() throws WCMException {
        String string = ConfigServer.getServer().getSysConfigValue("WaterMarkScales", "640:120,240:50,500:100");
        if (string == null || (string = string.trim()).length() <= 0) {
            return new HashMap();
        }
        String[] stringArray = CMyString.split(string, ",");
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf(58);
            if (n <= 0) continue;
            Integer n2 = new Integer(stringArray[i].substring(0, n).trim());
            Integer n3 = new Integer(stringArray[i].substring(n + 1).trim());
            hashMap.put(n2, n3);
        }
        return hashMap;
    }

    private String toScalerelateMark() {
        if (this.m_mapWaterMarkScale == null) {
            return "";
        }
        Object[] objectArray = this.m_mapWaterMarkScale.keySet().toArray();
        StringBuffer stringBuffer = new StringBuffer(objectArray.length * 10);
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(objectArray[i]);
            stringBuffer.append(':');
            stringBuffer.append(this.m_mapWaterMarkScale.get(objectArray[i]));
        }
        return stringBuffer.toString();
    }

    public int getWaterMarkSize(int n) throws WCMException {
        this.loadConfig();
        Integer n2 = (Integer)this.m_mapWaterMarkScale.get(new Integer(n));
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    public String getScaleDescAt(int n) throws WCMException {
        this.loadConfig();
        if (n >= this.m_pScaleSizeDescs.length) {
            return I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label14", "\u672a\u77e5");
        }
        String string = this.m_pScaleSizeDescs[n];
        return I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label" + string, string);
    }

    private String[] findScaleSizeDescs() throws WCMException {
        String string = ConfigServer.getServer().getSysConfigValue("ScaleSizeDescs", I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label2", "\u56fe\u7247\u5217\u8868,\u53d1\u5e03\u6982\u89c8,\u4e2d\u56fe,\u5927\u56fe,\u8d85\u5927\u56fe"));
        if (string == null || (string = string.trim()).length() <= 0) {
            throw new WCMException(I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label12", "\u56fe\u7247\u5e93\u914d\u7f6e\u9519\u8bef\uff1a\u7f29\u653e\u5c3a\u5bf8\u63cf\u8ff0\uff08SCALE_SIZE_DESC\uff09\u6ca1\u6709\u914d\u7f6e\uff01"));
        }
        String[] stringArray = CMyString.split(string, ",");
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label1", "\u7f29\u7565\u56fe");
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        return stringArray2;
    }

    public boolean saveConfig() throws WCMException {
        if (this.m_oConfigProperties == null) {
            this.m_oConfigProperties = new Properties();
        }
        ConfigServer.getServer().updateConfigValue("WaterMarkScales", this.toScalerelateMark());
        try {
            this.m_oConfigProperties.setProperty("Installed", "true");
        }
        catch (Error error) {
            error.printStackTrace();
            throw new WCMException(I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label15", "\u4fdd\u5b58\u56fe\u7247\u5e93\u8bbe\u7f6e\u5931\u8d25\uff01"), error);
        }
        return true;
    }

    public void setDefaultTemplateId(int n, int n2) throws WCMException {
        Template template = Template.findById(n2);
        if (template == null) {
            throw new WCMException(I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label16", "\u8bbe\u7f6e\u7684\u7ec6\u89c8\u6a21\u677f\u4e0d\u5b58\u5728\uff01[TempalteId=") + n2 + "]");
        }
        this.m_nDefaultDetailTemplateId = n2;
        template = Template.findById(n);
        if (template == null) {
            throw new WCMException(I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label16", "\u8bbe\u7f6e\u7684\u7ec6\u89c8\u6a21\u677f\u4e0d\u5b58\u5728\uff01[TempalteId=") + n2 + "]");
        }
        this.m_nDefaultOutTemplateId = n;
    }

    public void setImageFileExt(String[] stringArray, String string) throws WCMException {
        ConfigServer.getServer().updateConfigValue("SupportImageFilesExts", CMyString.join(stringArray, ","));
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            bl = true;
            break;
        }
        if (!bl && string != null && string.length() > 0) {
            throw new WCMException(I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label17", "\u9ed8\u8ba4\u7684\u8f6c\u6362\u683c\u5f0f[") + string + I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label18", "]\u4e0d\u5728\u652f\u6301\u7684\u7c7b\u578b\u4e2d\uff01"));
        }
        ConfigServer.getServer().updateConfigValue("DefaultConvertImageFileExt", string);
    }

    public void setScaleSizes(int[] nArray, String[] stringArray, int[] nArray2) throws WCMException {
        if (nArray.length != stringArray.length) {
            throw new WCMException(I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label19", "\u5bbd\u5ea6\u4e0e\u63cf\u8ff0\u957f\u5ea6\u4e0d\u662f\u4e00\u4e00\u5bf9\u5e94"));
        }
        if (nArray.length != nArray2.length) {
            throw new WCMException(I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label20", "\u5bbd\u5ea6\u4e0e\u6c34\u5370\u957f\u5ea6\u4e0d\u662f\u4e00\u4e00\u5bf9\u5e94"));
        }
        ConfigServer.getServer().updateConfigValue("ScaleSizes", CMyString.join(nArray, ","));
        ConfigServer.getServer().updateConfigValue("ScaleSizeDescs", CMyString.join(stringArray, ","));
        this.m_mapWaterMarkScale.clear();
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray2[i] == 0) continue;
            this.m_mapWaterMarkScale.put(new Integer(nArray[i]), new Integer(nArray2[i]));
        }
    }

    public void setRelateSiteId(int n) throws WCMException {
        WebSite webSite = WebSite.findById(n);
        if (webSite == null) {
            throw new WCMException(I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label21", "\u6307\u5b9a\u7ad9\u70b9[SiteId=") + n + I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label22", "]\u4e0d\u5b58\u5728\uff01"));
        }
        this.m_nRelateSiteId = n;
    }

    public boolean isAutoEnable() throws WCMException {
        this.ensureLoaded();
        return "true".equals(this.m_oConfigProperties.get(AUTO_ENABLE));
    }

    public void setAtuoEnable(boolean bl) throws WCMException {
        this.ensureLoaded();
        this.m_oConfigProperties.setProperty(AUTO_ENABLE, String.valueOf(bl));
    }

    public int getRelatedKindId() throws WCMException {
        this.ensureLoaded();
        String string = this.m_oConfigProperties.getProperty(RELATED_KINDID, "0");
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public void setRealtedKindId(int n) throws WCMException {
        this.ensureLoaded();
        this.m_oConfigProperties.setProperty(RELATED_KINDID, String.valueOf(n));
    }

    public int[] getOtherRelatedKindIds() throws WCMException {
        this.ensureLoaded();
        String string = this.m_oConfigProperties.getProperty(RELATED_KINDIDS);
        if (CMyString.isEmpty(string)) {
            return new int[0];
        }
        return CMyString.splitToInt(string, ",");
    }

    public void setOtherRelatedKindIds(String string) throws WCMException {
        this.ensureLoaded();
        String string2 = CMyString.showNull(string, "");
        this.m_oConfigProperties.setProperty(RELATED_KINDIDS, string2);
    }

    public int getRelatedWaterMarkId() throws WCMException {
        this.ensureLoaded();
        String string = this.m_oConfigProperties.getProperty(WATERMARK_ID, "0");
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public void setRelatedWaterMarkId(int n) throws WCMException {
        this.ensureLoaded();
        this.m_oConfigProperties.setProperty(WATERMARK_ID, String.valueOf(n));
    }

    public int[] getRelatedWaterMarkPos() throws WCMException {
        this.ensureLoaded();
        String string = this.m_oConfigProperties.getProperty(WARTERMARK_POS);
        if (CMyString.isEmpty(string)) {
            return new int[]{ImageLibConstants.MARKPOS_RIGHT_BOTTOM};
        }
        return CMyString.splitToInt(string, ",");
    }

    public void setRelatedWaterMarkPos(String string) throws WCMException {
        this.ensureLoaded();
        String string2 = CMyString.showNull(string, "");
        this.m_oConfigProperties.setProperty(WARTERMARK_POS, string2);
    }

    private void ensureLoaded() throws WCMException {
        this.loadConfig();
    }

    public String getRelatedConvertType() throws WCMException {
        this.ensureLoaded();
        return this.m_oConfigProperties.getProperty(RELATED_CONVERT_TYPE, "");
    }

    public void setRelatedConvertType(String string) throws WCMException {
        this.assertValidType(string);
        this.ensureLoaded();
        this.m_oConfigProperties.setProperty(RELATED_CONVERT_TYPE, string);
    }

    private void assertValidType(String string) throws WCMException {
        if (string == null) {
            throw new WCMException(10, I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label23", "\u65e0\u6548\u53c2\u6570!"));
        }
        String string2 = string.toLowerCase();
        if (!"gif".equals(string2) && !"jpg".equals(string2)) {
            throw new WCMException(10, I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label24", "\u65e0\u6548\u7684\u8f6c\u6362\u683c\u5f0f,\u53ea\u652f\u6301\u5230gif/jpg\u7684\u8f6c\u6362!"));
        }
    }

    public boolean isInstalled() throws WCMException {
        this.ensureLoaded();
        String string = this.m_oConfigProperties.getProperty("Installed", "true");
        string = string.toLowerCase();
        return "true".equals(string) || "on".equals(string);
    }

    public void setInstalled() throws WCMException {
        this.ensureLoaded();
        this.m_oConfigProperties.setProperty("Installed", "true");
    }

    public boolean isCmdUsed() throws WCMException {
        if (this.m_oConfigProperties == null) {
            this.loadConfig();
        }
        return this.m_zCmdUsed;
    }

    public boolean isOriginalMarked() throws WCMException {
        this.ensureLoaded();
        return this.m_zMarkOriginal;
    }

    public String getScaleStyle() throws WCMException {
        this.ensureLoaded();
        return this.m_sScaleStyle;
    }
}

