/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.old;

import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.wcm.old.WCMFormInfo;
import com.trs.wcm.old.WCMFormInfos;
import java.util.Enumeration;
import java.util.Hashtable;

public class WCMExcelData
extends Document {
    public static final int OBJ_TYPE = 612;
    public static final String DB_TABLE_NAME = "WCMEXCELDATA";
    public static final String DB_ID_NAME = "RECID";

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("DOCCHANNEL") == null) {
                throw new WCMException(1106, I18NMessage.get(WCMExcelData.class, "WCMExcelData.label1", "\u5c5e\u6027\uff0d\u6240\u5c5e\u9891\u9053\uff08DOCCHANNEL\uff09\u6ca1\u6709\u8bbe\u7f6e(WCMExcel.isValid)"));
            }
            if (this.getProperty("FORMID") == null) {
                throw new WCMException(1106, I18NMessage.get(WCMExcelData.class, "WCMExcelData.label2", "\u5c5e\u6027\uff0d\u6240\u5c5e\u8868\u5355FormId\u6ca1\u6709\u8bbe\u7f6e(WCMExcel.isValid)"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(WCMExcelData.class, "WCMExcelData.label3", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(WCMExcel.isValid)"));
        }
        return true;
    }

    public int getWCMType() {
        return 612;
    }

    public int getChannelId() {
        return this.getPropertyAsInt("DOCCHANNEL", 0);
    }

    public Channel getChannel() throws WCMException {
        int n = this.getChannelId();
        if (n == 0) {
            return null;
        }
        return Channel.findById(n);
    }

    public boolean setChannel(int n) throws WCMException {
        return this.setProperty("DOCCHANNEL", n);
    }

    public boolean setChannel(Channel channel) throws WCMException {
        if (channel == null || !channel.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(WCMExcelData.class, "WCMExcelData.label4", "\u65e0\u6548\u7684\u9891\u9053\u5bf9\u8c61(WCMExcelData.setChannel)"));
        }
        return this.setChannel(channel.getId());
    }

    public boolean setForm(int n) throws WCMException {
        return this.setProperty("FORMID", n);
    }

    public int getFormId() {
        return this.getPropertyAsInt("FORMID", 0);
    }

    public WCMFormInfo getForm() throws WCMException {
        int n = this.getFormId();
        String string = "WCMFORMINFOID=" + n;
        WCMFormInfos wCMFormInfos = new WCMFormInfos(User.getSystem());
        wCMFormInfos.setMaxSize(1);
        try {
            wCMFormInfos.open(new WCMFilter("", string, ""));
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(WCMExcelData.class, "WCMExcelData.label5", "\u83b7\u53d6\u81ea\u5b9a\u4e49\u8868\u5355\u4fe1\u606f\u5931\u8d25\uff01"), exception);
        }
        if (wCMFormInfos.isEmpty()) {
            return null;
        }
        WCMFormInfo wCMFormInfo = (WCMFormInfo)wCMFormInfos.getAt(0);
        return wCMFormInfo;
    }

    public void setPropertyByDocument(Document document) throws WCMException {
        Hashtable hashtable = document.getAllProperty();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.getDBManager().getFieldInfo(this.getDbTableName(), string) == null) continue;
            this.setProperty(string, hashtable.get(string));
        }
    }

    public Document getDocument() throws WCMException {
        if (this.getProperty("DOCID") == null) {
            return null;
        }
        Object var1_1 = null;
        try {
            Documents documents = new Documents(User.getSystem(), 1, 1);
            documents.setMaxBufferSize(1);
            documents.setPageSize(1);
            documents.setMaxSize(1);
            documents.open(new WCMFilter("", "DOCID=" + this.getProperty("DOCID"), ""));
            if (documents.isEmpty()) {
                return null;
            }
            return (Document)documents.getAt(0);
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(WCMExcelData.class, "WCMExcelData.label6", "\u83b7\u53d6\u6587\u6863\u5bf9\u8c61\u5931\u8d25\uff01"), exception);
        }
    }
}

