/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcag2.validator;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyString;
import com.trs.wcag2.HTMLUtil;
import com.trs.wcag2.validator.AbstractValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class HtmlCharsetValidator
extends AbstractValidator {
    protected String m_sType = I18NMessage.get(HtmlCharsetValidator.class, "HtmlCharsetValidator.label1", "W3C\u89c4\u8303");
    protected Object m_oWarning = I18NMessage.get(HtmlCharsetValidator.class, "HtmlCharsetValidator.label2", "\u9875\u9762\u7684Charset\u5c5e\u6027\u6ca1\u6709\u6307\u5b9a");
    protected String m_oExample = I18NMessage.get(HtmlCharsetValidator.class, "HtmlCharsetValidator.label3", "\u5728Head\u8282\u70b9\u4e2d\u6dfb\u52a0\u63cf\u8ff0charset\u7684meta\u8282\u70b9\uff0c\u4f8b\u5982\uff1a<br>") + "<br>&nbsp;&nbsp;&lt;META content=\"text/html; charset=UTF-8\" http-equiv=Content-Type&gt;";

    public Object doValid(String string, HashMap hashMap) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String string2 = "META";
        int n = 1;
        List list = HTMLUtil.findTagStartHTML(string, string2);
        if (list.size() == 0) {
            return Boolean.FALSE;
        }
        for (int[] nArray : list) {
            String string3 = string.substring(nArray[0], nArray[1]);
            String string4 = HTMLUtil.getEleAttrs(string3, string2);
            HashMap hashMap2 = HTMLUtil.makeHsAttrs(string4);
            if (!hashMap2.containsKey("http-equiv")) continue;
            String string5 = CMyString.showNull((String)hashMap2.get("content"));
            if (string5.toLowerCase().indexOf("charset") == -1 && n != list.size()) {
                ++n;
                continue;
            }
            if (string5.toLowerCase().indexOf("charset") != -1) continue;
            int[] nArray2 = HTMLUtil.getPosition(string.substring(0, nArray[0]));
            arrayList.add(new String[]{String.valueOf(nArray2[0]), String.valueOf(nArray2[1]), string3});
        }
        if (arrayList.size() > 0) {
            return arrayList;
        }
        return Boolean.TRUE;
    }

    public Object getWarnObj() {
        return this.m_oWarning;
    }

    public String getType() {
        return this.m_sType;
    }

    public Object getExampleObj() {
        return this.m_oExample;
    }
}

