/*
 * Decompiled with CFR 0.152.
 */
package com.trs.util.swf;

import com.artofsolving.jodconverter.DocumentFamily;
import com.artofsolving.jodconverter.DocumentFormat;
import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.connection.SocketOpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.converter.OpenOfficeDocumentConverter;
import com.trs.infra.util.CharsetDetector;
import com.trs.util.swf.ErrorInputStreamWatchThread;
import com.trs.util.swf.InputStreamWatchThread;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class SWFCreator
extends Thread {
    private static Logger m_Logger = Logger.getLogger(SWFCreator.class);
    private File m_oSrcFile;
    private File m_oPDFFile;
    private String m_sSWFFileName;
    public String m_sServiceHost = "127.0.0.1";
    public int m_nServicePort = 8100;
    public String m_sSWFToollsPath = "C:\\SWFTools\\";

    public SWFCreator(String string) {
        this.m_oSrcFile = new File(string);
        String string2 = SWFCreator.changeFileExt(string, "pdf");
        this.m_oPDFFile = new File(string2);
        this.m_sSWFFileName = SWFCreator.changeFileExt(string, "swf");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean toPDF() {
        long l;
        boolean bl;
        block9: {
            String string = SWFCreator.extractFileExt(this.m_oSrcFile.getName());
            if (string.equalsIgnoreCase("pdf") || this.m_oPDFFile.exists()) {
                return true;
            }
            bl = false;
            l = System.currentTimeMillis();
            SocketOpenOfficeConnection socketOpenOfficeConnection = new SocketOpenOfficeConnection(this.m_sServiceHost, this.m_nServicePort);
            try {
                try {
                    socketOpenOfficeConnection.connect();
                    OpenOfficeDocumentConverter openOfficeDocumentConverter = new OpenOfficeDocumentConverter((OpenOfficeConnection)socketOpenOfficeConnection);
                    if (string.equalsIgnoreCase("txt")) {
                        String string2 = CharsetDetector.detect(this.m_oSrcFile.getAbsolutePath());
                        DocumentFormat documentFormat = new DocumentFormat("Plain Text", DocumentFamily.TEXT, "text/plain", "txt");
                        documentFormat.setImportOption("FilterName", (Object)"Text (encoded)");
                        documentFormat.setImportOption("FilterOptions", (Object)(string2 + ",CRLF"));
                        documentFormat.setExportFilter(DocumentFamily.TEXT, "Text (encoded)");
                        documentFormat.setExportOption(DocumentFamily.TEXT, "FilterOptions", (Object)(string2 + ",CRLF"));
                        DocumentFormat documentFormat2 = new DocumentFormat("Portable Document Format", "application/pdf", "pdf");
                        documentFormat2.setExportFilter(DocumentFamily.DRAWING, "draw_pdf_Export");
                        documentFormat2.setExportFilter(DocumentFamily.PRESENTATION, "impress_pdf_Export");
                        documentFormat2.setExportFilter(DocumentFamily.SPREADSHEET, "calc_pdf_Export");
                        documentFormat2.setExportFilter(DocumentFamily.TEXT, "writer_pdf_Export");
                        openOfficeDocumentConverter.convert(this.m_oSrcFile, documentFormat, this.m_oPDFFile, documentFormat2);
                    } else {
                        openOfficeDocumentConverter.convert(this.m_oSrcFile, this.m_oPDFFile);
                    }
                    bl = true;
                }
                catch (ConnectException connectException) {
                    connectException.printStackTrace();
                    Object var11_11 = null;
                    if (socketOpenOfficeConnection != null) {
                        socketOpenOfficeConnection.disconnect();
                        socketOpenOfficeConnection = null;
                    }
                    break block9;
                }
                Object var11_10 = null;
                if (socketOpenOfficeConnection == null) break block9;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (socketOpenOfficeConnection != null) {
                    socketOpenOfficeConnection.disconnect();
                    socketOpenOfficeConnection = null;
                }
                throw throwable;
            }
            socketOpenOfficeConnection.disconnect();
            socketOpenOfficeConnection = null;
        }
        m_Logger.debug((Object)("\u751f\u6210" + this.m_oPDFFile.getName() + "\u8017\u8d39\uff1a" + (System.currentTimeMillis() - l) + "\u6beb\u79d2"));
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean toSWF() throws IOException {
        if (new File(this.m_sSWFFileName).exists()) {
            return true;
        }
        if (!this.m_oPDFFile.exists()) {
            m_Logger.info((Object)"pdf\u8f6c\u6362swf\u5931\u8d25\uff0c\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728!");
            throw new IOException();
        }
        if (this.m_sSWFToollsPath.length() > 0 && this.m_sSWFToollsPath.charAt(this.m_sSWFToollsPath.length() - 1) != File.separatorChar) {
            this.m_sSWFToollsPath = this.m_sSWFToollsPath + File.separatorChar;
        }
        File file = this.m_oPDFFile;
        synchronized (file) {
            m_Logger.debug((Object)("\u5f00\u59cb\u8c03\u7528swftools\u8f6c\u6362pdf\u6587\u4ef6:" + this.m_sSWFFileName));
            String string = this.m_sSWFToollsPath + "pdf2swf";
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            arrayList.add("-z");
            arrayList.add("-s");
            arrayList.add("flashversion=9");
            arrayList.add("-s");
            arrayList.add("poly2bitmap");
            arrayList.add(this.m_oPDFFile.getAbsolutePath());
            arrayList.add("-o");
            arrayList.add(this.m_sSWFFileName);
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            Process process = Runtime.getRuntime().exec(stringArray);
            InputStreamWatchThread inputStreamWatchThread = new InputStreamWatchThread(process);
            inputStreamWatchThread.start();
            ErrorInputStreamWatchThread errorInputStreamWatchThread = new ErrorInputStreamWatchThread(process);
            errorInputStreamWatchThread.start();
            try {
                process.waitFor();
                inputStreamWatchThread.setOver(true);
                errorInputStreamWatchThread.setOver(true);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        m_Logger.debug((Object)"\u8f6c\u6362\u5b8c\u6210");
        return true;
    }

    public void run() {
        if (this.toPDF()) {
            try {
                this.toSWF();
            }
            catch (Exception exception) {
                m_Logger.error((Object)("Fail to convert " + this.m_oSrcFile + " to " + this.m_sSWFFileName), (Throwable)exception);
            }
        }
    }

    public File getInputFile() {
        return this.m_oSrcFile;
    }

    public void setInputFile(File file) {
        this.m_oSrcFile = file;
    }

    public File getOutputFile() {
        return this.m_oPDFFile;
    }

    public void setOutputFile(File file) {
        this.m_oPDFFile = file;
    }

    private static String extractFileExt(String string) {
        int n = string.lastIndexOf(46);
        return n >= 0 ? string.substring(n + 1) : "";
    }

    private static String changeFileExt(String string, String string2) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string + "." + string2;
        }
        return string.substring(0, n + 1) + string2;
    }

    public static void main(String[] stringArray) {
        SWFCreator sWFCreator = new SWFCreator("c:/TRS\u5185\u5bb9\u7ba1\u7406\u4ea4\u6d41.ppt");
        sWFCreator.start();
    }
}

