/*
 * Decompiled with CFR 0.152.
 */
package com.trs.update.wcm;

import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMy3WLib;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.update.wcm.ConflictFilesOfWCMMaker;
import com.trs.update.wcm.WCMFixUpdater;
import com.trs.update.wcm.WCMUpdaterConstants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class WCMUpdateServer {
    private static Logger logger = Logger.getLogger(WCMFixUpdater.class);
    private String m_sWCMPath = null;
    private String m_sFixDownloadPath = null;
    private ArrayList m_arAlreadyFixs = new ArrayList();
    private ArrayList m_arAllFixNames = new ArrayList();
    private ArrayList m_arAllFixDescs = new ArrayList();
    private ArrayList m_arConflictFiles;
    private String m_sTimestamp;
    private StringBuffer m_sbManualWorkInfo = new StringBuffer();
    private HashMap m_hErrorInfo = new HashMap();

    public WCMUpdateServer() throws Exception {
        this.init();
    }

    public WCMUpdateServer(String _sGetFixURL) throws Exception {
        WCMUpdaterConstants.URL_GET_FIX = _sGetFixURL;
        this.init();
    }

    public String getManualWorkInfo() {
        return this.m_sbManualWorkInfo.toString();
    }

    public ArrayList getConflictFiles() {
        return this.m_arConflictFiles;
    }

    public String getTimestamp() {
        return this.m_sTimestamp;
    }

    /*
     * Unable to fully structure code
     */
    public String update() throws Exception {
        block15: {
            this.initFixInfo();
            this.m_sTimestamp = CMyDateTime.now().toString("yyyyMMddHHmmss");
            sUpdateLog = String.valueOf(this.m_sWCMPath) + WCMUpdaterConstants.PATH_LOGS + this.m_sTimestamp + ".log";
            sbResult = new StringBuffer();
            try {
                i = 0;
                nSize = this.m_arAllFixNames.size();
                while (i < nSize) {
                    sCurrFixName = (String)this.m_arAllFixNames.get(i);
                    if (!this.m_arAlreadyFixs.contains(sCurrFixName)) {
                        updater = new WCMFixUpdater(sCurrFixName, this.m_sTimestamp);
                        updater.createtFixFiles();
                        updater.validFix();
                        updater.backUpFix();
                    }
                    ++i;
                }
                oConfilctFilesOfWCMMaker = new ConflictFilesOfWCMMaker(String.valueOf(this.m_sWCMPath) + WCMUpdaterConstants.PATH_BACKUP + this.m_sTimestamp + File.separatorChar);
                this.m_arConflictFiles = oConfilctFilesOfWCMMaker.compare();
                this.m_arAlreadyFixs.add("UPDATEPREDOWITH");
            }
            catch (Exception e) {
                CMyFile.writeFile(sUpdateLog, "Fail to update fix!\n" + CMyException.getStackTraceText(e));
                throw e;
            }
            try {
                i = 0;
                nSize = this.m_arAllFixNames.size();
                while (i < nSize) {
                    sCurrFixName = (String)this.m_arAllFixNames.get(i);
                    if (!this.m_arAlreadyFixs.contains(sCurrFixName)) {
                        updater = new WCMFixUpdater(sCurrFixName, this.m_sTimestamp);
                        sbResult.append("=============" + sCurrFixName + " \u66f4\u65b0\u7ed3\u679c========\n");
                        sbResult.append(updater.update());
                        sbResult.append("\n");
                        sErrorInfo = updater.getErrInfo();
                        if (sErrorInfo != null) {
                            this.m_hErrorInfo.put(sCurrFixName, sErrorInfo);
                            sbResult.append(String.valueOf(sErrorInfo) + "\n");
                        }
                        if (updater.getManualWorkInfo() != null) {
                            this.m_sbManualWorkInfo.append("=============" + sCurrFixName + " \u624b\u5de5\u66f4\u65b0\u8bf4\u660e========\n");
                            this.m_sbManualWorkInfo.append(updater.getManualWorkInfo());
                        }
                        this.m_arAlreadyFixs.add(sCurrFixName);
                    }
                    ++i;
                }
                if (this.m_sbManualWorkInfo != null && this.m_sbManualWorkInfo.length() > 0) {
                    sManualLog = String.valueOf(this.m_sWCMPath) + WCMUpdaterConstants.PATH_LOGS + this.m_sTimestamp + "_manual.log";
                    CMyFile.writeFile(sManualLog, this.m_sbManualWorkInfo.toString());
                }
                CMyFile.writeFile(sUpdateLog, sbResult.toString());
                var9_13 = sbResult.toString();
                return var9_13;
            }
            catch (Exception e) {
                CMyFile.writeFile(sUpdateLog, "Fail to update fix!\n" + CMyException.getStackTraceText(e));
                throw e;
            }
            finally {
                if (this.m_arConflictFiles == null || this.m_arConflictFiles.size() <= 0) break block15;
                sConflictLog = String.valueOf(this.m_sWCMPath) + WCMUpdaterConstants.PATH_LOGS + this.m_sTimestamp + "_conflict.log";
                sbConflictLogContent = new StringBuffer(this.m_arConflictFiles.size() * 100);
                i = 0;
                nSize = this.m_arConflictFiles.size();
                ** while (i < nSize)
            }
lbl-1000:
            // 1 sources

            {
                sbConflictLogContent.append(this.m_arConflictFiles.get(i));
                sbConflictLogContent.append("\n");
                ++i;
                continue;
            }
lbl79:
            // 1 sources

            CMyFile.writeFile(sConflictLog, sbConflictLogContent.toString());
        }
        throw var8_22;
    }

    public String getCurrFixInfo() throws Exception {
        return this.getCurrFixInfo(true);
    }

    public String getCurrFixInfo(boolean _bContainUpdated) throws Exception {
        this.initFixInfo();
        StringBuffer sbFixInfo = new StringBuffer();
        int i = 0;
        int nSize = this.m_arAllFixNames.size();
        while (i < nSize) {
            String sCurrFixName = (String)this.m_arAllFixNames.get(i);
            if (!this.m_arAlreadyFixs.contains(sCurrFixName) || _bContainUpdated) {
                String sCurrUpdatedInfo = this.m_arAlreadyFixs.contains(sCurrFixName) ? "\u5df2\u7ecf\u66f4\u65b0" : "<span class=\"unupdate\">\u5c1a\u672a\u66f4\u65b0</span>";
                sbFixInfo.append("\n");
                sbFixInfo.append(String.valueOf(sCurrFixName) + " \u66f4\u65b0\u60c5\u51b5\uff1a" + sCurrUpdatedInfo);
                sbFixInfo.append("\n");
                sbFixInfo.append("FIX\u63cf\u8ff0\uff1a" + this.m_arAllFixDescs.get(i));
                sbFixInfo.append("\n");
            }
            ++i;
        }
        return sbFixInfo.toString();
    }

    public HashMap getNeedUpdateFixes() throws Exception {
        this.initFixInfo();
        HashMap hResult = new HashMap();
        int i = 0;
        int nSize = this.m_arAllFixNames.size();
        while (i < nSize) {
            String sCurrFixName = (String)this.m_arAllFixNames.get(i);
            if (!this.m_arAlreadyFixs.contains(sCurrFixName)) {
                hResult.put(sCurrFixName, this.m_arAllFixDescs.get(i));
            }
            ++i;
        }
        return hResult;
    }

    public ArrayList getAllFixes() {
        return this.m_arAllFixNames;
    }

    public boolean isUpdated(String _sFixKey) {
        return this.m_arAlreadyFixs.contains(_sFixKey.toUpperCase());
    }

    public boolean hasError(String _sFixKey) {
        return this.m_hErrorInfo.containsKey(_sFixKey.toUpperCase());
    }

    public String getErrorInfo(String _sFixKey) {
        return (String)this.m_hErrorInfo.get(_sFixKey.toUpperCase());
    }

    private void initFixInfo() throws Exception {
        if (this.m_arAllFixNames.size() > 0) {
            return;
        }
        File oFixIdsDiretoryFile = new File(String.valueOf(this.m_sWCMPath) + WCMUpdaterConstants.PATH_FIX_ID);
        if (oFixIdsDiretoryFile.exists()) {
            File[] pFixIdFiles = CMyFile.listFiles(oFixIdsDiretoryFile.getAbsolutePath(), WCMUpdaterConstants.EXT_FIX_ID);
            int i = 0;
            while (i < pFixIdFiles.length) {
                String sName = pFixIdFiles[i].getName().toUpperCase();
                this.m_arAlreadyFixs.add(sName.substring(0, sName.length() - WCMUpdaterConstants.EXT_FIX_ID.length() - 1));
                ++i;
            }
        }
        this.makeWCMAllFixInfo();
    }

    public boolean validUploadFixIndexFile() {
        if (!CMyString.isEmpty(WCMUpdaterConstants.URL_GET_FIX)) {
            String sURL = String.valueOf(WCMUpdaterConstants.URL_GET_FIX) + WCMUpdaterConstants.FILE_FIX_INDEX;
            String sLocalFixIndexFile = String.valueOf(this.m_sFixDownloadPath) + WCMUpdaterConstants.FILE_FIX_INDEX;
            try {
                CMy3WLib.getFile(sURL, sLocalFixIndexFile);
            }
            catch (Exception e) {
                logger.error((Object)("\u4ece\u3010 " + sURL + "\u3011\u4e0b\u8f7dindex.txt\u5931\u8d25!"), (Throwable)e);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isExistsIndexFile() {
        String sLocalFixIndexFile = String.valueOf(this.m_sFixDownloadPath) + WCMUpdaterConstants.FILE_FIX_INDEX;
        return CMyFile.fileExists(sLocalFixIndexFile);
    }

    private void makeWCMAllFixInfo() throws Exception {
        String sLocalFixIndexFile = String.valueOf(this.m_sFixDownloadPath) + WCMUpdaterConstants.FILE_FIX_INDEX;
        if (!CMyString.isEmpty(WCMUpdaterConstants.URL_GET_FIX)) {
            String sURL = String.valueOf(WCMUpdaterConstants.URL_GET_FIX) + WCMUpdaterConstants.FILE_FIX_INDEX;
            try {
                CMy3WLib.getFile(sURL, sLocalFixIndexFile);
            }
            catch (Exception e) {
                logger.error((Object)("\u4ece\u3010 " + sURL + "\u3011\u4e0b\u8f7dindex.txt\u5931\u8d25!"), (Throwable)e);
            }
        }
        InputStreamReader fileReader = null;
        FileInputStream fis = null;
        BufferedReader buffReader = null;
        try {
            try {
                String sLine;
                fis = new FileInputStream(sLocalFixIndexFile);
                buffReader = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
                boolean zFirstLine = true;
                while ((sLine = buffReader.readLine()) != null) {
                    if (zFirstLine) {
                        sLine = WCMUpdateServer.removeBomHeaderIfExists(sLine);
                        zFirstLine = false;
                    }
                    if (sLine == null || (sLine = sLine.trim()).length() == 0) continue;
                    int nPos = sLine.indexOf(32);
                    if (nPos <= 0) {
                        throw new Exception("index.txt\u6709\u4e00\u884c\u4e0d\u7b26\u5408\u89c4\u5219\uff01[" + sLine + "]");
                    }
                    this.m_arAllFixNames.add(sLine.substring(0, nPos).toUpperCase());
                    this.m_arAllFixDescs.add(sLine.substring(nPos + 1));
                }
            }
            catch (FileNotFoundException ex) {
                throw new CMyException(55, "\u8981\u8bfb\u53d6\u7684\u6587\u4ef6\u6ca1\u6709\u627e\u5230\uff0c\u53ef\u80fd\u5f53\u524d\u73af\u5883\u662f\u79bb\u7ebf\u73af\u5883\uff0c\u9700\u8981\u624b\u5de5\u4e0b\u8f7d\u6587\u4ef6", ex);
            }
            catch (IOException ex) {
                throw new CMyException(53, "\u8bfb\u6587\u4ef6\u65f6\u9519\u8bef", ex);
            }
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (buffReader != null) {
                    buffReader.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static String removeBomHeaderIfExists(String _sLine) {
        if (_sLine == null) {
            return null;
        }
        String line = _sLine;
        if (line.length() > 0) {
            char ch = line.charAt(0);
            while (ch == '\ufeff' || ch == '\ufffe') {
                if ((line = line.substring(1)).length() == 0) break;
                ch = line.charAt(0);
            }
        }
        return line;
    }

    private void init() throws Exception {
        this.m_sWCMPath = ConfigServer.getServer().getInitProperty("WCM_PATH");
        this.m_sWCMPath = WCMUpdaterConstants.setStrEndWithPathFlag(this.m_sWCMPath);
        if (!CMyFile.fileExists(this.m_sWCMPath)) {
            throw new Exception("\u8bf7\u4fee\u6539WEB-INF/classes/TRSWCMApp.ini\u6587\u4ef6\uff0c\u786e\u4fddWCM_Path\u8bbe\u7f6e\u6b63\u786e\uff01\u76ee\u524d\u914d\u7f6e\u4e3a\u3010" + this.m_sWCMPath + "\u3011");
        }
        this.m_sFixDownloadPath = String.valueOf(this.m_sWCMPath) + WCMUpdaterConstants.PATH_FIXS_DOWNLOAD;
    }
}

