/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import java.util.HashMap;
import java.util.Map;

class Token {
    public static final int TOKEN_TEXT = 0;
    public static final int TOKEN_COMMENT = 1;
    public static final int TOKEN_TAG = 2;
    public static final int TOKEN_SCRIPT = 3;
    private static final char[] TAG_BR = "<br".toCharArray();
    private static final char[] TAG_P = "<p".toCharArray();
    private static final char[] TAG_LI = "<li".toCharArray();
    private static final char[] TAG_PRE = "<pre".toCharArray();
    private static final char[] TAG_HR = "<hr".toCharArray();
    private static final char[] END_TAG_TD = "</td>".toCharArray();
    private static final char[] END_TAG_TR = "</tr>".toCharArray();
    private static final char[] END_TAG_LI = "</li>".toCharArray();
    private static final Map SPECIAL_CHARS = new HashMap();
    private int type;
    private String html;
    private String text = null;
    private int length = 0;
    private boolean isPre = false;

    public Token(int n, char[] cArray, int n2, int n3, boolean bl) {
        this.type = n;
        this.length = n3 - n2;
        this.html = new String(cArray, n2, this.length);
        this.parseText(bl);
    }

    public int getLength() {
        return this.length;
    }

    public boolean isPreTag() {
        return this.isPre;
    }

    private void parseText(boolean bl) {
        if (this.type == 2) {
            char[] cArray = this.html.toCharArray();
            if (this.compareTag(TAG_BR, cArray) || this.compareTag(TAG_P, cArray)) {
                this.text = "\n";
            } else if (this.compareTag(TAG_LI, cArray)) {
                this.text = "\n* ";
            } else if (this.compareTag(TAG_PRE, cArray)) {
                this.isPre = true;
            } else if (this.compareTag(TAG_HR, cArray)) {
                this.text = "\n--------\n";
            } else if (this.compareString(END_TAG_TD, cArray)) {
                this.text = "\t";
            } else if (this.compareString(END_TAG_TR, cArray) || this.compareString(END_TAG_LI, cArray)) {
                this.text = "\n";
            }
        } else if (this.type == 0) {
            this.text = this.toText(this.html, bl);
        }
    }

    public String getText() {
        return this.text == null ? "" : this.text;
    }

    private String toText(String string, boolean bl) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        int n = 0;
        boolean bl2 = false;
        while (n < cArray.length) {
            char c = cArray[n];
            char c2 = n + 1 < cArray.length ? cArray[n + 1] : (char)'\u0000';
            if (c == ' ') {
                if (bl || !bl2) {
                    stringBuffer = stringBuffer.append(' ');
                }
                bl2 = true;
                ++n;
                continue;
            }
            if (c == '\r' && c2 == '\n') {
                if (bl) {
                    stringBuffer = stringBuffer.append('\n');
                }
                n += 2;
                continue;
            }
            if (c == '\n' || c == '\r') {
                if (bl) {
                    stringBuffer = stringBuffer.append('\n');
                }
                ++n;
                continue;
            }
            bl2 = false;
            if (c == '&') {
                int n2 = this.readUtil(cArray, n, ';', 10);
                if (n2 == -1) {
                    stringBuffer = stringBuffer.append('&');
                    ++n;
                    continue;
                }
                String string2 = new String(cArray, n, n2);
                String string3 = (String)SPECIAL_CHARS.get(string2);
                if (string3 != null) {
                    stringBuffer = stringBuffer.append(string3);
                    n += n2;
                    continue;
                }
                if (c2 == '#') {
                    String string4 = new String(cArray, n + 2, n2 - 3);
                    try {
                        int n3 = Integer.parseInt(string4);
                        if (n3 > 0 && n3 < 65536) {
                            stringBuffer = stringBuffer.append((char)n3);
                            ++n;
                            continue;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    stringBuffer = stringBuffer.append("&#");
                    n += 2;
                    continue;
                }
                stringBuffer = stringBuffer.append('&');
                ++n;
                continue;
            }
            stringBuffer = stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }

    private int readUtil(char[] cArray, int n, char c, int n2) {
        int n3 = n + n2;
        if (n3 > cArray.length) {
            n3 = cArray.length;
        }
        for (int i = n; i < n3; ++i) {
            if (cArray[i] != c) continue;
            return i - n + 1;
        }
        return -1;
    }

    private boolean compareTag(char[] cArray, char[] cArray2) {
        int n;
        if (cArray.length >= cArray2.length) {
            return false;
        }
        for (n = 0; n < cArray.length; ++n) {
            if (Character.toLowerCase(cArray2[n]) == cArray[n]) continue;
            return false;
        }
        if (cArray2.length > cArray.length) {
            n = Character.toLowerCase(cArray2[cArray.length]);
            return n < 97 || n > 122;
        }
        return true;
    }

    private boolean compareString(char[] cArray, char[] cArray2) {
        if (cArray.length > cArray2.length) {
            return false;
        }
        for (int i = 0; i < cArray.length; ++i) {
            if (Character.toLowerCase(cArray2[i]) == cArray[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.html;
    }

    static {
        SPECIAL_CHARS.put("&quot;", "\"");
        SPECIAL_CHARS.put("&lt;", "<");
        SPECIAL_CHARS.put("&gt;", ">");
        SPECIAL_CHARS.put("&amp;", "&");
        SPECIAL_CHARS.put("&reg;", "(r)");
        SPECIAL_CHARS.put("&copy;", "(c)");
        SPECIAL_CHARS.put("&nbsp;", " ");
        SPECIAL_CHARS.put("&pound;", "?");
    }
}

