/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CharsetDetector;
import java.io.File;
import java.util.regex.Pattern;

public class SymbolC2E {
    public static char[][] resourceSymbols = new char[][]{{'\u3002', '.'}, {'\uff1f', '?'}, {'\uff01', '!'}, {'\uff0c', ','}, {'\u3001', ','}, {'\uff1b', ';'}, {'\uff1a', ':'}, {'\u201c', '\"'}, {'\u201d', '\"'}, {'\u300e', '['}, {'\u300f', ']'}, {'\u2018', '\''}, {'\u2019', '\''}, {'\u300c', '['}, {'\u300d', ']'}, {'\uff08', '('}, {'\uff09', ')'}, {'\uff08', '('}, {'\uff09', ')'}, {'\uff3b', '['}, {'\uff3d', ']'}, {'\u3014', '('}, {'\u3015', ')'}, {'\u3010', '['}, {'\u3011', ']'}, {'\uff5e', '~'}, {'\u300a', '<'}, {'\u300b', '>'}, {'\u3008', '<'}, {'\u3009', '>'}};
    public static char[][] pageSymbols = new char[][]{{'\u3002', '.'}, {'\uff1f', '?'}, {'\uff01', '!'}, {'\uff0c', ','}, {'\u3001', ','}, {'\uff1b', ';'}, {'\uff1a', ':'}, {'\u300e', '['}, {'\u300f', ']'}, {'\u300c', '['}, {'\u300d', ']'}, {'\uff08', '('}, {'\uff09', ')'}, {'\uff08', '('}, {'\uff09', ')'}, {'\uff3b', '['}, {'\uff3d', ']'}, {'\u3014', '('}, {'\u3015', ')'}, {'\u3010', '['}, {'\u3011', ']'}, {'\uff5e', '~'}, {'\u300a', '<'}, {'\u300b', '>'}, {'\u3008', '<'}, {'\u3009', '>'}};
    public static char[][] runtimeSymbols = pageSymbols;
    public static Pattern normalPattern = Pattern.compile("\\.(html|htm|jsp|js|properties)$");
    public static Pattern resourcePattern = Pattern.compile("\\.(js|properties)$");
    public static Pattern pagePattern = Pattern.compile("\\.(html|htm|jsp|js|)$");
    public static Pattern runtimePattern = normalPattern;
    private static boolean bJsFile = false;

    public static char replace(char c) {
        for (int i = 0; i < runtimeSymbols.length; ++i) {
            if (runtimeSymbols[i][0] != c) continue;
            return runtimeSymbols[i][1];
        }
        return c;
    }

    public static String replace(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            char c2 = SymbolC2E.replace(c);
            String string2 = String.valueOf(c2);
            if (bJsFile && c != c2) {
                if (c2 == '\"') {
                    string2 = "\\" + c2;
                } else if (c2 == '\'') {
                    string2 = "\\" + c2;
                }
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static boolean isExcludeDir(String string) {
        if (runtimePattern != pagePattern) {
            return false;
        }
        return string.indexOf("app/js/data/locale") >= 0;
    }

    public static void replaceDir(String string, String string2) throws Exception {
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        if (SymbolC2E.isExcludeDir(string)) {
            return;
        }
        if (!CMyFile.fileExists(string2)) {
            CMyFile.makeDir(string2, true);
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            String string3 = fileArray[i].getPath();
            String string4 = string2 + File.separator + fileArray[i].getName();
            if (fileArray[i].isFile()) {
                SymbolC2E.replaceFile(string3, string4);
                continue;
            }
            SymbolC2E.replaceDir(string3, string4);
        }
    }

    public static boolean isExcludeFile(String string) {
        return !runtimePattern.matcher(string).find();
    }

    public static void replaceFile(String string, String string2) throws Exception {
        if (!CMyFile.fileExists(string)) {
            return;
        }
        if (SymbolC2E.isExcludeFile(string)) {
            return;
        }
        bJsFile = string.endsWith(".js");
        System.out.println("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        System.out.println(string);
        String string3 = CharsetDetector.detect(string);
        String string4 = CMyFile.readFile(string, string3);
        CMyFile.writeFile(string2, SymbolC2E.replace(string4), string3);
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "E:\\MyWorkspace\\TRS.WCM.V6.1.Std\\runtime\\en\\wcm\\WEB-INF\\classes\\locale\\";
        String string2 = "d:\\WCMV61-sym";
        if (stringArray.length >= 2) {
            string = stringArray[0];
            string2 = stringArray[1];
        }
        if (stringArray.length >= 3) {
            if (stringArray[2].equalsIgnoreCase("page")) {
                SymbolC2E.replacePages(string, string2);
            } else {
                SymbolC2E.replaceResources(string, string2);
            }
        } else {
            SymbolC2E.replaceDir(string, string2);
        }
    }

    public static void replaceResources(String string, String string2) throws Exception {
        runtimePattern = resourcePattern;
        runtimeSymbols = resourceSymbols;
        String[][] stringArrayArray = new String[][]{{"app/js/data/locale/"}, {"WEB-INF/classes/locale/"}, {"WEB-INF/classes/wcm6-locale/"}, {"WEB-INF/classes/i18nmessage/"}};
        if (CMyString.isEmpty(string2)) {
            string2 = string;
        }
        for (int i = 0; i < stringArrayArray.length; ++i) {
            String[] stringArray = stringArrayArray[i];
            String string3 = string + File.separator + stringArray[0];
            String string4 = string2 + File.separator + (stringArray.length > 1 ? stringArray[1] : stringArray[0]);
            SymbolC2E.replaceDir(string3, string4);
        }
    }

    public static void replacePages(String string, String string2) throws Exception {
        runtimePattern = pagePattern;
        runtimeSymbols = pageSymbols;
        SymbolC2E.replaceDir(string, string2);
    }
}

