/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CharsetDetector;
import com.trs.tools.CommonResourceBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResourceAnalyzer {
    private static Pattern ptJavascript = Pattern.compile("(?si)<script[^>]*? src=[\"']([^\"']*)[\"'][^>]*>(\\s)*</script>");
    private static Pattern ptCssLink = Pattern.compile("(?mi)<link[^>]* href=[\"']([^\"']*)[\"'][^>]*>");
    private static Map m_arrCombinedRs = new HashMap();
    static String m_sSourceWcmPath;
    private static String m_sRuntimeWcmPath;
    private static String m_sWcm61Uri;
    private static String m_sWcmRootUri;
    private static boolean m_bOnePage;
    private static String m_sOnePage;
    public static String locale;

    private static void debug(String string) {
    }

    public static void setSrcPath(String string) {
        m_sSourceWcmPath = string;
    }

    public static void setRuntimePath(String string) {
        m_sRuntimeWcmPath = string;
    }

    public static void analyzer(String[] stringArray) throws Exception {
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                ResourceAnalyzer.analyzerFile(stringArray[i]);
            }
            return;
        }
        ResourceAnalyzer.analyzerFolder(m_sSourceWcmPath);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length >= 2) {
            m_sSourceWcmPath = CMyString.setStrEndWith(stringArray[0].replace('/', File.separatorChar), File.separatorChar);
            m_sRuntimeWcmPath = CMyString.setStrEndWith(stringArray[1].replace('/', File.separatorChar), File.separatorChar);
            m_bOnePage = false;
        }
        if (stringArray.length >= 3) {
            locale = stringArray[2];
        }
        System.out.println("===>" + m_sSourceWcmPath + "==>" + m_sRuntimeWcmPath + "==>" + locale);
        CommonResourceBuilder.locale = locale;
        CommonResourceBuilder.build(m_sSourceWcmPath);
        ResourceAnalyzer.analyzerFolder(m_sSourceWcmPath);
    }

    public static void analyzerFolder(String string) throws Exception {
        File[] fileArray;
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            fileArray = file.getAbsolutePath();
            String[] stringArray = new String[]{".svn", "CVS"};
            for (int i = 0; i < stringArray.length; ++i) {
                if (!fileArray.endsWith(stringArray[i])) continue;
                return;
            }
        }
        fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isFile()) {
                String string2 = fileArray[i].getAbsolutePath().substring(m_sSourceWcmPath.length()).replace('\\', '/');
                if (!m_bOnePage) {
                    System.out.println("^^^^^^^^^^" + string2);
                }
                if (m_bOnePage && !string2.endsWith(m_sOnePage)) continue;
                ResourceAnalyzer.analyzerFile(string2);
                continue;
            }
            ResourceAnalyzer.analyzerFolder(fileArray[i].getAbsolutePath());
        }
    }

    private static boolean isExcludeFile(String string) {
        boolean bl = !string.endsWith(".html") && !string.endsWith(".jsp") && !string.endsWith(".htm");
        bl = bl || "login.jsp".equals(string) || "login_dowith.jsp".equals(string);
        bl = bl || string.startsWith("js/source/wcmlib/");
        bl = bl || string.startsWith("editor/");
        bl = bl || string.equals("include/error.jsp");
        bl = bl || string.startsWith("logo/");
        bl = bl || string.startsWith("application/");
        bl = bl || string.endsWith("individual.html");
        return bl;
    }

    private static HashMap getFirstHash(String string, ArrayList arrayList) {
        ArrayList<String> arrayList2 = CommonResourceBuilder.getMapped(string);
        if (arrayList2 == null || arrayList2.size() == 0) {
            arrayList2 = new ArrayList<String>();
            arrayList2.add(string);
        }
        HashMap hashMap = null;
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            String string2 = m_sWcm61Uri + (String)iterator.next();
            for (int i = 0; i < arrayList.size(); ++i) {
                HashMap hashMap2 = (HashMap)arrayList.get(i);
                if (hashMap2 == null || !hashMap2.containsKey("file") || hashMap2.containsKey("html")) continue;
                Object v = hashMap2.get("file");
                if (!"js/runtime/data/list.js".equals(string) ? !v.equals(string2) : !v.equals(string2) && !v.equals(m_sWcm61Uri + "js/data/combine.jsp?s=operpanel,tab")) continue;
                if (hashMap != null) {
                    int n = Integer.valueOf((String)hashMap.get("ps1"));
                    int n2 = Integer.valueOf((String)hashMap2.get("ps1"));
                    if (n2 >= n) continue;
                    hashMap = hashMap2;
                    continue;
                }
                hashMap = hashMap2;
            }
        }
        return hashMap;
    }

    public static void analyzerFile(String string) throws Exception {
        int n;
        int n2;
        Object object;
        Object object2;
        Cloneable cloneable;
        Object object3;
        String string2 = m_sSourceWcmPath + string;
        String string3 = m_sRuntimeWcmPath + string;
        if (ResourceAnalyzer.isExcludeFile(string)) {
            CMyFile.copyFile(string2, string3, true, true);
            return;
        }
        String string4 = CMyFile.extractMainFileName(string);
        String string5 = string4 + locale + ".js";
        String string6 = string4 + locale + ".css";
        String string7 = CharsetDetector.detect(string2);
        String string8 = CMyFile.readFile(string2, string7);
        Matcher matcher = ptJavascript.matcher(string8);
        ArrayList<Cloneable> arrayList = new ArrayList<Cloneable>();
        ArrayList arrayList2 = new ArrayList();
        while (matcher.find()) {
            object3 = ResourceAnalyzer.formatRealPath(matcher.group(1), string);
            if (ResourceAnalyzer.isExCollectJs((String)object3) || ((String)object3).indexOf(string5) >= 0) continue;
            cloneable = new HashMap();
            ((HashMap)cloneable).put("ps1", "" + matcher.start());
            ((HashMap)cloneable).put("ps2", "" + matcher.end());
            ((HashMap)cloneable).put("file", object3);
            ((HashMap)cloneable).put("script", "1");
            ((HashMap)cloneable).put("oldhtml", matcher.group(0));
            arrayList.add(cloneable);
            arrayList2.add(object3);
        }
        matcher = ptCssLink.matcher(string8);
        object3 = new ArrayList();
        cloneable = new ArrayList();
        while (matcher.find()) {
            if (matcher.group().indexOf("text/css") == -1 || ((String)(object2 = ResourceAnalyzer.formatRealPath(matcher.group(1), string))).indexOf(string6) >= 0) continue;
            object = new HashMap();
            ((HashMap)object).put("ps1", "" + matcher.start());
            ((HashMap)object).put("ps2", "" + matcher.end());
            ((HashMap)object).put("file", object2);
            ((HashMap)object).put("oldhtml", matcher.group(0));
            ((ArrayList)object3).add(object);
            ((ArrayList)cloneable).add(object2);
        }
        object2 = ResourceAnalyzer.orderIt(arrayList, (ArrayList)object3);
        object = ResourceAnalyzer.getPageType(string, arrayList2);
        if (object == null) {
            CMyFile.copyFile(string2, string3, true, true);
            return;
        }
        if ("combinpage".equals(object)) {
            ResourceAnalyzer.doWithCombinePage(string, (ArrayList)object2);
            String string9 = ResourceAnalyzer.replaceResource(string8, (ArrayList)object2);
            CMyFile.writeFile(string3, string9, string7);
            return;
        }
        String[] stringArray = ResourceAnalyzer.getResourcesByPageType((String)object);
        StringBuffer stringBuffer = new StringBuffer();
        ResourceAnalyzer.doWithPreDefined(string, (ArrayList)object2, stringArray, stringBuffer);
        arrayList2 = ResourceAnalyzer.withoutJsCombined(stringArray, arrayList2, string);
        String string10 = string.replaceAll(".*/([^/]*)\\.(htm|html|jsp)$", "$1");
        String string11 = string.replaceAll(".*/([^/]*)$", "$1") + ".compress.js";
        System.out.println(string10 + ".js");
        StringBuffer stringBuffer2 = new StringBuffer();
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            String string12 = (String)arrayList2.get(n2);
            if (string12.endsWith(string10 + ".js") && string12.indexOf("/locale/") < 0 || string12.indexOf(".jsp") != -1 && string12.indexOf("js/data/combine.jsp") == -1 && string12.indexOf("js/list/plugins.jsp") == -1) continue;
            if (string12.startsWith(m_sWcm61Uri)) {
                string12 = string12.replaceAll("^" + m_sWcm61Uri, "");
                CommonResourceBuilder.outContent(m_sSourceWcmPath + string12, stringBuffer2, false, false);
                continue;
            }
            System.out.println(string12 + "-->" + m_sSourceWcmPath.replace('\\', '/').replaceAll(m_sWcm61Uri, "") + string12);
        }
        int n3 = n2 = stringBuffer2.length() > 0 ? 1 : 0;
        if (stringBuffer2.length() > 0) {
            try {
                CMyFile.writeFile(m_sRuntimeWcmPath + string + ".compress.js", stringBuffer2.toString(), "UTF-8");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        boolean bl = false;
        for (n = arrayList2.size() - 1; n >= 0; --n) {
            String string13 = (String)arrayList2.get(n);
            if (string13.endsWith(string10 + ".js")) {
                bl = true;
            }
            if (string13.indexOf(".jsp") != -1 && string13.indexOf("js/data/combine.jsp") == -1 && string13.indexOf("js/list/plugins.jsp") == -1 || !string13.startsWith(m_sWcm61Uri)) continue;
            arrayList2.remove(n);
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            stringBuffer.append("<script src=\"");
            stringBuffer.append(ResourceAnalyzer.getRelativePath((String)arrayList2.get(n), string));
            stringBuffer.append("\"></script>\n");
        }
        if (n2 != 0) {
            stringBuffer.append("<script src=\"");
            stringBuffer.append(string11);
            stringBuffer.append("\"></script>\n");
        }
        if (bl) {
            stringBuffer.append("<script src=\"");
            stringBuffer.append(string10 + ".js");
            stringBuffer.append("\"></script>\n");
        }
        if (CMyFile.fileExists(m_sSourceWcmPath + string5)) {
            stringBuffer.append("<script src=\"");
            stringBuffer.append(string5);
            stringBuffer.append("\"></script>\n");
            System.out.println("==========================>" + string5);
        }
        StringBuffer stringBuffer3 = new StringBuffer();
        cloneable = ResourceAnalyzer.withoutCssCombined(stringArray, (ArrayList)cloneable, string);
        for (int i = 0; i < ((ArrayList)cloneable).size(); ++i) {
            stringBuffer3.append("<link href=\"");
            stringBuffer3.append(ResourceAnalyzer.getRelativePath((String)((ArrayList)cloneable).get(i), string));
            stringBuffer3.append("\" rel=\"stylesheet\" type=\"text/css\">\n");
        }
        String string14 = ResourceAnalyzer.replaceResource(string8, (ArrayList)object2);
        if (CMyFile.fileExists(m_sSourceWcmPath + string6)) {
            stringBuffer.append("<link href=\"");
            stringBuffer.append(string6);
            stringBuffer.append("\" rel=\"stylesheet\" type=\"text/css\">\n");
            System.out.println("==========================>" + string5);
        }
        string14 = string14.replaceAll("(?m)^\\s*$", "").replaceAll("(?im)^\\s*<\\!--.*?-->\\s*$", "").replaceAll("\n{2,}", "\n");
        StringBuffer stringBuffer4 = null;
        int n4 = string14.toLowerCase().indexOf("</head>");
        if (n4 == -1) {
            string14 = stringBuffer3.toString() + string14;
        } else {
            stringBuffer4 = new StringBuffer();
            stringBuffer4.append(string14.substring(0, n4));
            stringBuffer4.append(stringBuffer3);
            stringBuffer4.append(string14.substring(n4));
            string14 = stringBuffer4.toString();
        }
        int n5 = string14.toLowerCase().indexOf("</body>");
        if (n5 == -1) {
            string14 = string14 + stringBuffer.toString();
        } else {
            stringBuffer4 = new StringBuffer();
            stringBuffer4.append(string14.substring(0, n5));
            stringBuffer4.append(stringBuffer);
            stringBuffer4.append(string14.substring(n5));
            string14 = stringBuffer4.toString();
        }
        CMyFile.writeFile(string3, string14, string7);
    }

    private static void doWithPreDefined(String string, ArrayList arrayList, String[] stringArray, StringBuffer stringBuffer) {
        HashMap hashMap = null;
        HashMap hashMap2 = null;
        HashMap hashMap3 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            StringBuffer stringBuffer2 = new StringBuffer();
            if (stringArray[i].endsWith(".js")) {
                stringBuffer2.append("<script src=\"");
                stringBuffer2.append(ResourceAnalyzer.getRelativePath(stringArray[i], string));
                stringBuffer2.append("\"></script>");
            } else {
                stringBuffer2.append("<link href=\"");
                stringBuffer2.append(ResourceAnalyzer.getRelativePath(stringArray[i], string));
                stringBuffer2.append("\" rel=\"stylesheet\" type=\"text/css\">\n");
            }
            HashMap hashMap4 = ResourceAnalyzer.getFirstHash(stringArray[i], arrayList);
            if (hashMap4 == null) {
                HashMap hashMap5 = hashMap3 = stringArray[i].endsWith(".js") ? hashMap : hashMap2;
                if (hashMap3 != null) {
                    hashMap3.put("html", hashMap3.get("html") + "\n" + stringBuffer2.toString());
                    continue;
                }
                stringBuffer.append(stringBuffer2.toString() + "\n");
                continue;
            }
            if (stringArray[i].endsWith(".js")) {
                hashMap = hashMap4;
            } else {
                hashMap2 = hashMap4;
            }
            hashMap4.put("html", stringBuffer2.toString());
        }
    }

    private static void doWithCombinePage(String string, ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            HashMap hashMap = (HashMap)arrayList.get(i);
            String string2 = (String)hashMap.get("file");
            if (hashMap.containsKey("script") && string2.indexOf("js/data/combine.jsp") != -1) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<script src=\"");
                String string3 = string2.replaceAll(".*\\?s=([^?]*)$", "$1");
                String[] stringArray = string3.split(",");
                String string4 = CommonResourceBuilder.getCombineFile(stringArray);
                if (string4 == null) continue;
                stringBuffer.append(ResourceAnalyzer.getRelativePath(string4, string));
                stringBuffer.append("\"></script>");
                hashMap.put("html", stringBuffer.toString());
                continue;
            }
            hashMap.put("html", hashMap.get("oldhtml"));
        }
    }

    private static String[] getResourcesByPageType(String string) {
        String[] stringArray = string.split("#");
        String[] stringArray2 = (String[])m_arrCombinedRs.get(stringArray[0]);
        if (stringArray2 == null) {
            stringArray2 = new String[]{};
        }
        if (stringArray.length > 1 && stringArray[1].length() != 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray2.length; ++i) {
                arrayList.add(stringArray2[i]);
            }
            if (!"website".equals(stringArray[1]) && !"channel".equals(stringArray[1])) {
                arrayList.add("js/runtime/data/oper_channelwebsite.js");
            } else if ("channel".equals(stringArray[1])) {
                arrayList.add("js/runtime/data/oper_website.js");
            }
            arrayList.add("js/runtime/data/oper_cmsobj_" + stringArray[1] + ".js");
            stringArray2 = new String[arrayList.size()];
            arrayList.toArray(stringArray2);
        }
        return stringArray2;
    }

    private static String replaceResource(String string, ArrayList arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            HashMap hashMap = (HashMap)arrayList.get(i);
            int n2 = Integer.valueOf((String)hashMap.get("ps1"));
            int n3 = Integer.valueOf((String)hashMap.get("ps2"));
            if (n2 != n) {
                stringBuffer.append(string.substring(n, n2));
            }
            if (hashMap.containsKey("html")) {
                stringBuffer.append(hashMap.get("html"));
            }
            n = n3;
        }
        if (n != string.length()) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    private static boolean isExCollectJs(String string) {
        if (string.indexOf("/extension.js") != -1) {
            return true;
        }
        if (string.indexOf("/cssrender.js") != -1) {
            return true;
        }
        if (string.indexOf("/individuation/customize_config.jsp") != -1) {
            return true;
        }
        return string.indexOf("/template/trsad_config.jsp") != -1;
    }

    private static ArrayList orderIt(ArrayList arrayList, ArrayList arrayList2) {
        ArrayList<HashMap> arrayList3 = new ArrayList<HashMap>();
        int n = 0;
        int n2 = 0;
        while (n < arrayList.size() || n2 < arrayList2.size()) {
            HashMap hashMap = null;
            HashMap hashMap2 = null;
            if (n < arrayList.size()) {
                hashMap = (HashMap)arrayList.get(n);
            }
            if (n2 < arrayList2.size()) {
                hashMap2 = (HashMap)arrayList2.get(n2);
            }
            int n3 = 100000000;
            int n4 = 100000000;
            if (hashMap != null) {
                n3 = Integer.valueOf((String)hashMap.get("ps1"));
            }
            if (hashMap2 != null) {
                n4 = Integer.valueOf((String)hashMap2.get("ps1"));
            }
            if (n3 > n4) {
                arrayList3.add(hashMap2);
                ++n2;
                continue;
            }
            if (n3 < n4) {
                arrayList3.add(hashMap);
                ++n;
                continue;
            }
            ++n;
            ++n2;
        }
        return arrayList3;
    }

    private static String formatRealPath(String string, String string2) {
        if (string.startsWith("/")) {
            return string;
        }
        String string3 = string2.indexOf("/") == -1 ? "" : string2.replaceAll("^(.*/)[^/]*$", "$1");
        String string4 = string = m_sWcm61Uri + string3 + string;
        while (!(string = string.replaceAll("(/|^)\\./", "$1").replaceAll("(/|^)[^/\\.]*/\\.\\./", "$1")).equals(string4)) {
            string4 = string;
        }
        ResourceAnalyzer.debug(">>>>>" + string);
        return string;
    }

    private static String getRelativePath(String string, String string2) {
        if ((string = string.replaceAll("^" + m_sWcm61Uri, "")).startsWith(m_sWcmRootUri)) {
            String string3 = "";
            int n = string2.split("/").length - 1;
            if (!string2.startsWith(m_sWcm61Uri)) {
                ++n;
            }
            for (int i = 0; i < n; ++i) {
                string3 = "../" + string3;
            }
            System.out.println("----------->" + string3 + string.replaceFirst("^" + m_sWcmRootUri, ""));
            return string3 + string.replaceFirst("^" + m_sWcmRootUri, "");
        }
        int n = string2.split("/").length - 1;
        for (int i = 0; i < n; ++i) {
            string = "../" + string;
        }
        ResourceAnalyzer.debug("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<" + string);
        return string;
    }

    private static ArrayList withoutCssCombined(String[] stringArray, ArrayList arrayList, String string) {
        Object object;
        int n;
        for (n = arrayList.size() - 1; n >= 0; --n) {
            object = (String)arrayList.get(n);
            if (((String)object).indexOf("js/source/wcmlib/") == -1) continue;
            arrayList.remove(n);
        }
        for (n = 0; n < stringArray.length; ++n) {
            object = CommonResourceBuilder.getMapped(stringArray[n]);
            if (object == null || ((ArrayList)object).size() == 0) continue;
            Iterator iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                String string2 = m_sWcm61Uri + (String)iterator.next();
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    String string3 = (String)arrayList.get(i);
                    if (!string3.equals(string2)) continue;
                    arrayList.remove(i);
                }
            }
        }
        return arrayList;
    }

    private static ArrayList withoutJsCombined(String[] stringArray, ArrayList arrayList, String string) {
        Object object;
        int n;
        for (n = arrayList.size() - 1; n >= 0; --n) {
            object = (String)arrayList.get(n);
            if (((String)object).indexOf("js/data/combine.jsp") == -1 && ((String)object).indexOf("js/list/plugins.jsp") == -1) continue;
            arrayList.remove(n);
        }
        for (n = 0; n < stringArray.length; ++n) {
            object = CommonResourceBuilder.getMapped(stringArray[n]);
            if (object == null || ((ArrayList)object).size() == 0) {
                object = new ArrayList<String>();
                ((ArrayList)object).add(stringArray[n]);
            }
            Iterator iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                String string2 = m_sWcm61Uri + (String)iterator.next();
                ResourceAnalyzer.debug(stringArray[n] + "**********" + string2);
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    String string3 = (String)arrayList.get(i);
                    ResourceAnalyzer.debug("**********^^^^^^^^^^^^^^^" + string3);
                    if (!string3.equals(string2)) continue;
                    arrayList.remove(i);
                }
            }
        }
        return arrayList;
    }

    private static String getPageType(String string, ArrayList arrayList) {
        if (string.equals("main.jsp")) {
            return "main";
        }
        if (string.endsWith("/document_addedit.jsp")) {
            return "document-addedit";
        }
        if (string.endsWith("nav_tree.html") || string.endsWith("nav_tree_select.jsp") || string.endsWith("nav_tree_select_site.jsp") || string.endsWith("nav_tree_inner.html")) {
            return "nav-tree";
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string2 = "";
        for (String string3 : arrayList) {
            if (string3.endsWith("tab_fittable.js")) {
                return "fittable";
            }
            if (string3.endsWith("AbsList.js")) {
                bl = true;
                continue;
            }
            if (string3.endsWith("AbsThumb.js")) {
                bl2 = true;
                continue;
            }
            if (string3.matches("(^|.*/)js/data/cmsobj/.*\\.js$")) {
                string2 = string3.replaceAll(".*/([^/]*)\\.js$", "$1");
                continue;
            }
            if (string3.endsWith("lightbase.js")) {
                bl3 = true;
                continue;
            }
            if (string3.indexOf("js/data/combine.jsp") == -1) continue;
            bl4 = true;
        }
        ResourceAnalyzer.debug("xxxx-----------sXxx:" + string2);
        if (bl && !bl2) {
            if (bl3) {
                return "list#" + string2;
            }
            return "list-old#" + string2;
        }
        if (bl2) {
            if (bl3) {
                return "thumb#" + string2;
            }
            return "thumb-old#" + string2;
        }
        if (bl4) {
            return "combinpage";
        }
        return null;
    }

    static {
        m_arrCombinedRs.put("main", new String[]{"js/runtime/lightlib.js", "js/runtime/core_main.js", "js/runtime/data/locale_all.js", "js/runtime/menu_cmsmenu.js", "js/runtime/data/main.js", "main/main.js", "js/runtime/ajax_bdh.js", "js/runtime/components_dd.js", "css/common_main.css", "js/resource/full_widgets.css"});
        m_arrCombinedRs.put("list-old", new String[]{"js/runtime/myext-debug.js", "js/runtime/core_main.js", "js/runtime/abs_list_old.js", "js/runtime/data/list.js", "css/common_list.css", "js/resource/all_widgets.css"});
        m_arrCombinedRs.put("list", new String[]{"js/runtime/lightlib.js", "js/runtime/core_main.js", "js/runtime/abs_list.js", "js/runtime/data/list.js", "css/common_list.css", "js/resource/all_widgets.css"});
        m_arrCombinedRs.put("thumb-old", new String[]{"js/runtime/myext-debug.js", "js/runtime/core_main.js", "js/runtime/abs_thumb_old.js", "js/runtime/data/list.js", "css/common_thumb.css", "js/resource/all_widgets.css"});
        m_arrCombinedRs.put("thumb", new String[]{"js/runtime/lightlib.js", "js/runtime/core_main.js", "js/runtime/abs_thumb.js", "js/runtime/data/list.js", "css/common_thumb.css", "js/resource/all_widgets.css"});
        m_arrCombinedRs.put("fittable", new String[]{"js/runtime/lightlib.js", "js/runtime/core_main.js", "js/runtime/data/fittable.js", "js/runtime/widgets_fittable.js", "css/wcm-common.css"});
        m_arrCombinedRs.put("document-addedit", new String[]{"js/runtime/lightlib.js", "js/runtime/core_main.js", "js/runtime/light_comps.js", "js/runtime/dialog_dd.js", "css/common_main.css", "js/resource/all_widgets.css"});
        m_arrCombinedRs.put("nav-tree", new String[]{"js/runtime/lightlib.js", "js/runtime/core_main.js", "js/source/wcmlib/com.trs.tree/TreeNav.js", "js/easyversion/ajax.js", "js/runtime/components_dd.js", "css/common_tree.css"});
        m_sSourceWcmPath = "D:\\workspace\\TRS.WCM.V6.1.Std\\release\\wcm\\app\\";
        m_sRuntimeWcmPath = "D:\\workspace\\TRS.WCM.V6.1.Std\\runtime2\\wcm\\app\\";
        m_sWcm61Uri = "/wcm/app/";
        m_sWcmRootUri = "/wcm/";
        m_bOnePage = true;
        m_sOnePage = "individual.html";
        locale = "cn";
    }
}

