/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class MediaFilesMD5Digest {
    private static final int BUFFER_LENGTH = 4096;
    private final byte[] BUFFER = new byte[4096];
    private String m_sAppDir;
    private String m_sDigestStoreFile;
    private MessageDigest m_oDigest;

    public MediaFilesMD5Digest(String string, String string2) {
        this.m_sAppDir = string;
        this.m_sDigestStoreFile = string2;
    }

    public void digest() throws Exception {
        final Properties properties = new Properties();
        File file = new File(this.m_sAppDir);
        if (!file.exists() || !file.isDirectory()) {
            throw new Exception("Invlaid application dir: " + this.m_sAppDir);
        }
        final int n = file.getAbsolutePath().length() + 1;
        this.m_oDigest = MessageDigest.getInstance("MD5");
        file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    if (!".svn".equals(file.getName())) {
                        file.listFiles(this);
                    }
                } else {
                    String string = file.getAbsolutePath();
                    string = string.substring(n);
                    string = string.replace(File.separatorChar, '/');
                    properties.put(string, MediaFilesMD5Digest.this.digest(file));
                }
                return false;
            }
        });
        this.storeResult(properties);
    }

    public Set getDifference() throws Exception {
        final TreeSet treeSet = new TreeSet(new Comparator(){

            public int compare(Object object, Object object2) {
                DifferenceRecord differenceRecord = (DifferenceRecord)object;
                DifferenceRecord differenceRecord2 = (DifferenceRecord)object2;
                return differenceRecord.getName().compareTo(differenceRecord2.getName());
            }
        });
        File file = new File(this.m_sAppDir);
        if (!file.exists() || !file.isDirectory()) {
            throw new Exception("Invlaid application dir: " + this.m_sAppDir);
        }
        final Properties properties = this.loadStandardDigest();
        final int n = file.getAbsolutePath().length() + 1;
        this.m_oDigest = MessageDigest.getInstance("MD5");
        file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    if (!".svn".equals(file.getName())) {
                        file.listFiles(this);
                    }
                } else {
                    String string = file.getAbsolutePath();
                    string = string.substring(n);
                    String string2 = properties.getProperty(string = string.replace(File.separatorChar, '/'));
                    if (string2 == null) {
                        treeSet.add(new DifferenceRecord(file.getAbsolutePath(), false));
                    } else {
                        String string3 = MediaFilesMD5Digest.this.digest(file);
                        if (!string2.equals(string3)) {
                            treeSet.add(new DifferenceRecord(file.getAbsolutePath()));
                        }
                    }
                }
                return false;
            }
        });
        return treeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Properties loadStandardDigest() throws Exception {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.m_sDigestStoreFile);
            properties.load(fileInputStream);
            Object var4_3 = null;
            if (fileInputStream == null) return properties;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            fileInputStream.close();
            return properties;
        }
        catch (Exception exception) {}
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String digest(File var1_1) {
        block12: {
            var2_2 = null;
            var3_3 = new ByteArrayOutputStream((int)var1_1.length());
            try {
                var2_2 = new FileInputStream(var1_1);
                var4_4 = -1;
                while ((var4_4 = var2_2.read(this.BUFFER, 0, 4096)) != -1) {
                    var3_3.write(this.BUFFER, 0, var4_4);
                }
                var3_3.flush();
                var6_7 = null;
                ** if (var2_2 == null) goto lbl-1000
            }
            catch (Throwable var5_13) {
                var6_9 = null;
                if (var2_2 != null) {
                    try {
                        var2_2.close();
                    }
                    catch (Exception var7_12) {
                        // empty catch block
                    }
                }
                throw var5_13;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var2_2.close();
                }
                catch (Exception var7_10) {}
            }
lbl-1000:
            // 2 sources

            {
                break block12;
                catch (Exception var4_5) {
                    var6_8 = null;
                    if (var2_2 != null) {
                        try {
                            var2_2.close();
                        }
                        catch (Exception var7_11) {}
                    }
                }
            }
        }
        this.m_oDigest.reset();
        this.m_oDigest.update(var3_3.toByteArray());
        var4_6 = new BigInteger(1, this.m_oDigest.digest());
        return var4_6.toString(16);
    }

    public String digest(String string) throws Exception {
        File file = new File(string);
        if (!file.exists() || !file.isFile()) {
            return "";
        }
        this.m_oDigest = MessageDigest.getInstance("MD5");
        return this.digest(file);
    }

    public void generaterDelListFile(String string, String string2, String string3) throws Exception {
        Properties properties = new Properties();
        properties.load(new FileInputStream(new File(string)));
        Properties properties2 = new Properties();
        properties2.load(new FileInputStream(new File(string2)));
        Enumeration<?> enumeration = properties.propertyNames();
        Properties properties3 = new Properties();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            if (properties2.containsKey(string4)) continue;
            properties3.put(string4, properties.get(string4));
        }
        this.storeResult(properties3, string3);
    }

    private void storeResult(Properties properties) throws FileNotFoundException, IOException {
        this.storeResult(properties, this.m_sDigestStoreFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void storeResult(Properties properties, String string) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = null;
        try {
            File file = new File(string);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            fileOutputStream = new FileOutputStream(file);
            properties.store(fileOutputStream, "wcmapp file md5 digest.");
            Object var6_5 = null;
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            fileOutputStream.close();
            return;
        }
        catch (Exception exception) {}
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        String string2 = null;
        string2 = stringArray.length > 1 ? stringArray[1] : string + File.separator + "media_digest.txt";
        MediaFilesMD5Digest mediaFilesMD5Digest = new MediaFilesMD5Digest(string, string2);
        try {
            mediaFilesMD5Digest.digest();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class DifferenceRecord {
        private String m_sFileName;
        private boolean m_bModified;

        public DifferenceRecord(String string) {
            this(string, true);
        }

        public DifferenceRecord(String string, boolean bl) {
            this.m_sFileName = string;
            this.m_bModified = bl;
        }

        public String getName() {
            return this.m_sFileName;
        }

        public boolean isModified() {
            return this.m_bModified;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || !(object instanceof DifferenceRecord)) {
                return false;
            }
            return this.m_sFileName.equals(((DifferenceRecord)object).m_sFileName);
        }

        public int hashCode() {
            return this.m_sFileName.hashCode();
        }

        public String toString() {
            return this.m_sFileName + ":" + (this.m_bModified ? "modified" : "added");
        }
    }
}

