/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CharsetDetector;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Localizer2 {
    private static Pattern m_pBlockWhere = Pattern.compile("(?i)<(p|caption|font|title|span|b|div|td|th|li|font|option|a|legend|button|label|noscript)\\b[^>]* WCMAnt:param=[\"']([^\"']*)[\"'][^>]*>");
    private static Pattern m_pAttrTrans = Pattern.compile("(?i)(<[^>]* WCMAnt:paramattr=[\"']([^\"':]*):([^\"':]*?)[\"']( [^>/]*)?)([\\s/\\s]?)>");
    private static Pattern m_pScriptLocale = Pattern.compile("(?i)(<script(?: [^>]*)? WCMAnt:locale=[\"']([^\"']*)[\"'](?:[^>]*)?)>");
    private static Pattern m_pLinkLocale = Pattern.compile("(?i)(<link(?: [^>]*)? WCMAnt:locale=[\"']([^\"']*)[\"'](?:[^>]*?))/?>");
    private String m_sRootPath;
    private String[] m_arrToTransPaths;
    private String m_sTargetPath;
    private String m_sLocaleFilePath;
    private String m_sLang = "cn";
    private Hashtable m_htTranslates = new Hashtable();
    private boolean m_recordLocaleProps = false;
    private Map m_tmpTranParams = null;
    private List list = new ArrayList();
    private StringBuffer m_sbRepeatInfo = new StringBuffer(2000);
    private String m_sFileName4RepeatKey = "repeatKey.txt";
    private Writer m_localePropsWriter = null;

    public Localizer2(String string, String string2, String string3, String string4) {
        this.m_sRootPath = CMyString.setStrEndWith(string.replace('/', File.separatorChar).replace('\\', File.separatorChar), File.separatorChar);
        this.m_sTargetPath = CMyString.setStrEndWith(string2.replace('/', File.separatorChar).replace('\\', File.separatorChar), File.separatorChar);
        this.m_sLocaleFilePath = CMyString.setStrEndWith(string3.replace('/', File.separatorChar).replace('\\', File.separatorChar), File.separatorChar);
        this.m_sLang = string4;
        if (!this.m_recordLocaleProps) {
            this.loadTranslates();
        }
    }

    public String[] getToTransPaths() {
        return this.m_arrToTransPaths;
    }

    public void setToTransPaths(String[] stringArray) {
        this.m_arrToTransPaths = stringArray;
    }

    public void setRecordLocaleProps(boolean bl) {
        this.m_recordLocaleProps = bl;
    }

    private void loadTranslates() {
        try {
            String string = this.m_sLocaleFilePath + this.m_sLang + ".properties";
            if (!new File(string).exists()) {
                return;
            }
            String string2 = CharsetDetector.detect(string);
            String string3 = CMyFile.readFile(string, string2);
            String[] stringArray = string3.split("\n(\r)?");
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i].trim();
                if (string4.length() == 0 || string4.startsWith("#") || string4.indexOf("=") == -1) continue;
                int n = string4.indexOf(61);
                this.m_htTranslates.put(string4.substring(0, n).toUpperCase(), string4.substring(n + 1));
            }
        }
        catch (CMyException cMyException) {
            cMyException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void localize() throws CMyException {
        block14: {
            if (this.m_recordLocaleProps) {
                this.getLocalePropsWriter();
            }
            this.localize1();
            Object var3_1 = null;
            if (!this.m_recordLocaleProps) break block14;
            try {
                this.writeLocale();
                this.closeLocalePropsWriter();
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
            try {
                CMyFile.writeFile(this.m_sLocaleFilePath + this.m_sFileName4RepeatKey, this.m_sbRepeatInfo.toString(), "utf-8");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block14;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var3_2 = null;
                    if (!this.m_recordLocaleProps) break block14;
                    try {
                        this.writeLocale();
                        this.closeLocalePropsWriter();
                    }
                    catch (IOException exception2) {
                        exception2.printStackTrace();
                    }
                    try {
                        CMyFile.writeFile(this.m_sLocaleFilePath + this.m_sFileName4RepeatKey, this.m_sbRepeatInfo.toString(), "utf-8");
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (this.m_recordLocaleProps) {
                    try {
                        this.writeLocale();
                        this.closeLocalePropsWriter();
                    }
                    catch (IOException exception) {
                        exception.printStackTrace();
                    }
                    try {
                        CMyFile.writeFile(this.m_sLocaleFilePath + this.m_sFileName4RepeatKey, this.m_sbRepeatInfo.toString(), "utf-8");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
    }

    private void writeLocale() throws IOException, CMyException {
        Collections.sort(this.list, new Comparator(){

            public int compare(Object object, Object object2) {
                String[] stringArray = (String[])object;
                String[] stringArray2 = (String[])object2;
                return stringArray[0].compareToIgnoreCase(stringArray2[0]);
            }
        });
        Writer writer = this.getLocalePropsWriter();
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            String[] stringArray = (String[])this.list.get(i);
            writer.write(stringArray[0]);
            writer.write("=");
            writer.write(stringArray[1]);
            writer.write("\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void localizeNew(Date date) throws CMyException {
        if (this.m_recordLocaleProps) {
            this.getLocalePropsWriter();
        }
        this.localizeNew1(date);
        Object var4_2 = null;
        if (!this.m_recordLocaleProps) return;
        try {
            this.closeLocalePropsWriter();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return;
        {
            catch (Exception exception) {
                exception.printStackTrace();
                Object var4_3 = null;
                if (!this.m_recordLocaleProps) return;
                try {
                    this.closeLocalePropsWriter();
                    return;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!this.m_recordLocaleProps) throw throwable;
            try {
                this.closeLocalePropsWriter();
                throw throwable;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw throwable;
        }
    }

    public void localize1() throws CMyException {
        if (this.m_arrToTransPaths == null || this.m_arrToTransPaths.length <= 0) {
            this.localizePath(new File(this.m_sRootPath));
            return;
        }
        for (int i = 0; i < this.m_arrToTransPaths.length; ++i) {
            File file = new File(this.m_sRootPath + this.m_arrToTransPaths[i]);
            this.localizePath(file);
        }
    }

    public void localizeNew1(Date date) throws CMyException {
        for (int i = 0; i < this.m_arrToTransPaths.length; ++i) {
            File file = new File(this.m_sRootPath + File.separatorChar + this.m_arrToTransPaths[i]);
            this.localizePathNew(file, date);
        }
    }

    public void localizePath(File file) throws CMyException {
        if (file.isDirectory()) {
            String string = file.getAbsolutePath();
            String[] stringArray = new String[]{".svn", "CVS"};
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.endsWith(stringArray[i])) continue;
                return;
            }
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.localizePath(fileArray[i]);
            }
            return;
        }
        this.localizeFile(file, this.getToFileName(file));
    }

    private void localizePathNew(File file, Date date) throws CMyException {
        if (date == null) {
            this.localizePath(file);
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.localizePathNew(fileArray[i], date);
            }
            return;
        }
        if (file.lastModified() >= date.getTime()) {
            this.localizeFile(file, this.getToFileName(file));
        }
    }

    public void localizeFile(File file, String string) throws CMyException {
        String string2 = file.getAbsolutePath();
        if (!this.isAccept(string2)) {
            CMyFile.copyFile(string2, string, true, true);
            return;
        }
        System.out.println("----------From :" + string2);
        System.out.println(">>>>>>>>>>>>To :" + string);
        String string3 = CharsetDetector.detect(string2);
        String string4 = CMyFile.readFile(string2, string3);
        string4 = string4.replaceAll("\\%>", "%_!_%");
        string4 = this.blockTrans(string4);
        string4 = this.attrTrans(string4);
        string4 = this.scriptLocalize(string4);
        string4 = this.linkLocalize(string4);
        string4 = string4.replaceAll("\\%_\\!_\\%", "%>");
        CMyFile.writeFile(string, string4, string3);
    }

    private String scriptLocalize(String string) {
        Matcher matcher = m_pScriptLocale.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (matcher.find()) {
            int n2 = matcher.start();
            stringBuffer.append(string.substring(n, n2));
            String string2 = matcher.group(2).replaceAll("(?i)\\$locale\\$", this.m_sLang);
            stringBuffer.append(matcher.group(1).replaceAll("(?i) src=[\"'][^\"']*[\"']", ""));
            stringBuffer.append(" src=\"");
            stringBuffer.append(string2);
            stringBuffer.append("\">");
            n = matcher.end();
        }
        if (n != string.length() - 1) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    private String linkLocalize(String string) {
        Matcher matcher = m_pLinkLocale.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (matcher.find()) {
            int n2 = matcher.start();
            stringBuffer.append(string.substring(n, n2));
            String string2 = matcher.group(2).replaceAll("(?i)\\$locale\\$", this.m_sLang);
            stringBuffer.append(matcher.group(1).replaceAll("(?i) href=[\"'][^\"']*[\"']", ""));
            stringBuffer.append(" href=\"");
            stringBuffer.append(string2);
            stringBuffer.append("\" />");
            n = matcher.end();
        }
        if (n != string.length() - 1) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    private boolean isAccept(String string) {
        String string2 = string.replaceFirst("^.*\\.([^\\.]*)", "$1").toLowerCase();
        return "jsp".equals(string2) || "html".equals(string2) || "htm".equals(string2);
    }

    private String attrTrans(String string) {
        Matcher matcher = m_pAttrTrans.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (matcher.find()) {
            int n2 = matcher.start();
            stringBuffer.append(string.substring(n, n2));
            String string2 = matcher.group(2);
            String string3 = matcher.group(3);
            String string4 = this.getTranslate(string3, this.m_recordLocaleProps ? this.getAttrValue(matcher.group(1), string2) : "");
            if (string4 != null) {
                stringBuffer.append(matcher.group(1).replaceAll("(?i) " + string2 + "=[\"'][^\"']*[\"']", ""));
                stringBuffer.append(" ");
                stringBuffer.append(string2);
                stringBuffer.append("=\"");
                stringBuffer.append(string4);
                stringBuffer.append("\"");
                stringBuffer.append(matcher.group(5));
                stringBuffer.append(">");
            } else {
                stringBuffer.append(matcher.group(0));
            }
            n = matcher.end();
        }
        if (n != string.length() - 1) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    private int getNextQuoteIndex(String string, char c, int n) {
        int n2 = string.indexOf(c, n);
        while (n2 > 0 && string.charAt(n2 - 1) == '\\') {
            n2 = string.indexOf(c, n2 + 1);
        }
        return n2;
    }

    private String getAttrValue(String string, String string2) {
        int n;
        String string3 = " " + string2.toLowerCase() + "=";
        int n2 = string.toLowerCase().indexOf(string3);
        if (n2 < 0) {
            return "";
        }
        char c = string.charAt(n2 += string3.length());
        int n3 = this.getNextQuoteIndex(string = string.substring(n2 + 1), c, 0);
        if (n3 < 0) {
            return "";
        }
        String string4 = "<%";
        String string5 = "%_!_%";
        String string6 = string.substring(0, n3);
        if (string6.indexOf(string4) == -1) {
            return string6;
        }
        int n4 = string6.lastIndexOf(string4);
        if (n4 < (n = string6.lastIndexOf(string5))) {
            return string6;
        }
        int n5 = string.indexOf(string5, n3);
        while (n3 > 0 && n5 > 0) {
            n3 = this.getNextQuoteIndex(string, c, n5);
            if (n3 < 0) {
                return "";
            }
            string6 = string.substring(n5, n3);
            if (string6.indexOf(string4) == -1) {
                return string.substring(0, n3);
            }
            n5 = string.indexOf(string5, n3);
        }
        return "";
    }

    private String blockTrans(String string) {
        Matcher matcher = m_pBlockWhere.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (matcher.find()) {
            int n2 = matcher.start();
            if (n2 < n) continue;
            stringBuffer.append(string.substring(n, n2));
            String string2 = matcher.group(1);
            n = this.doBlock(matcher, string, string2, stringBuffer);
        }
        if (n != string.length() - 1) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    private int doBlock(Matcher matcher, String string, String string2, StringBuffer stringBuffer) {
        string2 = string2.toLowerCase();
        String string3 = "<" + string2;
        String string4 = "</" + string2 + ">";
        int n = matcher.end();
        String string5 = string.substring(n);
        String string6 = string5.toLowerCase();
        int n2 = string6.indexOf(string3);
        int n3 = string6.indexOf(string4);
        if (n3 < 0) {
            stringBuffer.append(matcher.group(0));
            return n;
        }
        if (n2 < 0 || n3 < n2) {
            String string7 = matcher.group(2);
            String string8 = this.getTranslate(string7, string5.substring(0, n3));
            stringBuffer.append(matcher.group(0));
            stringBuffer.append(string8);
            stringBuffer.append(string4);
            return n + n3 + string4.length();
        }
        int n4 = 2;
        int n5 = n2 + string3.length();
        String string9 = null;
        while (n4 > 0 && n5 >= 0) {
            string9 = string6.substring(n5);
            int n6 = string9.indexOf(string3);
            int n7 = string9.indexOf(string4);
            if (n7 < 0) {
                n5 = -1;
                break;
            }
            if (n6 < 0 || n7 < n6) {
                --n4;
                n5 += n7 + string4.length();
                continue;
            }
            ++n4;
            n5 += n6 + string3.length();
        }
        if (n5 > 0) {
            String string10 = matcher.group(2);
            String string11 = this.getTranslate(string10, string5.substring(0, n5 - string4.length()));
            stringBuffer.append(matcher.group(0));
            stringBuffer.append(string11);
            stringBuffer.append(string4);
            return n + n5;
        }
        stringBuffer.append(matcher.group(0));
        return n;
    }

    private Writer getLocalePropsWriter() throws IOException, CMyException {
        String string = this.m_sLocaleFilePath + this.m_sLang + ".properties.tmp";
        if (this.m_localePropsWriter == null) {
            if (!new File(string).exists()) {
                CMyFile.makeDir(this.m_sLocaleFilePath, true);
            }
            this.m_tmpTranParams = new HashMap();
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            this.m_localePropsWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "GBK");
        }
        return this.m_localePropsWriter;
    }

    private void closeLocalePropsWriter() throws IOException {
        if (this.m_localePropsWriter != null) {
            this.m_localePropsWriter.close();
        }
    }

    private String getTranslate(String string, String string2) {
        string2 = CMyString.showEmpty(string2).trim().replaceAll("\\%_\\!_\\%", "%>");
        if (this.m_recordLocaleProps) {
            try {
                String string3 = (String)this.m_tmpTranParams.get(string.toUpperCase());
                if (string3 != null) {
                    if (!string3.equalsIgnoreCase(string2)) {
                        String string4 = I18NMessage.get(Localizer2.class, "Localizer2.label1", I18NMessage.get(Localizer2.class, "Localizer2.label1", "\u91cd\u590d\u4f7f\u7528\u540c\u4e00\u4e2a\u53d8\u91cf:")) + string + I18NMessage.get(Localizer2.class, "Localizer2.label2", I18NMessage.get(Localizer2.class, "Localizer2.label2", ",\u65e7\u503c:")) + string3 + I18NMessage.get(Localizer2.class, "Localizer2.label3", I18NMessage.get(Localizer2.class, "Localizer2.label3", ",\u65b0\u503c:")) + string2;
                        System.out.println(string4);
                        this.m_sbRepeatInfo.append(string4);
                        this.m_sbRepeatInfo.append("\n");
                        this.m_tmpTranParams.put(string.toUpperCase(), string2);
                        this.list.add(new String[]{string, string2});
                    }
                } else {
                    this.m_tmpTranParams.put(string.toUpperCase(), string2);
                    this.list.add(new String[]{string, string2});
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return CMyString.showNull((String)this.m_htTranslates.get(string.toUpperCase()), string2);
    }

    private String getToFileName(File file) {
        String string = file.getAbsolutePath();
        return this.m_sTargetPath + string.substring(this.m_sRootPath.length());
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 4) {
            System.err.println("\u81f3\u5c11\u9700\u8981\u4f20\u5165\u56db\u4e2a\u53c2\u6570\uff0c\u8bf7\u53c2\u8003main\u65b9\u6cd5\u7684javadoc\u8bf4\u660e");
            return;
        }
        Localizer2 localizer2 = new Localizer2(stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
        if (stringArray.length >= 5) {
            localizer2.setRecordLocaleProps("true".equalsIgnoreCase(stringArray[4]));
        }
        if (stringArray.length >= 6) {
            localizer2.setToTransPaths(stringArray[5].split(","));
            System.out.println("\u5c06\u5206\u6790\u6307\u5b9a\u76ee\u5f55" + stringArray[5] + "\u4e0b\u7684\u9875\u9762\u6587\u4ef6");
        }
        try {
            localizer2.localize();
        }
        catch (CMyException cMyException) {
            cMyException.printStackTrace();
        }
    }
}

