/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CharsetDetector;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LocaleTools {
    private static Pattern chinesePattern = Pattern.compile("\"([^\"\n\u4e00-\u9fbb]*[\u4e00-\u9fbb]+[^\"\n]*)\"");
    private static String[] aRootPath = new String[]{"E:\\MyWorkspace\\TRS.WCM.V6.1.Std\\SourceCode\\Java\\scene"};
    private static String sRootPrefix = "E:\\MyWorkspace\\TRS.WCM.V6.1.Std\\SourceCode\\Java\\scene";
    private static Pattern findMaxLabelIndexPattern = Pattern.compile("(?m)I18NMessage[\\. \\s]+get\\([^,]+,[^,\\d]+([\\d]+)");
    private static boolean bOnlyFind = true;
    private static String newFileExt = "";
    private static int nCurrLabelIndex = 0;
    private static String sCurrPackageName = null;
    private static String sCurrFileName = null;
    private static List properties = null;
    private static Map mProperties = new HashMap();
    private static BufferedWriter propertiesWriter = null;
    private static Pattern localeServerPattern = Pattern.compile("(?m)I18NMessage[\\. \\s]+get\\([^,]+,\\s*\"([^,\"\\d]+([\\d]+))\"\\s*,\\s*");

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append("\u6307\u5b9a\u7684\u53c2\u6570\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u81f3\u5c11\u9700\u8981\u4e24\u4e2a\u4e2a\u53c2\u6570\n");
            stringBuffer.append("\u7b2c\u4e00\u4e2a\u53c2\u6570\u6307\u5b9a\u9700\u8981\u5904\u7406\u7684java\u6e90\u7801\u76ee\u5f55\uff1a\n");
            stringBuffer.append("\t\t\u5982\uff1a\n");
            stringBuffer.append("d:/workspace/TRS.WCM.V6.1/SourceCode/Java/scene/com/trs");
            stringBuffer.append("\n\u7b2c\u4e8c\u4e2a\u53c2\u6570\u6307\u5b9a\u662f\u5426\u4fee\u6539java\u6587\u4ef6\uff0c\u503c\u4e3afalse\uff0c\u4fee\u6539\u5f53\u524d\u6b63\u5728\u5206\u6790\u7684\u6e90\u7801\u6587\u4ef6\uff0c\u4e3atrue\u65f6\u4e0d\u4fee\u6539\n");
            stringBuffer.append("\n\u7b2c\u4e09\u4e2a\u53c2\u6570\uff0c\u53ef\u9009\uff0c\u6307\u5b9ajava\u6587\u4ef6\u5305\u540d\u63d0\u53d6\u7684\u76ee\u5f55\u524d\u7f00\uff0c\u9ed8\u8ba4\u4e0e\u7b2c\u4e00\u4e2a\u53c2\u6570\u76f8\u540c\uff1a\n");
            stringBuffer.append("\t\t\u5982\uff1a\n");
            stringBuffer.append("d:/workspace/TRS.WCM.V6.1/SourceCode/Java/scene/");
            System.out.println(stringBuffer.toString());
            return;
        }
        LocaleTools.aRootPath[0] = stringArray[0];
        sRootPrefix = stringArray[0];
        if ("true".equals(stringArray[1])) {
            bOnlyFind = true;
        } else if ("false".equals(stringArray[1])) {
            bOnlyFind = false;
        }
        if (stringArray.length > 2) {
            sRootPrefix = stringArray[2];
        }
        LocaleTools.analyzeDir(new File(aRootPath[0]));
    }

    private static void analyzeDir(File file) throws Exception {
        int n;
        if (!file.exists() || LocaleTools.isExcludeDir(file.getPath())) {
            return;
        }
        String string = file.getAbsolutePath();
        System.out.println(">>>>>>>>>>>>" + string);
        sCurrPackageName = string.substring(sRootPrefix.length()).replaceAll("\\\\", ".");
        properties = new ArrayList();
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".java");
            }
        });
        for (n = 0; n < fileArray.length; ++n) {
            if (!fileArray[n].isFile()) continue;
            LocaleTools.analyzeFile(fileArray[n]);
        }
        if (properties.size() > 0) {
            LocaleTools.writeProperties(file);
        }
        for (n = 0; n < fileArray.length; ++n) {
            if (!fileArray[n].isDirectory()) continue;
            LocaleTools.analyzeDir(fileArray[n]);
        }
    }

    private static boolean isExcludeDir(String string) {
        return string.indexOf("/com/trs/util") >= 0 || string.indexOf("CVS") >= 0 || string.indexOf("svn") >= 0;
    }

    private static void analyzeFile(File file) throws Exception {
        String string = file.getAbsolutePath();
        System.out.println("^^^^^^^^^^^^^^^^^" + string);
        sCurrFileName = file.getName().replaceFirst("\\.[^\\.]+$", "");
        String string2 = CharsetDetector.detect(string);
        String string3 = CMyFile.readFile(string, string2);
        StringBuffer stringBuffer = new StringBuffer(string3.length());
        nCurrLabelIndex = LocaleTools.getMaxLabelIndex(string3) + 1;
        int n = 0;
        Matcher matcher = chinesePattern.matcher(string3);
        while (matcher.find()) {
            String string4;
            int n2 = matcher.start();
            int n3 = matcher.end();
            String string5 = string3.substring(n, n2);
            stringBuffer.append(string5);
            n = n3;
            if (LocaleTools.isInComment(string5) || LocaleTools.isInLocale(string5, matcher.group(1))) {
                stringBuffer.append(matcher.group(0));
                continue;
            }
            String string6 = matcher.group(1);
            String string7 = sCurrFileName + ":" + string6;
            String string8 = (String)mProperties.get(string7);
            if (string8 == null) {
                string4 = "" + nCurrLabelIndex;
                string8 = LocaleTools.getLocaleKey();
                properties.add(new String[]{string8, string6, string4});
                mProperties.put(string7, string8);
            }
            string4 = LocaleTools.getReplaceLocale(string8, string6);
            stringBuffer.append(string4);
        }
        if (n < string3.length()) {
            stringBuffer.append(string3.substring(n));
        }
        if (bOnlyFind) {
            return;
        }
        CMyFile.writeFile(string + newFileExt, stringBuffer.toString(), string2);
    }

    private static Writer getPropertiesWriter(File file) throws Exception {
        if (propertiesWriter == null) {
            propertiesWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file.getAbsolutePath() + "/i18nmessage.properties")));
        }
        return propertiesWriter;
    }

    private static void closePropertiesWriter() throws Exception {
        if (propertiesWriter == null) {
            return;
        }
        propertiesWriter.close();
        propertiesWriter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void writeProperties(File file) throws Exception {
        try {
            try {
                Collections.sort(properties, new Comparator(){

                    public int compare(Object object, Object object2) {
                        String[] stringArray = (String[])object;
                        String[] stringArray2 = (String[])object2;
                        int n = stringArray[0].compareToIgnoreCase(stringArray[2]);
                        return n != 0 ? -n : Integer.parseInt(stringArray[2]) - Integer.parseInt(stringArray2[2]);
                    }
                });
                Writer writer = LocaleTools.getPropertiesWriter(file);
                writer.write("#" + sCurrPackageName + "\n");
                int n = properties.size();
                for (int i = 0; i < n; ++i) {
                    String[] stringArray = (String[])properties.get(i);
                    writer.write(stringArray[0]);
                    writer.write("=");
                    writer.write(stringArray[1]);
                    writer.write("\n");
                }
                Object var6_6 = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var6_7 = null;
                LocaleTools.closePropertiesWriter();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            LocaleTools.closePropertiesWriter();
            throw throwable;
        }
        LocaleTools.closePropertiesWriter();
    }

    private static String getLocaleKey() {
        return sCurrFileName + ".label" + nCurrLabelIndex++;
    }

    private static String getReplaceLocale(String string, String string2) {
        return "I18NMessage.get(" + sCurrFileName + ".class, \"" + string + "\", \"" + string2 + "\")";
    }

    private static boolean isInComment(String string) {
        int n;
        int n2 = string.lastIndexOf("//");
        if (n2 > (n = string.lastIndexOf(10))) {
            return true;
        }
        int n3 = string.lastIndexOf("/*");
        if (n3 < 0) {
            return false;
        }
        int n4 = string.lastIndexOf("*/");
        return n3 > n4;
    }

    private static boolean isInLocale(String string, String string2) {
        int n = string.lastIndexOf("I18NMessage");
        if (n < 0) {
            return false;
        }
        String string3 = string.substring(n);
        Matcher matcher = localeServerPattern.matcher(string3);
        if (!matcher.find()) {
            return false;
        }
        String string4 = sCurrFileName + ":" + string2;
        String string5 = (String)mProperties.get(string4);
        String string6 = matcher.group(1);
        if (string6.equals(string5)) {
            return true;
        }
        properties.add(new String[]{string6, string2, matcher.group(2)});
        if (string5 == null) {
            mProperties.put(string4, string6);
        }
        return true;
    }

    private static int getMaxLabelIndex(String string) {
        int n = 0;
        Matcher matcher = findMaxLabelIndexPattern.matcher(string);
        while (matcher.find()) {
            int n2 = Integer.parseInt(matcher.group(1));
            if (n >= n2) continue;
            n = n2;
        }
        return n;
    }
}

