/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LocalServerAuto {
    private static final String WEB_INF_CLASSES_LOCALE = "/WEB-INF/classes/locale/";
    String m_sLang = "cn";
    String m_sRootPath = "/wcm";
    String m_sTargetPath = "";
    String[] m_arrToTransPaths = new String[]{"app", "console"};
    static Pattern m_pLocalServer = Pattern.compile("(?)LocaleServer\\.getString\\(\"([^\"]*?)\"\\s*,\\s*\"(.*?)\"\\)");
    Writer m_localePropsWriter = null;
    private Map m_tmpTranParams = null;
    private List list = new ArrayList();

    public LocalServerAuto(String string, String string2) {
        this.m_sRootPath = new File(string.replace('/', File.separatorChar).replace('\\', File.separatorChar)).getAbsolutePath();
        this.m_sLang = string2;
    }

    public String[] getToTransPaths() {
        return this.m_arrToTransPaths;
    }

    public void setToTransPaths(String[] stringArray) {
        this.m_arrToTransPaths = stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void analyze() throws CMyException {
        block9: {
            this.getLocalePropsWriter();
            for (int i = 0; i < this.m_arrToTransPaths.length; ++i) {
                File file = new File(this.m_sRootPath + File.separatorChar + this.m_arrToTransPaths[i]);
                this.analyzePath(file);
            }
            this.writeLocale();
            Object var4_4 = null;
            try {
                this.closeLocalePropsWriter();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            break block9;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var4_5 = null;
                    try {
                        this.closeLocalePropsWriter();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {
                    this.closeLocalePropsWriter();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    public void analyzePath(File file) throws CMyException, IOException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.analyzePath(fileArray[i]);
            }
            return;
        }
        this.analyzeFile(file);
    }

    public void analyzeFile(File file) throws CMyException, IOException {
        String string = file.getAbsolutePath();
        if (!this.isPageFile(string)) {
            return;
        }
        String string2 = this.genFileEncoding(string);
        String string3 = CMyFile.readFile(string, string2);
        this.analyzeContent(string, string3);
    }

    private void analyzeContent(String string, String string2) throws IOException {
        Matcher matcher = m_pLocalServer.matcher(string2);
        while (matcher.find()) {
            String string3 = matcher.group(1);
            String string4 = matcher.group(2);
            String string5 = (String)this.m_tmpTranParams.get(string3);
            if (string5 != null) {
                if (string5.equals(string4)) continue;
                System.out.println(string + I18NMessage.get(LocalServerAuto.class, "LocalServerAuto.label1", "===>\u91cd\u590d\u4f7f\u7528\u53d8\u91cf:") + string3 + I18NMessage.get(LocalServerAuto.class, "LocalServerAuto.label2", ",\u65e7\u503c:") + string5 + I18NMessage.get(LocalServerAuto.class, "LocalServerAuto.label3", ",\u65b0\u503c:") + string4);
                continue;
            }
            this.list.add(new String[]{string3, string4});
            this.m_tmpTranParams.put(string3, string4);
        }
    }

    private void writeLocale() throws IOException {
        Collections.sort(this.list, new Comparator(){

            public int compare(Object object, Object object2) {
                String[] stringArray = (String[])object;
                String[] stringArray2 = (String[])object2;
                return stringArray[0].compareToIgnoreCase(stringArray2[0]);
            }
        });
        Writer writer = this.getLocalePropsWriter();
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            String[] stringArray = (String[])this.list.get(i);
            writer.write(stringArray[0]);
            writer.write("=");
            writer.write(stringArray[1]);
            writer.write("\n");
        }
    }

    private boolean isPageFile(String string) {
        String string2 = string.replaceFirst("^.*\\.([^\\.]*)", "$1").toLowerCase();
        return "jsp".equals(string2);
    }

    private Writer getLocalePropsWriter() throws IOException {
        String string = this.m_sRootPath + WEB_INF_CLASSES_LOCALE + this.m_sLang + ".properties";
        if (this.m_localePropsWriter == null) {
            if (!new File(string).exists()) {
                CMyFile.makeDir(this.m_sRootPath + WEB_INF_CLASSES_LOCALE, true);
            }
            this.m_tmpTranParams = new HashMap();
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            this.m_localePropsWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "GBK");
        }
        return this.m_localePropsWriter;
    }

    private void closeLocalePropsWriter() throws IOException {
        if (this.m_localePropsWriter != null) {
            this.m_localePropsWriter.close();
        }
    }

    private String genFileEncoding(String string) {
        String string2 = "GBK";
        if ((string = string.replace('\\', '/')).indexOf("/metadata/application/") != -1) {
            return "UTF-8";
        }
        if (string.indexOf("/ext/") != -1 && string.indexOf("/locale/") == -1 && string.indexOf("wcm") == -1) {
            return "GBK";
        }
        if (string.endsWith(".xml")) {
            return "GBK";
        }
        if (!string.endsWith(".jsp")) {
            return "UTF-8";
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        String string = "E:\\MyWorkspace\\TRS.WCM.V6.1.Std\\release\\cn\\wcm";
        String string2 = "zh_CN";
        if (stringArray.length >= 2) {
            string = stringArray[0];
            string2 = stringArray[1];
        }
        LocalServerAuto localServerAuto = new LocalServerAuto(string, string2);
        localServerAuto.setToTransPaths(new String[]{"app"});
        try {
            localServerAuto.analyze();
        }
        catch (CMyException cMyException) {
            cMyException.printStackTrace();
        }
    }
}

