/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CharsetDetector;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPIncludeFileFinder {
    private String m_sRootPath;
    private String m_sOutputFileName;
    private Pattern m_IncludeRegExp = Pattern.compile("(?im)<%@ *include.*?file=.*?\".*?([a-zA-Z_0-9]+\\.jsp)\".*?%>");
    private Map m_FileContentMapping = new HashMap();
    private FileFilter jspFileFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".jsp");
        }
    };

    public JSPIncludeFileFinder(String string, String string2) {
        this.m_sRootPath = string;
        this.m_sOutputFileName = string2;
    }

    public void analyze() throws CMyException {
        File file = new File(this.m_sRootPath);
        StringBuffer stringBuffer = new StringBuffer(1000);
        this.analyzeFolder(file, file, stringBuffer);
        if (stringBuffer.length() > 0) {
            CMyFile.writeFile(this.m_sOutputFileName, stringBuffer.toString());
        }
    }

    private void analyzeFolder(File file, File file2, StringBuffer stringBuffer) throws CMyException {
        File[] fileArray = file2.listFiles(this.jspFileFilter);
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                this.analyzeFolder(file, fileArray[i], stringBuffer);
                continue;
            }
            System.out.println("\u5f00\u59cb\u5206\u6790\u6587\u4ef6[" + fileArray[i].getAbsolutePath() + "]");
            if (!this.isIncludInFolder(file, fileArray[i])) continue;
            stringBuffer.append(fileArray[i].getName()).append("\n");
            System.out.println(fileArray[i].getName());
        }
    }

    private boolean isIncludInFolder(File file, File file2) throws CMyException {
        File[] fileArray = file.listFiles(this.jspFileFilter);
        for (int i = 0; i < fileArray.length; ++i) {
            if (!(fileArray[i].isDirectory() ? this.isIncludInFolder(fileArray[i], file2) : this.isIncludeInFile(fileArray[i], file2))) continue;
            return true;
        }
        return false;
    }

    public List getIncludeFiles(String string) throws CMyException {
        ArrayList<String> arrayList = (ArrayList<String>)this.m_FileContentMapping.get(string);
        if (arrayList != null) {
            return arrayList;
        }
        arrayList = new ArrayList<String>();
        String string2 = CharsetDetector.detect(string);
        String string3 = CMyFile.readFile(string, string2);
        Matcher matcher = this.m_IncludeRegExp.matcher(string3);
        while (matcher.find()) {
            arrayList.add(matcher.group(1));
        }
        this.m_FileContentMapping.put(string, arrayList);
        return arrayList;
    }

    private boolean isIncludeInFile(File file, File file2) throws CMyException {
        String string = file.getAbsolutePath();
        List list = this.getIncludeFiles(string);
        String string2 = file2.getName();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (!string2.equals(list.get(i))) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) throws CMyException {
        if (stringArray.length < 2) {
            System.out.println("\u9700\u8981\u6307\u5b9a\u4e24\u4e2a\u53c2\u6570\uff0c\u8bf7\u53c2\u8003main\u65b9\u6cd5\u6ce8\u91ca");
            return;
        }
        JSPIncludeFileFinder jSPIncludeFileFinder = new JSPIncludeFileFinder(stringArray[0], stringArray[1]);
        jSPIncludeFileFinder.analyze();
    }
}

