/*
 * Decompiled with CFR 0.152.
 */
package com.trs.template.domain.setting;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.template.domain.setting.ITemplateSetting;
import java.util.Enumeration;
import java.util.Properties;

public class TemplateSettingFactory {
    public static final String PROPERTY_NAME_SETTING = "setting.properties";
    private static TemplateSettingFactory itsInstance = new TemplateSettingFactory();
    private static Properties s_oSettingTypeMap;

    public ITemplateSetting makeSettingByType(String string) throws WCMException {
        String string2 = s_oSettingTypeMap.getProperty(string.toUpperCase());
        return (ITemplateSetting)this.makeInstance(string2);
    }

    public ITemplateSetting[] makeAllSettings() throws WCMException {
        ITemplateSetting[] iTemplateSettingArray = new ITemplateSetting[s_oSettingTypeMap.size()];
        for (int i = 0; i < iTemplateSettingArray.length; ++i) {
            String string = this.getSettingTypeClassz()[i];
            iTemplateSettingArray[i] = (ITemplateSetting)this.makeInstance(string);
        }
        return iTemplateSettingArray;
    }

    public static TemplateSettingFactory getInstance() {
        if (s_oSettingTypeMap == null) {
            TemplateSettingFactory.loadProperties();
            if (s_oSettingTypeMap == null) {
                throw new RuntimeException(I18NMessage.get(TemplateSettingFactory.class, "TemplateSettingFactory.label1", "\u65e0\u6cd5\u521d\u59cb\u5316\u914d\u7f6e\u6587\u4ef6!"));
            }
        }
        return itsInstance;
    }

    public String[] getSettingTypes() {
        String[] stringArray = new String[s_oSettingTypeMap.size()];
        Enumeration<Object> enumeration = s_oSettingTypeMap.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public String[] getSettingTypeClassz() {
        String[] stringArray = new String[s_oSettingTypeMap.size()];
        Enumeration<Object> enumeration = s_oSettingTypeMap.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    private static void loadProperties() {
        s_oSettingTypeMap = new Properties();
        s_oSettingTypeMap.put("DWT_CHANNELS", "com.trs.template.domain.setting.ChannelsTemplateSetting");
        s_oSettingTypeMap.put("DWT_FIELDS", "com.trs.template.domain.setting.FieldsTemplateSetting");
        s_oSettingTypeMap.put("DWT_TEMPLATES", "com.trs.template.domain.setting.TemplatesTemplateSetting");
    }

    private Object makeInstance(String string) throws WCMException {
        try {
            return Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new WCMException("Cannot create setting-instance for [" + string + "]", exception);
        }
    }
}

