/*
 * Decompiled with CFR 0.152.
 */
package com.trs.template.domain;

import com.trs.infra.I18NMessage;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyZip;
import com.trs.infra.util.xml.IXmlPersistentObject;
import com.trs.infra.util.xml.XmlObjectPersistentor;
import com.trs.template.domain.InfoEntityFinder;
import com.trs.template.domain.SourcePathHelper;
import com.trs.template.persistent.InfoEntities;
import com.trs.template.persistent.WebSiteInfoEntity;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class TemplateXmlGenerator {
    private static final String XML_ENCODING = "GBK";
    private static Logger s_logger = Logger.getLogger(TemplateXmlGenerator.class);
    private ArrayList m_arAllRelChannelsXmlFiles = null;
    private ArrayList m_arAllRelFieldsXmlFiles = null;
    private ArrayList m_arAllRelTemplatesXmlFiles = null;
    private InfoEntityFinder m_oInfoEntityFinder = new InfoEntityFinder();
    private InfoEntities m_oSiteInfoEntities = null;
    private InfoEntities m_oTagFieldInfoEntities = null;
    private InfoEntities m_oTemplateInfoEntities = null;

    protected synchronized void renderChannels() {
        this.m_arAllRelChannelsXmlFiles = new ArrayList();
        this.makeAllSiteInfo();
        this.makeAllBaseChannelInfo();
    }

    private synchronized void renderFields() {
        this.m_arAllRelFieldsXmlFiles = new ArrayList(1);
        this.makeAllFieldsInfo();
    }

    private synchronized void renderTemplates() {
        this.m_arAllRelTemplatesXmlFiles = new ArrayList(1);
        this.makeAllTemplatesInfo();
    }

    protected void makeAllSiteInfo() {
        try {
            this.m_oSiteInfoEntities = this.m_oInfoEntityFinder.getSiteEntities();
            String string = SourcePathHelper.getSiteInfoFilePath();
            this.persistentEntities(this.m_oSiteInfoEntities, string);
            this.m_arAllRelChannelsXmlFiles.add(string);
        }
        catch (Exception exception) {
            throw new RuntimeException(I18NMessage.get(TemplateXmlGenerator.class, "TemplateXmlGenerator.label1", "\u5e8f\u5217\u5316\u7ad9\u70b9\u63cf\u8ff0\u4fe1\u606f\u7684xml\u5931\u8d25![") + exception.getLocalizedMessage() + "}", exception);
        }
    }

    protected void makeAllBaseChannelInfo() {
        if (this.m_oSiteInfoEntities == null || this.m_oSiteInfoEntities.size() == 0) {
            return;
        }
        for (int i = 0; i < this.m_oSiteInfoEntities.size(); ++i) {
            WebSiteInfoEntity webSiteInfoEntity = (WebSiteInfoEntity)this.m_oSiteInfoEntities.getAt(i);
            this.makeBaseChannelInfo(webSiteInfoEntity.getSiteId());
        }
    }

    protected void makeAllFieldsInfo() {
        try {
            this.m_oTagFieldInfoEntities = this.m_oInfoEntityFinder.getFieldEntities();
            String string = SourcePathHelper.getFieldInfoFilePath();
            this.persistentEntities(this.m_oTagFieldInfoEntities, string);
            this.m_arAllRelFieldsXmlFiles.add(string);
        }
        catch (Exception exception) {
            throw new RuntimeException(I18NMessage.get(TemplateXmlGenerator.class, "TemplateXmlGenerator.label2", "\u5e8f\u5217\u5316\u5b57\u6bb5\u63cf\u8ff0\u4fe1\u606f\u7684xml\u5931\u8d25![") + exception.getLocalizedMessage() + "}", exception);
        }
    }

    private void makeAllTemplatesInfo() {
        String string = null;
        try {
            this.m_oTemplateInfoEntities = this.m_oInfoEntityFinder.getTemplateEntities();
            string = SourcePathHelper.getTemplateInfoFilePath();
            this.persistentEntities(this.m_oTemplateInfoEntities, string);
            this.m_arAllRelTemplatesXmlFiles.add(string);
        }
        catch (Exception exception) {
            s_logger.error((Object)("failed to serialize mapping file!" + string), (Throwable)exception);
            throw new RuntimeException(I18NMessage.get(TemplateXmlGenerator.class, "TemplateXmlGenerator.label3", "\u5e8f\u5217\u5316\u6a21\u677f\u63cf\u8ff0\u4fe1\u606f\u7684xml\u5931\u8d25![") + exception.getLocalizedMessage() + "}", exception);
        }
    }

    private void makeBaseChannelInfo(int n) {
        try {
            InfoEntities infoEntities = this.m_oInfoEntityFinder.getBaseChannelEntities(n);
            String string = SourcePathHelper.getBaseChannelInfoFilePath(n);
            this.persistentEntities(infoEntities, string);
            this.m_arAllRelChannelsXmlFiles.add(string);
        }
        catch (Exception exception) {
            throw new RuntimeException(I18NMessage.get(TemplateXmlGenerator.class, "TemplateXmlGenerator.label4", "\u5e8f\u5217\u5316\u9891\u9053\u63cf\u8ff0\u4fe1\u606f\u7684xml\u5931\u8d25![") + exception.getLocalizedMessage() + "}", exception);
        }
    }

    private void persistentEntities(IXmlPersistentObject iXmlPersistentObject, String string) throws CMyException {
        XmlObjectPersistentor xmlObjectPersistentor = new XmlObjectPersistentor();
        xmlObjectPersistentor.setMappingSrc(SourcePathHelper.getMappingFilePath());
        CMyFile.writeFile(string, "", XML_ENCODING);
        xmlObjectPersistentor.updateInstance(iXmlPersistentObject, string, XML_ENCODING);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Has generated file[" + string + "] successfully"));
        }
    }

    public ArrayList getAllRelChannelsXmlFiles() {
        if (this.m_arAllRelChannelsXmlFiles == null) {
            this.renderChannels();
        }
        return this.m_arAllRelChannelsXmlFiles;
    }

    public ArrayList getAllRelFieldsXmlFiles() {
        if (this.m_arAllRelFieldsXmlFiles == null) {
            this.renderFields();
        }
        return this.m_arAllRelFieldsXmlFiles;
    }

    public ArrayList getAllRelTemplatesXmlFiles() {
        if (this.m_arAllRelTemplatesXmlFiles == null) {
            this.renderTemplates();
        }
        return this.m_arAllRelTemplatesXmlFiles;
    }

    public static byte[] zipFiles(List list) throws CMyException {
        if (list == null || list.size() == 0) {
            return null;
        }
        CMyZip cMyZip = new CMyZip();
        FilesMan filesMan = FilesMan.getFilesMan();
        String string = filesMan.getNextFilePathName("ST", "zip");
        cMyZip.setZipFileName(string);
        String string2 = SourcePathHelper.getFormatedSettingFilesDir(string);
        for (int i = 0; i < list.size(); ++i) {
            String string3 = (String)list.get(i);
            CMyFile.moveFile(string3, string2 + CMyFile.extractFileName(string3));
        }
        cMyZip.addToZip(string2);
        cMyZip.done();
        CMyFile.deleteDir(string2);
        return CMyFile.readBytesFromFile(string);
    }
}

