/*
 * Decompiled with CFR 0.152.
 */
package com.trs.template.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.xml.XmlObjectPersistentor;
import com.trs.service.IChannelService;
import com.trs.service.ITemplateService;
import com.trs.template.domain.SourcePathHelper;
import com.trs.template.persistent.BaseChannelInfoEntity;
import com.trs.template.persistent.InfoEntities;
import com.trs.template.persistent.TemplateInfoEntity;
import com.trs.template.persistent.WebSiteInfoEntity;
import java.util.List;
import org.apache.log4j.Logger;

public class InfoEntityFinder {
    private IChannelService m_oChnlSrv = null;
    private InfoEntities m_oSiteEntities = null;
    private InfoEntities m_oCurrBaseChannelEntities = null;
    private InfoEntities m_oFieldEntities = null;
    private InfoEntities m_oTemplateEntities = null;
    private User m_oLoginUser = ContextHelper.getLoginUser();
    private static Logger s_logger = Logger.getLogger(InfoEntityFinder.class);
    private ITemplateService m_oTemplateSrv;

    public InfoEntityFinder() {
        this.m_oChnlSrv = (IChannelService)DreamFactory.createObjectById("IChannelService");
        this.m_oTemplateSrv = (ITemplateService)DreamFactory.createObjectById("ITemplateService");
    }

    protected void loadSiteInfoEntities() throws WCMException {
        this.m_oSiteEntities = new InfoEntities();
        try {
            User user = this.m_oLoginUser;
            WebSites webSites = new WebSites(user);
            webSites.open(null);
            if (webSites.size() == 0) {
                return;
            }
            for (int i = 0; i < webSites.size(); ++i) {
                WebSiteInfoEntity webSiteInfoEntity;
                WebSite webSite = (WebSite)webSites.getAt(i);
                if (webSite == null || webSite.isDeleted() || !this.hasRight(user, webSite) || (webSiteInfoEntity = new WebSiteInfoEntity(webSite.getId(), webSite.getName(), webSite.getDesc())) == null) continue;
                this.m_oSiteEntities.add(webSiteInfoEntity);
            }
        }
        catch (WCMException wCMException) {
            throw new WCMException(I18NMessage.get(InfoEntityFinder.class, "InfoEntityFinder.label1", "\u67e5\u627e\u7528\u6237[") + this.m_oLoginUser.getName() + I18NMessage.get(InfoEntityFinder.class, "InfoEntityFinder.label2", "]\u53ef\u7f16\u8f91\u7684\u7ad9\u70b9\u65f6\u51fa\u9519!"), wCMException);
        }
    }

    private boolean hasRight(User user, WebSite webSite) throws WCMException {
        if (user.isAdministrator() || webSite.getCrUserName().equals(user.getName())) {
            return true;
        }
        return AuthServer.hasRight(user, (CMSObj)webSite, 64);
    }

    protected void loadBaseChannelEntities(int n) throws WCMException {
        this.m_oCurrBaseChannelEntities = new InfoEntities();
        try {
            WebSite webSite = WebSite.findById(n);
            if (webSite == null) {
                throw new WCMException(I18NMessage.get(InfoEntityFinder.class, "InfoEntityFinder.label3", "\u6ca1\u6709\u627e\u5230\u7ad9\u70b9[") + n + "]!");
            }
            BaseChannelInfoEntity baseChannelInfoEntity = this.makeBaseChannelInfoEntity(webSite);
            if (baseChannelInfoEntity == null) {
                throw new WCMException(I18NMessage.get(InfoEntityFinder.class, "InfoEntityFinder.label4", "\u65e0\u6cd5\u521b\u5efa\u7ad9\u70b9[") + n + I18NMessage.get(InfoEntityFinder.class, "InfoEntityFinder.label5", "]\u7684\u683c\u5f0f\u5316\u4fe1\u606f!"));
            }
            this.m_oCurrBaseChannelEntities.add(baseChannelInfoEntity);
            this.loadChildrenChannels(webSite);
        }
        catch (WCMException wCMException) {
            throw new WCMException(I18NMessage.get(InfoEntityFinder.class, "InfoEntityFinder.label1", "\u67e5\u627e\u7528\u6237[") + this.m_oLoginUser.getName() + I18NMessage.get(InfoEntityFinder.class, "InfoEntityFinder.label6", "]\u53ef\u7f16\u8f91\u7684\u9891\u9053\u5217\u8868\u65f6\u51fa\u9519!"), wCMException);
        }
    }

    private void loadChildrenChannels(BaseChannel baseChannel) throws WCMException {
        List list = this.m_oChnlSrv.getChildren(baseChannel, 23);
        if (list.size() == 0) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            BaseChannel baseChannel2 = (BaseChannel)list.get(i);
            BaseChannelInfoEntity baseChannelInfoEntity = this.makeBaseChannelInfoEntity(baseChannel2);
            if (baseChannelInfoEntity != null) {
                this.m_oCurrBaseChannelEntities.add(baseChannelInfoEntity);
            }
            this.loadChildrenChannels(baseChannel2);
        }
    }

    private BaseChannelInfoEntity makeBaseChannelInfoEntity(BaseChannel baseChannel) throws WCMException {
        BaseChannelInfoEntity baseChannelInfoEntity = new BaseChannelInfoEntity();
        baseChannelInfoEntity.setChannelId(baseChannel.getId());
        baseChannelInfoEntity.setChannelName(baseChannel.getName());
        baseChannelInfoEntity.setChannelDesc(baseChannel.getDesc());
        baseChannelInfoEntity.setIsRoot(baseChannel.isSite());
        baseChannelInfoEntity.setParentId(baseChannel.getParentId());
        baseChannelInfoEntity.setChildren(baseChannel.getChildrenSize(this.m_oLoginUser));
        return baseChannelInfoEntity;
    }

    public InfoEntities getBaseChannelEntities(int n) throws WCMException {
        this.loadBaseChannelEntities(n);
        return this.m_oCurrBaseChannelEntities;
    }

    public InfoEntities getSiteEntities() throws WCMException {
        if (this.m_oSiteEntities == null) {
            this.loadSiteInfoEntities();
        }
        return this.m_oSiteEntities;
    }

    public InfoEntities getFieldEntities() throws WCMException {
        if (this.m_oFieldEntities == null) {
            this.loadMockFieldEntities();
        }
        return this.m_oFieldEntities;
    }

    private void loadMockFieldEntities() throws WCMException {
        try {
            XmlObjectPersistentor xmlObjectPersistentor = new XmlObjectPersistentor();
            xmlObjectPersistentor.setMappingSrc(SourcePathHelper.getFieldMockMappingFilePath());
            String string = SourcePathHelper.getMockFieldInfoFilePath();
            this.m_oFieldEntities = (InfoEntities)xmlObjectPersistentor.getParsedInstance(string);
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Has building all the fields from file[" + string + "] successfully"));
            }
        }
        catch (CMyException cMyException) {
            throw new WCMException(I18NMessage.get(InfoEntityFinder.class, "InfoEntityFinder.label7", "\u67e5\u627e\u7528\u6237\u7f6e\u6807\u5b57\u6bb5\u5217\u8868\u65f6\u51fa\u9519!"), cMyException);
        }
    }

    public InfoEntities getTemplateEntities() throws WCMException {
        if (this.m_oTemplateEntities == null) {
            this.loadTemplateEntities();
        }
        return this.m_oTemplateEntities;
    }

    protected void loadTemplateEntities() throws WCMException {
        this.m_oTemplateEntities = new InfoEntities();
        try {
            User user = this.m_oLoginUser;
            WebSites webSites = new WebSites(user);
            webSites.open(null);
            if (webSites.size() == 0) {
                return;
            }
            for (int i = 0; i < webSites.size(); ++i) {
                WebSite webSite = (WebSite)webSites.getAt(i);
                if (webSite == null || webSite.isDeleted() || !this.hasRight(user, webSite)) continue;
                Templates templates = this.m_oTemplateSrv.getManagedTemplates(webSite, -1, null, true);
                for (int j = 0; j < templates.size(); ++j) {
                    Template template = (Template)templates.getAt(j);
                    TemplateInfoEntity templateInfoEntity = this.makeTemplateInfoEntity(template);
                    if (templateInfoEntity == null) continue;
                    this.m_oTemplateEntities.add(templateInfoEntity);
                }
            }
        }
        catch (WCMException wCMException) {
            throw new WCMException(I18NMessage.get(InfoEntityFinder.class, "InfoEntityFinder.label1", "\u67e5\u627e\u7528\u6237[") + this.m_oLoginUser.getName() + I18NMessage.get(InfoEntityFinder.class, "InfoEntityFinder.label8", "]\u53ef\u7f16\u8f91\u7684\u6a21\u677f\u5217\u8868\u65f6\u51fa\u9519!"), wCMException);
        }
    }

    private TemplateInfoEntity makeTemplateInfoEntity(Template template) {
        if (template == null) {
            return null;
        }
        TemplateInfoEntity templateInfoEntity = new TemplateInfoEntity();
        templateInfoEntity.setTemplateId(template.getId());
        templateInfoEntity.setTemplateName(this.getPreparedTemplateName(template));
        templateInfoEntity.setTemplateName(template.getName());
        templateInfoEntity.setTemplateType(template.getType());
        templateInfoEntity.setFolderId(template.getFolderId());
        templateInfoEntity.setFolderType(template.getFolderType());
        return templateInfoEntity;
    }

    private String getPreparedTemplateName(Template template) {
        String string = null;
        int n = template.getFolderType();
        boolean bl = n == 103;
        StringBuffer stringBuffer = new StringBuffer(template.getName());
        stringBuffer.append("(");
        stringBuffer.append(bl ? "S" : "C");
        stringBuffer.append(template.getFolderId());
        stringBuffer.append(")");
        string = stringBuffer.toString();
        stringBuffer.setLength(0);
        return string;
    }
}

