/*
 * Decompiled with CFR 0.152.
 */
package com.trs.template;

import com.trs.infra.I18NMessage;
import com.trs.template.IErrorMessages;
import com.trs.template.TemplateServiceConfig;

public class ErrorMessagesFactory {
    private static IErrorMessages m_IErrorMessages = null;

    public static IErrorMessages getIErrorMessages() throws Exception {
        if (m_IErrorMessages == null) {
            String string = TemplateServiceConfig.getConfigValue("IErrorMessages");
            m_IErrorMessages = ErrorMessagesFactory.createErrorMessages(string);
        }
        return m_IErrorMessages;
    }

    private static IErrorMessages createErrorMessages(String string) throws Exception {
        IErrorMessages iErrorMessages = null;
        try {
            Class<?> clazz = Class.forName(string);
            iErrorMessages = (IErrorMessages)clazz.newInstance();
            if (iErrorMessages == null) {
                throw new Exception(I18NMessage.get(ErrorMessagesFactory.class, "ErrorMessagesFactory.label1", "\u5f02\u5e38\u4fe1\u606f\u96c6\u5408'") + string + I18NMessage.get(ErrorMessagesFactory.class, "ErrorMessagesFactory.label2", "'\u521d\u59cb\u5316\u5931\u8d25"));
            }
            iErrorMessages.open();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            throw exception;
        }
        return iErrorMessages;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        m_IErrorMessages = null;
    }
}

