/*
 * Decompiled with CFR 0.152.
 */
package com.trs.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class SQLInjectionPreventionFilter
implements Filter {
    private static final Node ROOT_NODE = new Node('R');
    private String m_sWarnView;

    public void destroy() {
        this.clear(ROOT_NODE);
    }

    private void clear(Node node) {
        List list = node.nodes;
        if (list != null && !list.isEmpty()) {
            int n = list.size();
            for (int i = n - 1; i >= 0; --i) {
                this.clear((Node)list.get(i));
            }
            list.clear();
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.isVlunable(servletRequest, servletResponse)) {
            this.forward2WarnView(servletRequest, servletResponse);
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private void forward2WarnView(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        RequestDispatcher requestDispatcher = servletRequest.getRequestDispatcher(this.m_sWarnView);
        requestDispatcher.forward(servletRequest, servletResponse);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String string = filterConfig.getInitParameter("filterwords");
        if (string == null || string.trim().length() == 0) {
            return;
        }
        this.createTree(string);
        this.m_sWarnView = filterConfig.getInitParameter("warnview");
    }

    private boolean isVlunable(ServletRequest servletRequest, ServletResponse servletResponse) {
        Map map = servletRequest.getParameterMap();
        if (map == null || map.isEmpty()) {
            return false;
        }
        Iterator iterator = map.entrySet().iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            Map.Entry entry = iterator.next();
            Object v = entry.getValue();
            if (v instanceof String[]) {
                String[] stringArray = (String[])v;
                int n = stringArray.length;
                for (int i = 0; i < n && !bl; ++i) {
                    bl = this.isVlunable(stringArray[i]);
                }
                continue;
            }
            bl = this.isVlunable(v.toString());
        }
        return bl;
    }

    protected boolean isVlunable(String string) {
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        char[] cArray = string.toLowerCase().toCharArray();
        Node node = ROOT_NODE;
        StringBuffer stringBuffer = new StringBuffer(32);
        for (int i = 0; i < cArray.length; ++i) {
            if ((node = this.findNode(node, cArray[i])) == null) {
                node = ROOT_NODE;
                i -= stringBuffer.length();
                stringBuffer.setLength(0);
                continue;
            }
            if (node.flag == 1) {
                return true;
            }
            stringBuffer.append(cArray[i]);
        }
        return false;
    }

    private void createTree(String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        char[] cArray = string.toLowerCase().toCharArray();
        int n = 0;
        int n2 = 0;
        while ((n = string.indexOf(44, n2)) != -1) {
            this.insertNode(ROOT_NODE, this.copyOfRange(cArray, n2, n), 0);
            n2 = n + 1;
        }
        if (cArray.length > n2) {
            this.insertNode(ROOT_NODE, this.copyOfRange(cArray, n2, cArray.length), 0);
        }
    }

    private char[] copyOfRange(char[] cArray, int n, int n2) {
        int n3 = n2 - n;
        char[] cArray2 = new char[n3];
        System.arraycopy(cArray, n, cArray2, 0, Math.min(cArray.length - n, n3));
        return cArray2;
    }

    private void insertNode(Node node, char[] cArray, int n) {
        Node node2 = this.findNode(node, cArray[n]);
        if (node2 == null) {
            node2 = new Node(cArray[n]);
            node.nodes.add(node2);
        }
        if (n == cArray.length - 1) {
            node2.flag = 1;
        }
        if (++n < cArray.length) {
            this.insertNode(node2, cArray, n);
        }
    }

    private Node findNode(Node node, char c) {
        List list = node.nodes;
        Node node2 = null;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Node node3 = (Node)list.get(i);
            if (node3.c != c) continue;
            node2 = node3;
            break;
        }
        return node2;
    }

    public static void main(String[] stringArray) {
        SQLInjectionPreventionFilter sQLInjectionPreventionFilter = new SQLInjectionPreventionFilter();
        sQLInjectionPreventionFilter.createTree("delete");
        System.out.println(sQLInjectionPreventionFilter.isVlunable("my;delete:"));
    }

    private static class Node {
        public char c;
        public int flag;
        public List nodes = new ArrayList();

        public Node(char c) {
            this.c = c;
            this.flag = 0;
        }
    }
}

