/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.config.PublishDistributionTargetType;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.distribute.PublishDistributionMgr;
import com.trs.components.common.publish.persistent.distribute.PublishDistribution;
import com.trs.components.common.publish.persistent.distribute.PublishDistributions;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.WCMFolderPublishConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.log.LogServer;
import com.trs.service.IWCMPublishElementService;
import java.util.Iterator;
import java.util.Map;

public class WCMPublishElementServiceImpl
implements IWCMPublishElementService {
    public WCMFolderPublishConfig findFolderConfig(BaseChannel baseChannel) throws WCMException {
        return WCMFolderPublishConfig.findOf(baseChannel.getWCMType(), baseChannel.getId());
    }

    public WCMFolderPublishConfig save(BaseChannel baseChannel, WCMFolderPublishConfig wCMFolderPublishConfig) throws WCMException {
        String string = I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label1", "\u4fdd\u5b58") + baseChannel + I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label2", "\u53d1\u5e03\u914d\u7f6e\u4fe1\u606f");
        if (baseChannel == null) {
            throw new WCMException(string + I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label3", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6307\u5b9a\u9891\u9053\uff01"));
        }
        int n = 13;
        if (!AuthServer.hasRight(ContextHelper.getLoginUser(), (CMSObj)baseChannel, n)) {
            throw new WCMException(string + I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label4", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\uff01"));
        }
        long l = LogServer.startRecord(this.getLoginUserName(), "PUBLISH_SETTING", string, baseChannel);
        try {
            wCMFolderPublishConfig.save(this.getLoginUser());
            LogServer.endRecordSucceedOperation(l);
        }
        catch (WCMException wCMException) {
            LogServer.endRecordFailedOperation(l, wCMException);
            throw new WCMException(string + I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label5", "\u5931\u8d25!"), wCMException);
        }
        return wCMFolderPublishConfig;
    }

    public PublishDistributions findPublishDistributions(WebSite webSite, boolean bl, WCMFilter wCMFilter) throws WCMException {
        return this.getPublishDistributionMgr().getDistributionsOf(this.getFolder(webSite), bl, wCMFilter);
    }

    public PublishDistribution save(WebSite webSite, PublishDistribution publishDistribution) throws WCMException {
        String string = I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label1", "\u4fdd\u5b58") + webSite + I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label6", "\u7684\u53d1\u5e03\u5206\u53d1\u76ee\u5f55\u4fe1\u606f");
        if (webSite == null || publishDistribution == null) {
            throw new WCMException(string + I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label7", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6307\u5b9a\u7ad9\u70b9\u6216\u53d1\u5e03\u5206\u53d1\u4fe1\u606f\uff01"));
        }
        int n = 1;
        if (!AuthServer.hasRight(ContextHelper.getLoginUser(), (CMSObj)webSite, n)) {
            throw new WCMException(string + I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label4", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\uff01"));
        }
        long l = LogServer.startRecord(this.getLoginUserName(), "DISTRIBUTION_SAVE", string, webSite);
        try {
            publishDistribution.setFolder(webSite.getWCMType(), webSite.getId());
            PublishDistributionMgr publishDistributionMgr = (PublishDistributionMgr)DreamFactory.createObjectById("PublishDistributionMgr");
            publishDistributionMgr.save(publishDistribution);
            LogServer.endRecordSucceedOperation(l);
        }
        catch (WCMException wCMException) {
            LogServer.endRecordFailedOperation(l, wCMException);
            throw new WCMException(string + I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label5", "\u5931\u8d25!"), wCMException);
        }
        return publishDistribution;
    }

    public void setPubDistributionsEnable(WebSite webSite, String string, boolean bl) throws WCMException {
        String string2 = I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label8", "\u5c06[") + webSite + I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label9", "]\u53d1\u5e03\u5206\u53d1\u76ee\u5f55") + (bl ? I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label10", "\u542f\u7528") : I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label11", "\u505c\u6b62")) + "\uff01";
        if (webSite == null) {
            throw new WCMException(string2 + I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label12", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6307\u5b9a\u7ad9\u70b9\uff01"));
        }
        int n = 1;
        if (!AuthServer.hasRight(ContextHelper.getLoginUser(), (CMSObj)webSite, n)) {
            throw new WCMException(string2 + I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label4", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\uff01"));
        }
        PublishDistributions publishDistributions = PublishDistributions.findByIds(this.getLoginUser(), string);
        if (publishDistributions.isEmpty()) {
            return;
        }
        String string3 = bl ? "DISTRIBUTION_ENABLE" : "DISTRIBUTION_DISABLE";
        long l = LogServer.startRecord(this.getLoginUserName(), string3, string2, webSite);
        try {
            int n2 = publishDistributions.size();
            for (int i = 0; i < n2; ++i) {
                PublishDistribution publishDistribution = (PublishDistribution)publishDistributions.getAt(i);
                if (publishDistribution == null || bl ^ publishDistribution.isEnabled()) continue;
                publishDistribution.canEdit(this.getLoginUser());
                publishDistribution.setEnabled(bl);
                this.getPublishDistributionMgr().save(publishDistribution);
            }
            LogServer.endRecordSucceedOperation(l);
        }
        catch (WCMException wCMException) {
            LogServer.endRecordFailedOperation(l, wCMException);
            throw new WCMException(string2 + I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label5", "\u5931\u8d25!"), wCMException);
        }
    }

    public void deletePublishDistributions(WebSite webSite, String string) throws WCMException {
        String string2 = I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label8", "\u5c06[") + webSite + I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label13", "]\u53d1\u5e03\u5206\u53d1\u76ee\u5f55\u5220\u9664\uff01");
        if (webSite == null) {
            throw new WCMException(string2 + I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label12", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6307\u5b9a\u7ad9\u70b9\uff01"));
        }
        int n = 1;
        if (!AuthServer.hasRight(ContextHelper.getLoginUser(), (CMSObj)webSite, n)) {
            throw new WCMException(string2 + I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label4", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\uff01"));
        }
        PublishDistributions publishDistributions = PublishDistributions.findByIds(this.getLoginUser(), string);
        if (publishDistributions.isEmpty()) {
            return;
        }
        long l = LogServer.startRecord(this.getLoginUserName(), "DISTRIBUTION_DELETE", string2, webSite);
        try {
            int n2 = publishDistributions.size();
            for (int i = 0; i < n2; ++i) {
                PublishDistribution publishDistribution = (PublishDistribution)publishDistributions.getAt(i);
                if (publishDistribution == null) continue;
                this.getPublishDistributionMgr().delete(publishDistribution);
            }
            LogServer.endRecordSucceedOperation(l);
        }
        catch (WCMException wCMException) {
            LogServer.endRecordFailedOperation(l, wCMException);
            throw new WCMException(string2 + I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label5", "\u5931\u8d25!"), wCMException);
        }
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private String getLoginUserName() {
        return ContextHelper.getLoginUser().getName();
    }

    protected PublishDistributionMgr getPublishDistributionMgr() {
        return (PublishDistributionMgr)DreamFactory.createObjectById("PublishDistributionMgr");
    }

    private IPublishFolder getFolder(BaseChannel baseChannel) throws WCMException {
        return (IPublishFolder)PublishElementFactory.makeElementFrom(baseChannel);
    }

    public Iterator getDistributionTargetTypes() throws Exception {
        Map map = PublishServerConfigMapper.getDistributionTargetTypes();
        return map.values().iterator();
    }

    public PublishDistributionTargetType lookupDistributionTargetTypeByName(String string) throws Exception {
        return PublishServerConfigMapper.lookupDistributionTargetTypeByName(string);
    }
}

