/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.GroupMgr;
import com.trs.cms.auth.domain.UserMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.message.Message;
import com.trs.components.common.message.MessageServer;
import com.trs.components.wcm.content.domain.UserDocumentMgr;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.IdFilterSqlUtil;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.log.LogServer;
import com.trs.infra.util.CMyString;
import com.trs.service.IGroupService;
import com.trs.service.IUserService;
import org.apache.log4j.Logger;

public class UserService
implements IUserService {
    private static final Logger m_oLogger = Logger.getLogger((String)UserService.class.getName());

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public Documents getDocuments() throws WCMException {
        return this.getDocuments(null);
    }

    public Documents getDocuments(WCMFilter wCMFilter) throws WCMException {
        return this.getUserDocumentMgr().getDocuments(wCMFilter);
    }

    public Documents getDraft() throws WCMException {
        return this.getDraft(null);
    }

    public Documents getDraft(WCMFilter wCMFilter) throws WCMException {
        return this.getUserDocumentMgr().getDraft(wCMFilter);
    }

    public Documents getRecycleDocuments() throws WCMException {
        return this.getRecycleDocuments(null);
    }

    public Documents getRecycleDocuments(WCMFilter wCMFilter) throws WCMException {
        return this.getUserDocumentMgr().getRecycleDocuments(wCMFilter);
    }

    public Groups getGroups(User user) throws WCMException {
        return this.getUserMgr().getGroups(user);
    }

    public Groups getGroups() throws WCMException {
        return this.getUserMgr().getGroups(this.getLoginUser());
    }

    public Roles getRoles(User user) throws WCMException {
        return this.getUserMgr().getRoles(user);
    }

    public Roles getRoles() throws WCMException {
        return this.getUserMgr().getRoles(this.getLoginUser());
    }

    public User save(User user) throws WCMException {
        boolean bl;
        User user2 = user;
        User user3 = this.getLoginUser();
        boolean bl2 = user3.getName().equals(user.getName());
        boolean bl3 = user3.isAdministrator();
        if (!(bl3 || bl2 || (bl = this.getUserMgr().isManagerOfUser(user2)))) {
            throw new WCMException(1002, I18NMessage.get(UserService.class, "UserService.label1", "\u60a8\u65e0\u6743\u4fdd\u5b58\u7528\u6237\uff01\u53ea\u6709\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u7528\u6237\u81ea\u8eab\u6216\u7528\u6237\u521b\u5efa\u8005\u624d\u53ef\u4ee5\u66f4\u6539\u4fdd\u5b58\u7528\u6237\u4fe1\u606f."));
        }
        String string = I18NMessage.get(UserService.class, "UserService.label2", "\u4fdd\u5b58") + this.wrapObj(user2);
        String string2 = user2.isAddMode() ? "USER_ADD" : "USER_EDIT";
        long l = LogServer.startRecord(user3.getName(), string2, string, user2);
        try {
            user2 = this.getUserMgr().save(user2);
        }
        catch (WCMException wCMException) {
            LogServer.endRecordFailedOperation(l, wCMException);
            throw wCMException;
        }
        LogServer.endRecordSucceedOperation(l);
        return user2;
    }

    public User save(User user, Group group) throws WCMException {
        IGroupService iGroupService = (IGroupService)DreamFactory.createObjectById("IGroupService");
        if (group == null) {
            return this.save(user);
        }
        User user2 = user;
        User user3 = this.getLoginUser();
        if (!AuthServer.hasRight(user3, group)) {
            throw new WCMException(1002, I18NMessage.get(UserService.class, "UserService.label3", "\u60a8\u65e0\u6743\u4fdd\u5b58\u7528\u6237\uff01"));
        }
        String string = CMyString.format(I18NMessage.get(UserService.class, "UserService.label42", "\u5728{0}\u4e2d\u65b0\u5efa{1}"), new Object[]{group, user});
        long l = LogServer.startRecord(user3.getName(), "GROUPUSER_ADD", string, user);
        try {
            user2 = this.getUserMgr().save(user2);
            iGroupService.addUser(user2, group);
        }
        catch (Exception exception) {
            LogServer.endRecordFailedOperation(l, exception);
            throw new WCMException(1104, I18NMessage.get(UserService.class, "UserService.label6", "\u6dfb\u52a0\u5230\u7ec4\u5931\u8d25\u4e2d\u6b62\uff01"), exception);
        }
        LogServer.endRecordSucceedOperation(l);
        return user2;
    }

    private UserMgr getUserMgr() throws WCMException {
        UserMgr userMgr = (UserMgr)DreamFactory.createObjectById("UserMgr");
        if (userMgr == null) {
            throw new WCMException(I18NMessage.get(UserService.class, "UserService.label7", "UserMgr\u5728\u5de5\u5382\u4e2d\u914d\u7f6e\u9519\u8bef\uff01"));
        }
        return userMgr;
    }

    private GroupMgr getGroupMgr() throws WCMException {
        GroupMgr groupMgr = (GroupMgr)DreamFactory.createObjectById("GroupMgr");
        if (groupMgr == null) {
            throw new WCMException(I18NMessage.get(UserService.class, "UserService.label7", "UserMgr\u5728\u5de5\u5382\u4e2d\u914d\u7f6e\u9519\u8bef\uff01"));
        }
        return groupMgr;
    }

    private UserDocumentMgr getUserDocumentMgr() throws WCMException {
        UserDocumentMgr userDocumentMgr = (UserDocumentMgr)DreamFactory.createObjectById("UserDocumentMgr");
        if (userDocumentMgr == null) {
            throw new WCMException(I18NMessage.get(UserService.class, "UserService.label8", "UserDocumentMgr\u5728\u5de5\u5382\u4e2d\u914d\u7f6e\u9519\u8bef\uff01"));
        }
        return userDocumentMgr;
    }

    public boolean enable(User user) throws WCMException {
        boolean bl;
        User user2 = user.getCrUser();
        boolean bl2 = bl = user2 != null ? this.getLoginUser().getName().equals(user2.getName()) : false;
        if (!this.getLoginUser().isAdministrator() && !bl) {
            throw new WCMException(1002, I18NMessage.get(UserService.class, "UserService.label9", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u5f00\u901a\u7528\u6237!"));
        }
        boolean bl3 = false;
        String string = CMyString.format(I18NMessage.get(UserService.class, "UserService.label43", "\u5f00\u901a{0}\u7684\u5e10\u53f7."), new Object[]{user});
        long l = LogServer.startRecord(this.getLoginUser().getName(), "USER_ENABLE", string, user);
        try {
            bl3 = this.changeUserRegStatus(user, 30);
        }
        catch (WCMException wCMException) {
            LogServer.endRecordFailedOperation(l, wCMException);
            throw wCMException;
        }
        LogServer.endRecordSucceedOperation(l);
        if (bl3) {
            final User user3 = user;
            final User user4 = this.getLoginUser();
            Thread thread = new Thread(){

                public void run() {
                    ContextHelper.initContext(user4);
                    String string = user3.getEmail();
                    if (string != null && string.length() > 0) {
                        UserService.this.sendEmailNotice(user3);
                    }
                }
            };
            thread.start();
        }
        return bl3;
    }

    void sendEmailNotice(User user) {
        try {
            Message message = this.createNotice(user);
            MessageServer.send(message);
        }
        catch (WCMException wCMException) {
            m_oLogger.error((Object)"failed to send email to notice the user!", (Throwable)wCMException);
        }
    }

    private Message createNotice(User user) throws WCMException {
        Message message = new Message();
        message.setTitle(I18NMessage.get(UserService.class, "UserService.label12", "\u5e10\u53f7\u5f00\u901a"));
        StringBuffer stringBuffer = new StringBuffer(I18NMessage.get(UserService.class, "UserService.label44", " "));
        stringBuffer.append(" " + user.getName());
        stringBuffer.append(I18NMessage.get(UserService.class, "UserService.label13", ",\u60a8\u597d!\n\n\t\t\u60a8\u7533\u8bf7\u7684\u7528\u6237\u5e10\u53f7\u5df2\u7ecf\u5f00\u901a,"));
        String string = "";
        try {
            string = ConfigServer.getServer().getSysConfigValue("WCM_URL", "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!"".equals(string)) {
            stringBuffer.append(I18NMessage.get(UserService.class, "UserService.label14", "\n\u53ef\u4ee5\u901a\u8fc7")).append("<a href=" + string + ">" + string + "</a>").append(I18NMessage.get(UserService.class, "UserService.label15", "\u8bbf\u95ee\u7cfb\u7edf.\n"));
        } else {
            stringBuffer.append(I18NMessage.get(UserService.class, "UserService.label45", "\u53ef\u4ee5\u767b\u5f55/\u4f7f\u7528\u7cfb\u7edf\u4e86.\n"));
        }
        stringBuffer.append(I18NMessage.get(UserService.class, "UserService.label16", "\n\u795d\u60a8\u5de5\u4f5c\u6109\u5feb."));
        message.setBody(stringBuffer.toString());
        message.setSendTypes("Email");
        message.setReceivers(user.getWCMType(), String.valueOf(user.getId()));
        return message;
    }

    public boolean disable(User user) throws WCMException {
        boolean bl;
        User user2 = user.getCrUser();
        boolean bl2 = bl = user2 != null ? this.getLoginUser().getName().equals(user2.getName()) : false;
        if (!this.getLoginUser().isAdministrator() && !bl) {
            throw new WCMException(1002, I18NMessage.get(UserService.class, "UserService.label17", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u505c\u7528\u7528\u6237!"));
        }
        String string = I18NMessage.get(UserService.class, "UserService.label18", "\u505c\u7528:") + this.wrapObj(user);
        long l = LogServer.startRecord(this.getLoginUser().getName(), "USER_DISABLE", string, user);
        try {
            this.changeUserRegStatus(user, 20);
        }
        catch (Throwable throwable) {
            LogServer.endRecordFailedOperation(l, throwable);
            throw new WCMException(1100, I18NMessage.get(UserService.class, "UserService.label19", "\u505c\u7528\u7528\u6237\u5931\u8d25!"), throwable);
        }
        LogServer.endRecordSucceedOperation(l);
        return true;
    }

    public boolean restore(User user) throws WCMException {
        boolean bl;
        User user2 = user.getCrUser();
        boolean bl2 = bl = user2 != null ? this.getLoginUser().getName().equals(user2.getName()) : false;
        if (!this.getLoginUser().isAdministrator() && !bl) {
            throw new WCMException(1002, I18NMessage.get(UserService.class, "UserService.label20", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u6062\u590d\u5df2\u505c\u7528\u7684\u7528\u6237!"));
        }
        String string = I18NMessage.get(UserService.class, "UserService.label21", "\u6062\u590d\u5df2\u5220\u9664\u7684") + this.wrapObj(user);
        long l = LogServer.startRecord(this.getLoginUser().getName(), "USER_RESTORE", string, user);
        try {
            user.canEdit(this.getLoginUser());
            user.setDeleted(false);
            this.save(user);
        }
        catch (Throwable throwable) {
            LogServer.endRecordFailedOperation(l, throwable);
            throw new WCMException(1100, I18NMessage.get(UserService.class, "UserService.label22", "\u6062\u590d\u5220\u9664\u7684\u7528\u6237\u5931\u8d25!"), throwable);
        }
        LogServer.endRecordSucceedOperation(l);
        return true;
    }

    public boolean restore(Users users) throws WCMException {
        if (users == null || users.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(UserService.class, "UserService.label23", "\u65e0\u6548\u7684\u7528\u6237\u96c6\u5408!"));
        }
        User user = null;
        for (int i = 0; i < users.size(); ++i) {
            user = (User)users.getAt(i);
            if (user == null) continue;
            this.restore(user);
        }
        return true;
    }

    public boolean resetPassword(User user, String string, String string2) throws WCMException {
        if (!this.getLoginUser().equals(user)) {
            throw new WCMException(1002, I18NMessage.get(UserService.class, "UserService.label24", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u4fee\u6539\u7528\u6237\u7684\u5bc6\u7801!"));
        }
        String string3 = I18NMessage.get(UserService.class, "UserService.label25", "\u4fee\u6539\u5bc6\u7801");
        long l = LogServer.startRecord(this.getLoginUser().getName(), "USER_EDIT", string3, user);
        try {
            this.getUserMgr().resetPassword(user, string, string2);
        }
        catch (Throwable throwable) {
            LogServer.endRecordFailedOperation(l, throwable);
            throw new WCMException(1100, I18NMessage.get(UserService.class, "UserService.label26", "\u4fee\u6539\u5bc6\u7801\u5931\u8d25"), throwable);
        }
        LogServer.endRecordSucceedOperation(l);
        return true;
    }

    public boolean resetPassword(User user) throws WCMException {
        if (!this.getLoginUser().isAdministrator()) {
            throw new WCMException(1002, I18NMessage.get(UserService.class, "UserService.label24", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u4fee\u6539\u7528\u6237\u7684\u5bc6\u7801!"));
        }
        String string = I18NMessage.get(UserService.class, "UserService.label27", "\u91cd\u8bbe") + this.wrapObj(user) + I18NMessage.get(UserService.class, "UserService.label28", "\u7684\u5bc6\u7801");
        long l = LogServer.startRecord(this.getLoginUser().getName(), "USER_EDIT", string, user);
        try {
            this.getUserMgr().resetPassword(user);
        }
        catch (Throwable throwable) {
            LogServer.endRecordFailedOperation(l, throwable);
            throw new WCMException(1100, I18NMessage.get(UserService.class, "UserService.label29", "\u91cd\u8bbe\u5bc6\u7801\u5931\u8d25"), throwable);
        }
        LogServer.endRecordSucceedOperation(l);
        return true;
    }

    public boolean resetPassword(User user, String string) throws WCMException {
        if (!(this.getLoginUser().isAdministrator() || this.isAdminOfGroup(this.getLoginUser()) && user.getCrUser().equals(this.getLoginUser()))) {
            throw new WCMException(1002, I18NMessage.get(UserService.class, "UserService.label24", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u4fee\u6539\u7528\u6237\u7684\u5bc6\u7801!"));
        }
        String string2 = I18NMessage.get(UserService.class, "UserService.label27", "\u91cd\u8bbe") + this.wrapObj(user) + I18NMessage.get(UserService.class, "UserService.label28", "\u7684\u5bc6\u7801");
        long l = LogServer.startRecord(this.getLoginUser().getName(), "USER_EDIT", string2, user);
        try {
            this.getUserMgr().resetPassword(user, string);
        }
        catch (Throwable throwable) {
            LogServer.endRecordFailedOperation(l, throwable);
            throw new WCMException(1100, I18NMessage.get(UserService.class, "UserService.label29", "\u91cd\u8bbe\u5bc6\u7801\u5931\u8d25"), throwable);
        }
        LogServer.endRecordSucceedOperation(l);
        return true;
    }

    private String wrapObj(User user) {
        return "[" + user + "] ";
    }

    public boolean delete(String string, boolean bl) throws WCMException {
        if (string == null || string.length() == 0) {
            return true;
        }
        Users users = Users.findByIds(this.getLoginUser(), string);
        if (users.isEmpty()) {
            return true;
        }
        return this.delete(users, bl);
    }

    public boolean delete(Users users, boolean bl) throws WCMException {
        if (users == null) {
            throw new WCMException(20, I18NMessage.get(UserService.class, "UserService.label30", "\u7528\u6237\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        Users users2 = users;
        for (int i = 0; i < users2.size(); ++i) {
            User user = (User)users2.getAt(i);
            if (user != null) {
                this.delete(user, bl);
                continue;
            }
            m_oLogger.error((Object)I18NMessage.get(UserService.class, "UserService.label31", "\u4ece\u7528\u6237\u96c6\u5408\u4e2d\u53d6\u7528\u6237\u65f6\uff0c\u7528\u6237\u4e3a\u7a7a\uff01"));
        }
        return true;
    }

    public boolean delete(int n, boolean bl) throws WCMException {
        if (n <= 0) {
            throw new WCMException(10, I18NMessage.get(UserService.class, "UserService.label32", "\u65e0\u6548\u7684\u7528\u6237Id[") + n + "]");
        }
        User user = User.findById(n);
        if (user == null) {
            throw new WCMException(200006, I18NMessage.get(UserService.class, "UserService.label33", "\u6ca1\u6709\u627e\u5230Id\u4e3a[") + n + I18NMessage.get(UserService.class, "UserService.label34", "]\u7684\u7528\u6237!"));
        }
        return this.delete(user, bl);
    }

    public boolean delete(User user, boolean bl) throws WCMException {
        boolean bl2;
        if (user == null) {
            throw new WCMException(20, I18NMessage.get(UserService.class, "UserService.label30", "\u7528\u6237\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        User user2 = user;
        boolean bl3 = AuthServer.hasRight(this.getLoginUser(), (CMSObj)user2, 12);
        User user3 = user.getCrUser();
        boolean bl4 = bl2 = user3 != null ? this.getLoginUser().getName().equals(user3.getName()) : false;
        if (!bl3 && !bl2) {
            throw new WCMException(1002, I18NMessage.get(UserService.class, "UserService.label35", "\u60a8\u65e0\u6743\u5220\u9664\u7528\u6237\uff01"));
        }
        String string = I18NMessage.get(UserService.class, "UserService.label36", "\u5220\u9664") + this.wrapObj(user2);
        if (bl) {
            string = "\u5f7b\u5e95" + string;
        }
        long l = LogServer.startRecord(this.getLoginUser().getName(), "USER_DEL", string, user);
        boolean bl5 = false;
        try {
            bl5 = this.getUserMgr().delete(user2, bl);
        }
        catch (Throwable throwable) {
            LogServer.endRecordFailedOperation(l, throwable);
            throw new WCMException(1100, I18NMessage.get(UserService.class, "UserService.label37", "\u5220\u9664\u7528\u6237\u5931\u8d25\uff01"), throwable);
        }
        LogServer.endRecordSucceedOperation(l);
        return bl5;
    }

    public boolean disable(int n) throws WCMException {
        User user = User.findById(n);
        return this.disable(user);
    }

    public boolean enable(int n) throws WCMException {
        User user = User.findById(n);
        if (user == null) {
            throw new WCMException(200006, I18NMessage.get(UserService.class, "UserService.label38", "\u6ca1\u6709\u627e\u5230\u7528\u6237[") + n + "]!");
        }
        return this.enable(user);
    }

    private boolean changeUserRegStatus(User user, int n) throws WCMException {
        if (this.getLoginUser() == null) {
            throw new WCMException(20, I18NMessage.get(UserService.class, "UserService.label39", "\u7528\u6237\u6ca1\u6709\u767b\u9646!"));
        }
        return this.getUserMgr().changeUserRegStatus(user, n);
    }

    public Users getUsers(int n, WCMFilter wCMFilter) throws WCMException {
        if (this.getLoginUser() == null || !this.getLoginUser().isAdministrator()) {
            throw new WCMException(1002, I18NMessage.get(UserService.class, "UserService.label40", "\u53ea\u6709\u7cfb\u7edf\u7ba1\u7406\u5458\u53ef\u4ee5\u7ba1\u7406\u6240\u6709\u7528\u6237!"));
        }
        WCMFilter wCMFilter2 = new WCMFilter("", "", "");
        StringBuffer stringBuffer = new StringBuffer(64);
        if (-1 == n) {
            stringBuffer.append("STATUS<=").append(30);
        } else if (10 == n) {
            stringBuffer.append("ISDELETED=?");
            wCMFilter2.addSearchValues(1);
        } else {
            stringBuffer.append("STATUS=? and ISDELETED=?");
            wCMFilter2.addSearchValues(n);
            wCMFilter2.addSearchValues(0);
        }
        wCMFilter2.setWhere(stringBuffer.toString());
        wCMFilter2.mergeWith(wCMFilter);
        return Users.openWCMObjs(this.getLoginUser(), wCMFilter2);
    }

    public Users getMyUsers(int n, WCMFilter wCMFilter) throws WCMException {
        User user = this.getLoginUser();
        if (user == null || !user.isAdministrator() && !this.isAdminOfGroup(user)) {
            throw new WCMException(1002, I18NMessage.get(UserService.class, "UserService.label41", "\u53ea\u6709\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u8005\u7ec4\u7ba1\u7406\u5458\u53ef\u4ee5\u7ba1\u7406\u81ea\u8eab\u521b\u5efa\u7684\u7528\u6237!"));
        }
        WCMFilter wCMFilter2 = new WCMFilter("", "", "");
        StringBuffer stringBuffer = new StringBuffer(64);
        if (-1 == n) {
            stringBuffer.append("STATUS<=").append(30);
        } else if (10 == n) {
            stringBuffer.append("ISDELETED=?");
            wCMFilter2.addSearchValues(1);
        } else {
            stringBuffer.append("STATUS=? and ISDELETED=?");
            wCMFilter2.addSearchValues(n);
            wCMFilter2.addSearchValues(0);
        }
        stringBuffer.append(" and CRUSER=?");
        wCMFilter2.addSearchValues(user.getName());
        wCMFilter2.setWhere(stringBuffer.toString());
        wCMFilter2.mergeWith(wCMFilter);
        return Users.openWCMObjs(user, wCMFilter2);
    }

    public Users getCanMgrUsers(int n, WCMFilter wCMFilter) throws WCMException {
        User user = this.getLoginUser();
        if (user == null || !user.isAdministrator() && !this.isAdminOfGroup(user)) {
            throw new WCMException(1002, I18NMessage.get(UserService.class, "UserService.label41", "\u53ea\u6709\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u8005\u7ec4\u7ba1\u7406\u5458\u53ef\u4ee5\u7ba1\u7406\u7528\u6237!"));
        }
        WCMFilter wCMFilter2 = new WCMFilter("", "", "");
        StringBuffer stringBuffer = new StringBuffer(64);
        if (-1 == n) {
            stringBuffer.append("STATUS<=").append(30);
        } else if (10 == n) {
            stringBuffer.append("ISDELETED=?");
            wCMFilter2.addSearchValues(1);
        } else {
            stringBuffer.append("STATUS=? and ISDELETED=?");
            wCMFilter2.addSearchValues(n);
            wCMFilter2.addSearchValues(0);
        }
        wCMFilter2.setWhere(stringBuffer.toString());
        wCMFilter2.mergeWith(wCMFilter);
        if (user.isAdministrator()) {
            return Users.openWCMObjs(user, wCMFilter2);
        }
        Groups groups = this.getGroupMgr().getOffspringGroups(user, null);
        String string = groups.getIdListAsString();
        String string2 = "";
        if (!CMyString.isEmpty(string)) {
            string2 = " and " + IdFilterSqlUtil.makeAsString("WCMGrpUser.GroupId", string);
        }
        String string3 = "exists(select 1 from WCMGrpUser where WCMGrpUser.UserId = WCMUser.UserId " + string2 + ")";
        WCMFilter wCMFilter3 = new WCMFilter(null, string3, null);
        wCMFilter3.mergeWith(wCMFilter2);
        return Users.openWCMObjs(user, wCMFilter3);
    }

    public boolean isAdminOfGroup(User user) throws WCMException {
        return this.getUserMgr().isAdminOfGroup(user);
    }

    public boolean isManagerOfRole(User user) throws WCMException {
        return this.getUserMgr().isManagerOfRole(user);
    }
}

