/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.tagparser.TemplateParameterList;
import com.trs.components.common.publish.domain.template.TemplateArgumentMgr;
import com.trs.components.common.publish.domain.template.TemplateCacheMgr;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.domain.template.TemplateExporter;
import com.trs.components.common.publish.domain.template.TemplateImporter;
import com.trs.components.common.publish.domain.template.TemplateMgr;
import com.trs.components.common.publish.domain.template.TemplateNestMgr;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateArgument;
import com.trs.components.common.publish.persistent.template.TemplateArguments;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMDatainvalidException;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.log.LogServer;
import com.trs.infra.util.Reports;
import com.trs.service.ITemplateService;
import java.util.Iterator;
import java.util.List;

public class TemplateService
implements ITemplateService {
    private TemplateMgr m_oTemplateMgr = null;
    private TemplateEmployMgr m_oEmployMgr = null;
    private TemplateArgumentMgr m_oArgumentMgr = (TemplateArgumentMgr)DreamFactory.createObjectById("TemplateArgumentMgr");

    public TemplateService() {
        this.m_oTemplateMgr = (TemplateMgr)DreamFactory.createObjectById("TemplateMgr");
        this.m_oEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public Template save(Template template, boolean bl, int n) throws WCMException {
        if (template == null) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label1", "\u5f53\u524d\u6a21\u677f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\uff01"));
        }
        long l = 0L;
        Template template2 = template;
        try {
            int n2;
            Template template3 = this.transformVO2PO(template);
            int n3 = n2 = template3.isAddMode() ? 21 : 23;
            if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)template3, n2)) {
                throw new WCMException(1002, I18NMessage.get(TemplateService.class, "TemplateService.label2", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u4fdd\u5b58\u5f53\u524d\u6a21\u677f!"));
            }
            TemplateMgr templateMgr = this.getTemplateMgr();
            String string = template3.isAddMode() ? "TEMPLATE_ADD" : "TEMPLATE_EDIT";
            String string2 = I18NMessage.get(TemplateService.class, "TemplateService.label3", "\u4fdd\u5b58[") + template3 + "]";
            l = LogServer.startRecord(this.getLoginUser().getName(), string, string2, template3);
            template2 = templateMgr.save(template3, "", bl, n);
            LogServer.endRecordSucceedOperation(l);
        }
        catch (WCMException wCMException) {
            LogServer.endRecordFailedOperation(l, wCMException);
            throw new WCMException(1100, I18NMessage.get(TemplateService.class, "TemplateService.label4", "\u4fdd\u5b58\u5f53\u524d\u6a21\u677f\u53d1\u751f\u5f02\u5e38!"), wCMException);
        }
        catch (Exception exception) {
            LogServer.endRecordFailedOperation(l, exception);
            throw new WCMException(0, I18NMessage.get(TemplateService.class, "TemplateService.label4", "\u4fdd\u5b58\u5f53\u524d\u6a21\u677f\u53d1\u751f\u5f02\u5e38!"), exception);
        }
        return template2;
    }

    public Template save(Template template) throws WCMException {
        return this.save(template, true, 2);
    }

    public boolean delete(String string) throws WCMException {
        if (string == null || string.length() == 0) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label5", "\u65e0\u6548\u7684TemplateId\u5e8f\u5217,\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c!"));
        }
        Templates templates = Templates.findByIds(this.getLoginUser(), string);
        return this.delete(templates);
    }

    public boolean delete(Templates templates) throws WCMException {
        if (templates == null) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label6", "\u65e0\u6548\u7684\u5f53\u524d\u6a21\u677f\u96c6\u5408,\u65e0\u6cd5\u5220\u9664!"));
        }
        for (int i = 0; i < templates.size(); ++i) {
            Template template = (Template)templates.getAt(i);
            if (this.delete(template)) continue;
            throw new WCMException(1100, I18NMessage.get(TemplateService.class, "TemplateService.label7", "\u5220\u9664Template[") + template.getName() + I18NMessage.get(TemplateService.class, "TemplateService.label8", "]\u5931\u8d25,\u4e2d\u6b62\u64cd\u4f5c"));
        }
        return true;
    }

    public boolean delete(int n) throws WCMException {
        if (n <= 0) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label9", "\u65e0\u6548\u7684TemplateId[") + n + I18NMessage.get(TemplateService.class, "TemplateService.label10", "],Id\u5e94\u8be5\u5927\u4e8e0"));
        }
        Template template = Template.findById(n);
        if (template == null) {
            return true;
        }
        return this.delete(template);
    }

    public boolean delete(Template template) throws WCMException {
        if (template == null) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label11", "\u65e0\u6548\u7684\u5f53\u524d\u6a21\u677f,\u65e0\u6cd5\u5220\u9664!"));
        }
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)template, 22)) {
            throw new WCMException(1002, I18NMessage.get(TemplateService.class, "TemplateService.label12", "\u5bf9\u4e0d\u8d77,\u60a8\u6ca1\u6709\u5220\u9664\u6a21\u677f\u7684\u6743\u9650!"));
        }
        String string = I18NMessage.get(TemplateService.class, "TemplateService.label13", "\u5220\u9664[") + template + "]";
        long l = 0L;
        boolean bl = false;
        try {
            TemplateMgr templateMgr = this.getTemplateMgr();
            l = LogServer.startRecord(this.getLoginUser().getName(), "TEMPLATE_DEL", string, template);
            bl = templateMgr.delete(template);
            LogServer.endRecordSucceedOperation(l);
        }
        catch (WCMException wCMException) {
            LogServer.endRecordFailedOperation(l, wCMException);
            throw new WCMException(1100, I18NMessage.get(TemplateService.class, "TemplateService.label14", "\u5220\u9664\u5f53\u524d\u6a21\u677f\u51fa\u9519!"), wCMException);
        }
        catch (Exception exception) {
            LogServer.endRecordFailedOperation(l, exception);
            throw new WCMException(0, I18NMessage.get(TemplateService.class, "TemplateService.label14", "\u5220\u9664\u5f53\u524d\u6a21\u677f\u51fa\u9519!"), exception);
        }
        return bl;
    }

    private Template transformVO2PO(Template template) {
        return template;
    }

    public String export(String string) throws WCMException {
        if (string == null || string.length() == 0) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label15", "\u65e0\u6548\u7684\u6a21\u677fId\u5e8f\u5217!"));
        }
        Templates templates = Templates.findByIds(this.getLoginUser(), string);
        if (templates.isEmpty()) {
            throw new WCMException(200006, I18NMessage.get(TemplateService.class, "TemplateService.label16", "\u6ca1\u6709\u627e\u5230\u6a21\u677f!"));
        }
        return this.export(templates);
    }

    public String export(Templates templates) throws WCMException {
        if (templates == null || templates.isEmpty()) {
            throw new WCMException(10, "Templates collection could not be empty!");
        }
        Template template = (Template)templates.getAt(0);
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)template, 24)) {
            throw new WCMException(1002, I18NMessage.get(TemplateService.class, "TemplateService.label17", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u5bfc\u51fa\u6307\u5b9a\u7684\u6a21\u677f!"));
        }
        TemplateExporter templateExporter = new TemplateExporter();
        return templateExporter.export(templates);
    }

    public String export(int n) throws WCMException {
        if (n <= 0) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label18", "\u65e0\u6548\u7684\u6a21\u677fId[") + n + I18NMessage.get(TemplateService.class, "TemplateService.label19", "],\u4e0d\u80fd\u5b8c\u6210\u5bfc\u51fa!"));
        }
        return this.export(new Integer(n).toString());
    }

    public String export(Template template) throws WCMException {
        if (template == null) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label20", "\u65e0\u6548\u7684\u6a21\u677f,\u65e0\u6cd5\u5bfc\u51fa!"));
        }
        Templates templates = Templates.createNewInstance(this.getLoginUser());
        templates.addElement(template);
        return this.export(templates);
    }

    public String preview(int n) throws WCMException {
        if (n <= 0) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label21", "\u65e0\u6548\u7684\u9891\u9053id[") + n + "]!");
        }
        Template template = Template.findById(n);
        if (template == null) {
            throw new WCMException(200006, I18NMessage.get(TemplateService.class, "TemplateService.label22", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u6a21\u677f!"));
        }
        return this.preview(template);
    }

    public String preview(Template template) throws WCMException {
        if (template == null) {
            throw new WCMException(10, "Valid template required!");
        }
        this.validateRight(template, 24, I18NMessage.get(TemplateService.class, "TemplateService.label23", "\u9884\u89c8\u6a21\u677f"));
        return this.m_oTemplateMgr.preview(template);
    }

    public Reports importFromZip(CMSObj cMSObj, String string, int n, int n2, String[] stringArray) throws WCMException {
        if (!AuthServer.hasRight(this.getLoginUser(), cMSObj, 21)) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label24", "\u60a8\u6682\u65f6\u65e0\u6743\u5bfc\u5165\u6a21\u677f\uff01"));
        }
        long l = 0L;
        try {
            TemplateImporter templateImporter = new TemplateImporter();
            IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(cMSObj);
            String string2 = this.getLoginUser() + I18NMessage.get(TemplateService.class, "TemplateService.label25", "\u6279\u91cf\u5bfc\u5165\u6a21\u677f\u5230[") + cMSObj + "]";
            l = LogServer.startRecord(this.getLoginUser().getName(), "TEMPLATE_IMPORT", string2, cMSObj);
            Reports reports = templateImporter.importFromZip(iPublishFolder, string, n, n2, stringArray);
            LogServer.endRecordSucceedOperation(l);
            return reports;
        }
        catch (Exception exception) {
            LogServer.endRecordFailedOperation(l, exception);
            throw new WCMException(1100, "Failed to import templates from zip file " + string, exception);
        }
    }

    public Reports importFromHTML(CMSObj cMSObj, String string, int n, String string2) throws WCMException {
        if (!AuthServer.hasRight(this.getLoginUser(), cMSObj, 21)) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label24", "\u60a8\u6682\u65f6\u65e0\u6743\u5bfc\u5165\u6a21\u677f\uff01"));
        }
        long l = 0L;
        try {
            TemplateImporter templateImporter = new TemplateImporter();
            IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(cMSObj);
            String string3 = this.getLoginUser() + I18NMessage.get(TemplateService.class, "TemplateService.label26", "\u5bfc\u5165\u5355\u4e2aHTML\u6a21\u677f\u5230[") + cMSObj + "]";
            l = LogServer.startRecord(this.getLoginUser().getName(), "TEMPLATE_IMPORT", string3, cMSObj);
            Reports reports = templateImporter.importFromHTML(iPublishFolder, string, n, string2);
            LogServer.endRecordSucceedOperation(l);
            return reports;
        }
        catch (Exception exception) {
            LogServer.endRecordFailedOperation(l, exception);
            throw new WCMException(1100, "Failed to import template from HTML file " + string, exception);
        }
    }

    public String[] extractTemplateNamesFromZip(String string) throws WCMException {
        if (string == null) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label27", "\u6587\u4ef6\u540d\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5f97\u5230\u6a21\u677f\u540d\u79f0\uff01"));
        }
        TemplateImporter templateImporter = new TemplateImporter();
        return templateImporter.extractTemplateNamesFromZip(string);
    }

    public Reports redistributeAppendixes(CMSObj cMSObj, boolean bl) throws WCMException {
        if (cMSObj == null) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label28", "\u6307\u5b9a\u7684\u7ad9\u70b9/\u9891\u9053\u65e0\u6548\uff01"));
        }
        try {
            IPublishFolder iPublishFolder = null;
            iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(cMSObj);
            return this.m_oTemplateMgr.redistributeAppendixes(iPublishFolder, bl);
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to fetch the managed templates in the channel/site!", exception);
        }
    }

    public Template getDetailTemplate(IPublishElement iPublishElement) throws WCMException {
        if (iPublishElement == null) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label29", "\u9891\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5f97\u5230\u5176\u7ec6\u89c8\u6a21\u677f\uff01"));
        }
        try {
            return this.m_oEmployMgr.getDetailTemplate(iPublishElement);
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to get the detail template of the specified channel.", exception);
        }
    }

    public Templates getOutlineTemplates(IPublishFolder iPublishFolder) throws WCMException {
        if (iPublishFolder == null) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label30", "\u9891\u9053/\u7ad9\u70b9\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5f97\u5230\u5176\u6982\u89c8\u6a21\u677f\uff01"));
        }
        try {
            return this.m_oEmployMgr.getOutlineTemplates(iPublishFolder);
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to get the outline template of the specified folder.", exception);
        }
    }

    private TemplateMgr getTemplateMgr() {
        TemplateMgr templateMgr = (TemplateMgr)DreamFactory.createObjectById("TemplateMgr");
        return templateMgr;
    }

    public void setDetailTemplate(IPublishFolder iPublishFolder, int n, boolean bl) throws WCMException {
        if (iPublishFolder == null) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label31", "\u9891\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8bbe\u5b9a\u6982\u89c8\u6a21\u677f\uff01"));
        }
        try {
            this.m_oEmployMgr.setDetailTemplate(iPublishFolder, n, bl);
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to set the detail template of the channel", exception);
        }
    }

    public void setOutlineTemplates(IPublishFolder iPublishFolder, String string, boolean bl) throws WCMException {
        if (iPublishFolder == null) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label30", "\u9891\u9053/\u7ad9\u70b9\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5f97\u5230\u5176\u6982\u89c8\u6a21\u677f\uff01"));
        }
        try {
            this.m_oEmployMgr.setOutlineTemplates(iPublishFolder, string, bl);
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to set the outline template of the channel/site", exception);
        }
    }

    public void setDetailTemplate(IPublishContent iPublishContent, int n, int n2) throws WCMException {
        if (iPublishContent == null) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label32", "\u4f20\u5165\u65e0\u6548\u7684\u53c2\u6570\uff0c\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4e3a\u5176\u8bbe\u5b9a\u6a21\u677f\uff01"));
        }
        try {
            this.m_oEmployMgr.setDetailTemplate(iPublishContent, n, false, n2);
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to set the detail template of the document.", exception);
        }
    }

    public void setDetailTemplate(IPublishContent iPublishContent, int n) throws WCMException {
        this.setDetailTemplate(iPublishContent, n, 2);
    }

    public Templates getManagedTemplates(CMSObj cMSObj, int n, WCMFilter wCMFilter, boolean bl) throws WCMException {
        if (cMSObj == null) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label28", "\u6307\u5b9a\u7684\u7ad9\u70b9/\u9891\u9053\u65e0\u6548\uff01"));
        }
        try {
            IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(cMSObj);
            return this.m_oTemplateMgr.getManagedTemplates(iPublishFolder, n, wCMFilter, bl);
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to fetch the managed templates in the channel/site!", exception);
        }
    }

    public Templates getOptionalTemplates(IPublishFolder iPublishFolder, int n, WCMFilter wCMFilter, boolean bl) throws WCMException {
        if (iPublishFolder == null) {
            throw new WCMDatainvalidException(I18NMessage.get(TemplateService.class, "TemplateService.label33", "\u6ca1\u6709\u6307\u5b9aFolder!"));
        }
        try {
            return this.m_oTemplateMgr.getOptionalTemplates(iPublishFolder, n, wCMFilter, bl);
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(TemplateService.class, "TemplateService.label34", "\u83b7\u53d6\u6307\u5b9a") + iPublishFolder.getInfo() + I18NMessage.get(TemplateService.class, "TemplateService.label35", "\u4e0b\u53ef\u9009\u7684\u6a21\u677f\u96c6\u5408\u5931\u8d25\uff01!"), exception);
        }
    }

    public Templates getNestedTemplates(Template template) throws WCMException {
        if (template == null) {
            throw new WCMException(10, "Valid template required!");
        }
        TemplateNestMgr templateNestMgr = (TemplateNestMgr)DreamFactory.createObjectById("TemplateNestMgr");
        return templateNestMgr.getNestedTemplates(template);
    }

    public Templates getTemplatesNested(Template template) throws WCMException {
        if (template == null) {
            throw new WCMException(10, "Valid template required!");
        }
        TemplateNestMgr templateNestMgr = (TemplateNestMgr)DreamFactory.createObjectById("TemplateNestMgr");
        return templateNestMgr.getTemplatesNested(template);
    }

    public List getTemplateEmployers(Template template, int n) throws WCMException {
        if (template == null) {
            throw new WCMException(10, "Valid template required!");
        }
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)template, 24)) {
            throw new WCMException(1002, I18NMessage.get(TemplateService.class, "TemplateService.label36", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u67e5\u770b\u6a21\u677f\u7684\u4f7f\u7528\u8005\u5217\u8868!"));
        }
        return this.m_oEmployMgr.getEmployers(template, n);
    }

    public List getTemplateEmployers(Template template) throws WCMException {
        if (template == null) {
            throw new WCMException(10, "Valid template required!");
        }
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)template, 24)) {
            throw new WCMException(1002, I18NMessage.get(TemplateService.class, "TemplateService.label36", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u67e5\u770b\u6a21\u677f\u7684\u4f7f\u7528\u8005\u5217\u8868!"));
        }
        return this.m_oEmployMgr.getEmployers(template, null);
    }

    public Template findByName(int n, String string) throws WCMException {
        TemplateCacheMgr templateCacheMgr = (TemplateCacheMgr)DreamFactory.createObjectById("TemplateCacheMgr");
        return templateCacheMgr.lookupByName((IPublishFolder)PublishElementFactory.lookupElement(103, n), string);
    }

    public TemplateArguments getTemplateArguments(IPublishElement iPublishElement) throws WCMException {
        return this.m_oArgumentMgr.getArguments(iPublishElement);
    }

    public boolean deleteTemplateArgument(TemplateArgument templateArgument) throws WCMException {
        return this.m_oArgumentMgr.delete(templateArgument);
    }

    public void deleteTemplateArguments(TemplateArguments templateArguments) throws WCMException {
        if (templateArguments == null) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label37", "\u65e0\u6548\u7684\u6a21\u677f\u53c2\u6570\u96c6\u5408,\u65e0\u6cd5\u5220\u9664!"));
        }
        for (int i = 0; i < templateArguments.size(); ++i) {
            TemplateArgument templateArgument = (TemplateArgument)templateArguments.getAt(i);
            if (templateArgument == null || this.deleteTemplateArgument(templateArgument)) continue;
            throw new WCMException(1100, I18NMessage.get(TemplateService.class, "TemplateService.label7", "\u5220\u9664Template[") + templateArgument.getArgumentName() + I18NMessage.get(TemplateService.class, "TemplateService.label8", "]\u5931\u8d25,\u4e2d\u6b62\u64cd\u4f5c"));
        }
    }

    public TemplateArgument saveTemplateArgument(TemplateArgument templateArgument) throws WCMException {
        return this.m_oArgumentMgr.save(templateArgument);
    }

    public TemplateParameterList getTemplateParameters(IPublishElement iPublishElement) throws WCMException {
        Object object;
        TemplateParameterList templateParameterList = new TemplateParameterList(true);
        if (iPublishElement instanceof IPublishFolder && (object = this.getOutlineTemplates((IPublishFolder)iPublishElement)) != null) {
            for (int i = ((BaseObjs)object).size() - 1; i >= 0; --i) {
                Template template = (Template)((BaseObjs)object).getAt(i);
                if (template == null) continue;
                templateParameterList.addParameterList(template.getTemplateParameters());
            }
        }
        if ((object = this.getDetailTemplate(iPublishElement)) != null) {
            templateParameterList.addParameterList(((Template)object).getTemplateParameters());
        }
        return templateParameterList;
    }

    public TemplateParameterList getTemplateParameters(IPublishElement iPublishElement, boolean bl) throws WCMException {
        Object object;
        TemplateParameterList templateParameterList = new TemplateParameterList(true);
        TemplateParameterList templateParameterList2 = null;
        if (iPublishElement instanceof IPublishFolder && (object = this.getOutlineTemplates((IPublishFolder)iPublishElement)) != null) {
            for (int i = ((BaseObjs)object).size() - 1; i >= 0; --i) {
                Template template = (Template)((BaseObjs)object).getAt(i);
                if (template == null || (templateParameterList2 = template.getTemplateParameters()) == null) continue;
                this.addNestedParameters(iPublishElement, template, templateParameterList2);
                templateParameterList.addParameterList(templateParameterList2);
            }
        }
        if ((object = this.getDetailTemplate(iPublishElement)) != null && (templateParameterList2 = ((Template)object).getTemplateParameters()) != null) {
            this.addNestedParameters(iPublishElement, (Template)object, templateParameterList2);
            templateParameterList.addParameterList(templateParameterList2);
        }
        return templateParameterList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNestedParameters(IPublishElement iPublishElement, Template template, TemplateParameterList templateParameterList) {
        if (templateParameterList.getNestParsed()) {
            return;
        }
        TemplateService templateService = this;
        synchronized (templateService) {
            Iterator iterator = template.iterateNestedIdentity();
            if (iterator == null) {
                return;
            }
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Template template2 = template.getNestedTemplate(iPublishElement, string);
                template2.getTemplateParameters();
            }
        }
    }

    private void validateRight(Template template, int n, String string) throws WCMException {
        IPublishFolder iPublishFolder = template.getFolder();
        if (iPublishFolder == null) {
            throw new WCMException(200006, I18NMessage.get(TemplateService.class, "TemplateService.label38", "\u6a21\u677f\u6240\u5c5e\u680f\u76ee\u6ca1\u6709\u627e\u5230\uff01"));
        }
        if (AuthServer.hasRight(this.getLoginUser(), iPublishFolder.getSubstance(), n)) {
            return;
        }
        for (IPublishFolder iPublishFolder2 = iPublishFolder.getParent(); iPublishFolder2 != null; iPublishFolder2 = iPublishFolder2.getParent()) {
            if (AuthServer.hasRight(this.getLoginUser(), iPublishFolder2.getSubstance(), n)) {
                return;
            }
            if (iPublishFolder2.isRoot()) break;
        }
        throw new WCMException(1002, I18NMessage.get(TemplateService.class, "TemplateService.label39", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743") + string + "!");
    }
}

