/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.job.JobScheduleServer;
import com.trs.components.common.job.JobWorkerType;
import com.trs.components.common.job.Schedule;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.log.LogServer;
import com.trs.infra.util.CMyString;
import com.trs.service.IScheduleService;

public class ScheduleService
implements IScheduleService {
    public Schedule savePublishSchedule(Schedule schedule, BaseChannel baseChannel) throws WCMException {
        return this.saveSchedule(schedule, baseChannel, this.findPublishWorker(), I18NMessage.get(ScheduleService.class, "ScheduleService.label1", "\u7ad9\u70b9\u6216\u9891\u9053"), 17);
    }

    public Schedule deletePublishSchedule(BaseChannel baseChannel) throws WCMException {
        return this.deleteSchedule(baseChannel, this.findPublishWorker(), I18NMessage.get(ScheduleService.class, "ScheduleService.label1", "\u7ad9\u70b9\u6216\u9891\u9053"), 17);
    }

    public Schedule findPublishSchedule(BaseChannel baseChannel) throws WCMException {
        return this.findSchedule(this.findPublishWorker(), baseChannel, I18NMessage.get(ScheduleService.class, "ScheduleService.label1", "\u7ad9\u70b9\u6216\u9891\u9053"));
    }

    public Schedule savePublishSchedule(Schedule schedule, Document document) throws WCMException {
        return this.saveSchedule(schedule, document, this.findPublishWorker(), I18NMessage.get(ScheduleService.class, "ScheduleService.label2", "\u6587\u6863"), 39);
    }

    public Schedule deletePublishSchedule(Document document) throws WCMException {
        return this.deleteSchedule(document, this.findPublishWorker(), I18NMessage.get(ScheduleService.class, "ScheduleService.label2", "\u6587\u6863"), 39);
    }

    public Schedule findPublishSchedule(Document document) throws WCMException {
        return this.findSchedule(this.findPublishWorker(), document, I18NMessage.get(ScheduleService.class, "ScheduleService.label2", "\u6587\u6863"));
    }

    private Schedule saveSchedule(Schedule schedule, CMSObj cMSObj, JobWorkerType jobWorkerType, String string, int n) throws WCMException {
        String string2 = CMyString.format(I18NMessage.get(ScheduleService.class, "ScheduleService.label15", "\u8bbe\u7f6e{0}\u7684{1}"), new Object[]{cMSObj, jobWorkerType.getDesc()});
        if (schedule == null || cMSObj == null) {
            throw new WCMException(string2 + I18NMessage.get(ScheduleService.class, "ScheduleService.label4", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6307\u5b9a") + string + "\uff01");
        }
        if (!AuthServer.hasRight(ContextHelper.getLoginUser(), cMSObj, n)) {
            throw new WCMException(string2 + I18NMessage.get(ScheduleService.class, "ScheduleService.label5", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\uff01"));
        }
        long l = LogServer.startRecord(this.getLoginUserName(), "SCHEDULE_SAVE", string2, cMSObj);
        try {
            Schedule schedule2 = JobScheduleServer.saveSchedule(jobWorkerType, schedule, cMSObj);
            LogServer.endRecordSucceedOperation(l);
            return schedule2;
        }
        catch (WCMException wCMException) {
            LogServer.endRecordFailedOperation(l, wCMException);
            throw new WCMException(string2 + I18NMessage.get(ScheduleService.class, "ScheduleService.label6", "\u5931\u8d25!"), wCMException);
        }
    }

    private Schedule deleteSchedule(CMSObj cMSObj, JobWorkerType jobWorkerType, String string, int n) throws WCMException {
        String string2 = CMyString.format(I18NMessage.get(ScheduleService.class, "ScheduleService.label14", "\u5220\u9664{0}\u7684{1}"), new Object[]{cMSObj, jobWorkerType.getDesc()});
        if (cMSObj == null) {
            throw new WCMException(string2 + I18NMessage.get(ScheduleService.class, "ScheduleService.label4", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6307\u5b9a") + string + "\uff01");
        }
        if (!AuthServer.hasRight(ContextHelper.getLoginUser(), cMSObj, n)) {
            throw new WCMException(string2 + I18NMessage.get(ScheduleService.class, "ScheduleService.label5", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\uff01"));
        }
        long l = LogServer.startRecord(this.getLoginUserName(), "SCHEDULE_DELETE", string2, cMSObj);
        try {
            Schedule schedule = JobScheduleServer.deleteSchedule(jobWorkerType, cMSObj);
            LogServer.endRecordSucceedOperation(l);
            return schedule;
        }
        catch (WCMException wCMException) {
            LogServer.endRecordFailedOperation(l, wCMException);
            throw new WCMException(string2 + I18NMessage.get(ScheduleService.class, "ScheduleService.label6", "\u5931\u8d25!"), wCMException);
        }
    }

    private Schedule findSchedule(JobWorkerType jobWorkerType, CMSObj cMSObj, String string) throws WCMException {
        String string2 = I18NMessage.get(ScheduleService.class, "ScheduleService.label9", "\u83b7\u53d6") + cMSObj + I18NMessage.get(ScheduleService.class, "ScheduleService.label10", "\u7684\u8ba1\u5212\u53d1\u5e03");
        if (cMSObj == null) {
            throw new WCMException(string2 + I18NMessage.get(ScheduleService.class, "ScheduleService.label11", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6307\u5b9a\u7684") + string + "\uff01");
        }
        return JobScheduleServer.findSchedule(jobWorkerType, cMSObj);
    }

    private JobWorkerType findPublishWorker() throws WCMException {
        return this.findWorkerById(4);
    }

    private JobWorkerType findWorkerById(int n) throws WCMException {
        JobWorkerType jobWorkerType = JobWorkerType.findById(n);
        if (jobWorkerType == null) {
            throw new WCMException(I18NMessage.get(ScheduleService.class, "ScheduleService.label12", "\u7cfb\u7edf\u914d\u7f6e\u9519\u8bef\uff01\u627e\u4e0d\u5230Id\u4e3a[") + n + I18NMessage.get(ScheduleService.class, "ScheduleService.label13", "]\u7684Worker\uff01"));
        }
        return jobWorkerType;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private String getLoginUserName() {
        return this.getLoginUser().getName();
    }
}

