/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.recent.RecentMgr;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.service.IRecentService;
import org.apache.log4j.Logger;

public class RecentService
implements IRecentService {
    private static Logger m_oLogger = Logger.getLogger((String)RecentService.class.getName());

    public User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public boolean add(int n, int n2) throws WCMException {
        if (n2 < 0 || n < 0) {
            throw new WCMException(10, I18NMessage.get(RecentService.class, "RecentService.label1", "\u4f20\u5165\u7684\u7c7b\u578b\u6216\u8005Id\u65e0\u6548\uff01"));
        }
        RecentMgr recentMgr = (RecentMgr)DreamFactory.createObjectById("RecentMgr");
        return recentMgr.add(n, n2);
    }

    public String getIds(int n) throws WCMException {
        if (n < 0) {
            throw new WCMException(10, I18NMessage.get(RecentService.class, "RecentService.label2", "\u5bf9\u8c61\u7c7b\u578b\u65e0\u6548\uff0c\u65e0\u6cd5\u5f97\u5230\u8bbf\u95ee\u8bb0\u5f55\uff01"));
        }
        RecentMgr recentMgr = (RecentMgr)DreamFactory.createObjectById("RecentMgr");
        return recentMgr.getIds(n);
    }

    public Documents getDocuments(WCMFilter wCMFilter) throws WCMException {
        return this.getDocuments(wCMFilter, false);
    }

    public Documents getDocuments(WCMFilter wCMFilter, boolean bl) throws WCMException {
        RecentMgr recentMgr = (RecentMgr)DreamFactory.createObjectById("RecentMgr");
        return recentMgr.getDocuments(wCMFilter, bl);
    }

    public Channels getChannels(WCMFilter wCMFilter) throws WCMException {
        return this.getChannels(wCMFilter, false);
    }

    public Channels getChannels(WCMFilter wCMFilter, boolean bl) throws WCMException {
        RecentMgr recentMgr = (RecentMgr)DreamFactory.createObjectById("RecentMgr");
        return recentMgr.getChannels(wCMFilter, bl);
    }

    public Channels getChannelsWithRight(WCMFilter wCMFilter) throws WCMException {
        return this.getChannels(wCMFilter, false, 64);
    }

    public Channels getChannels(WCMFilter wCMFilter, boolean bl, int n) throws WCMException {
        RecentMgr recentMgr = (RecentMgr)DreamFactory.createObjectById("RecentMgr");
        Channels channels = recentMgr.getChannels(wCMFilter, bl);
        for (int i = channels.size() - 1; i >= 0; --i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null || AuthServer.hasRight(this.getLoginUser(), (CMSObj)channel, n)) continue;
            channels.remove(channel, false);
        }
        return channels;
    }

    public Templates getTemplates(WCMFilter wCMFilter) throws WCMException {
        RecentMgr recentMgr = (RecentMgr)DreamFactory.createObjectById("RecentMgr");
        return recentMgr.getTemplates(wCMFilter);
    }

    public WebSites getWebSites(WCMFilter wCMFilter) throws WCMException {
        RecentMgr recentMgr = (RecentMgr)DreamFactory.createObjectById("RecentMgr");
        return recentMgr.getWebSites(wCMFilter);
    }

    public boolean add(int n, String string) throws WCMException {
        if (n < 0) {
            throw new WCMException(10, I18NMessage.get(RecentService.class, "RecentService.label3", "\u5bf9\u8c61\u7c7b\u578b\u4e0d\u5bf9\uff0c\u65e0\u6cd5\u83b7\u5f97\u6700\u65b0\u8bbf\u95ee\u7684\u5185\u5bb9"));
        }
        if (string == null) {
            return true;
        }
        try {
            String[] stringArray = CMyString.split(string, ",");
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                int n3 = Integer.parseInt(stringArray[i].trim());
                this.add(n, n3);
            }
            return true;
        }
        catch (Exception exception) {
            m_oLogger.error((Object)(I18NMessage.get(RecentService.class, "RecentService.label4", "\u8bb0\u5f55Recent\u65f6\uff0c\u5206\u89e3\u5b57\u7b26\u53d1\u751f\u5f02\u5e38\uff01") + exception.toString()));
            return false;
        }
    }

    public boolean addChnlDoc(int n, int n2) throws WCMException {
        DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        ChnlDoc chnlDoc = documentMgr.findChnlDoc(Document.findById(n2), Channel.findById(n));
        if (chnlDoc == null) {
            throw new WCMException(10, I18NMessage.get(RecentService.class, "RecentService.label5", "\u65e0\u6cd5\u627e\u5230\u9891\u9053\u6587\u6863\uff01"));
        }
        try {
            this.add(614, chnlDoc.getId());
            return true;
        }
        catch (Exception exception) {
            m_oLogger.debug((Object)(I18NMessage.get(RecentService.class, "RecentService.label6", "\u6dfb\u52a0\u6700\u8fd1\u8bbf\u95ee\u7684\u9891\u9053\u6587\u6863\u65f6\u53d1\u751f\u5f02\u5e38\uff01") + exception.toString()));
            return false;
        }
    }

    public ChnlDocs getChnlDocs(WCMFilter wCMFilter) throws WCMException {
        return this.getChnlDocs(wCMFilter, false);
    }

    public ChnlDocs getChnlDocs(WCMFilter wCMFilter, boolean bl) throws WCMException {
        RecentMgr recentMgr = (RecentMgr)DreamFactory.createObjectById("RecentMgr");
        return recentMgr.getChnlDocs(wCMFilter, bl);
    }
}

