/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.domain.taskdispatch.IPublishTaskMgr;
import com.trs.components.common.publish.domain.taskdispatch.PublishTaskRuntime;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.taskdispatch.PublishTask;
import com.trs.components.common.publish.persistent.taskdispatch.PublishTasks;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMDatainvalidException;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.service.IPublishService;
import java.util.Iterator;

public class PublishService
implements IPublishService {
    private PublishServer m_oPublishServer = PublishServer.getInstance();
    private IPublishTaskMgr m_oPublishTaskMgr = (IPublishTaskMgr)DreamFactory.createObjectById("IPublishTaskMgr");

    public User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public String[] preview(BaseChannel baseChannel, String[] stringArray) throws WCMException {
        int n;
        if (baseChannel == null) {
            throw new WCMDatainvalidException(10, I18NMessage.get(PublishService.class, "PublishService.label1", "\u6307\u5b9a\u7ad9\u70b9/\u9891\u9053\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
        }
        int n2 = n = baseChannel.isSite() ? 3 : 15;
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)baseChannel, n)) {
            throw new WCMException(1002, I18NMessage.get(PublishService.class, "PublishService.label2", "\u60a8\u6ca1\u6709\u6743\u9650\u9884\u89c8") + this.getSiteOrChannelMsg(baseChannel));
        }
        try {
            IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(baseChannel);
            return this.m_oPublishServer.previewFolder(iPublishFolder, stringArray);
        }
        catch (WCMDatainvalidException wCMDatainvalidException) {
            throw new WCMDatainvalidException(I18NMessage.get(PublishService.class, "PublishService.label3", "\u9884\u89c8[") + baseChannel + I18NMessage.get(PublishService.class, "PublishService.label4", "]\u5931\u8d25\u2014\u2014\u6570\u636e\u6709\u8bef\uff1a\n") + wCMDatainvalidException.getMyMessage());
        }
        catch (WCMException wCMException) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label5", "\u9884\u89c8") + (baseChannel.isSite() ? I18NMessage.get(PublishService.class, "PublishService.label6", "\u7ad9\u70b9") : I18NMessage.get(PublishService.class, "PublishService.label7", "\u9891\u9053")) + I18NMessage.get(PublishService.class, "PublishService.label8", "\u5931\u8d25"), wCMException);
        }
    }

    private String getSiteOrChannelMsg(BaseChannel baseChannel) {
        return (baseChannel.isSite() ? I18NMessage.get(PublishService.class, "PublishService.label6", "\u7ad9\u70b9") : I18NMessage.get(PublishService.class, "PublishService.label7", "\u9891\u9053")) + "[" + baseChannel.getName() + "](ID=" + baseChannel.getId() + ")";
    }

    public String preview(Document document, String[] stringArray) throws WCMException {
        if (document == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label9", "\u6307\u5b9a\u6587\u6863\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
        }
        return this.preview(document, document.getChannel(), stringArray);
    }

    public String preview(Document document, Channel channel, String[] stringArray) throws WCMException {
        if (document == null) {
            throw new WCMDatainvalidException(10, I18NMessage.get(PublishService.class, "PublishService.label9", "\u6307\u5b9a\u6587\u6863\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
        }
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)document, 38)) {
            throw new WCMException(1002, I18NMessage.get(PublishService.class, "PublishService.label2", "\u60a8\u6ca1\u6709\u6743\u9650\u9884\u89c8") + this.getSiteOrChannelMsg(channel) + I18NMessage.get(PublishService.class, "PublishService.label10", "\u4e2d\u7684\u6587\u6863"));
        }
        try {
            IPublishContent iPublishContent = (IPublishContent)PublishElementFactory.makeElementFrom(document);
            IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
            iPublishContent.setFolder(iPublishFolder);
            return this.m_oPublishServer.previewContent(iPublishContent, stringArray);
        }
        catch (WCMDatainvalidException wCMDatainvalidException) {
            throw new WCMDatainvalidException(I18NMessage.get(PublishService.class, "PublishService.label3", "\u9884\u89c8[") + document + I18NMessage.get(PublishService.class, "PublishService.label11", "]\u5931\u8d25-\u6570\u636e\u6709\u8bef\uff1a") + wCMDatainvalidException.getMyMessage(), wCMDatainvalidException);
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to preview the document!", exception);
        }
    }

    public String previewInfoviewPrint(Document document, Channel channel, String[] stringArray, int n) throws WCMException {
        if (document == null) {
            throw new WCMDatainvalidException(10, I18NMessage.get(PublishService.class, "PublishService.label9", "\u6307\u5b9a\u6587\u6863\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
        }
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)document, 38)) {
            throw new WCMException(1002, I18NMessage.get(PublishService.class, "PublishService.label2", "\u60a8\u6ca1\u6709\u6743\u9650\u9884\u89c8") + this.getSiteOrChannelMsg(channel) + I18NMessage.get(PublishService.class, "PublishService.label10", "\u4e2d\u7684\u6587\u6863"));
        }
        try {
            IPublishContent iPublishContent = (IPublishContent)PublishElementFactory.makeElementFrom(document);
            IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
            iPublishContent.setFolder(iPublishFolder);
            Template template = Template.findById(n);
            return this.m_oPublishServer.previewContent(iPublishContent, stringArray, template);
        }
        catch (WCMDatainvalidException wCMDatainvalidException) {
            throw new WCMDatainvalidException(I18NMessage.get(PublishService.class, "PublishService.label3", "\u9884\u89c8[") + document + I18NMessage.get(PublishService.class, "PublishService.label11", "]\u5931\u8d25-\u6570\u636e\u6709\u8bef\uff1a") + wCMDatainvalidException.getMyMessage(), wCMDatainvalidException);
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to preview the document!", exception);
        }
    }

    public void publish(BaseChannel baseChannel, int n) throws WCMException {
        int n2;
        if (baseChannel == null) {
            throw new WCMDatainvalidException(10, I18NMessage.get(PublishService.class, "PublishService.label1", "\u6307\u5b9a\u7ad9\u70b9/\u9891\u9053\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
        }
        if (baseChannel.isSite()) {
            n2 = n == 2 ? 4 : 5;
        } else {
            int n3 = n2 = n == 2 ? 16 : 17;
        }
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)baseChannel, n2)) {
            throw new WCMDatainvalidException(1002, I18NMessage.get(PublishService.class, "PublishService.label12", "\u60a8\u6ca1\u6709\u6743\u9650") + (n == 2 ? I18NMessage.get(PublishService.class, "PublishService.label13", "\u5b8c\u5168") : I18NMessage.get(PublishService.class, "PublishService.label14", "\u5feb\u901f")) + I18NMessage.get(PublishService.class, "PublishService.label15", "\u53d1\u5e03") + this.getSiteOrChannelMsg(baseChannel));
        }
        try {
            IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(baseChannel);
            this.m_oPublishServer.publishFolder(iPublishFolder, n);
        }
        catch (WCMDatainvalidException wCMDatainvalidException) {
            throw new WCMDatainvalidException(1100, I18NMessage.get(PublishService.class, "PublishService.label16", "\u53d1\u5e03[") + baseChannel + I18NMessage.get(PublishService.class, "PublishService.label4", "]\u5931\u8d25\u2014\u2014\u6570\u636e\u6709\u8bef\uff1a\n") + wCMDatainvalidException.getMyMessage(), wCMDatainvalidException);
        }
        catch (WCMException wCMException) {
            throw new WCMDatainvalidException(1100, I18NMessage.get(PublishService.class, "PublishService.label16", "\u53d1\u5e03[") + baseChannel + I18NMessage.get(PublishService.class, "PublishService.label17", "]\u8fd0\u884c\u4e2d\u51fa\u73b0\u5f02\u5e38\uff01"), wCMException);
        }
    }

    public void delete(BaseChannel baseChannel) throws WCMException {
        int n;
        if (baseChannel == null) {
            throw new WCMDatainvalidException(I18NMessage.get(PublishService.class, "PublishService.label1", "\u6307\u5b9a\u7ad9\u70b9/\u9891\u9053\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
        }
        int n2 = n = baseChannel.isSite() ? 5 : 17;
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)baseChannel, n)) {
            throw new WCMException(1002, I18NMessage.get(PublishService.class, "PublishService.label18", "\u60a8\u6ca1\u6709\u6743\u9650\u53d1\u5e03") + this.getSiteOrChannelMsg(baseChannel));
        }
        try {
            IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(baseChannel);
            this.m_oPublishServer.deleteFolder(iPublishFolder);
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to delete the " + (baseChannel.isSite() ? "site" : "channel") + " publish pages!", exception);
        }
    }

    public void publish(Document document, int n) throws Exception {
        if (document == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label9", "\u6307\u5b9a\u6587\u6863\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
        }
        this.publish(document, document.getChannel(), n);
    }

    public void publish(Document document, Channel channel, int n) throws Exception {
        if (document == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label9", "\u6307\u5b9a\u6587\u6863\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
        }
        if (channel == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label19", "\u6307\u5b9a\u9891\u9053\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
        }
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)document, 39)) {
            throw new WCMException(1002, I18NMessage.get(PublishService.class, "PublishService.label18", "\u60a8\u6ca1\u6709\u6743\u9650\u53d1\u5e03") + this.getSiteOrChannelMsg(channel) + I18NMessage.get(PublishService.class, "PublishService.label20", "\u4e0a\u7684\u6587\u6863"));
        }
        try {
            IPublishContent iPublishContent = (IPublishContent)PublishElementFactory.makeElementFrom(document);
            IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
            iPublishContent.setFolder(iPublishFolder);
            this.m_oPublishServer.publishContent(iPublishContent, n);
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(PublishService.class, "PublishService.label21", "\u53d1\u5e03\u6587\u6863\u5931\u8d25!"), exception);
        }
    }

    public void publish(Documents documents, int n) throws Exception {
        if (documents == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label22", "\u6307\u5b9a\u6587\u6863\u96c6\u5408\u4e3anull"));
        }
        if (documents.isEmpty()) {
            return;
        }
        Document document = null;
        for (int i = 0; i < documents.size(); ++i) {
            document = (Document)documents.getAt(i);
            if (document == null) continue;
            this.publish(document, n);
        }
    }

    public void publish(Documents documents, Channel channel, int n) throws Exception {
        if (n == 7) {
            this.delete(documents, channel);
            return;
        }
        if (documents == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label22", "\u6307\u5b9a\u6587\u6863\u96c6\u5408\u4e3anull"));
        }
        if (channel == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label19", "\u6307\u5b9a\u9891\u9053\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
        }
        if (documents.isEmpty()) {
            return;
        }
        try {
            IPublishElements iPublishElements = PublishElementFactory.makeElementsFrom(documents);
            IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
            this.m_oPublishServer.publishContents(iPublishElements, iPublishFolder, n);
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to publish the contents collection!", exception);
        }
    }

    public void delete(Document document) throws WCMException {
        if (document == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label9", "\u6307\u5b9a\u6587\u6863\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
        }
        this.delete(document, document.getChannel());
    }

    public void delete(Document document, Channel channel) throws WCMException {
        if (document == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label9", "\u6307\u5b9a\u6587\u6863\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
        }
        if (channel == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label19", "\u6307\u5b9a\u9891\u9053\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
        }
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)document, 33)) {
            throw new WCMException(1002, I18NMessage.get(PublishService.class, "PublishService.label23", "\u60a8\u6ca1\u6709\u6743\u9650\u5220\u9664") + this.getSiteOrChannelMsg(channel) + I18NMessage.get(PublishService.class, "PublishService.label24", "\u4e0a\u5df2\u53d1\u5e03\u7684\u6587\u6863\u9875\u9762"));
        }
        try {
            IPublishContent iPublishContent = (IPublishContent)PublishElementFactory.makeElementFrom(document);
            IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
            iPublishContent.setFolder(iPublishFolder);
            this.m_oPublishServer.deleteContent(iPublishContent);
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to delete the published content!", exception);
        }
    }

    public void delete(Documents documents) throws WCMException {
        if (documents == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label22", "\u6307\u5b9a\u6587\u6863\u96c6\u5408\u4e3anull"));
        }
        if (documents.isEmpty()) {
            return;
        }
        Document document = null;
        for (int i = 0; i < documents.size(); ++i) {
            document = (Document)documents.getAt(i);
            if (document == null) continue;
            this.delete(document);
        }
    }

    public void delete(Documents documents, Channel channel) throws WCMException {
        Object object;
        Object object2;
        if (documents == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label22", "\u6307\u5b9a\u6587\u6863\u96c6\u5408\u4e3anull"));
        }
        if (channel == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label19", "\u6307\u5b9a\u9891\u9053\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
        }
        if (documents.isEmpty()) {
            return;
        }
        Channels channels = null;
        DocumentMgr documentMgr = null;
        documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        block5: for (int i = 0; i < documents.size(); ++i) {
            object2 = (Document)documents.getAt(i);
            if (object2 == null || (object = ChnlDoc.findByDocAndChnl((Document)object2, channel)) == null) continue;
            switch (((ChnlDoc)object).getModal()) {
                case 1: {
                    Channels channels2 = documentMgr.getQutoedChannels((Document)object2, 2, null);
                    if (channels2 == null) continue block5;
                    if (channels == null) {
                        channels = channels2;
                        continue block5;
                    }
                    channels.addElements(channels2);
                    continue block5;
                }
            }
        }
        try {
            IPublishElements iPublishElements = PublishElementFactory.makeElementsFrom(documents);
            object2 = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
            object = PublishElementFactory.makeElementsFrom(channels);
            this.m_oPublishServer.deleteContents(iPublishElements, (IPublishFolder)object2, (IPublishElements)object);
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to delete the published contents!", exception);
        }
    }

    public PublishTasks getMyTasks(WCMFilter wCMFilter) throws WCMException {
        return this.m_oPublishTaskMgr.getMyTasks(wCMFilter);
    }

    public PublishTasks getAllTasks(WCMFilter wCMFilter) throws WCMException {
        return this.m_oPublishTaskMgr.getTasks(wCMFilter);
    }

    public void deleteTasks(String string) throws WCMException {
        PublishTasks publishTasks = PublishTasks.findByIds(ContextHelper.getLoginUser(), string);
        for (int i = 0; i < publishTasks.size(); ++i) {
            PublishTask publishTask = (PublishTask)publishTasks.getAt(i);
            if (publishTask == null) continue;
            this.delete(publishTask);
        }
    }

    private void delete(PublishTask publishTask) throws WCMException {
        if (publishTask == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label25", "\u6307\u5b9a\u53d1\u5e03\u4efb\u52a1\u4e3anull"));
        }
        User user = this.getLoginUser();
        if (!user.nameIs(publishTask.getCrUserName()) && !user.isAdministrator()) {
            throw new WCMException(1002, I18NMessage.get(PublishService.class, "PublishService.label26", "\u5bf9\u4e0d\u8d77\uff0c\u60a8\u6ca1\u6709\u6743\u9650\u53d6\u6d88\u8be5\u53d1\u5e03\u4efb\u52a1\uff01"));
        }
        try {
            this.m_oPublishServer.deleteTask(publishTask);
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to cancel the specified publish task!", exception);
        }
    }

    private void redo(PublishTask publishTask) throws WCMException {
        if (publishTask == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label25", "\u6307\u5b9a\u53d1\u5e03\u4efb\u52a1\u4e3anull"));
        }
        User user = this.getLoginUser();
        if (!user.nameIs(publishTask.getCrUserName()) && !user.isAdministrator()) {
            throw new WCMException(1002, I18NMessage.get(PublishService.class, "PublishService.label27", "\u5bf9\u4e0d\u8d77\uff0c\u60a8\u6ca1\u6709\u6743\u9650\u91cd\u65b0\u6267\u884c\u8be5\u53d1\u5e03\u4efb\u52a1\uff01"));
        }
        try {
            this.m_oPublishServer.redoTask(publishTask);
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to cancel the specified publish task!", exception);
        }
    }

    public void redoTasks(String string) throws WCMException {
        PublishTasks publishTasks = PublishTasks.findByIds(ContextHelper.getLoginUser(), string);
        for (int i = 0; i < publishTasks.size(); ++i) {
            PublishTask publishTask = (PublishTask)publishTasks.getAt(i);
            if (publishTask == null) continue;
            this.redo(publishTask);
        }
    }

    public void publish(ChnlDocs chnlDocs, int n) throws Exception {
        if (chnlDocs == null || chnlDocs.isEmpty()) {
            throw new WCMDatainvalidException(10, I18NMessage.get(PublishService.class, "PublishService.label28", "\u6307\u5b9a\u9891\u9053\u6587\u6863\u96c6\u5408\u4e3anull"));
        }
        ChnlDoc chnlDoc = null;
        for (int i = 0; i < chnlDocs.size(); ++i) {
            chnlDoc = (ChnlDoc)chnlDocs.getAt(i);
            if (chnlDoc == null) continue;
            this.publish(chnlDoc.getDocument(), chnlDoc.getChannel(), n);
        }
    }

    private void assertTaskRight(PublishTask publishTask) throws WCMException {
        if (publishTask == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label25", "\u6307\u5b9a\u53d1\u5e03\u4efb\u52a1\u4e3anull"));
        }
        User user = this.getLoginUser();
        if (!user.nameIs(publishTask.getCrUserName()) && !user.isAdministrator()) {
            throw new WCMException(1002, I18NMessage.get(PublishService.class, "PublishService.label26", "\u5bf9\u4e0d\u8d77\uff0c\u60a8\u6ca1\u6709\u6743\u9650\u53d6\u6d88\u8be5\u53d1\u5e03\u4efb\u52a1\uff01"));
        }
    }

    public void cancelTasks(String string) throws WCMException {
        PublishTasks publishTasks = PublishTasks.findByIds(ContextHelper.getLoginUser(), string);
        for (int i = 0; i < publishTasks.size(); ++i) {
            PublishTask publishTask = (PublishTask)publishTasks.getAt(i);
            if (publishTask == null) continue;
            this.assertTaskRight(publishTask);
            this.m_oPublishServer.cancelTask(publishTask);
        }
    }

    public void pauseTask(String string) throws WCMException {
        PublishTasks publishTasks = PublishTasks.findByIds(ContextHelper.getLoginUser(), string);
        for (int i = 0; i < publishTasks.size(); ++i) {
            PublishTask publishTask = (PublishTask)publishTasks.getAt(i);
            if (publishTask == null) continue;
            this.assertTaskRight(publishTask);
            this.m_oPublishServer.pauseTask(publishTask);
        }
    }

    public void resumeTask(String string) throws WCMException {
        PublishTasks publishTasks = PublishTasks.findByIds(ContextHelper.getLoginUser(), string);
        for (int i = 0; i < publishTasks.size(); ++i) {
            PublishTask publishTask = (PublishTask)publishTasks.getAt(i);
            if (publishTask == null) continue;
            this.assertTaskRight(publishTask);
            this.m_oPublishServer.resumeTask(publishTask);
        }
    }

    public PublishTaskRuntime getTaskRuntime(int n) {
        return this.m_oPublishServer.getTaskRuntime(n);
    }

    public PublishTask getRunningTask(int n) {
        return this.m_oPublishServer.getRunningTask(n);
    }

    public Iterator getRunningTasks() {
        return this.m_oPublishServer.getRunningTasks();
    }

    public void publishForcibly(int n, String string) throws WCMException {
        Object object;
        User user = this.getLoginUser();
        Document document = Document.findById(n);
        Channels channels = null;
        String string2 = string;
        if (string2 == null || (string2 = string2.trim()).length() <= 0) {
            object = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
            channels = ((DocumentMgr)object).getChannels(document, 0, null);
        } else {
            int n2;
            channels = Channels.findByIds(user, string);
            if (channels.indexOf(n2 = document.getChannelId()) < 0) {
                channels.addElement(n2);
            }
        }
        if (!user.isAdministrator()) {
            int n3 = 39;
            for (int i = channels.size() - 1; i >= 0; --i) {
                Channel channel = (Channel)channels.getAt(i);
                if (channel == null || AuthServer.hasRight(user, (CMSObj)channel, n3)) continue;
                channels.removeAt(i, false);
            }
        }
        if (channels.isEmpty()) {
            return;
        }
        object = (IPublishContent)PublishElementFactory.makeElementFrom(document);
        object.setFolder(object.getOriginalHome());
        IPublishElements iPublishElements = PublishElementFactory.makeElementsFrom(channels);
        this.m_oPublishServer.publishContent((IPublishContent)object, iPublishElements);
    }

    public void publishConfirm(BaseChannel baseChannel, String string, String string2, String string3) throws WCMException {
        boolean bl;
        if (baseChannel == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label19", "\u6307\u5b9a\u9891\u9053\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
        }
        if (string == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label29", "\u6307\u5b9a\u7684\u6e90\u6587\u4ef6\u4e3a\u7a7a\uff01"));
        }
        User user = this.getLoginUser();
        if (baseChannel.isSite()) {
            bl = AuthServer.hasRight(user, (CMSObj)baseChannel, 4) || AuthServer.hasRight(user, (CMSObj)baseChannel, 5);
        } else {
            boolean bl2 = bl = AuthServer.hasRight(user, (CMSObj)baseChannel, 16) || AuthServer.hasRight(user, (CMSObj)baseChannel, 17);
        }
        if (!bl) {
            throw new WCMDatainvalidException(1002, I18NMessage.get(PublishService.class, "PublishService.label30", "\u60a8\u6ca1\u6709\u6743\u9650\u786e\u8ba4\u53d1\u5e03\uff1a") + this.getSiteOrChannelMsg(baseChannel));
        }
        try {
            IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(baseChannel);
            this.m_oPublishServer.publishConfirm(iPublishFolder, string, string2, string3);
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(PublishService.class, "PublishService.label31", "\u786e\u8ba4\u53d1\u5e03\u5931\u8d25!"), exception);
        }
    }

    public String preview(Document document, Channel channel, String[] stringArray, Template template) throws WCMException {
        return null;
    }
}

