/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.cms.content.HTMLContent;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.soap.OcrSoapClient;
import com.trs.net.ftp.FtpURL;
import com.trs.net.ftp.impl.FtpClientImpl;
import com.trs.service.IOfficeDocumentService;
import com.trs.service.impl.OfficeExtractDocumentService;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class OfficeDocumentService
extends OfficeExtractDocumentService
implements IOfficeDocumentService {
    private static Logger m_oLogger = Logger.getLogger(OfficeDocumentService.class);
    String mFtpHost = null;
    int nFtpPort = 21;
    String mFtpUploadPath = null;
    String mFtpDownloadPath = null;
    String mFtpUserName = null;
    String mFtpPwd = null;
    FtpClientImpl m_oFtpClient = null;
    String mSoapUrl = null;
    String mSoapUrn = null;
    String mSoapUserName = null;
    String mSoapPwd = null;
    String mSoapEncoding = null;

    public OfficeDocumentService() {
        ConfigServer configServer = ConfigServer.getServer();
        try {
            this.mFtpHost = configServer.getSysConfigValue("OCR_FTP_HOST", "127.0.0.1");
            String string = configServer.getSysConfigValue("OCR_FTP_PORT", "21");
            try {
                this.nFtpPort = Integer.parseInt(string);
            }
            catch (Exception exception) {
                this.nFtpPort = 21;
            }
            this.mFtpUploadPath = configServer.getSysConfigValue("OCR_FTP_UPLOAD_PATH", "");
            this.mFtpDownloadPath = configServer.getSysConfigValue("OCR_FTP_DOWNLOAD_PATH", "");
            this.mFtpUserName = configServer.getSysConfigValue("OCR_FTP_USR", "trs");
            this.mFtpPwd = configServer.getSysConfigValue("OCR_FTP_PWD", "trs");
            this.mSoapUrl = configServer.getSysConfigValue("OCR_SOAP_URL", "http://127.0.0.1:8000");
            this.mSoapUrn = configServer.getSysConfigValue("OCR_SOAP_URN", "urn:Office2HTML");
            this.mSoapUserName = configServer.getSysConfigValue("OCR_SOAP_USR", "trs");
            this.mSoapPwd = configServer.getSysConfigValue("OCR_SOAP_PWD", "trs");
            this.mSoapEncoding = configServer.getSysConfigValue("OCR_SOAP_ENCODING", "GBK");
        }
        catch (WCMException wCMException) {
            m_oLogger.error((Object)I18NMessage.get(OfficeDocumentService.class, "OfficeDocumentService.label1", "\u83b7\u53d6\u914d\u7f6e\u4fe1\u606f\u51fa\u9519!"), (Throwable)wCMException);
        }
    }

    private FtpClientImpl openFtpClient() throws IOException {
        FtpURL ftpURL = new FtpURL("ftp://trs:trs@abc:21");
        ftpURL.setHost(this.mFtpHost);
        ftpURL.setPort(this.nFtpPort);
        ftpURL.setUserName(this.mFtpUserName);
        ftpURL.setPassWord(this.mFtpPwd);
        this.m_oFtpClient = new FtpClientImpl(ftpURL);
        this.m_oFtpClient.open();
        return this.m_oFtpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void ftpUpload(String string) throws IOException {
        try {
            this.m_oFtpClient = this.openFtpClient();
            File file = new File(string);
            String string2 = CMyFile.extractFileName(string, null);
            this.m_oFtpClient.upload(file, this.mFtpUploadPath + "/" + string2);
            file.delete();
            Object var5_4 = null;
            if (this.m_oFtpClient == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.m_oFtpClient == null) throw throwable;
            this.m_oFtpClient.close();
            throw throwable;
        }
        this.m_oFtpClient.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void ftpDownload(String string, String string2) throws IOException {
        try {
            this.m_oFtpClient = this.openFtpClient();
            File file = new File(string2);
            this.m_oFtpClient.download(this.mFtpDownloadPath + "/" + string, file);
            try {
                this.m_oFtpClient.deleteFile(this.mFtpDownloadPath + "/" + string);
            }
            catch (IOException iOException) {
                m_oLogger.warn((Object)(I18NMessage.get(OfficeDocumentService.class, "OfficeDocumentService.label2", "\u4e0b\u8f7d\u76ee\u5f55\u672a\u914d\u7f6e\u5220\u9664\u6587\u4ef6\u7684\u6743\u9650!:") + iOException.getMessage()));
            }
            Object var6_5 = null;
            if (this.m_oFtpClient == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (this.m_oFtpClient == null) throw throwable;
            this.m_oFtpClient.close();
            throw throwable;
        }
        this.m_oFtpClient.close();
    }

    String renderHtmlFormat(String string) throws CMyException {
        String string2 = CMyFile.extractFilePath(string);
        string2 = string2 + "temp" + System.currentTimeMillis() + File.separator;
        CMyUnZipFile cMyUnZipFile = new CMyUnZipFile(string, string2);
        try {
            cMyUnZipFile.doUnZipAnd();
            CMyFile.deleteFile(string);
        }
        catch (CMyException cMyException) {
            throw new WCMException(200, I18NMessage.get(OfficeDocumentService.class, "OfficeDocumentService.label3", "Zip\u6587\u4ef6\u89e3\u538b\u5931\u8d25!"), cMyException);
        }
        Hashtable hashtable = cMyUnZipFile.getAllFileNameIndex();
        String string3 = null;
        String string4 = CMyFile.extractFileName(string, null);
        String string5 = string4.replaceAll("\\..*$", ".html");
        HashMap hashMap = new HashMap();
        Enumeration enumeration = hashtable.keys();
        String string6 = null;
        if (m_oLogger.isDebugEnabled()) {
            m_oLogger.debug((Object)string5);
        }
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            if (m_oLogger.isDebugEnabled()) {
                m_oLogger.debug((Object)(string3 + ":" + hashtable.get(string3)));
            }
            if (!string3.equalsIgnoreCase(string5)) {
                hashMap.put(string3.toLowerCase(), hashtable.get(string3));
                continue;
            }
            string6 = (String)hashtable.get(string3);
        }
        String string7 = CMyFile.readFile(string6, this.mSoapEncoding);
        String string8 = HTMLContent.saveHTMLContentFromOut(string7, hashMap);
        HTMLContent hTMLContent = new HTMLContent(string8);
        string8 = hTMLContent.parseHTMLContent(null);
        new File(string6).delete();
        return string8;
    }

    String soapConvert(String string) throws RemoteException, ServiceException {
        OcrSoapClient ocrSoapClient = new OcrSoapClient();
        ocrSoapClient.setServer(this.mSoapUrl, this.mSoapUserName, this.mSoapPwd);
        ocrSoapClient.setUrn(this.mSoapUrn);
        String string2 = ocrSoapClient.ConvertOfficeFile(string);
        return string2;
    }

    public String convert2Html(String string) throws Exception {
        String string2 = CMyFile.extractFileName(string, null);
        String string3 = CMyFile.extractFilePath(string);
        this.ftpUpload(string);
        String string4 = this.soapConvert(string2);
        this.ftpDownload(string4, string3 + string4);
        return this.renderHtmlFormat(string3 + string4);
    }
}

