/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.components.infoview.InfoViewConfig;
import com.trs.components.infoview.InfoViewMgr;
import com.trs.components.infoview.config.BindingBean;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import com.trs.service.IInfoViewInitor;
import com.trs.service.IInfoViewInitorValue;
import com.trs.service.InfoViewContext;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class InfoViewInitorImpl
implements IInfoViewInitor {
    private InfoViewMgr m_oInfoViewMgr = (InfoViewMgr)DreamFactory.createObjectById("InfoViewMgr");
    private InfoViewConfig m_oInfoViewConfig = this.m_oInfoViewMgr.getInfoViewConfig();

    public Object init(InfoViewContext infoViewContext) throws WCMException {
        List list = this.m_oInfoViewConfig.getInfoviewBindings();
        String string = "{";
        boolean bl = true;
        for (BindingBean bindingBean : list) {
            String string2;
            String string3 = bindingBean.getClassname();
            if (string3 != null) {
                try {
                    Class<?> clazz = Class.forName(string3);
                    IInfoViewInitorValue iInfoViewInitorValue = (IInfoViewInitorValue)clazz.newInstance();
                    string2 = (String)iInfoViewInitorValue.getFieldValue(infoViewContext, bindingBean);
                }
                catch (Exception exception) {
                    throw new WCMException(I18NMessage.get(InfoViewInitorImpl.class, "InfoViewInitorImpl.label1", "\u65e0\u6cd5\u627e\u5230\u7c7b[") + string3 + I18NMessage.get(InfoViewInitorImpl.class, "InfoViewInitorImpl.label2", "],\u6216\u8005\u6b64\u7c7b\u4e0d\u662f\u63a5\u53e3[IInfoViewInitor]\u7684\u5b9e\u73b0\u7c7b"));
                }
            } else {
                string2 = (String)this.getFieldValue(infoViewContext, bindingBean);
            }
            if (string2 == null || string2 == "") continue;
            if (!bl) {
                string = string + ",\n";
            }
            string = string + CMyString.filterForJs(bindingBean.getName()) + ":\"" + CMyString.filterForJs(string2) + "\"";
            bl = false;
        }
        string = string + "}";
        return string;
    }

    public Object getFieldValue(InfoViewContext infoViewContext, BindingBean bindingBean) throws WCMException {
        String string = bindingBean.getName();
        if ("UserName".equalsIgnoreCase(string)) {
            User user = infoViewContext.getUser();
            if (user != null) {
                return user.getName();
            }
        } else {
            if ("ChannelName".equalsIgnoreCase(string)) {
                return infoViewContext.getChannel().getName();
            }
            if ("GroupName".equalsIgnoreCase(string)) {
                Groups groups;
                User user = infoViewContext.getUser();
                if (user != null && (groups = user.getGroups()) != null && groups.size() > 0) {
                    return ((Group)groups.getAt(0)).getName();
                }
            } else {
                if ("CurrDate".equalsIgnoreCase(string)) {
                    String string2 = CMyString.showNull(bindingBean.getFormat(), "yyyy-MM-dd");
                    Date date = new Date();
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
                    return simpleDateFormat.format(date);
                }
                if ("CurrTime".equalsIgnoreCase(string)) {
                    String string3 = CMyString.showNull(bindingBean.getFormat(), "yyyy-MM-dd HH:mm:ss");
                    Date date = new Date();
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string3);
                    return simpleDateFormat.format(date);
                }
            }
        }
        return null;
    }
}

