/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.domain.DocumentImporter;
import com.trs.infra.I18NMessage;
import com.trs.infra.util.Reports;
import java.io.File;
import java.util.Properties;
import org.apache.log4j.Logger;

public class FtpSoap4Radar {
    public String importViaFtp(String string) {
        return Importer.importDocs(string);
    }

    private static class Importer {
        private static final Logger logger = Logger.getLogger(Importer.class);
        private static final String CONF = "/ftpsoap4radar.properties";
        private boolean m_zServiceable = false;
        private boolean m_zImporteDup = false;
        private String m_sFtpDir = null;
        private String m_sUnerviceAble = null;
        private User m_oUser = null;
        private static final Importer IMPORTER = new Importer();

        private Importer() {
            this.loadConf();
        }

        public static String importDocs(String string) {
            return IMPORTER.importDocs0(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private void loadConf() {
            block22: {
                var1_1 = FtpSoap4Radar.class;
                var2_2 = null;
                var3_3 = null;
                try {
                    var2_2 = var1_1.getResourceAsStream("/ftpsoap4radar.properties");
                    if (var2_2 == null) {
                        var2_2 = var1_1.getResourceAsStream("/ftpsoap4radar.properties".substring(1));
                    }
                    var3_3 = new Properties();
                    var3_3.load(var2_2);
                    var6_4 = null;
                    ** if (var2_2 == null) goto lbl-1000
                }
                catch (Throwable var5_12) {
                    var6_6 = null;
                    if (var2_2 != null) {
                        try {
                            var2_2.close();
                        }
                        catch (Exception var7_9) {
                            // empty catch block
                        }
                    }
                    throw var5_12;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var2_2.close();
                    }
                    catch (Exception var7_7) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block22;
                    catch (Exception var4_10) {
                        Importer.logger.error((Object)"load ftpsoap4radar.properties fail!", (Throwable)var4_10);
                        var6_5 = null;
                        if (var2_2 != null) {
                            try {
                                var2_2.close();
                            }
                            catch (Exception var7_8) {}
                        }
                    }
                }
            }
            if (var3_3 == null) {
                return;
            }
            var4_11 = var3_3.getProperty("soapftp.dir");
            if (var4_11 == null || var4_11.trim().length() == 0) {
                Importer.logger.error((Object)"soapftp.dir not set!");
            } else {
                var5_13 = new File(var4_11);
                if (!var5_13.exists()) {
                    Importer.logger.error((Object)"soapftp.dir doesn't exists!");
                } else if (!var5_13.isDirectory()) {
                    Importer.logger.error((Object)"soapftp.dir isn't a directory!");
                } else {
                    this.m_zServiceable = true;
                    this.m_sFtpDir = var5_13.getAbsolutePath() + File.separator;
                    Importer.logger.info((Object)("soapftp.dir:" + this.m_sFtpDir));
                    var5_13 = null;
                }
            }
            if (this.m_zServiceable) {
                var4_11 = var3_3.getProperty("import.doctitle.duplicated");
                this.m_zImporteDup = "true".equals(var4_11);
                var4_11 = var3_3.getProperty("import.username", "system");
                ContextHelper.initContext(User.getSystem());
                this.m_oUser = User.findByName(var4_11);
                if (this.m_oUser == null) {
                    this.m_oUser = User.getSystem();
                }
            } else {
                var5_13 = new StringBuffer(256);
                var5_13.append("\n<REPORTS>\n<IS-SUCCESS>false</IS-SUCCESS>\n");
                var5_13.append("<TITLE><![CDATA[");
                var5_13.append(I18NMessage.get(FtpSoap4Radar.class, "FtpSoap4Radar.label1", "WCM\u670d\u52a1\u662f\u4e0d\u53ef\u53ca\u7684,\u53ef\u80fd\u662f\u4e34\u65f6\u5de5\u4f5c\u76ee\u5f55["));
                var5_13.append(this.m_sFtpDir);
                var5_13.append(I18NMessage.get(FtpSoap4Radar.class, "FtpSoap4Radar.label2", "]\u4e0d\u53ef\u7528!"));
                var5_13.append("]]></TITLE>\n");
                var5_13.append("<REPORT>\n<IS-SUCCESS>false</IS-SUCCESS>\n");
                var5_13.append(I18NMessage.get(FtpSoap4Radar.class, "FtpSoap4Radar.label3", "<TITLE><![CDATA[\u4e0d\u80fd\u5bfc\u5165\u6587\u6863]]></TITLE>\n"));
                var5_13.append(I18NMessage.get(FtpSoap4Radar.class, "FtpSoap4Radar.label4", "<ERROR-INFO><![CDATA[WCM\u4e34\u65f6\u5de5\u4f5c\u76ee\u5f55\u4e0d\u53ef\u7528]]>"));
                var5_13.append("</ERROR-INFO>\n</REPORT>\n</REPORTS>");
                this.m_sUnerviceAble = var5_13.toString();
                var5_13.setLength(0);
                var5_13 = null;
            }
            var3_3.clear();
            var3_3 = null;
        }

        private String importDocs0(String string) {
            if (this.m_zServiceable) {
                Reports reports = new Reports(I18NMessage.get(FtpSoap4Radar.class, "FtpSoap4Radar.label5", "\u5bfc\u5165\u6587\u6863"));
                try {
                    string = this.m_sFtpDir + string;
                    ContextHelper.initContext(this.m_oUser);
                    DocumentImporter documentImporter = new DocumentImporter();
                    reports = documentImporter.importFromFile(string, null, null, this.m_zImporteDup, false);
                    if (logger.isDebugEnabled()) {
                        StringBuffer stringBuffer = new StringBuffer(512);
                        stringBuffer.append("Success=[");
                        stringBuffer.append(reports.getSucessedReporter().size());
                        stringBuffer.append("]Faile=[");
                        stringBuffer.append(reports.getFailedReporter().size());
                        stringBuffer.append("]Waring=[");
                        stringBuffer.append(reports.getWarnedReporter().size());
                        stringBuffer.append("]\n");
                        stringBuffer.append(reports.toXML());
                        logger.debug((Object)stringBuffer);
                    }
                    return reports.toXML();
                }
                catch (Throwable throwable) {
                    StringBuffer stringBuffer = new StringBuffer(64);
                    stringBuffer.append(I18NMessage.get(FtpSoap4Radar.class, "FtpSoap4Radar.label6", "\u4ece\u6587\u4ef6["));
                    stringBuffer.append(string);
                    stringBuffer.append(I18NMessage.get(FtpSoap4Radar.class, "FtpSoap4Radar.label7", "]\u4e2d\u5bfc\u5165\u6587\u6863!"));
                    reports.setTitle(stringBuffer.toString());
                    reports.addFailedReport(stringBuffer.toString(), throwable);
                    return reports.toXML();
                }
            }
            return this.m_sUnerviceAble;
        }
    }
}

