/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMProcessServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.ExtendedField;
import com.trs.cms.content.ExtendedFields;
import com.trs.components.infoview.InfoViewHelper;
import com.trs.components.infoview.InfoViewMgr;
import com.trs.components.infoview.helper.BaseInfoViewFieldValueCreator;
import com.trs.components.infoview.helper.InfoViewFieldValueCreatorFactory;
import com.trs.components.infoview.mad.InfoViewDataHelper;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.domain.DocBakMgr;
import com.trs.components.wcm.content.domain.DocReplyMgr;
import com.trs.components.wcm.content.domain.DocumentExporter;
import com.trs.components.wcm.content.domain.DocumentImporter;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.DocumentPriMgr;
import com.trs.components.wcm.content.domain.IDocKeywordMgr;
import com.trs.components.wcm.content.domain.RelationMgr;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.DocBak;
import com.trs.components.wcm.content.persistent.DocBaks;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.Relations;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMDatainvalidException;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.support.log.LogServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.DiscoveryFactoryBuddy;
import com.trs.infra.util.Reports;
import com.trs.service.IDocumentService;
import com.trs.service.IInfoViewService;
import com.trs.service.ServiceHelper;
import com.trs.webframework.exception.ServiceInvocationException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class DocumentService
implements IDocumentService {
    private static Logger m_oLogger = Logger.getLogger(DocumentService.class);
    private static final int TRANSMIT_TYPE_COPY = 1;
    private static final int TRANSMIT_TYPE_MOVE = 2;
    private static final int TRANSMIT_TYPE_QUOTE = 3;
    private static final int TRANSMIT_TYPE_MIRROR = 4;
    private static final String[] TRANSMIT_TYPE_TEXT = new String[]{I18NMessage.get(DocumentService.class, "DocumentService.label1", "\u590d\u5236"), I18NMessage.get(DocumentService.class, "DocumentService.label2", "\u79fb\u52a8"), I18NMessage.get(DocumentService.class, "DocumentService.label3", "\u94fe\u63a5\u578b\u5f15\u7528"), I18NMessage.get(DocumentService.class, "DocumentService.label4", "\u955c\u50cf\u578b\u5f15\u7528")};
    public AppendixMgr m_oAppendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
    public DocumentMgr m_oDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
    private DocBakMgr m_oDocBakMgr = (DocBakMgr)DreamFactory.createObjectById("DocBakMgr");
    public RelationMgr m_oRelationMgr = (RelationMgr)DreamFactory.createObjectById("RelationMgr");
    private DocReplyMgr m_oDocReplyMgr = (DocReplyMgr)DreamFactory.createObjectById("DocReplyMgr");
    private IDocKeywordMgr m_oDocKeywordMgr = (IDocKeywordMgr)DreamFactory.createObjectById("IDocKeywordMgr");

    public DocBaks getDocBaks(com.trs.components.wcm.content.persistent.Document document) throws WCMException {
        return this.getDocBaks(document, null);
    }

    public DocBaks getDocBaks(com.trs.components.wcm.content.persistent.Document document, WCMFilter wCMFilter) throws WCMException {
        return this.m_oDocBakMgr.findDocBaks(document, wCMFilter);
    }

    public DocBak getDocBak(com.trs.components.wcm.content.persistent.Document document, int n) throws WCMException {
        return this.m_oDocBakMgr.getDocBak(document, n);
    }

    public com.trs.components.wcm.content.persistent.Document save(com.trs.components.wcm.content.persistent.Document document, List list, List list2) throws WCMException {
        return this.save(document, list, list2, new HashMap(0));
    }

    public com.trs.components.wcm.content.persistent.Document save(com.trs.components.wcm.content.persistent.Document document, List list, List list2, String string) throws WCMException {
        Map map = WCMProcessServiceHelper.makeFlowContextInfoMap(string);
        return this.save(document, list, list2, map);
    }

    public com.trs.components.wcm.content.persistent.Document save(com.trs.components.wcm.content.persistent.Document document, List list, List list2, int n) throws WCMException {
        if (!WCMProcessServiceHelper.hasFlowingActionRight(this.getLoginUser(), n, 32)) {
            throw new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label5", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u5728\u5f53\u524d\u5de5\u4f5c\u6d41\u8282\u70b9\u4e0a\u4fdd\u5b58\u6587\u6863!"));
        }
        return this.save(document, list, list2, new HashMap(0), false);
    }

    public com.trs.components.wcm.content.persistent.Document save(com.trs.components.wcm.content.persistent.Document document, List list, List list2, Map map) throws WCMException {
        return this.save(document, list, list2, map, true);
    }

    public com.trs.components.wcm.content.persistent.Document save(com.trs.components.wcm.content.persistent.Document document, List list, List list2, Map map, boolean bl) throws WCMException {
        if (bl && !this.validateRight(this.getLoginUser(), document, 80)) {
            throw new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label6", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u4fdd\u5b58\u6587\u6863!"));
        }
        String string = I18NMessage.get(DocumentService.class, "DocumentService.label7", "\u4fdd\u5b58") + document;
        boolean bl2 = document.isAddMode();
        String string2 = bl2 ? "DOCUMENT_ADD" : "DOCUMENT_EDIT";
        long l = LogServer.startRecord(this.getLoginUserName(), string2, string, document);
        try {
            this.m_oDocumentMgr.save(document);
            this.m_oAppendixMgr.saveAppendixes(document, list);
            this.m_oRelationMgr.saveRelations(document, list2);
        }
        catch (Throwable throwable) {
            LogServer.endRecordFailedOperation(l, throwable);
            throw new WCMException(1100, I18NMessage.get(DocumentService.class, "DocumentService.label8", "\u4fdd\u5b58\u6587\u6863\u5931\u8d25!"), throwable);
        }
        int n = document.getPropertyAsInt("DocFlag", 0);
        if (bl2 && n == 0) {
            try {
                WCMProcessServiceHelper.startDocumentInFlow(this.getLoginUser(), document, map);
            }
            catch (Throwable throwable) {
                ServiceInvocationException serviceInvocationException = new ServiceInvocationException(I18NMessage.get(DocumentService.class, "DocumentService.label120", "\u6587\u6863[") + document.getTitle() + "-" + document.getId() + I18NMessage.get(DocumentService.class, "DocumentService.label121", "]\u5df2\u7ecf\u4fdd\u5b58\u6210\u529f\uff0c\u4f46\u56e0\u60a8\u7684\u5de5\u4f5c\u6d41\u8bbe\u7f6e\u6709\u8bef\uff0c\u5c06\u5176\u6295\u5165\u6d41\u8f6c\u5931\u8d25\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u5de5\u4f5c\u6d41\uff0c\u4fee\u6b63\u540e\u5c06\u6587\u6863\u91cd\u65b0\u6295\u5165\u6d41\u8f6c\uff01"), throwable);
                serviceInvocationException.setErrorCode("17080");
                throw serviceInvocationException;
            }
        }
        LogServer.endRecordSucceedOperation(l);
        return document;
    }

    public boolean delete(String string, Channel channel, boolean bl) throws WCMException {
        if (string == null || string.length() == 0) {
            return true;
        }
        Documents documents = Documents.findByIds(this.getLoginUser(), string);
        return this.delete(documents, channel, bl);
    }

    public boolean delete(Documents documents, Channel channel, boolean bl) throws WCMException {
        if (documents == null) {
            throw new WCMException(20, I18NMessage.get(DocumentService.class, "DocumentService.label9", "\u6ca1\u6709\u8981\u5220\u9664\u7684\u6587\u6863\uff01"));
        }
        Channel channel2 = channel;
        for (int i = 0; i < documents.size(); ++i) {
            com.trs.components.wcm.content.persistent.Document document = (com.trs.components.wcm.content.persistent.Document)documents.getAt(i);
            if (document == null || channel == null && (channel2 = document.getChannelId() == 0 ? Channel.DRAFT_CHANNEL : document.getChannel()) == null) continue;
            this.delete(document, channel2, bl);
        }
        return true;
    }

    public boolean delete(int n, Channel channel, boolean bl) throws WCMException {
        com.trs.components.wcm.content.persistent.Document document = com.trs.components.wcm.content.persistent.Document.findById(n);
        if (document == null) {
            throw new WCMException(200006, I18NMessage.get(DocumentService.class, "DocumentService.label10", "\u6ca1\u6709\u627e\u5230[id=") + n + I18NMessage.get(DocumentService.class, "DocumentService.label11", "]\u7684\u6587\u6863,\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        return this.delete(document, channel, bl);
    }

    public boolean delete(com.trs.components.wcm.content.persistent.Document document, Channel channel, boolean bl) throws WCMException {
        if (document == null) {
            throw new WCMException(20, I18NMessage.get(DocumentService.class, "DocumentService.label12", "\u5f53\u524d\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        Channel channel2 = channel;
        if (channel2 == null) {
            channel2 = document.getChannel();
        }
        if (document.isDraft()) {
            channel2 = Channel.DRAFT_CHANNEL;
        }
        if (channel2 == null) {
            throw new WCMException(20, I18NMessage.get(DocumentService.class, "DocumentService.label13", "\u5f53\u524d\u9891\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        if (!this.validateRight(this.getLoginUser(), document, 33)) {
            throw new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label14", "\u60a8\u6682\u65f6\u65e0\u6743\u5728[") + channel + I18NMessage.get(DocumentService.class, "DocumentService.label15", "]\u4e0b\u5220\u9664\u6587\u6863[") + document + "]");
        }
        long l = LogServer.startRecord(this.getLoginUser().getName(), "DOCUMENT_DEL", I18NMessage.get(DocumentService.class, "DocumentService.label16", "\u5220\u9664:") + document, document);
        try {
            this.m_oDocumentMgr.delete(document, channel2, bl);
        }
        catch (Throwable throwable) {
            LogServer.endRecordFailedOperation(l, throwable);
            throw new WCMException(1100, I18NMessage.get(DocumentService.class, "DocumentService.label17", "\u5220\u9664\u6587\u6863\u5931\u8d25\uff01"), throwable);
        }
        LogServer.endRecordSucceedOperation(l);
        return true;
    }

    private Reports copyTo(com.trs.components.wcm.content.persistent.Document document, Channel channel, Channel channel2) throws WCMException {
        Reports reports = new Reports(I18NMessage.get(DocumentService.class, "DocumentService.label18", "\u590d\u5236\u6587\u6863"));
        if (!DocumentAuthServer.hasRight(this.getLoginUser(), (BaseChannel)channel, document, 34)) {
            reports.addFailedReport(document + I18NMessage.get(DocumentService.class, "DocumentService.label19", "\u590d\u5236\u5931\u8d25!"), new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label20", "\u5bf9\u4e0d\u8d77,\u60a8\u6682\u65f6\u65e0\u6743\u4ece\u9891\u9053[") + channel.getName() + I18NMessage.get(DocumentService.class, "DocumentService.label21", "]\u590d\u5236\u6587\u6863!")));
            return reports;
        }
        if (!this.validateRight(this.getLoginUser(), channel2, 31)) {
            reports.addFailedReport(channel2 + I18NMessage.get(DocumentService.class, "DocumentService.label22", "\u6dfb\u52a0\u5931\u8d25!"), new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label23", "\u5bf9\u4e0d\u8d77,\u60a8\u6682\u65f6\u65e0\u6743\u5728\u9891\u9053[") + channel2.getName() + I18NMessage.get(DocumentService.class, "DocumentService.label24", "]\u6dfb\u52a0\u6587\u6863!")));
            return reports;
        }
        String string = I18NMessage.get(DocumentService.class, "DocumentService.label122", "\u590d\u5236") + document + I18NMessage.get(DocumentService.class, "DocumentService.label25", "\u5230") + channel2;
        long l = LogServer.startRecord(this.getLoginUserName(), "DOCUMENT_COPY", string, document);
        com.trs.components.wcm.content.persistent.Document document2 = null;
        try {
            document2 = this.m_oDocumentMgr.copyDocument(document, channel, channel2);
            if (document2 == null) {
                reports.addSucessedReport(document + I18NMessage.get(DocumentService.class, "DocumentService.label26", "\u5728") + channel2 + I18NMessage.get(DocumentService.class, "DocumentService.label27", "\u4e0b\u5df2\u5b58\u5728\u5f15\u7528\u5173\u7cfb!"));
                return reports;
            }
            if (document2.getId() != document.getId()) {
                this.m_oAppendixMgr.copyAppendixes(document, document2);
                this.m_oRelationMgr.copyRelations(document, document2);
                this.m_oDocReplyMgr.copyDocReplys(document, document2);
            }
            reports.addSucessedReport(document + I18NMessage.get(DocumentService.class, "DocumentService.label28", "\u590d\u5236\u6210\u529f\uff01"));
        }
        catch (WCMException wCMException) {
            LogServer.endRecordFailedOperation(l, wCMException);
            reports.addFailedReport(document + I18NMessage.get(DocumentService.class, "DocumentService.label19", "\u590d\u5236\u5931\u8d25!"), wCMException);
            return reports;
        }
        LogServer.endRecordSucceedOperation(l);
        return reports;
    }

    private Reports moveTo(com.trs.components.wcm.content.persistent.Document document, Channel channel, Channel channel2) throws WCMException {
        Reports reports = new Reports(I18NMessage.get(DocumentService.class, "DocumentService.label29", "\u79fb\u52a8\u6587\u6863."));
        if (!DocumentAuthServer.hasRight(this.getLoginUser(), (BaseChannel)channel, document, 33) || !this.validateRight(this.getLoginUser(), channel2, 31)) {
            reports.addFailedReport(document + I18NMessage.get(DocumentService.class, "DocumentService.label30", "\u79fb\u52a8\u5931\u8d25!"), new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label31", "\u5bf9\u4e0d\u8d77,\u60a8\u6682\u65f6\u65e0\u6743\u79fb\u52a8!")));
            return reports;
        }
        try {
            reports.addReport(this.m_oDocumentMgr.moveTo(document, channel, channel2));
        }
        catch (WCMException wCMException) {
            reports.addFailedReport(document + I18NMessage.get(DocumentService.class, "DocumentService.label30", "\u79fb\u52a8\u5931\u8d25!"), wCMException);
        }
        return reports;
    }

    public void withdraw(com.trs.components.wcm.content.persistent.Document document) {
    }

    public Reports importDocuments(String string, int n, String string2, boolean bl, boolean bl2) throws WCMException {
        DocumentImporter documentImporter = (DocumentImporter)DreamFactory.createObjectById("DocumentImporter");
        Channel channel = Channel.findById(n);
        long l = LogServer.startRecord(this.getLoginUserName(), "DOCUMENT_IMPORT", I18NMessage.get(DocumentService.class, "DocumentService.label32", "\u5bfc\u5165\u6587\u6863"), channel);
        Reports reports = new Reports("");
        try {
            if (!this.validateRight(this.getLoginUser(), channel, 31)) {
                throw new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label33", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u5728") + channel + I18NMessage.get(DocumentService.class, "DocumentService.label34", "\u4e0a\u91c7\u96c6\u6587\u6863!"));
            }
            reports = documentImporter.importFromFile(string, channel, string2, bl, bl2);
        }
        catch (WCMException wCMException) {
            LogServer.endRecordFailedOperation(l, wCMException);
            reports.addFailedReport(I18NMessage.get(DocumentService.class, "DocumentService.label35", "\u6587\u6863\u5bfc\u5165\u5931\u8d25"), wCMException);
            throw new WCMException(1100, I18NMessage.get(DocumentService.class, "DocumentService.label36", "\u5bfc\u5165\u6587\u6863\u5931\u8d25!"), wCMException);
        }
        LogServer.endRecordSucceedOperation(l);
        return reports;
    }

    public Reports importTRSDocuments(String string, int n, String string2, boolean bl, boolean bl2) throws WCMException {
        DocumentImporter documentImporter = (DocumentImporter)DreamFactory.createObjectById("DocumentImporter");
        Channel channel = Channel.findById(n);
        long l = LogServer.startRecord(this.getLoginUserName(), "DOCUMENT_IMPORT", I18NMessage.get(DocumentService.class, "DocumentService.label32", "\u5bfc\u5165\u6587\u6863"), channel);
        Reports reports = new Reports("");
        try {
            if (!this.validateRight(this.getLoginUser(), channel, 31)) {
                throw new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label33", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u5728") + channel + I18NMessage.get(DocumentService.class, "DocumentService.label34", "\u4e0a\u91c7\u96c6\u6587\u6863!"));
            }
            reports = documentImporter.importFromTRSFile(string, channel, string2, bl, bl2);
        }
        catch (WCMException wCMException) {
            LogServer.endRecordFailedOperation(l, wCMException);
            reports.addFailedReport(I18NMessage.get(DocumentService.class, "DocumentService.label35", "\u6587\u6863\u5bfc\u5165\u5931\u8d25"), wCMException);
            throw new WCMException(1100, I18NMessage.get(DocumentService.class, "DocumentService.label36", "\u5bfc\u5165\u6587\u6863\u5931\u8d25!"), wCMException);
        }
        LogServer.endRecordSucceedOperation(l);
        return reports;
    }

    public File[] getExitedXslFiles() throws WCMException {
        return DocumentImporter.getExistedXslFiles(this.getLoginUser());
    }

    public File[] getExitedMappingFiles() throws WCMException {
        return DocumentImporter.getExistedMapingFiles(this.getLoginUser());
    }

    public String getMyDocumentImportSourceFilePath() throws WCMException {
        return DocumentImporter.getMyDocumentImportSourceFilePath(this.getLoginUser());
    }

    public void changeDocumentsStatus(Documents documents, Channel channel, Status status) throws WCMException {
        if (documents == null || documents.isEmpty()) {
            throw new WCMException(20, I18NMessage.get(DocumentService.class, "DocumentService.label37", "\u6587\u6863\u96c6\u5408\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539\u72b6\u6001\uff01"));
        }
        com.trs.components.wcm.content.persistent.Document document = null;
        for (int i = 0; i < documents.size(); ++i) {
            document = (com.trs.components.wcm.content.persistent.Document)documents.getAt(i);
            if (document == null) continue;
            this.changeDocumentStatus(document, channel, status);
        }
    }

    public void changeDocumentStatus(com.trs.components.wcm.content.persistent.Document document, Channel channel, Status status) throws WCMException {
        Channel channel2;
        if (document == null) {
            throw new WCMException(20, I18NMessage.get(DocumentService.class, "DocumentService.label38", "\u6587\u6863\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u4fee\u6539\u72b6\u6001\uff01"));
        }
        Channel channel3 = channel2 = channel == null ? document.getChannel() : channel;
        if (channel2 == null) {
            throw new WCMDatainvalidException(20, I18NMessage.get(DocumentService.class, "DocumentService.label39", "\u6ca1\u6709\u6307\u5b9a\u9891\u9053\uff0c\u65e0\u6cd5\u4fee\u6539\u72b6\u6001\uff01"));
        }
        if (!DocumentAuthServer.hasRight(this.getLoginUser(), (BaseChannel)channel, document, status.getRightIndex())) {
            throw new WCMDatainvalidException(I18NMessage.get(DocumentService.class, "DocumentService.label40", "\u6ca1\u6709\u6743\u9650\u6539\u53d8") + channel2 + I18NMessage.get(DocumentService.class, "DocumentService.label41", "\u4e0b\u6587\u6863\u7684\u72b6\u6001\uff01"));
        }
        this.m_oDocumentMgr.changeStatus(document, channel2, status);
    }

    public Appendixes getAppendixes(com.trs.components.wcm.content.persistent.Document document) throws WCMException {
        return this.getAppendixes(document, -1);
    }

    public Appendixes getAppendixes(com.trs.components.wcm.content.persistent.Document document, int n) throws WCMException {
        return this.getAppendixes(document, n, null);
    }

    public Appendixes getAppendixes(com.trs.components.wcm.content.persistent.Document document, int n, WCMFilter wCMFilter) throws WCMException {
        AppendixMgr appendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
        return appendixMgr.getAppendixes(document, n, wCMFilter);
    }

    public Appendixes getAppendixes(com.trs.components.wcm.content.persistent.Document document, WCMFilter wCMFilter) throws WCMException {
        return this.m_oAppendixMgr.getAppendixes(document, wCMFilter);
    }

    public Documents getRelatedDocuments(com.trs.components.wcm.content.persistent.Document document, int n, WCMFilter wCMFilter, boolean bl, boolean bl2) throws WCMException {
        return this.m_oDocumentMgr.getRelatedDocuments(document, n, wCMFilter, bl, bl2);
    }

    public Documents getRelatedDocuments(com.trs.components.wcm.content.persistent.Document document, int n) throws WCMException {
        return this.getRelatedDocuments(document, n, null);
    }

    public Documents getRelatedDocuments(com.trs.components.wcm.content.persistent.Document document, int n, WCMFilter wCMFilter) throws WCMException {
        return this.getRelatedDocuments(document, n, wCMFilter, true, false);
    }

    public com.trs.components.wcm.content.persistent.Document recoverDocument(DocBak docBak, com.trs.components.wcm.content.persistent.Document document) throws WCMException {
        if (docBak == null || document == null) {
            throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label42", "\u6587\u6863\u5907\u4efd\u6216\u8005\u6587\u6863\u65e0\u6548\uff0c\u65e0\u6cd5\u4ece\u5907\u4efd\u6062\u590d\u6587\u6863!"));
        }
        if (!this.validateRight(this.getLoginUser(), document, 32)) {
            throw new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label43", "\u5bf9\u4e0d\u8d77,\u4f60\u65e0\u6743\u4fee\u6539\u6587\u6863!"));
        }
        DocBakMgr docBakMgr = (DocBakMgr)DreamFactory.createObjectById("DocBakMgr");
        return docBakMgr.recoverDocument(docBak, document);
    }

    public DocBak backup(com.trs.components.wcm.content.persistent.Document document) throws WCMException {
        if (!this.validateRight(this.getLoginUser(), document, 32)) {
            throw new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label44", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u5907\u4efd\u8be5\u6587\u6863!"));
        }
        return this.m_oDocBakMgr.bakupDocument(document);
    }

    public void deleteDocBak(int n) throws WCMException {
        DocBak docBak = (DocBak)DocBak.findById(n);
        if (docBak == null) {
            throw new WCMException(200006, I18NMessage.get(DocumentService.class, "DocumentService.label45", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a[id=") + n + I18NMessage.get(DocumentService.class, "DocumentService.label46", "]\u7684\u6587\u6863\u7248\u672c\uff01"));
        }
        this.deleteDocBak(docBak);
    }

    public void deleteDocBaks(String string) throws WCMException {
        DocBaks docBaks = DocBaks.findByIds(this.getLoginUser(), string);
        if (docBaks.isEmpty()) {
            return;
        }
        this.deleteDocBaks(docBaks);
    }

    public void deleteDocBaks(DocBaks docBaks) throws WCMException {
        if (docBaks == null || docBaks.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label47", "\u65e0\u6548\u7684\u6587\u6863\u7248\u672c\u96c6\u5408,\u6ca1\u6709\u9700\u8981\u5220\u9664\u7684\u6587\u6863\u7248\u672c!"));
        }
        for (int i = 0; i < docBaks.size(); ++i) {
            DocBak docBak = (DocBak)docBaks.getAt(i);
            if (docBak == null) continue;
            this.deleteDocBak(docBak);
        }
    }

    public void deleteDocBak(DocBak docBak) throws WCMException {
        if (docBak == null) {
            throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label48", "\u65e0\u6548\u7684\u6587\u6863\u7248\u672c\u5bf9\u8c61,\u65e0\u6cd5\u5220\u9664!"));
        }
        if (!this.validateRight(this.getLoginUser(), docBak.getDocument(), 32)) {
            throw new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label49", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u5220\u9664\u6587\u6863\u7248\u672c!"));
        }
        this.m_oDocBakMgr.deleteDocBak(docBak);
    }

    public User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public Channels getQuoteChannels(com.trs.components.wcm.content.persistent.Document document) throws WCMException {
        DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        return documentMgr.getQutoedChannels(document, 0, null);
    }

    public Channels getQuoteChannels(int n) throws WCMException {
        if (n <= 0) {
            throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label50", "\u65e0\u6548\u7684\u6587\u6863Id[") + n + "]");
        }
        com.trs.components.wcm.content.persistent.Document document = com.trs.components.wcm.content.persistent.Document.findById(n);
        if (document == null) {
            throw new WCMException(200006, I18NMessage.get(DocumentService.class, "DocumentService.label51", "\u6ca1\u6709\u627e\u5230\u6307\u5b9aId\u7684\u6587\u6863,\u65e0\u6cd5\u83b7\u53d6\u5f15\u7528\u8be5\u6587\u6863\u7684\u9891\u9053"));
        }
        return this.getQuoteChannels(document);
    }

    public void restore(com.trs.components.wcm.content.persistent.Document document, Channel channel) throws WCMException {
        if (!DocumentAuthServer.hasRight(this.getLoginUser(), (BaseChannel)channel, document, 33)) {
            throw new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label52", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u4ece\u56de\u6536\u7ad9\u4e2d\u6062\u590d\u6587\u6863!"));
        }
        this.m_oDocumentMgr.restore(document, channel);
    }

    public void restore(Documents documents) throws WCMException {
        if (documents == null || documents.isEmpty()) {
            return;
        }
        com.trs.components.wcm.content.persistent.Document document = null;
        for (int i = 0; i < documents.size(); ++i) {
            document = (com.trs.components.wcm.content.persistent.Document)documents.getAt(i);
            if (document == null) continue;
            this.restore(document, document.getChannel());
        }
    }

    public Reports restore(String string, int n) throws WCMException {
        Documents documents = Documents.findByIds(ContextHelper.getLoginUser(), string);
        if (documents == null || documents.isEmpty()) {
            throw new WCMException(I18NMessage.get(DocumentService.class, "DocumentService.label53", "\u6ca1\u6709\u8981\u6062\u590d\u7684\u6587\u6863\uff01"));
        }
        Channel channel = null;
        if (n > 0 && (channel = Channel.findById(n)) == null) {
            throw new WCMException(I18NMessage.get(DocumentService.class, "DocumentService.label54", "\u9891\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6062\u590d\u6587\u6863\uff01"));
        }
        Reports reports = new Reports(I18NMessage.get(DocumentService.class, "DocumentService.label55", "\u6062\u590d\u6587\u6863."));
        for (int i = 0; i < documents.size(); ++i) {
            com.trs.components.wcm.content.persistent.Document document = (com.trs.components.wcm.content.persistent.Document)documents.getAt(i);
            if (document == null) {
                m_oLogger.debug((Object)I18NMessage.get(DocumentService.class, "DocumentService.label56", "\u6062\u590d\u6587\u6863\u65f6\u53d1\u73b0\u6709\u4e00\u7bc7\u4e3a\u7a7a\uff01"));
                reports.addWarnedReport(I18NMessage.get(DocumentService.class, "DocumentService.label57", "\u6062\u590d\u6587\u6863\u65f6\u53d1\u73b0\u6709\u4e00\u7bc7\u4e3a\u7a7a"), null);
                continue;
            }
            try {
                this.restore(document, channel);
                reports.addSucessedReport(I18NMessage.get(DocumentService.class, "DocumentService.label58", "\u6210\u529f\u6062\u590d\u4e00\u7bc7\u6587\u6863\uff01\u6587\u6863\u6807\u9898\uff1a") + document.getTitle());
                continue;
            }
            catch (WCMException wCMException) {
                reports.addFailedReport(I18NMessage.get(DocumentService.class, "DocumentService.label59", "\u6062\u590d\u6587\u6863\u5931\u8d25\uff01"), wCMException);
            }
        }
        return reports;
    }

    public Relations getRelations(com.trs.components.wcm.content.persistent.Document document) throws WCMException {
        if (document == null) {
            return null;
        }
        RelationMgr relationMgr = (RelationMgr)DreamFactory.createObjectById("RelationMgr");
        return relationMgr.getRelations(document);
    }

    public int getMaxToppedNum() {
        return this.m_oDocumentMgr.getMaxToppedNum();
    }

    public Documents getToppedDocuments(Channel channel, WCMFilter wCMFilter) throws WCMException {
        return this.m_oDocumentMgr.getToppedDocuments(channel, wCMFilter);
    }

    public boolean isDocumentTopped(com.trs.components.wcm.content.persistent.Document document, Channel channel) throws WCMException {
        DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        return documentMgr.isDocumentTopped(document, channel);
    }

    public void setTopDocument(com.trs.components.wcm.content.persistent.Document document, Channel channel, int n, CMyDateTime cMyDateTime) throws WCMException {
        if (!this.validateRight(this.getLoginUser(), channel, 32)) {
            throw new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label60", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u5bf9\u6b64\u6587\u6863\u8fdb\u884c\u7f6e\u9876\u8bbe\u7f6e!"));
        }
        DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        documentMgr.setTopedDocument(document, channel, n, cMyDateTime);
    }

    public void removeToppedDocument(com.trs.components.wcm.content.persistent.Document document, Channel channel) throws WCMException {
        if (!this.validateRight(this.getLoginUser(), channel, 32)) {
            throw new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label61", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u7f16\u8f91\u6b64\u6587\u6863!"));
        }
        DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        documentMgr.removeToppedDocument(channel, document);
    }

    public int getTopPosition(com.trs.components.wcm.content.persistent.Document document, Channel channel) throws WCMException {
        DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        return documentMgr.getTopPosition(channel, document);
    }

    public boolean isDocumentTopScheduled(com.trs.components.wcm.content.persistent.Document document, Channel channel) throws WCMException {
        DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        DocumentPriMgr documentPriMgr = (DocumentPriMgr)DreamFactory.createObjectById("DocumentPriMgr");
        return documentPriMgr.findSchedule(documentMgr.findChnlDoc(document, channel)) != null;
    }

    public CMyDateTime getTopTime(com.trs.components.wcm.content.persistent.Document document, Channel channel) throws WCMException {
        DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        return documentMgr.getDocumentTopTime(document, channel);
    }

    public void moveForward(int n, int n2) throws WCMException {
        ChnlDoc chnlDoc = this.m_oDocumentMgr.getPreviousChnlDoc(this.m_oDocumentMgr.findChnlDoc(com.trs.components.wcm.content.persistent.Document.findById(n), Channel.findById(n2)), false);
        if (chnlDoc == null) {
            return;
        }
        this.moveDocumentInChannel(n, chnlDoc.getDocId(), n2);
    }

    public void moveBackward(int n, int n2) throws WCMException {
        ChnlDoc chnlDoc = this.m_oDocumentMgr.getNextChnlDoc(this.m_oDocumentMgr.findChnlDoc(com.trs.components.wcm.content.persistent.Document.findById(n), Channel.findById(n2)), false);
        if (chnlDoc == null) {
            return;
        }
        this.moveDocumentInChannel(n, chnlDoc.getDocId(), n2);
    }

    public void moveFirst(int n, int n2) throws WCMException {
        ChnlDoc chnlDoc = this.m_oDocumentMgr.getFirstChnlDoc(this.m_oDocumentMgr.findChnlDoc(com.trs.components.wcm.content.persistent.Document.findById(n), Channel.findById(n2)), false);
        if (chnlDoc == null) {
            return;
        }
        this.moveDocumentInChannel(n, chnlDoc.getDocId(), n2);
    }

    public void moveLast(int n, int n2) throws WCMException {
        ChnlDoc chnlDoc = this.m_oDocumentMgr.getLastChnlDoc(this.m_oDocumentMgr.findChnlDoc(com.trs.components.wcm.content.persistent.Document.findById(n), Channel.findById(n2)), false);
        if (chnlDoc == null) {
            return;
        }
        this.moveDocumentInChannel(n, chnlDoc.getDocId(), n2, 0);
    }

    public void moveDocumentInChannel(int n, int n2, int n3) throws WCMException {
        this.moveDocumentInChannel(n, n2, n3, 1);
    }

    public void moveDocumentInChannel(int n, int n2, int n3, int n4) throws WCMException {
        com.trs.components.wcm.content.persistent.Document document = com.trs.components.wcm.content.persistent.Document.findById(n);
        if (document == null) {
            throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label62", "\u6e90\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539\u987a\u5e8f\uff01"));
        }
        if (!this.validateRight(this.getLoginUser(), document, 80)) {
            throw new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label63", "\u5bf9\u4e0d\u8d77,\u60a8\u6682\u65f6\u65e0\u6743\u4fee\u6539\u6e90\u6587\u6863!"));
        }
        this.m_oDocumentMgr.moveDocumentInChannel(com.trs.components.wcm.content.persistent.Document.findById(n), com.trs.components.wcm.content.persistent.Document.findById(n2), Channel.findById(n3), n4);
    }

    public void mirrorTo(com.trs.components.wcm.content.persistent.Document document, Channel channel) throws WCMException {
        if (!this.validateRight(this.getLoginUser(), document, 34)) {
            throw new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label64", "\u4f60\u65e0\u6743\u5efa\u7acb\u6587\u6863\u955c\u50cf\uff1a") + document.getTitle());
        }
        DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        documentMgr.mirrorTo(document, channel);
    }

    public Channels getMirrorChannels(com.trs.components.wcm.content.persistent.Document document) throws WCMException {
        DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        return documentMgr.getQutoedChannels(document, 3, null);
    }

    public Channels getChannels(com.trs.components.wcm.content.persistent.Document document) throws WCMException {
        DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        return documentMgr.getQutoedChannels(document, 0, null);
    }

    public boolean delete(ChnlDocs chnlDocs, boolean bl) throws WCMException {
        if (chnlDocs == null) {
            throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label65", "\u9891\u9053\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        for (int i = 0; i < chnlDocs.size(); ++i) {
            ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(i);
            if (chnlDoc == null) {
                m_oLogger.error((Object)I18NMessage.get(DocumentService.class, "DocumentService.label66", "\u5220\u9664\u9891\u9053\u6587\u6863\u65f6\uff0c\u6709\u4e00\u7bc7\u9891\u9053\u6587\u6863\u4e3a\u7a7a\uff01"));
                continue;
            }
            this.delete(chnlDoc.getDocument(), chnlDoc.getChannel(), bl);
        }
        return true;
    }

    public String getLoginUserName() {
        return ContextHelper.getLoginUser().getName();
    }

    public String export(com.trs.components.wcm.content.persistent.Document document, String string, boolean bl) throws WCMException {
        return this.getExporter().export(document, string, bl);
    }

    public String export(int n, String string, boolean bl) throws WCMException {
        return this.getExporter().export(n, string, bl);
    }

    public String export(String string, String string2, boolean bl) throws WCMException {
        return this.export(Documents.findByIds(this.getLoginUser(), string), string2, bl);
    }

    public String export(Documents documents, String string, boolean bl) throws WCMException {
        int n = documents.size();
        for (int i = 0; i < n; ++i) {
            com.trs.components.wcm.content.persistent.Document document = (com.trs.components.wcm.content.persistent.Document)documents.getAt(i);
            if (document == null || this.validateRight(this.getLoginUser(), document, 34)) continue;
            throw new WCMException("[" + this.getLoginUser() + I18NMessage.get(DocumentService.class, "DocumentService.label67", "]\u4e0d\u80fd\u67e5\u770b[") + document + I18NMessage.get(DocumentService.class, "DocumentService.label68", "]\u7684\u8be6\u7ec6\u4fe1\u606f\uff0c\u6240\u4ee5\u4e0d\u80fd\u5bfc\u51fa\uff01"));
        }
        return this.getExporter().export(documents, string, bl);
    }

    public String export(String string, String string2, boolean bl, boolean bl2) throws WCMException {
        User user = this.getLoginUser();
        String string3 = string2;
        if (bl2) {
            ExtendedFields extendedFields = new ExtendedFields(user);
            WCMFilter wCMFilter = new WCMFilter("", "TableName=?", "EXTFIELDID asc", "EXTFIELDID,FIELDNAME");
            wCMFilter.addSearchValues(0, "WCMDOCUMENT");
            extendedFields.open(wCMFilter);
            StringBuffer stringBuffer = new StringBuffer(256);
            if (!CMyString.isEmpty(string3)) {
                stringBuffer.append(string3).append(",");
            }
            ExtendedField extendedField = null;
            int n = extendedFields.size();
            for (int i = 0; i < n; ++i) {
                extendedField = (ExtendedField)extendedFields.getAt(i);
                if (extendedField == null) continue;
                stringBuffer.append(extendedField.getName());
                stringBuffer.append(",");
            }
            string3 = stringBuffer.substring(0, stringBuffer.length() - 1);
        }
        return this.export(string, string3, bl);
    }

    private DocumentExporter getExporter() {
        return (DocumentExporter)DreamFactory.createObjectById("DocumentExporter");
    }

    public Reports quoteTo(com.trs.components.wcm.content.persistent.Document document, String string) throws WCMException {
        if (document == null) {
            throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label69", "\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u5176\u5f15\u7528\uff01"));
        }
        Reports reports = new Reports(I18NMessage.get(DocumentService.class, "DocumentService.label70", "\u5f15\u7528") + document);
        try {
            this.m_oDocumentMgr.deleteDocQuotes(document, string);
        }
        catch (WCMException wCMException) {
            reports.addFailedReport(I18NMessage.get(DocumentService.class, "DocumentService.label71", "\u5220\u9664\u4e0d\u518d\u4f7f\u7528\u7684\u5f15\u7528\u5173\u7cfb\u65f6\u53d1\u751f\u9519\u8bef\uff01"), wCMException);
            return reports;
        }
        Channels channels = Channels.findByIds(ContextHelper.getLoginUser(), string);
        if (channels == null || channels.isEmpty()) {
            reports.addWarnedReport(I18NMessage.get(DocumentService.class, "DocumentService.label72", "\u76ee\u6807\u9891\u9053\u4e3a\u7a7a\uff0c\u6ca1\u6709\u6267\u884c\u5f15\u7528\u7684\u64cd\u4f5c\uff01"), null);
            return reports;
        }
        for (int i = 0; i < channels.size(); ++i) {
            Channel channel = (Channel)channels.getAt(i);
            Reports reports2 = this.quoteTo(document, document.getChannel(), channel);
            reports.merge(reports2);
        }
        return reports;
    }

    private Reports quoteTo(com.trs.components.wcm.content.persistent.Document document, Channel channel, Channel channel2) {
        Reports reports = new Reports(I18NMessage.get(DocumentService.class, "DocumentService.label73", "\u5f15\u7528\u6587\u6863."));
        if (channel2 == null) {
            reports.addWarnedReport(I18NMessage.get(DocumentService.class, "DocumentService.label74", "\u5f15\u7528\u6587\u6863\u65f6\uff0c\u4e00\u4e2a\u76ee\u6807\u9891\u9053\u4e3a\u7a7a\uff01\u7ee7\u7eed\u6267\u884c\u3002"), null);
            return reports;
        }
        try {
            if (!DocumentAuthServer.hasRight(this.getLoginUser(), (BaseChannel)channel, document, 34) || !this.validateRight(this.getLoginUser(), channel2, 31)) {
                reports.addFailedReport(document + I18NMessage.get(DocumentService.class, "DocumentService.label75", "]\u5f15\u7528\u5931\u8d25!"), new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label76", "\u5bf9\u4e0d\u8d77,\u60a8\u6682\u65f6\u65e0\u6743\u5f15\u7528\u6587\u6863!")));
                return reports;
            }
        }
        catch (WCMException wCMException) {
            reports.addFailedReport(I18NMessage.get(DocumentService.class, "DocumentService.label77", "\u6821\u9a8c\u5f15\u7528\u6587\u6863[") + document.getTitle() + I18NMessage.get(DocumentService.class, "DocumentService.label78", "]\u6743\u9650\u65f6\u53d1\u751f\u5f02\u5e38\uff01"), wCMException);
            return reports;
        }
        try {
            if (ChnlDoc.findByDocAndChnl(document, channel2) != null) {
                reports.addSucessedReport(document + I18NMessage.get(DocumentService.class, "DocumentService.label79", "\u5df2\u5728") + channel2 + I18NMessage.get(DocumentService.class, "DocumentService.label80", "\u4e0b\u5b58\u5728\u5f15\u7528\u5173\u7cfb!"));
            } else {
                this.m_oDocumentMgr.quoteTo(document, channel2);
                reports.addSucessedReport(document + I18NMessage.get(DocumentService.class, "DocumentService.label81", "\u5f15\u7528\u6210\u529f!"));
            }
        }
        catch (WCMException wCMException) {
            reports.addFailedReport(document + I18NMessage.get(DocumentService.class, "DocumentService.label82", "\u5f15\u7528\u5230") + channel2 + I18NMessage.get(DocumentService.class, "DocumentService.label83", "\u5931\u8d25\uff01"), wCMException);
        }
        return reports;
    }

    public Reports quoteTo(String string, int n, String string2) throws WCMException {
        return this.transmitTo(string, n, string2, 3);
    }

    public Reports copyTo(String string, int n, String string2) throws WCMException {
        return this.transmitTo(string, n, string2, 1);
    }

    public Reports moveTo(String string, int n, String string2) throws WCMException {
        return this.transmitTo(string, n, string2, 2);
    }

    public Reports copyTo(String string, String string2) throws WCMException {
        return this.transmitTo(string, string2, 1);
    }

    public Reports moveTo(String string, String string2) throws WCMException {
        return this.transmitTo(string, string2, 2);
    }

    public Reports quoteTo(String string, String string2) throws WCMException {
        return this.transmitTo(string, string2, 3);
    }

    public Reports mirrorTo(String string, String string2) throws WCMException {
        return this.transmitTo(string, string2, 4);
    }

    private Reports transmitTo(String string, String string2, int n) throws WCMException {
        int n2;
        if (n < 1 || n > 4) {
            throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label84", "\u64cd\u4f5c\u7c7b\u578b\u53c2\u6570[") + n + I18NMessage.get(DocumentService.class, "DocumentService.label85", "]\u65e0\u6548\uff01"));
        }
        String string3 = TRANSMIT_TYPE_TEXT[n - 1];
        Reports reports = new Reports(string3 + I18NMessage.get(DocumentService.class, "DocumentService.label86", "\u6587\u6863."));
        if (string == null || string.trim().length() == 0) {
            throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label87", "\u6e90\u9891\u9053\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5") + string3 + "\uff01");
        }
        if (string2 == null || string2.trim().length() == 0) {
            throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label88", "\u76ee\u6807\u9891\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5") + string3 + "\uff01 ");
        }
        ChnlDocs chnlDocs = ChnlDocs.findByIds(ContextHelper.getLoginUser(), string);
        if (chnlDocs == null || chnlDocs.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label87", "\u6e90\u9891\u9053\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5") + string3 + "\uff01");
        }
        for (int i = 0; i < chnlDocs.size(); ++i) {
            if (chnlDocs.getAt(i) != null) continue;
            reports.addFailedReport(string3 + I18NMessage.get(DocumentService.class, "DocumentService.label89", "\u8fc7\u7a0b\u4e2d\u6709\u4e00\u7bc7\u6e90\u9891\u9053\u6587\u6863\u4e3a\u7a7a\uff01"), null);
            chnlDocs.remove(chnlDocs.getAt(i), false);
        }
        Channels channels = Channels.findByIds(ContextHelper.getLoginUser(), string2);
        if (channels == null || channels.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label88", "\u76ee\u6807\u9891\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5") + string3 + "\uff01 ");
        }
        for (n2 = 0; n2 < channels.size(); ++n2) {
            if (channels.getAt(n2) != null) continue;
            reports.addFailedReport(string3 + I18NMessage.get(DocumentService.class, "DocumentService.label90", "\u8fc7\u7a0b\u4e2d\u6709\u4e00\u4e2a\u76ee\u6807\u9891\u9053\u4e3a\u7a7a\uff01"), null);
            channels.remove(channels.getAt(n2), false);
        }
        for (n2 = chnlDocs.size() - 1; n2 >= 0; --n2) {
            ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(n2);
            block9: for (int i = 0; i < channels.size(); ++i) {
                Channel channel = (Channel)channels.getAt(i);
                switch (n) {
                    case 1: {
                        reports.merge(this.copyTo(chnlDoc.getDocument(), chnlDoc.getChannel(), channel));
                        continue block9;
                    }
                    case 2: {
                        reports.merge(this.moveTo(chnlDoc.getDocument(), chnlDoc.getChannel(), channel));
                        continue block9;
                    }
                    case 3: {
                        reports.merge(this.quoteTo(chnlDoc.getDocument(), chnlDoc.getChannel(), channel));
                        continue block9;
                    }
                    case 4: {
                        reports.merge(this.mirroTo(chnlDoc.getDocument(), chnlDoc.getChannel(), channel));
                        continue block9;
                    }
                    default: {
                        reports.addFailedReport(I18NMessage.get(DocumentService.class, "DocumentService.label91", "\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\uff01"), null);
                    }
                }
            }
        }
        return reports;
    }

    private Reports mirroTo(com.trs.components.wcm.content.persistent.Document document, Channel channel, Channel channel2) {
        Reports reports = new Reports(I18NMessage.get(DocumentService.class, "DocumentService.label92", "\u955c\u50cf\u5f15\u7528\u6587\u6863."));
        if (channel2 == null) {
            reports.addWarnedReport(I18NMessage.get(DocumentService.class, "DocumentService.label93", "\u955c\u50cf\u5f15\u7528\u6587\u6863\u65f6\uff0c\u4e00\u4e2a\u76ee\u6807\u9891\u9053\u4e3a\u7a7a\uff01\u7ee7\u7eed\u6267\u884c\u3002"), null);
            return reports;
        }
        try {
            if (!DocumentAuthServer.hasRight(this.getLoginUser(), (BaseChannel)channel, document, 34) || !this.validateRight(this.getLoginUser(), channel2, 31)) {
                reports.addFailedReport(document + I18NMessage.get(DocumentService.class, "DocumentService.label94", "\u955c\u50cf\u5f15\u7528\u5931\u8d25!"), new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label95", "\u5bf9\u4e0d\u8d77,\u60a8\u6682\u65f6\u65e0\u6743\u955c\u50cf\u5f15\u7528\u6587\u6863!")));
                return reports;
            }
        }
        catch (WCMException wCMException) {
            reports.addFailedReport(I18NMessage.get(DocumentService.class, "DocumentService.label96", "\u6821\u9a8c\u955c\u50cf\u5f15\u7528\u6587\u6863[") + document.getTitle() + I18NMessage.get(DocumentService.class, "DocumentService.label78", "]\u6743\u9650\u65f6\u53d1\u751f\u5f02\u5e38\uff01"), wCMException);
            return reports;
        }
        try {
            if (ChnlDoc.findByDocAndChnl(document, channel2) != null) {
                reports.addSucessedReport(document + I18NMessage.get(DocumentService.class, "DocumentService.label79", "\u5df2\u5728") + channel2 + I18NMessage.get(DocumentService.class, "DocumentService.label80", "\u4e0b\u5b58\u5728\u5f15\u7528\u5173\u7cfb!"));
                return reports;
            }
            this.m_oDocumentMgr.mirrorTo(document, channel2);
            reports.addSucessedReport(document + I18NMessage.get(DocumentService.class, "DocumentService.label97", "\u6210\u529f\u5f15\u7528\u5230\u4e86") + channel2);
        }
        catch (WCMException wCMException) {
            reports.addFailedReport(document + I18NMessage.get(DocumentService.class, "DocumentService.label98", "\u6587\u6863\u5f15\u7528\u5230") + channel2 + I18NMessage.get(DocumentService.class, "DocumentService.label83", "\u5931\u8d25\uff01"), wCMException);
        }
        return reports;
    }

    public Reports mirrorTo(String string, int n, String string2) throws WCMException {
        return this.transmitTo(string, n, string2, 4);
    }

    private Reports transmitTo(String string, int n, String string2, int n2) throws WCMException {
        Documents documents;
        Channels channels;
        Channel channel;
        Reports reports;
        String string3;
        block21: {
            block20: {
                if (n2 < 1 || n2 > 4) {
                    throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label84", "\u64cd\u4f5c\u7c7b\u578b\u53c2\u6570[") + n2 + I18NMessage.get(DocumentService.class, "DocumentService.label85", "]\u65e0\u6548\uff01"));
                }
                string3 = TRANSMIT_TYPE_TEXT[n2 - 1];
                reports = new Reports(string3 + I18NMessage.get(DocumentService.class, "DocumentService.label86", "\u6587\u6863."));
                if (string2 == null || string2.trim().length() == 0) {
                    reports.addWarnedReport(I18NMessage.get(DocumentService.class, "DocumentService.label99", "\u6b32") + string3 + I18NMessage.get(DocumentService.class, "DocumentService.label100", "\u7684\u76ee\u6807\u9891\u9053Id\u5e8f\u5217\u4e3a\u7a7a\uff01"), null);
                    return reports;
                }
                channel = null;
                if (n > 0 && (channel = Channel.findById(n)) == null) {
                    throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label101", "\u6307\u5b9a\u9891\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c") + string3 + I18NMessage.get(DocumentService.class, "DocumentService.label102", "\u64cd\u4f5c\uff01"));
                }
                channels = Channels.findByIds(ContextHelper.getLoginUser(), string2);
                if (channels == null || channels.isEmpty()) {
                    reports.addWarnedReport(I18NMessage.get(DocumentService.class, "DocumentService.label103", "\u6ca1\u6709\u8981") + string3 + I18NMessage.get(DocumentService.class, "DocumentService.label104", "\u7684\u76ee\u6807\u9891\u9053\uff01"), null);
                    return reports;
                }
                documents = null;
                if (string != null && string.trim().length() != 0) break block20;
                if (channel == null) {
                    throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label99", "\u6b32") + string3 + I18NMessage.get(DocumentService.class, "DocumentService.label105", "\u7684\u6587\u6863Id\u5e8f\u5217\u4e3a\u7a7a\uff01"));
                }
                switch (n2) {
                    case 2: {
                        return this.moveAllDocuments(reports, channel, channels);
                    }
                    case 1: {
                        documents = this.m_oDocumentMgr.getDocuments(channel, null);
                        break block21;
                    }
                    default: {
                        throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label99", "\u6b32") + string3 + I18NMessage.get(DocumentService.class, "DocumentService.label105", "\u7684\u6587\u6863Id\u5e8f\u5217\u4e3a\u7a7a\uff01"));
                    }
                }
            }
            if (n == 0 || n == -2 || n == -1) {
                documents = Documents.findByIds(this.getLoginUser(), string);
            } else {
                WCMFilter wCMFilter = new WCMFilter("", "DocId IN(" + string + ")", "");
                documents = this.m_oDocumentMgr.getDocuments(channel, wCMFilter);
            }
        }
        if (documents == null || documents.isEmpty()) {
            reports.addWarnedReport(I18NMessage.get(DocumentService.class, "DocumentService.label103", "\u6ca1\u6709\u8981") + string3 + I18NMessage.get(DocumentService.class, "DocumentService.label106", "\u7684\u6587\u6863\uff01"), null);
            return reports;
        }
        for (int i = documents.size() - 1; i >= 0; --i) {
            com.trs.components.wcm.content.persistent.Document document = (com.trs.components.wcm.content.persistent.Document)documents.getAt(i);
            block11: for (int j = 0; j < channels.size(); ++j) {
                Channel channel2 = (Channel)channels.getAt(j);
                switch (n2) {
                    case 1: {
                        reports.merge(this.copyTo(document, channel, channel2));
                        continue block11;
                    }
                    case 2: {
                        reports.merge(this.moveTo(document, channel, channel2));
                        continue block11;
                    }
                    case 3: {
                        reports.merge(this.quoteTo(document, channel, channel2));
                        continue block11;
                    }
                    case 4: {
                        reports.merge(this.mirroTo(document, channel, channel2));
                        continue block11;
                    }
                    default: {
                        reports.addFailedReport(I18NMessage.get(DocumentService.class, "DocumentService.label91", "\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\uff01"), null);
                    }
                }
            }
        }
        return reports;
    }

    private Reports moveAllDocuments(Reports reports, Channel channel, Channels channels) throws WCMException {
        if (!this.validateRight(this.getLoginUser(), channel, 56)) {
            reports.addFailedReport(I18NMessage.get(DocumentService.class, "DocumentService.label107", "\u60a8\u65e0\u6743\u79fb\u52a8") + channel + I18NMessage.get(DocumentService.class, "DocumentService.label108", "\u7684\u6587\u6863!"), null);
            return reports;
        }
        int n = channels.size();
        for (int i = 0; i < n; ++i) {
            Channel channel2 = (Channel)channels.getAt(i);
            if (channel2 == null) continue;
            if (!this.validateRight(this.getLoginUser(), channel2, 31)) {
                reports.addFailedReport(I18NMessage.get(DocumentService.class, "DocumentService.label109", "\u60a8\u65e0\u6743\u5f80") + channel2 + I18NMessage.get(DocumentService.class, "DocumentService.label110", "\u6dfb\u52a0\u6587\u6863!"), null);
                return reports;
            }
            this.m_oDocumentMgr.moveAllDocumentsToChannel(channel, channel2);
            reports.addSucessedReport(I18NMessage.get(DocumentService.class, "DocumentService.label111", "\u6210\u529f\u79fb\u52a8\u9891\u9053[") + channel.getName() + I18NMessage.get(DocumentService.class, "DocumentService.label112", "]\u7684\u5168\u90e8\u6587\u6863\u5230\u6307\u5b9a\u9891\u9053[") + channel2.getName() + "]");
        }
        return reports;
    }

    public ChnlDoc findChnldoc(int n, int n2) throws WCMException {
        return this.m_oDocumentMgr.findChnlDoc(com.trs.components.wcm.content.persistent.Document.findById(n), Channel.findById(n2));
    }

    public Documents getRecycleDocuments(BaseChannel baseChannel, WCMFilter wCMFilter) throws WCMException {
        if (baseChannel == null) {
            throw new WCMException(200006, I18NMessage.get(DocumentService.class, "DocumentService.label113", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u9891\u9053"));
        }
        return this.m_oDocumentMgr.getRecycleDocuments(baseChannel, wCMFilter);
    }

    public Documents getAllRelatedDocumentsByKeywords(String string, int n, WCMFilter wCMFilter) throws WCMException {
        return this.m_oDocKeywordMgr.getAllRelatedDocumentsByKeywords(string, n, wCMFilter);
    }

    public com.trs.components.wcm.content.persistent.Document saveInfoViewDocument(com.trs.components.wcm.content.persistent.Document document, Document document2) throws WCMException {
        return this.saveInfoViewDocument(document, document2, new HashMap(0));
    }

    public com.trs.components.wcm.content.persistent.Document saveInfoViewDocument(com.trs.components.wcm.content.persistent.Document document, Document document2, String string) throws WCMException {
        Map map = WCMProcessServiceHelper.makeFlowContextInfoMap(string);
        return this.saveInfoViewDocument(document, document2, map);
    }

    public com.trs.components.wcm.content.persistent.Document saveInfoViewDocument(com.trs.components.wcm.content.persistent.Document document, InfoView infoView, Map map) throws WCMException {
        String string;
        if (document == null || map == null || infoView == null) {
            throw new WCMException(20, I18NMessage.get(DocumentService.class, "DocumentService.label114", "\u65e0\u6548\u7684\u6587\u6863\u5bf9\u8c61[null],\u65e0\u6cd5\u4fdd\u5b58!"));
        }
        document.setFlag(infoView.getId());
        Channel channel = document.getChannel();
        if (channel == null) {
            throw new WCMException(20, I18NMessage.get(DocumentService.class, "DocumentService.label115", "\u6587\u6863\u7684\u6240\u5c5e\u9891\u9053\u4e0d\u5b58\u5728!"));
        }
        if (13 != channel.getType()) {
            throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label116", "\u8981\u4fdd\u5b58\u7684\u6587\u6863\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u8868\u5355\u6587\u6863!"));
        }
        InfoViewMgr infoViewMgr = (InfoViewMgr)DreamFactory.createObjectById("InfoViewMgr");
        String string2 = infoViewMgr.getAbsolutePath(infoView, infoView.getTemplateFile());
        Document document2 = InfoViewHelper.buildDOM4JDocument(string2);
        Element element = document2.getRootElement();
        this.fillDomData(element, map, null);
        String string3 = this.getInfoViewDataHelper().buildContent(infoView, document, document2);
        document.setHtmlContent(string3);
        document = this.saveInfoViewDocument(document, document2);
        IInfoViewService iInfoViewService = ServiceHelper.createInfoViewService();
        if (document.isAddMode() && infoView.hasDocSerial()) {
            Node node;
            string = iInfoViewService.getInfoViewSerial(infoView);
            document.setProperty("DOCNO", string);
            String string4 = infoView.getSerialField();
            if (!CMyString.isEmpty(string4) && (node = document2.selectSingleNode("//" + string4)) != null) {
                node.setText(string);
            }
        }
        if (CMyString.isEmpty(string = iInfoViewService.getDocumentTitle(infoView, document2))) {
            string = I18NMessage.get(DocumentService.class, "DocumentService.label117", "\u81ea\u5b9a\u4e49\u8868\u5355\u6570\u636e");
        }
        document.setTitle(string);
        this.m_oDocumentMgr.save(document);
        return document;
    }

    private void fillDomData(Element element, Map map, String string) {
        List list = element.elements();
        if (list.size() == 0) {
            if (string != null) {
                string = string + "/" + element.getName();
                string = string.replaceAll("/([^:]*:)?", "_");
            } else {
                string = element.getName().replaceAll("([^:]*:)?", "");
            }
            Object v = map.get(string);
            if (v != null) {
                element.clearContent();
                element.addCDATA(v.toString());
            }
        } else {
            for (Element element2 : list) {
                if (string != null) {
                    string = string + "/" + element2.getName();
                }
                this.fillDomData(element2, map, string);
            }
        }
    }

    public com.trs.components.wcm.content.persistent.Document saveInfoViewDocument(com.trs.components.wcm.content.persistent.Document document, Document document2, Map map) throws WCMException {
        if (document == null || document2 == null) {
            throw new WCMException(20, I18NMessage.get(DocumentService.class, "DocumentService.label114", "\u65e0\u6548\u7684\u6587\u6863\u5bf9\u8c61[null],\u65e0\u6cd5\u4fdd\u5b58!"));
        }
        Channel channel = document.getChannel();
        if (channel == null) {
            throw new WCMException(20, I18NMessage.get(DocumentService.class, "DocumentService.label115", "\u6587\u6863\u7684\u6240\u5c5e\u9891\u9053\u4e0d\u5b58\u5728!"));
        }
        if (13 != channel.getType()) {
            throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label116", "\u8981\u4fdd\u5b58\u7684\u6587\u6863\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u8868\u5355\u6587\u6863!"));
        }
        Document document3 = document2;
        IInfoViewService iInfoViewService = ServiceHelper.createInfoViewService();
        boolean bl = document.isAddMode();
        if (!bl) {
            document3 = this.recoverWithOldDoc(document3, iInfoViewService.getDOM4JDocument(document.getContent()));
        }
        List list = document3.selectNodes("//@trs_is_inline_file");
        List list2 = this.processAppendix(list, 10);
        List list3 = document3.selectNodes("//@trs_is_inline_image");
        List list4 = this.processAppendix(list3, 20);
        List list5 = document3.selectNodes("//@trs_is_linked_image");
        List list6 = this.processAppendix(list5, 40);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(list2);
        arrayList.addAll(list4);
        arrayList.addAll(list6);
        HashMap hashMap = new HashMap();
        if (document.getProperties() != null) {
            document.getProperties().remove(this.getInfoViewDataHelper().getKEY_DOM4J());
        }
        if (document.getNewProperties() != null) {
            document.getNewProperties().remove(this.getInfoViewDataHelper().getKEY_DOM4J());
        }
        document.setContent(document3.asXML());
        document = this.synInfoViewFieldValue(document);
        this.save(document, null, null, map, false);
        Appendixes appendixes = this.getAppendixes(document);
        Appendix appendix3 = null;
        HashMap<String, Appendix> hashMap2 = new HashMap<String, Appendix>();
        if (appendixes != null && appendixes.size() > 0) {
            for (int i = 0; i < appendixes.size(); ++i) {
                appendix3 = (Appendix)appendixes.getAt(i);
                if (appendix3 == null) continue;
                hashMap2.put(appendix3.getFile(), appendix3);
            }
        }
        User user = this.getLoginUser();
        int n = document.getId();
        Appendix appendix2 = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            appendix2 = (Appendix)arrayList.get(i);
            String string = appendix2.getFile();
            appendix3 = (Appendix)hashMap2.get(string);
            if (appendix3 != null) {
                appendix2 = appendix3;
                appendix2.canEdit(user);
                hashMap2.remove(string);
            } else {
                appendix2.setDocId(n);
            }
            appendix2.setUsedByVersion(document.getVersion(), true);
            appendix2.setSerialNo(i);
            appendix2.save(user);
        }
        Collection collection = hashMap2.values();
        for (Appendix appendix3 : collection) {
            if (hashMap.containsKey(appendix3.getFile())) continue;
            appendix3.delete(user);
        }
        arrayList.clear();
        if (bl) {
            try {
                WCMProcessServiceHelper.startDocumentInFlow(this.getLoginUser(), document, map);
            }
            catch (Throwable throwable) {
                ServiceInvocationException serviceInvocationException = new ServiceInvocationException(I18NMessage.get(DocumentService.class, "DocumentService.label120", "\u6587\u6863[") + document.getTitle() + "-" + document.getId() + I18NMessage.get(DocumentService.class, "DocumentService.label121", "]\u5df2\u7ecf\u4fdd\u5b58\u6210\u529f\uff0c\u4f46\u56e0\u60a8\u7684\u5de5\u4f5c\u6d41\u8bbe\u7f6e\u6709\u8bef\uff0c\u5c06\u5176\u6295\u5165\u6d41\u8f6c\u5931\u8d25\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u5de5\u4f5c\u6d41\uff0c\u4fee\u6b63\u540e\u5c06\u6587\u6863\u91cd\u65b0\u6295\u5165\u6d41\u8f6c\uff01"), throwable);
                serviceInvocationException.setErrorCode("17080");
                throw serviceInvocationException;
            }
        }
        return document;
    }

    private Document recoverWithOldDoc(Document document, Document document2) {
        Element element = document2.getRootElement();
        Element element2 = document.getRootElement();
        this.asynNode(element, element2);
        return document;
    }

    private void asynNode(Element element, Element element2) {
        List list = element.elements();
        if (list.size() == 0) {
            return;
        }
        for (Element element3 : list) {
            String string = element3.getName();
            Element element4 = element2.element(string);
            if (element4 != null) {
                this.asynNode(element3, element4);
                continue;
            }
            element2.add(element3.createCopy());
        }
    }

    private void recoverUnReadFields(Document document, com.trs.components.wcm.content.persistent.Document document2, Map map) throws WCMException {
        List list = document.selectNodes("//@trs_unreadable_field");
        for (Node node : list) {
            Element element = node.getParent();
            this.renderWithOldValue(element, document2, map);
        }
    }

    private void renderWithOldValue(Element element, com.trs.components.wcm.content.persistent.Document document, Map map) throws WCMException {
        block2: {
            List list;
            block1: {
                list = element.elements();
                if (list.size() != 0) break block1;
                String string = element.getName();
                if (string == null) break block2;
                String string2 = this.getInfoViewDataHelper().getFieldValue(document, string);
                element.clearContent();
                element.addCDATA(string2);
                if (map == null || string2 == null || !string2.startsWith("W0") && !string2.startsWith("P0")) break block2;
                map.put(string2, "");
                break block2;
            }
            for (Element element2 : list) {
                this.renderWithOldValue(element2, document, map);
            }
        }
    }

    public List processAppendix(List list, int n) throws WCMException {
        ArrayList<Appendix> arrayList = new ArrayList<Appendix>(list.size());
        Node node = null;
        String string = null;
        String string2 = null;
        Appendix appendix = null;
        Element element = null;
        String string3 = n == 20 ? "W0" : "P0";
        String string4 = null;
        for (int i = 0; i < list.size(); ++i) {
            node = (Node)list.get(i);
            element = node.getParent();
            string = element.getTextTrim();
            string2 = element.getName();
            string4 = element.attributeValue("FileName");
            node.detach();
            appendix = new Appendix();
            appendix.setFlag(n);
            appendix.setSrcFile(string);
            String string5 = string;
            if (n != 40) {
                string5 = this.processAppendixFile(string, string3);
                element.setText(string5);
            }
            appendix.setFile(string5);
            appendix.setFileExt(CMyFile.extractFileExt(string));
            appendix.setDesc(CMyString.showNull(string4, string));
            appendix.setRelatedColumn(string2);
            arrayList.add(appendix);
        }
        return arrayList;
    }

    private String processAppendixFile(String string, String string2) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        if (FilesMan.isValidFile(string, string2)) {
            return string;
        }
        return filesMan.copyWCMFile(string, string2);
    }

    private InfoViewDataHelper getInfoViewDataHelper() throws WCMException {
        InfoViewDataHelper infoViewDataHelper = (InfoViewDataHelper)DiscoveryFactoryBuddy.getImplementor(InfoViewDataHelper.class);
        if (infoViewDataHelper == null) {
            throw new WCMException(I18NMessage.get(DocumentService.class, "DocumentService.label119", "\u6ca1\u6709\u5b89\u88c5\u8868\u5355\u9009\u4ef6\uff01\u8bf7\u6b63\u786e\u5b89\u88c5\u540e\u518d\u4f7f\u7528\u8be5\u9009\u9879\u529f\u80fd\uff01"));
        }
        return infoViewDataHelper;
    }

    private boolean validateRight(User user, CMSObj cMSObj, int n) throws WCMException {
        return AuthServer.hasRight(user, cMSObj, n);
    }

    private com.trs.components.wcm.content.persistent.Document synInfoViewFieldValue(com.trs.components.wcm.content.persistent.Document document) throws WCMException {
        int n = document.getFlag();
        List list = InfoViewFieldValueCreatorFactory.createValueCreator(n);
        if (list == null) {
            return document;
        }
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            BaseInfoViewFieldValueCreator baseInfoViewFieldValueCreator = (BaseInfoViewFieldValueCreator)list.get(0);
            baseInfoViewFieldValueCreator.setDocument(document);
            baseInfoViewFieldValueCreator.createInfoviewXMLDataUpdator();
            baseInfoViewFieldValueCreator.setInfoViewFieldValueBeforeSaveDoc();
            baseInfoViewFieldValueCreator.updateDocument();
            document = baseInfoViewFieldValueCreator.getDocument();
        }
        return document;
    }
}

