/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.customize.CustomizeMgr;
import com.trs.components.wcm.customize.CustomizedChannelIdsMan;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.service.ICustomizeService;

public class CustomizeService
implements ICustomizeService {
    public User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public boolean hasCustomized() throws WCMException {
        CustomizeMgr customizeMgr = (CustomizeMgr)DreamFactory.createObjectById("CustomizeMgr");
        try {
            return customizeMgr.hasCustomized();
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(CustomizeService.class, "CustomizeService.label1", "\u7cfb\u7edf\u51fa\u73b0\u5f02\u5e38,\u65e0\u6cd5\u786e\u5b9a\u7528\u6237\u662f\u5426\u6709\u4e2a\u6027\u5b9a\u5236\u7684\u5185\u5bb9!"), exception);
        }
    }

    public boolean save(int n) throws WCMException {
        CustomizeMgr customizeMgr = (CustomizeMgr)DreamFactory.createObjectById("CustomizeMgr");
        return customizeMgr.save(n);
    }

    public boolean delete(int n) throws WCMException {
        CustomizeMgr customizeMgr = (CustomizeMgr)DreamFactory.createObjectById("CustomizeMgr");
        return customizeMgr.delete(n);
    }

    public int[] getMoudels() throws WCMException {
        CustomizeMgr customizeMgr = (CustomizeMgr)DreamFactory.createObjectById("CustomizeMgr");
        return customizeMgr.getMoudels();
    }

    public boolean saveChannels(String string) throws WCMException {
        this.setCustomizedChannels(string);
        return true;
    }

    public boolean deleteChannels(int[] nArray) throws WCMException {
        CustomizeMgr customizeMgr = (CustomizeMgr)DreamFactory.createObjectById("CustomizeMgr");
        return customizeMgr.deleteChannels(nArray);
    }

    public Channels getChannels() throws WCMException {
        return this.getChannels(64);
    }

    public Channels getChannels(int n) throws WCMException {
        CustomizeMgr customizeMgr = (CustomizeMgr)DreamFactory.createObjectById("CustomizeMgr");
        Channels channels = customizeMgr.getChannels();
        Channel channel = null;
        for (int i = channels.size() - 1; i >= 0; --i) {
            channel = (Channel)channels.getAt(i);
            if (channel == null || AuthServer.hasRight(this.getLoginUser(), (CMSObj)channel, n) && !channel.isDeleted()) continue;
            channels.remove(channel, false);
        }
        return channels;
    }

    public boolean saveSites(int[] nArray) throws WCMException {
        throw new WCMException(1100, I18NMessage.get(CustomizeService.class, "CustomizeService.label2", "\u65b9\u6cd5\u6ca1\u5b9e\u73b0!"));
    }

    public boolean deleteSites(int[] nArray) throws WCMException {
        throw new WCMException(1100, I18NMessage.get(CustomizeService.class, "CustomizeService.label2", "\u65b9\u6cd5\u6ca1\u5b9e\u73b0!"));
    }

    public WebSites getWebSites() throws WCMException {
        throw new WCMException(1100, I18NMessage.get(CustomizeService.class, "CustomizeService.label2", "\u65b9\u6cd5\u6ca1\u5b9e\u73b0!"));
    }

    public void setCustomizedChannels(String string) throws WCMException {
        if (string == null) {
            throw new WCMException(10, I18NMessage.get(CustomizeService.class, "CustomizeService.label3", "\u65e0\u6548\u7684\u9891\u9053Id\u5e8f\u5217!"));
        }
        CustomizedChannelIdsMan customizedChannelIdsMan = new CustomizedChannelIdsMan(this.getLoginUser());
        customizedChannelIdsMan.dowithIds(string);
    }
}

