/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.domain.AutoTransmitMgr;
import com.trs.components.wcm.content.domain.ChannelExporter;
import com.trs.components.wcm.content.domain.ChannelImporter;
import com.trs.components.wcm.content.domain.ChannelMgr;
import com.trs.components.wcm.content.domain.ContentExtFieldMgr;
import com.trs.components.wcm.content.domain.ContentLinkMgr;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.ReplaceMgr;
import com.trs.components.wcm.content.domain.SiteMemberIdsMan;
import com.trs.components.wcm.content.domain.SiteMemberMgr;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChannelSyn;
import com.trs.components.wcm.content.persistent.ChannelSyns;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ContentExtField;
import com.trs.components.wcm.content.persistent.ContentExtFields;
import com.trs.components.wcm.content.persistent.ContentLink;
import com.trs.components.wcm.content.persistent.ContentLinks;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.Replace;
import com.trs.components.wcm.content.persistent.Replaces;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.log.LogServer;
import com.trs.infra.util.DebugTimer;
import com.trs.infra.util.Report;
import com.trs.infra.util.Reports;
import com.trs.service.IChannelService;
import com.trs.service.IDocumentService;
import com.trs.service.ServiceHelper;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ChannelService
implements IChannelService {
    private static Logger logger = Logger.getLogger(ChannelService.class);

    public List getChildren(BaseChannel baseChannel, int n, int n2) throws WCMException {
        return this.getChildren(baseChannel, n, new int[]{n2});
    }

    public List getChildren(BaseChannel baseChannel, int n, int[] nArray) throws WCMException {
        if (baseChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label1", "\u9891\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u5f97\u5176\u5b50\u9891\u9053\uff01"));
        }
        List list = baseChannel.getChildren(ContextHelper.getLoginUser(), nArray);
        if (AuthServer.hasSuperRight(this.getLoginUser(), baseChannel)) {
            return list;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            BaseChannel baseChannel2 = (BaseChannel)list.get(i);
            if (baseChannel2 != null && this.isVisible(this.getLoginUser(), baseChannel2, n)) continue;
            list.remove(i);
        }
        return list;
    }

    public List getChildren(BaseChannel baseChannel, int n, int[] nArray, StringBuffer stringBuffer) throws WCMException {
        if (baseChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label1", "\u9891\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u5f97\u5176\u5b50\u9891\u9053\uff01"));
        }
        List list = baseChannel.getChildren(ContextHelper.getLoginUser(), nArray);
        if (AuthServer.hasSuperRight(this.getLoginUser(), baseChannel)) {
            return list;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            BaseChannel baseChannel2 = (BaseChannel)list.get(i);
            DebugTimer debugTimer = new DebugTimer();
            if (logger.isDebugEnabled()) {
                debugTimer.start();
            }
            if (baseChannel2 == null || !this.isVisible(this.getLoginUser(), baseChannel2, n)) {
                list.remove(i);
            }
            if (!logger.isDebugEnabled()) continue;
            debugTimer.stop();
            logger.debug((Object)(ContextHelper.getLoginUser() + " is visible on " + baseChannel2 + " use [" + debugTimer.getTime() + "]ms!"));
        }
        return list;
    }

    public List getChildren(BaseChannel baseChannel, int n) throws WCMException {
        return this.getChildren(baseChannel, n, -1);
    }

    public List getChildren(BaseChannel baseChannel) throws WCMException {
        return this.getChildren(baseChannel, 64);
    }

    public Channels getRecycleChannels(BaseChannel baseChannel) throws WCMException {
        return this.getRecycleChannels(baseChannel, null);
    }

    public Channels getRecycleChannels(BaseChannel baseChannel, WCMFilter wCMFilter) throws WCMException {
        return this.getChannelMgr().getRecycleChannels(baseChannel, wCMFilter);
    }

    public Documents getDocuments(int n) throws WCMException {
        return this.getDocuments(n, null);
    }

    public Documents getDocuments(int n, WCMFilter wCMFilter) throws WCMException {
        if (n <= 0) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label2", "\u65e0\u6548\u7684\u9891\u9053id[") + n + "]");
        }
        Channel channel = Channel.findById(n);
        if (channel == null) {
            throw new WCMException(200006, I18NMessage.get(ChannelService.class, "ChannelService.label3", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u9891\u9053"));
        }
        return this.getDocuments(channel, wCMFilter);
    }

    public Documents getDocuments(BaseChannel baseChannel) throws WCMException {
        return this.getDocuments(baseChannel, null);
    }

    public Documents getDocuments(BaseChannel baseChannel, WCMFilter wCMFilter) throws WCMException {
        DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        return documentMgr.getDocuments(baseChannel, wCMFilter);
    }

    public Documents getRecycleDocuments(int n) throws WCMException {
        return this.getRecycleDocuments(n, null);
    }

    public Documents getRecycleDocuments(int n, WCMFilter wCMFilter) throws WCMException {
        if (n <= 0) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label2", "\u65e0\u6548\u7684\u9891\u9053id[") + n + "]");
        }
        Channel channel = Channel.findById(n);
        if (channel == null) {
            throw new WCMException(200006, I18NMessage.get(ChannelService.class, "ChannelService.label3", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u9891\u9053"));
        }
        return this.getRecycleDocuments(channel, wCMFilter);
    }

    public Documents getRecycleDocuments(BaseChannel baseChannel, WCMFilter wCMFilter) throws WCMException {
        DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        return documentMgr.getRecycleDocuments(baseChannel, wCMFilter);
    }

    public boolean delete(String string, boolean bl) throws WCMException {
        if (string == null || string.length() <= 0) {
            return true;
        }
        Channels channels = Channels.findByIds(this.getLoginUser(), string);
        return this.delete(channels, bl);
    }

    public boolean delete(Channels channels, boolean bl) throws WCMException {
        if (channels == null || channels.isEmpty()) {
            return true;
        }
        for (int i = channels.size() - 1; i >= 0; --i) {
            BaseChannel baseChannel = (BaseChannel)channels.getAt(i);
            this.delete(baseChannel, bl);
        }
        return true;
    }

    public boolean delete(BaseChannel baseChannel, boolean bl) throws WCMException {
        if (baseChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label4", "\u65e0\u6548\u7684\u7ad9\u70b9/\u9891\u9053\u5bf9\u8c61"));
        }
        int n = 0;
        n = baseChannel.isSite() ? 2 : 12;
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)baseChannel, n)) {
            throw new WCMException(1002, I18NMessage.get(ChannelService.class, "ChannelService.label5", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u5220\u9664\u8be5\u7ad9\u70b9(\u9891\u9053)!"));
        }
        String string = I18NMessage.get(ChannelService.class, "ChannelService.label6", "\u5220\u9664") + baseChannel;
        String string2 = baseChannel.isSite() ? "SITE_DEL" : "CHANNEL_DEL";
        long l = LogServer.startRecord(this.getLoginUserName(), string2, string, baseChannel);
        try {
            this.getChannelMgr().delete(baseChannel, bl);
        }
        catch (WCMException wCMException) {
            LogServer.endRecordFailedOperation(l, null);
            throw new WCMException(1100, I18NMessage.get(ChannelService.class, "ChannelService.label7", "\u5220\u9664[") + baseChannel + I18NMessage.get(ChannelService.class, "ChannelService.label8", "]\u5931\u8d25!"), wCMException);
        }
        LogServer.endRecordSucceedOperation(l);
        return true;
    }

    public BaseChannel save(BaseChannel baseChannel) throws WCMException {
        if (baseChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label9", "\u9891\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\uff01"));
        }
        int n = 0;
        User user = this.getLoginUser();
        if (baseChannel.isSite()) {
            int n2 = n = baseChannel.isAddMode() ? 0 : 1;
            if (!AuthServer.hasRight(user, (CMSObj)baseChannel, n)) {
                throw new WCMException(1002, I18NMessage.get(ChannelService.class, "ChannelService.label10", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u4fdd\u5b58\u5f53\u524d\u7ad9\u70b9/\u9891\u9053!"));
            }
        } else {
            n = baseChannel.isAddMode() ? 11 : 13;
            BaseChannel baseChannel2 = baseChannel.getHost();
            if (baseChannel2 == null) {
                throw new WCMException(I18NMessage.get(ChannelService.class, "ChannelService.label11", "\u7236\u5bf9\u8c61\u6ca1\u6709\u8bbe\u7f6e\uff0c\u65e0\u6cd5\u5224\u65ad\u9891\u9053\u7684\u6743\u9650\uff01"));
            }
            if (!AuthServer.hasRight(user, (CMSObj)baseChannel, n) && !AuthServer.hasRight(user, (CMSObj)baseChannel2, n)) {
                throw new WCMException(1002, I18NMessage.get(ChannelService.class, "ChannelService.label10", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u4fdd\u5b58\u5f53\u524d\u7ad9\u70b9/\u9891\u9053!"));
            }
        }
        long l = LogServer.startRecord(user.getName(), this.getOperTypeNameForSave(baseChannel), I18NMessage.get(ChannelService.class, "ChannelService.label12", "\u4fdd\u5b58") + baseChannel, baseChannel);
        try {
            baseChannel = this.getChannelMgr().save(baseChannel);
        }
        catch (WCMException wCMException) {
            LogServer.endRecordFailedOperation(l, null);
            throw new WCMException(1100, I18NMessage.get(ChannelService.class, "ChannelService.label13", "\u4fdd\u5b58\u7ad9\u70b9/\u9891\u9053\u5931\u8d25!"), wCMException);
        }
        LogServer.endRecordSucceedOperation(l);
        return baseChannel;
    }

    private String getOperTypeNameForSave(BaseChannel baseChannel) {
        boolean bl = baseChannel.isAddMode();
        if (baseChannel.isSite()) {
            return bl ? "SITE_ADD" : "SITE_EDIT";
        }
        return bl ? "CHANNEL_ADD" : "CHANNEL_EDIT";
    }

    public Channels getSynSrcChannel(Channel channel) throws WCMException {
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)channel, 13)) {
            throw new WCMException(1002, I18NMessage.get(ChannelService.class, "ChannelService.label14", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u4fee\u6539\u9891\u9053\u7684\u6587\u6863\u5206\u53d1\u8bbe\u7f6e!"));
        }
        return this.getAutoTransmitMgr().getSynSrcChannels(channel);
    }

    public Channels getSynToChannel(Channel channel) throws WCMException {
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)channel, 13)) {
            throw new WCMException(1002, I18NMessage.get(ChannelService.class, "ChannelService.label14", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u4fee\u6539\u9891\u9053\u7684\u6587\u6863\u5206\u53d1\u8bbe\u7f6e!"));
        }
        return this.getAutoTransmitMgr().getSynToChannels(channel);
    }

    public Replace saveReplace(Replace replace) throws WCMException {
        ReplaceMgr replaceMgr = (ReplaceMgr)DreamFactory.createObjectById("ReplaceMgr");
        Replace replace2 = replace;
        String string = I18NMessage.get(ChannelService.class, "ChannelService.label15", "\u4fdd\u5b58:") + replace;
        String string2 = replace.isAddMode() ? "REPLACE_ADD" : "REPLACE_EDIT";
        long l = LogServer.startRecord(this.getLoginUserName(), string2, string, replace);
        try {
            replace2 = replaceMgr.save(replace);
        }
        catch (Throwable throwable) {
            LogServer.endRecordFailedOperation(l, throwable);
            throw new WCMException(1100, I18NMessage.get(ChannelService.class, "ChannelService.label16", "\u4fdd\u5b58\u66ff\u6362\u5185\u5bb9\u5931\u8d25!"), throwable);
        }
        LogServer.endRecordSucceedOperation(l);
        return replace2;
    }

    public boolean deleteReplace(Replace replace) throws WCMException {
        ReplaceMgr replaceMgr = (ReplaceMgr)DreamFactory.createObjectById("ReplaceMgr");
        boolean bl = false;
        String string = I18NMessage.get(ChannelService.class, "ChannelService.label17", "\u5220\u9664:") + replace;
        long l = LogServer.startRecord(this.getLoginUserName(), "REPLACE_DEL", string, replace);
        try {
            bl = replaceMgr.delete(replace);
        }
        catch (Throwable throwable) {
            LogServer.endRecordFailedOperation(l, throwable);
            throw new WCMException(1100, I18NMessage.get(ChannelService.class, "ChannelService.label18", "\u5220\u9664\u66ff\u6362\u5185\u5bb9\u5931\u8d25!"), throwable);
        }
        LogServer.endRecordSucceedOperation(l);
        return bl;
    }

    public boolean deleteReplace(Replaces replaces) throws WCMException {
        if (replaces == null || replaces.isEmpty()) {
            return true;
        }
        Replace replace = null;
        for (int i = 0; i < replaces.size(); ++i) {
            replace = (Replace)replaces.getAt(i);
            if (replace == null) continue;
            this.deleteReplace(replace);
        }
        return true;
    }

    public Replaces getReplaces(Channel channel, WCMFilter wCMFilter) throws WCMException {
        ReplaceMgr replaceMgr = (ReplaceMgr)DreamFactory.createObjectById("ReplaceMgr");
        return replaceMgr.getReplaces(channel, wCMFilter);
    }

    public void restore(BaseChannel baseChannel) throws WCMException {
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)baseChannel.getSite(), 1)) {
            throw new WCMException(1002, I18NMessage.get(ChannelService.class, "ChannelService.label19", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u6062\u590d\u6b64\u7ad9\u70b9/\u9891\u9053"));
        }
        String string = baseChannel.isSite() ? "SITE_RESTORE" : "CHANNEL_RESTORE";
        long l = LogServer.startRecord(this.getLoginUserName(), string, I18NMessage.get(ChannelService.class, "ChannelService.label20", "\u6062\u590d") + baseChannel, baseChannel);
        try {
            this.getChannelMgr().restore(baseChannel);
        }
        catch (WCMException wCMException) {
            LogServer.endRecordFailedOperation(l, wCMException);
            throw new WCMException(1100, I18NMessage.get(ChannelService.class, "ChannelService.label21", "\u6062\u590d\u7ad9\u70b9/\u9891\u9053\u5931\u8d25!"), wCMException);
        }
        LogServer.endRecordSucceedOperation(l);
    }

    public void restore(Channels channels) throws WCMException {
        if (channels == null || channels.isEmpty()) {
            return;
        }
        for (int i = channels.size() - 1; i >= 0; --i) {
            BaseChannel baseChannel = (BaseChannel)channels.getAt(i);
            this.restore(baseChannel);
        }
    }

    public void restore(WebSites webSites) throws WCMException {
        if (webSites == null || webSites.isEmpty()) {
            return;
        }
        for (int i = webSites.size() - 1; i >= 0; --i) {
            BaseChannel baseChannel = (BaseChannel)webSites.getAt(i);
            this.restore(baseChannel);
        }
    }

    public WebSites getWebSites(WCMFilter wCMFilter) throws WCMException {
        User user = this.getLoginUser();
        if (user == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label22", "\u65e0\u6548\u7684\u7528\u6237\u5bf9\u8c61!"));
        }
        return this.getSiteMemberMgr().getUserSites(user, wCMFilter);
    }

    public void moveTo(Channel channel, WebSite webSite, int n) throws WCMException {
        if (channel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label23", "\u6b32\u79fb\u52a8\u7684\u9891\u9053\u4e3a\u7a7a\uff01"));
        }
        if (webSite == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label24", "\u76ee\u6807\u7ad9\u70b9\u4e3a\u7a7a\uff01"));
        }
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)channel, 12)) {
            throw new WCMException(1002, I18NMessage.get(ChannelService.class, "ChannelService.label25", "\u60a8\u6682\u65f6\u65e0\u6cd5\u79fb\u52a8\u9891\u9053\uff1a") + channel.getName());
        }
        String string = I18NMessage.get(ChannelService.class, "ChannelService.label26", "\u79fb\u52a8[") + channel + I18NMessage.get(ChannelService.class, "ChannelService.label27", "]\u81f3[") + webSite + "]";
        long l = LogServer.startRecord(this.getLoginUserName(), "CHANNEL_MOVE", string, channel);
        try {
            this.getChannelMgr().moveTo(channel, webSite, n);
        }
        catch (WCMException wCMException) {
            LogServer.endRecordFailedOperation(l, null);
            throw new WCMException(1100, I18NMessage.get(ChannelService.class, "ChannelService.label28", "\u79fb\u52a8\u9891\u9053\u5931\u8d25!"), wCMException);
        }
        LogServer.endRecordSucceedOperation(l);
    }

    public void moveTo(Channel channel, Channel channel2, int n) throws WCMException {
        if (channel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label23", "\u6b32\u79fb\u52a8\u7684\u9891\u9053\u4e3a\u7a7a\uff01"));
        }
        if (channel2 == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label29", "\u76ee\u6807\u9891\u9053\u4e3a\u7a7a\uff01"));
        }
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)channel, 12)) {
            throw new WCMException(1002, I18NMessage.get(ChannelService.class, "ChannelService.label25", "\u60a8\u6682\u65f6\u65e0\u6cd5\u79fb\u52a8\u9891\u9053\uff1a") + channel.getName());
        }
        String string = I18NMessage.get(ChannelService.class, "ChannelService.label26", "\u79fb\u52a8[") + channel + "]";
        long l = LogServer.startRecord(this.getLoginUserName(), "CHANNEL_MOVE", string, channel);
        try {
            this.getChannelMgr().moveTo(channel, channel2, n);
        }
        catch (WCMException wCMException) {
            LogServer.endRecordFailedOperation(l, null);
            throw wCMException;
        }
        LogServer.endRecordSucceedOperation(l);
    }

    public void moveTo(WebSite webSite, WebSite webSite2, int n) throws WCMException {
        throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label30", "\u7cfb\u7edf\u6682\u65f6\u4e0d\u652f\u6301\u7ad9\u70b9\u7684\u79fb\u52a8\uff01"));
    }

    public WebSites getUserSites(User user, WCMFilter wCMFilter) throws WCMException {
        return this.getSiteMemberMgr().getUserSites(user, wCMFilter);
    }

    public Users getSiteUsers(WebSite webSite, WCMFilter wCMFilter) throws WCMException {
        return this.getSiteMemberMgr().getSiteUsers(webSite, wCMFilter);
    }

    public void addUsersToSite(String string, WebSite webSite) throws WCMException {
        this.checkDoSiteMemberRight(webSite);
        this.setSiteMembers(webSite, 204, string);
    }

    public void addSitesToUser(String string, User user) throws WCMException {
        WebSites webSites = WebSites.findByIds(this.getLoginUser(), string);
        for (int i = 0; i < webSites.size(); ++i) {
            WebSite webSite = (WebSite)webSites.getAt(i);
            if (webSite == null) continue;
            this.checkDoSiteMemberRight(webSite);
            this.getSiteMemberMgr().addSiteUser(webSite, user);
        }
    }

    public void removeUsersFromSite(String string, WebSite webSite) throws WCMException {
        this.checkDoSiteMemberRight(webSite);
        Users users = Users.findByIds(this.getLoginUser(), string);
        for (int i = 0; i < users.size(); ++i) {
            User user = (User)users.getAt(i);
            if (user == null) continue;
            this.getSiteMemberMgr().removeSiteUser(webSite, user);
        }
    }

    public void removeSitesFromUser(String string, User user) throws WCMException {
        WebSites webSites = WebSites.findByIds(this.getLoginUser(), string);
        for (int i = 0; i < webSites.size(); ++i) {
            WebSite webSite = (WebSite)webSites.getAt(i);
            if (webSite == null) continue;
            this.checkDoSiteMemberRight(webSite);
            this.getSiteMemberMgr().removeSiteUser(webSite, user);
        }
    }

    private ChannelMgr getChannelMgr() {
        return (ChannelMgr)DreamFactory.createObjectById("ChannelMgr");
    }

    private void checkDoSiteMemberRight(WebSite webSite) throws WCMException {
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)webSite, 6)) {
            throw new WCMException(1002, I18NMessage.get(ChannelService.class, "ChannelService.label31", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u5728") + webSite + I18NMessage.get(ChannelService.class, "ChannelService.label32", "\u4e0a\u8fdb\u884c\u7528\u6237/\u7ec4\u7ec7\u7684\u6dfb\u52a0\u4e0e\u5220\u9664."));
        }
    }

    public boolean isVisible(User user, BaseChannel baseChannel) throws WCMException {
        return this.isVisible(user, baseChannel, 64);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVisible(User user, BaseChannel baseChannel, int n) throws WCMException {
        DebugTimer debugTimer;
        block11: {
            block10: {
                boolean bl;
                if (user == null) {
                    return false;
                }
                debugTimer = new DebugTimer();
                if (logger.isDebugEnabled()) {
                    debugTimer.start();
                    logger.debug((Object)(user + " is visisble on " + baseChannel));
                }
                try {
                    if (!baseChannel.isSite()) break block10;
                    bl = this.getSiteMemberMgr().isBelongToSite(user, (WebSite)baseChannel);
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    if (logger.isDebugEnabled()) {
                        debugTimer.stop();
                        logger.debug((Object)(user + " is visisble on " + baseChannel + " use [" + debugTimer.getTime() + "]ms"));
                    }
                    throw throwable;
                }
                if (logger.isDebugEnabled()) {
                    debugTimer.stop();
                    logger.debug((Object)(user + " is visisble on " + baseChannel + " use [" + debugTimer.getTime() + "]ms"));
                }
                return bl;
            }
            if (!AuthServer.hasRightOnSelf(user, baseChannel, n)) break block11;
            boolean bl = true;
            Object var7_8 = null;
            if (logger.isDebugEnabled()) {
                debugTimer.stop();
                logger.debug((Object)(user + " is visisble on " + baseChannel + " use [" + debugTimer.getTime() + "]ms"));
            }
            return bl;
        }
        Object var7_9 = null;
        if (logger.isDebugEnabled()) {
            debugTimer.stop();
            logger.debug((Object)(user + " is visisble on " + baseChannel + " use [" + debugTimer.getTime() + "]ms"));
        }
        return false;
    }

    public Reports importFromFile(String string, String string2, BaseChannel baseChannel) throws WCMException {
        ChannelImporter channelImporter = (ChannelImporter)DreamFactory.createObjectById("ChannelImporter");
        long l = 0L;
        String string3 = null;
        String string4 = null;
        BaseObj baseObj = null;
        if (baseChannel == null) {
            string3 = "SITE_IMPORT";
            string4 = I18NMessage.get(ChannelService.class, "ChannelService.label33", "\u5bfc\u5165\u7ad9\u70b9");
            baseObj = new BaseObj(){

                public int getWCMType() {
                    return 100;
                }

                public String getDbTableName() {
                    return null;
                }

                public String getIdFieldName() {
                    return null;
                }

                public boolean isValid() {
                    return false;
                }

                public String toString() {
                    return I18NMessage.get(ChannelService.class, "ChannelService.label34", "\u7cfb\u7edf");
                }
            };
        } else {
            string3 = "CHANNEL_IMPORT";
            string4 = I18NMessage.get(ChannelService.class, "ChannelService.label35", "\u5bfc\u5165\u9891\u9053");
            baseObj = baseChannel;
        }
        l = LogServer.startRecord(this.getLoginUserName(), string3, string4, baseObj);
        Reports reports = new Reports("");
        try {
            reports = channelImporter.importFromFile(string, string2, baseChannel);
        }
        catch (WCMException wCMException) {
            LogServer.endRecordFailedOperation(l, wCMException);
            reports.addFailedReport(string4 + I18NMessage.get(ChannelService.class, "ChannelService.label36", "\u5931\u8d25"), wCMException);
            throw new WCMException(1100, I18NMessage.get(ChannelService.class, "ChannelService.label75", "") + string4 + I18NMessage.get(ChannelService.class, "ChannelService.label37", "\u5931\u8d25!"), wCMException);
        }
        LogServer.endRecordSucceedOperation(l);
        return reports;
    }

    public String export(BaseChannel baseChannel, boolean bl, boolean bl2) throws WCMException {
        if (baseChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label38", "\u8981\u5bfc\u51fa\u7684\u7ad9\u70b9/\u9891\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5bfc\u51fa\uff01"));
        }
        ChannelExporter channelExporter = (ChannelExporter)DreamFactory.createObjectById("ChannelExporter");
        return channelExporter.export(baseChannel, bl, bl2);
    }

    public String export(WebSites webSites, boolean bl, boolean bl2) throws WCMException {
        if (webSites == null || webSites.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label39", "\u8981\u5bfc\u51fa\u7684\u7ad9\u70b9\u96c6\u5408\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5bfc\u51fa\uff01"));
        }
        ChannelExporter channelExporter = (ChannelExporter)DreamFactory.createObjectById("ChannelExporter");
        return channelExporter.export(webSites, bl, bl2);
    }

    public String export(Channels channels, boolean bl, boolean bl2) throws WCMException {
        if (channels == null || channels.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label40", "\u8981\u5bfc\u51fa\u7684\u9891\u9053\u96c6\u5408\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5bfc\u51fa\uff01"));
        }
        ChannelExporter channelExporter = (ChannelExporter)DreamFactory.createObjectById("ChannelExporter");
        return channelExporter.export(channels, bl, bl2);
    }

    public String exportChannels(String string, boolean bl, boolean bl2) throws WCMException {
        if (string == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label40", "\u8981\u5bfc\u51fa\u7684\u9891\u9053\u96c6\u5408\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5bfc\u51fa\uff01"));
        }
        Channels channels = Channels.findByIds(ContextHelper.getLoginUser(), string);
        return this.export(channels, bl, bl2);
    }

    public String exportSites(String string, boolean bl, boolean bl2) throws WCMException {
        if (string == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label39", "\u8981\u5bfc\u51fa\u7684\u7ad9\u70b9\u96c6\u5408\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5bfc\u51fa\uff01"));
        }
        WebSites webSites = WebSites.findByIds(ContextHelper.getLoginUser(), string);
        if (webSites == null || webSites.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label39", "\u8981\u5bfc\u51fa\u7684\u7ad9\u70b9\u96c6\u5408\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5bfc\u51fa\uff01"));
        }
        return this.export(webSites, bl, bl2);
    }

    public ContentLinks getContentLinks(WebSite webSite, WCMFilter wCMFilter) throws WCMException {
        return this.getContentLinkMgr().getContentLinks(webSite, wCMFilter);
    }

    public ContentLink saveContentLink(ContentLink contentLink) throws WCMException {
        WebSite webSite = contentLink.getSite();
        this.assertRightOnContentLink(webSite);
        String string = I18NMessage.get(ChannelService.class, "ChannelService.label15", "\u4fdd\u5b58:") + contentLink;
        String string2 = contentLink.isAddMode() ? "CONTENTLINK_ADD" : "CONTENTLINK_EDIT";
        long l = LogServer.startRecord(this.getLoginUserName(), string2, string, contentLink);
        ContentLink contentLink2 = contentLink;
        try {
            contentLink2 = this.getContentLinkMgr().save(contentLink);
        }
        catch (Throwable throwable) {
            LogServer.endRecordFailedOperation(l, throwable);
            throw new WCMException(1100, I18NMessage.get(ChannelService.class, "ChannelService.label41", "\u4fdd\u5b58\u5185\u5bb9\u8d85\u94fe\u63a5\u5931\u8d25!"), throwable);
        }
        LogServer.endRecordSucceedOperation(l);
        return contentLink2;
    }

    public void deleteContentLink(ContentLink contentLink) throws WCMException {
        String string = I18NMessage.get(ChannelService.class, "ChannelService.label17", "\u5220\u9664:") + contentLink;
        long l = LogServer.startRecord(this.getLoginUserName(), "CONTENTLINK_DEL", string, contentLink);
        try {
            this.getContentLinkMgr().delete(contentLink);
        }
        catch (Throwable throwable) {
            LogServer.endRecordFailedOperation(l, throwable);
            throw new WCMException(1100, I18NMessage.get(ChannelService.class, "ChannelService.label42", "\u5220\u9664\u5185\u5bb9\u8d85\u94fe\u63a5\u5931\u8d25!"), throwable);
        }
        LogServer.endRecordSucceedOperation(l);
    }

    public void deleteContentLinks(ContentLinks contentLinks) throws WCMException {
        if (contentLinks == null || contentLinks.isEmpty()) {
            return;
        }
        for (int i = 0; i < contentLinks.size(); ++i) {
            ContentLink contentLink = (ContentLink)contentLinks.getAt(i);
            if (contentLink == null) continue;
            this.deleteContentLink(contentLink);
        }
    }

    private ContentLinkMgr getContentLinkMgr() {
        return (ContentLinkMgr)DreamFactory.createObjectById("ContentLinkMgr");
    }

    private void assertRightOnContentLink(WebSite webSite) throws WCMException {
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)webSite, 1)) {
            throw new WCMException(1002, I18NMessage.get(ChannelService.class, "ChannelService.label43", "\u4f60\u65e0\u6743\u7ba1\u7406\u7ad9\u70b9\u7684\u5185\u5bb9\u8d85\u94fe\u63a5!"));
        }
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private String getLoginUserName() {
        return this.getLoginUser().getName();
    }

    private AutoTransmitMgr getAutoTransmitMgr() {
        return (AutoTransmitMgr)DreamFactory.createObjectById("AutoTransmitMgr");
    }

    public void deleteChannelSyn(int n) throws WCMException {
        ChannelSyn channelSyn = ChannelSyn.findById(n);
        if (channelSyn == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label44", "\u4f20\u5165\u53c2\u6570\u65e0\u6548\uff0c\u6ca1\u6709\u627e\u5230ID\u4e3a[") + n + I18NMessage.get(ChannelService.class, "ChannelService.label45", "]\u7684ChannelSyn\uff0c\u5220\u9664\u64cd\u4f5c\u4e2d\u6b62\uff01"));
        }
        this.getAutoTransmitMgr().delete(channelSyn);
    }

    public void deleteChannelSyns(String string) throws WCMException {
        if (string == null || string.trim().length() <= 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.deleteChannelSyn(Integer.parseInt(stringTokenizer.nextToken()));
        }
    }

    public ChannelSyns getChannelSyns(int n, WCMFilter wCMFilter) throws WCMException {
        Channel channel = Channel.findById(n);
        if (channel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label76", "\u4f20\u5165\u53c2\u6570\u65e0\u6548\uff0c\u6ca1\u6709\u627e\u5230ID\u4e3a[") + n + I18NMessage.get(ChannelService.class, "ChannelService.label46", "]\u7684\u9891\u9053\uff01"));
        }
        return this.getAutoTransmitMgr().getChannelSyns(channel, wCMFilter);
    }

    public ChannelSyns saveChannelSyns(ChannelSyn channelSyn, String string) throws WCMException {
        if (string == null || string.trim().length() <= 0) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label47", "\u4f20\u5165\u9891\u9053ID\u4e3a\u7a7a\uff0c\u5fc5\u987b\u6307\u5b9a\u63a5\u6536\u5206\u53d1\u7684\u9891\u9053\uff01"));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        ChannelSyns channelSyns = ChannelSyns.createNewInstance(this.getLoginUser());
        while (stringTokenizer.hasMoreTokens()) {
            ChannelSyn channelSyn2 = (ChannelSyn)channelSyn.cloneToNewObj();
            channelSyn2.setToChannelId(Integer.parseInt(stringTokenizer.nextToken()));
            channelSyn2 = this.saveChannelSyn(channelSyn2);
            channelSyns.addElement(channelSyn2);
        }
        return channelSyns;
    }

    public ChannelSyn saveChannelSyn(ChannelSyn channelSyn) throws WCMException {
        return this.getAutoTransmitMgr().save(channelSyn);
    }

    public WebSites getRecycleSites(WCMFilter wCMFilter) throws WCMException {
        return this.getChannelMgr().getRecycleSites(wCMFilter);
    }

    public Reports createFrom(int n, boolean bl) throws WCMException {
        WebSite webSite = WebSite.findById(n);
        if (webSite == null) {
            throw new WCMException(200006, I18NMessage.get(ChannelService.class, "ChannelService.label48", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u7ad9\u70b9,[id=") + n + "].");
        }
        return this.createFrom(webSite, bl);
    }

    public Reports createFrom(WebSite webSite, boolean bl) throws WCMException {
        if (webSite == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label49", "\u6ca1\u6709\u6307\u5b9a\u7c7b\u4f3c\u521b\u5efa\u7684\u6e90\u7ad9\u70b9!"));
        }
        long l = LogServer.startRecord(this.getLoginUserName(), "SITE_CREATEFROM", I18NMessage.get(ChannelService.class, "ChannelService.label50", "\u7c7b\u4f3c\u521b\u5efa\u7ad9\u70b9"), webSite);
        Reports reports = new Reports("");
        try {
            ChannelExporter channelExporter = (ChannelExporter)DreamFactory.createObjectById("ChannelExporter");
            String string = null;
            string = bl ? channelExporter.export(webSite, true, true) : channelExporter.export(webSite, true, false);
            ChannelImporter channelImporter = (ChannelImporter)DreamFactory.createObjectById("ChannelImporter");
            reports = channelImporter.importFromFile(string, null, null);
            reports.setTitle(I18NMessage.get(ChannelService.class, "ChannelService.label50", "\u7c7b\u4f3c\u521b\u5efa\u7ad9\u70b9"));
            List list = reports.getSucessedReporter();
            Report report = null;
            if (!list.isEmpty()) {
                report = (Report)list.get(0);
                report.setRportTitle(I18NMessage.get(ChannelService.class, "ChannelService.label51", "\u6210\u529f\u521b\u5efa\u7ad9\u70b9!"));
            } else {
                report = reports.getFailedReporterAt(0);
                report.setRportTitle(I18NMessage.get(ChannelService.class, "ChannelService.label52", "\u521b\u5efa\u7ad9\u70b9\u5931\u8d25!"));
            }
        }
        catch (WCMException wCMException) {
            LogServer.endRecordFailedOperation(l, wCMException);
            reports.addFailedReport(I18NMessage.get(ChannelService.class, "ChannelService.label53", "\u7c7b\u4f3c\u521b\u5efa\u7ad9\u70b9\u5931\u8d25"), wCMException);
            throw new WCMException(1100, I18NMessage.get(ChannelService.class, "ChannelService.label54", "\u7c7b\u4f3c\u521b\u5efa\u7ad9\u70b9\u5931\u8d25!"), wCMException);
        }
        LogServer.endRecordSucceedOperation(l);
        return reports;
    }

    public Reports createFrom(int n, BaseChannel baseChannel) throws WCMException {
        Channel channel = Channel.findById(n);
        if (channel == null) {
            throw new WCMException(200006, I18NMessage.get(ChannelService.class, "ChannelService.label55", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u9891\u9053,[id=") + n + "]!");
        }
        return this.createFrom(channel, baseChannel);
    }

    public Reports createFrom(Channel channel, BaseChannel baseChannel) throws WCMException {
        if (channel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label56", "\u6ca1\u6709\u6307\u5b9a\u7c7b\u4f3c\u521b\u5efa\u7684\u6e90\u9891\u9053!"));
        }
        if (baseChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label57", "\u6ca1\u6709\u6307\u5b9a\u65b0\u9891\u9053\u7684\u7236\u8282\u70b9!"));
        }
        long l = LogServer.startRecord(this.getLoginUserName(), "CHANNEL_CREATEFROM", I18NMessage.get(ChannelService.class, "ChannelService.label58", "\u7c7b\u4f3c\u521b\u5efa\u9891\u9053"), channel);
        Reports reports = new Reports("");
        try {
            ChannelExporter channelExporter = (ChannelExporter)DreamFactory.createObjectById("ChannelExporter");
            String string = channelExporter.export(channel, true, true);
            ChannelImporter channelImporter = (ChannelImporter)DreamFactory.createObjectById("ChannelImporter");
            reports = channelImporter.importFromFile(string, null, baseChannel);
            reports.setTitle(I18NMessage.get(ChannelService.class, "ChannelService.label58", "\u7c7b\u4f3c\u521b\u5efa\u9891\u9053"));
            List list = reports.getSucessedReporter();
            Report report = null;
            if (!list.isEmpty()) {
                report = (Report)list.get(0);
                report.setRportTitle(I18NMessage.get(ChannelService.class, "ChannelService.label59", "\u6210\u529f\u521b\u5efa\u9891\u9053!"));
            } else {
                report = reports.getFailedReporterAt(0);
                report.setRportTitle(I18NMessage.get(ChannelService.class, "ChannelService.label60", "\u521b\u5efa\u9891\u9053\u5931\u8d25!"));
            }
        }
        catch (WCMException wCMException) {
            LogServer.endRecordFailedOperation(l, wCMException);
            reports.addFailedReport(I18NMessage.get(ChannelService.class, "ChannelService.label61", "\u7c7b\u4f3c\u521b\u5efa\u9891\u9053\u5931\u8d25"), wCMException);
            throw new WCMException(1100, I18NMessage.get(ChannelService.class, "ChannelService.label62", "\u7c7b\u4f3c\u521b\u5efa\u9891\u9053\u5931\u8d25!"), wCMException);
        }
        LogServer.endRecordSucceedOperation(l);
        return reports;
    }

    private SiteMemberMgr getSiteMemberMgr() {
        return (SiteMemberMgr)DreamFactory.createObjectById("SiteMemberMgr");
    }

    public void addGroupsToSite(String string, WebSite webSite) throws WCMException {
        this.checkDoSiteMemberRight(webSite);
        this.setSiteMembers(webSite, 201, string);
    }

    public void addSitesToGroup(String string, Group group) throws WCMException {
        WebSites webSites = WebSites.findByIds(this.getLoginUser(), string);
        for (int i = 0; i < webSites.size(); ++i) {
            WebSite webSite = (WebSite)webSites.getAt(i);
            if (webSite == null) continue;
            this.checkDoSiteMemberRight(webSite);
            this.getSiteMemberMgr().addSiteGroup(webSite, group);
        }
    }

    public void removeGroupsFromSite(String string, WebSite webSite) throws WCMException {
        this.checkDoSiteMemberRight(webSite);
        Groups groups = Groups.findByIds(this.getLoginUser(), string);
        for (int i = 0; i < groups.size(); ++i) {
            Group group = (Group)groups.getAt(i);
            if (group == null) continue;
            this.getSiteMemberMgr().removeSiteGroup(webSite, group);
        }
    }

    public void removeSitesFromGroup(String string, Group group) throws WCMException {
        WebSites webSites = WebSites.findByIds(this.getLoginUser(), string);
        for (int i = 0; i < webSites.size(); ++i) {
            WebSite webSite = (WebSite)webSites.getAt(i);
            if (webSite == null) continue;
            this.checkDoSiteMemberRight(webSite);
            this.getSiteMemberMgr().removeSiteGroup(webSite, group);
        }
    }

    public Groups getSiteGroups(WebSite webSite, WCMFilter wCMFilter) throws WCMException {
        return this.getSiteMemberMgr().getSiteGroups(webSite, wCMFilter);
    }

    public Roles getSiteRoles(WebSite webSite, WCMFilter wCMFilter) throws WCMException {
        return this.getSiteMemberMgr().getSiteRoles(webSite, wCMFilter);
    }

    public ContentExtField saveExtField(BaseChannel baseChannel, ContentExtField contentExtField, boolean bl) throws WCMException {
        this.assertNotNull(baseChannel);
        this.assertEditRightOnBaseChannel(baseChannel);
        String string = I18NMessage.get(ChannelService.class, "ChannelService.label63", "\u4fdd\u5b58") + contentExtField;
        long l = LogServer.startRecord(this.getLoginUserName(), "EXTENTEDFIELD_EDIT", string, contentExtField);
        ContentExtField contentExtField2 = contentExtField;
        try {
            contentExtField2 = this.getExtFieldMgr().save(baseChannel, contentExtField2, bl);
        }
        catch (WCMException wCMException) {
            LogServer.endRecordFailedOperation(l, wCMException);
            throw new WCMException(1100, I18NMessage.get(ChannelService.class, "ChannelService.label64", "\u4fdd\u5b58\u6269\u5c55\u5b57\u6bb5\u5931\u8d25!"), wCMException);
        }
        LogServer.endRecordSucceedOperation(l);
        return contentExtField2;
    }

    public void deleteExtFields(BaseChannel baseChannel, String string, boolean bl) throws WCMException {
        if (this.emptyString(string)) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label65", "\u65e0\u6548\u7684Id\u5e8f\u5217!"));
        }
        ContentExtFields contentExtFields = ContentExtFields.findByIds(this.getLoginUser(), string);
        ContentExtField contentExtField = null;
        for (int i = 0; i < contentExtFields.size(); ++i) {
            contentExtField = (ContentExtField)contentExtFields.getAt(i);
            if (contentExtField == null) continue;
            this.deleteExtFiled(baseChannel, contentExtField, bl);
        }
    }

    public void deleteExtFiled(BaseChannel baseChannel, ContentExtField contentExtField, boolean bl) throws WCMException {
        this.assertNotNull(baseChannel);
        this.assertEditRightOnBaseChannel(baseChannel);
        this.assertCorrectData(baseChannel, contentExtField);
        String string = I18NMessage.get(ChannelService.class, "ChannelService.label7", "\u5220\u9664[") + contentExtField + "]";
        long l = LogServer.startRecord(this.getLoginUserName(), "EXTENTEDFIELD_DEL", string, contentExtField);
        try {
            this.getExtFieldMgr().delete(baseChannel, contentExtField, bl);
            LogServer.endRecordSucceedOperation(l);
        }
        catch (WCMException wCMException) {
            LogServer.endRecordFailedOperation(l, wCMException);
            throw wCMException;
        }
    }

    public ContentExtFields getExtFields(BaseChannel baseChannel, WCMFilter wCMFilter) throws WCMException {
        return this.getExtFieldMgr().getExtFields(baseChannel, wCMFilter);
    }

    private void assertCorrectData(BaseChannel baseChannel, ContentExtField contentExtField) throws WCMException {
        if (contentExtField.getObjId() != baseChannel.getId() || contentExtField.getObjType() != baseChannel.getWCMType()) {
            throw new WCMException(10, "[" + contentExtField + I18NMessage.get(ChannelService.class, "ChannelService.label66", "]\u4e0d\u662f[") + baseChannel + I18NMessage.get(ChannelService.class, "ChannelService.label67", "]\u4e0b\u7684\u6269\u5c55\u5b57\u6bb5"));
        }
    }

    private void assertNotNull(BaseChannel baseChannel) throws WCMException {
        if (baseChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label68", "\u6307\u5b9a\u7684\u7ad9\u70b9/\u9891\u9053\u65e0\u6548!"));
        }
    }

    private void assertEditRightOnBaseChannel(BaseChannel baseChannel) throws WCMException {
        int n = 19;
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)baseChannel, n)) {
            throw new WCMException(1002, I18NMessage.get(ChannelService.class, "ChannelService.label69", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u4fee\u6539[") + baseChannel + I18NMessage.get(ChannelService.class, "ChannelService.label70", "]\u7684\u6269\u5c55\u5b57\u6bb5!"));
        }
    }

    private boolean emptyString(String string) {
        return string == null || string.trim().length() == 0;
    }

    private ContentExtFieldMgr getExtFieldMgr() {
        return (ContentExtFieldMgr)DreamFactory.createObjectById("ContentExtFieldMgr");
    }

    public void setSiteMembers(int n, int n2, String string) throws WCMException {
        WebSite webSite = WebSite.findById(n);
        if (webSite == null) {
            throw new WCMException(200006, I18NMessage.get(ChannelService.class, "ChannelService.label71", "\u6ca1\u6709\u627e\u5230id\u4e3a[") + n + I18NMessage.get(ChannelService.class, "ChannelService.label72", "]\u7684\u7ad9\u70b9!"));
        }
        this.setSiteMembers(webSite, n2, string);
    }

    public void setSiteMembers(WebSite webSite, int n, String string) throws WCMException {
        this.assertNotNull(webSite);
        SiteMemberIdsMan siteMemberIdsMan = new SiteMemberIdsMan(webSite, n);
        siteMemberIdsMan.dowithIds(string);
    }

    public void addRolesToSite(String string, WebSite webSite) throws WCMException {
        this.setSiteMembers(webSite, 203, string);
    }

    public void removeRolesFromSite(String string, WebSite webSite) throws WCMException {
        this.checkDoSiteMemberRight(webSite);
        Roles roles = Roles.findByIds(this.getLoginUser(), string);
        Role role = null;
        for (int i = 0; i < roles.size(); ++i) {
            role = (Role)roles.getAt(i);
            if (role == null) continue;
            this.getSiteMemberMgr().removeSiteMember(webSite.getId(), 203, role.getId());
        }
    }

    public void emptyRecycleBin(int n) throws WCMException {
        Channel channel = Channel.findById(n);
        this.assertChannelNotFound(channel, n);
        Documents documents = this.getRecycleDocuments(channel, null);
        if (documents.isEmpty()) {
            return;
        }
        IDocumentService iDocumentService = ServiceHelper.createDocumentService();
        iDocumentService.delete(documents, channel, true);
    }

    public void restoreAllInRecycleBin(int n) throws WCMException {
        Channel channel = Channel.findById(n);
        this.assertChannelNotFound(channel, n);
        Documents documents = this.getRecycleDocuments(channel, null);
        if (documents.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label73", "\u6307\u5b9a\u7684\u9891\u9053\u56de\u6536\u7ad9\u4e2d\u6ca1\u6709\u6587\u6863!"));
        }
        IDocumentService iDocumentService = ServiceHelper.createDocumentService();
        iDocumentService.restore(documents.getIdListAsString(), n);
    }

    private void assertChannelNotFound(Channel channel, int n) throws WCMException {
        if (channel == null) {
            throw new WCMException(200006, I18NMessage.get(ChannelService.class, "ChannelService.label74", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u9891\u9053![id=") + n + "].");
        }
    }
}

