/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scene.tools;

import com.trs.scene.tools.SceneNode;
import com.trs.scene.tools.SceneNodeAction;
import com.trs.scene.tools.SceneNodeParser;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class SceneNodeToXML {
    public static String toXML(SceneNode sceneNode) throws Exception {
        Element element = DocumentHelper.createElement((String)"FDGraphModel");
        Element element2 = element.addElement("root");
        SceneNodeToXML.addDefaultContent(element2);
        SceneNodeToXML.createNodeXMLNode(element2, sceneNode, false);
        SceneNodeToXML.createNodeXMLNode(element2, sceneNode, true);
        return SceneNodeToXML.format(element);
    }

    private static void createNodeXMLNode(Element element, SceneNode sceneNode, boolean bl) throws Exception {
        ArrayList arrayList = sceneNode.getChildren();
        if (arrayList == null || arrayList.isEmpty()) {
            if (bl) {
                SceneNodeToXML.createOnlyShape(element, sceneNode);
            }
            return;
        }
        if (bl) {
            SceneNodeToXML.createOnlyRect(element, sceneNode);
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            ArrayList arrayList2;
            SceneNode sceneNode2 = (SceneNode)arrayList.get(i);
            if (!bl) {
                SceneNodeToXML.createOnlyConnector(element, sceneNode2);
            }
            if ((arrayList2 = sceneNode2.getChildren()) == null || arrayList2.isEmpty()) continue;
            SceneNodeToXML.createNodeXMLNode(element, (SceneNode)arrayList2.get(0), bl);
        }
    }

    private static void createOnlyConnector(Element element, SceneNode sceneNode) throws Exception {
        if (sceneNode == null) {
            return;
        }
        if (sceneNode.getType() != 3) {
            throw new Exception("\u6307\u5b9a\u7684\u8282\u70b9[" + sceneNode + "]\u4e0d\u662f\u8fde\u7ebf");
        }
        Element element2 = element.addElement("Connector");
        element2.addAttribute("label", sceneNode.getName());
        element2.addAttribute("id", String.valueOf(sceneNode.getId()));
        element2.addAttribute("condition", "");
        Element element3 = element2.addElement("FDCell");
        element3.addAttribute("edge", "1");
        element3.addAttribute("parent", "1");
        element3.addAttribute("source", String.valueOf(sceneNode.getParentId()));
        int n = sceneNode.getFirstChildId();
        if (n > 0) {
            element3.addAttribute("target", String.valueOf(sceneNode.getFirstChildId()));
        }
        Element element4 = element3.addElement("FDGeometry");
        element4.addAttribute("relative", "1");
        element4.addAttribute("as", "geometry");
        if (n <= 0) {
            Element element5 = element4.addElement("FDPoint");
            element5.addAttribute("x", String.valueOf(sceneNode.getPositionX()));
            element5.addAttribute("y", String.valueOf(sceneNode.getPositionY()));
            element5.addAttribute("as", "targetPoint");
        }
    }

    private static void createOnlyRect(Element element, SceneNode sceneNode) {
        Element element2 = element.addElement("Rect");
        element2.addAttribute("label", sceneNode.getName());
        element2.addAttribute("id", String.valueOf(sceneNode.getId()));
        Element element3 = element2.addElement("FDCell");
        element3.addAttribute("vertex", "1");
        element3.addAttribute("parent", "1");
        Element element4 = element3.addElement("FDGeometry");
        element4.addAttribute("x", String.valueOf(sceneNode.getPositionX()));
        element4.addAttribute("y", String.valueOf(sceneNode.getPositionY()));
        element4.addAttribute("width", String.valueOf(80));
        element4.addAttribute("height", String.valueOf(40));
        element4.addAttribute("as", "geometry");
    }

    private static void createOnlyShape(Element element, SceneNode sceneNode) {
        Element element2 = element.addElement("Shape");
        element2.addAttribute("label", sceneNode.getName());
        element2.addAttribute("id", String.valueOf(sceneNode.getId()));
        Element element3 = element2.addElement("FDCell");
        element3.addAttribute("style", "doubleEllipse");
        element3.addAttribute("vertex", "1");
        element3.addAttribute("parent", "1");
        Element element4 = element3.addElement("FDGeometry");
        element4.addAttribute("x", String.valueOf(sceneNode.getPositionX()));
        element4.addAttribute("y", String.valueOf(sceneNode.getPositionY()));
        element4.addAttribute("width", "60");
        element4.addAttribute("height", "60");
        element4.addAttribute("as", "geometry");
    }

    private static void addDefaultContent(Element element) {
        Element element2 = element.addElement("Diagram");
        element2.addAttribute("label", "\u81ea\u52a8\u4ea7\u751fDiagram");
        element2.addAttribute("id", "0");
        element2.addElement("FDCell");
        Element element3 = element.addElement("Layer");
        element3.addAttribute("label", "\u81ea\u52a8\u4ea7\u751fLayer");
        element3.addAttribute("id", "1");
        element3.addElement("FDCell").addAttribute("parent", "0");
    }

    public static String format(Element element) {
        StringWriter stringWriter = new StringWriter();
        OutputFormat outputFormat = OutputFormat.createPrettyPrint();
        outputFormat.setEncoding("GBK");
        XMLWriter xMLWriter = new XMLWriter((Writer)stringWriter, outputFormat);
        try {
            xMLWriter.write(element);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringWriter.toString();
    }

    public static void main(String[] stringArray) {
        String string = "c:\\\u573a\u666f\u5f0f\u670d\u52a1\u6279\u91cf\u521b\u5efa\\";
        try {
            File file = new File(string);
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                int n;
                File file2 = fileArray[i];
                String string2 = file2.getName();
                int n2 = string2.indexOf(46, n = string2.lastIndexOf(File.separatorChar));
                if (n2 < 0) continue;
                SceneNodeParser sceneNodeParser = new SceneNodeParser();
                SceneNode sceneNode = sceneNodeParser.importFormFileByName(file2.getAbsolutePath());
                SceneNodeAction sceneNodeAction = new SceneNodeAction(sceneNode);
                sceneNodeAction.confirmPosition(sceneNode);
                System.out.println(SceneNodeToXML.toXML(sceneNode));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

