/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scene.parser;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import com.trs.scene.parser.SceneConnector;
import com.trs.scene.parser.SceneNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class SceneXMLParser {
    private static Logger logger = Logger.getLogger(SceneXMLParser.class);
    private SceneNode m_oFirstNode = null;
    private String m_sXMLContent = null;

    public SceneXMLParser(String string) {
        this.m_sXMLContent = string;
    }

    public SceneNode parse() throws WCMException {
        Element element = null;
        try {
            element = DocumentHelper.parseText((String)this.m_sXMLContent).getRootElement().element("root");
        }
        catch (DocumentException documentException) {
            logger.error((Object)I18NMessage.get(SceneXMLParser.class, "SceneXMLParser.label1", "\u89e3\u6790XML\u51fa\u73b0\u5f02\u5e38\uff01"), (Throwable)documentException);
            logger.info((Object)"==========XML Content===========");
            logger.info((Object)this.m_sXMLContent);
            throw new WCMException(I18NMessage.get(SceneXMLParser.class, "SceneXMLParser.label1", "\u89e3\u6790XML\u51fa\u73b0\u5f02\u5e38\uff01"), documentException);
        }
        HashMap hashMap = this.makeNodes(element);
        if (hashMap.size() == 0) {
            throw new WCMException(I18NMessage.get(SceneXMLParser.class, "SceneXMLParser.label2", "\u6570\u636e\u9519\u8bef\uff0c\u6ca1\u6709\u4e00\u4e2a\u8282\u70b9\uff01"));
        }
        this.makeConnectors(element, hashMap);
        return this.m_oFirstNode;
    }

    private void makeConnectors(Element element, HashMap hashMap) throws WCMException {
        String string;
        Object object3;
        Object object2;
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        List list = element.elements("Connector");
        int n2 = list.size();
        if (n2 == 0) {
            throw new WCMException(I18NMessage.get(SceneXMLParser.class, "SceneXMLParser.label3", "\u6570\u636e\u6709\u8bef\uff0c\u8fde\u63a5\u5bf9\u8c61\u5728XML\u4e2d\u90fd\u4e0d\u5b58\u5728\uff1f"));
        }
        for (n = 0; n < n2; ++n) {
            Element element2;
            object2 = (Element)list.get(n);
            object3 = this.makeConnector((Element)object2);
            if (object3 == null || (element2 = object2.element("FDCell")) == null) continue;
            string = element2.attributeValue("source");
            if (CMyString.isEmpty(string)) {
                throw new WCMException(I18NMessage.get(SceneXMLParser.class, "SceneXMLParser.label4", "\u8fde\u7ebf\u6709\u8bef\uff0c\u6ca1\u6709\u8d77\u59cb\u8282\u70b9![\u8fde\u7ebf\u540d\u79f0=") + ((SceneConnector)object3).getName() + ", ID=" + ((SceneConnector)object3).getId() + "]");
            }
            int n3 = 0;
            try {
                n3 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            if (n3 <= 0) {
                throw new WCMException(I18NMessage.get(SceneXMLParser.class, "SceneXMLParser.label4", "\u8fde\u7ebf\u6709\u8bef\uff0c\u6ca1\u6709\u8d77\u59cb\u8282\u70b9![\u8fde\u7ebf\u540d\u79f0=") + ((SceneConnector)object3).getName() + ", ID=" + ((SceneConnector)object3).getId() + "]");
            }
            SceneNode sceneNode = (SceneNode)hashMap.get(new Integer(n3));
            if (sceneNode == null) continue;
            ((SceneConnector)object3).setPreNode(sceneNode);
            String string2 = element2.attributeValue("target");
            if (CMyString.isEmpty(string2)) {
                throw new WCMException(I18NMessage.get(SceneXMLParser.class, "SceneXMLParser.label5", "\u8fde\u7ebf\u6709\u8bef\uff0c\u6ca1\u6709\u76ee\u6807\u8282\u70b9![\u8fde\u7ebf\u540d\u79f0=") + ((SceneConnector)object3).getName() + ", ID=" + ((SceneConnector)object3).getId() + "]");
            }
            int n4 = 0;
            try {
                n4 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            if (n4 <= 0) {
                throw new WCMException(I18NMessage.get(SceneXMLParser.class, "SceneXMLParser.label5", "\u8fde\u7ebf\u6709\u8bef\uff0c\u6ca1\u6709\u76ee\u6807\u8282\u70b9![\u8fde\u7ebf\u540d\u79f0=") + ((SceneConnector)object3).getName() + ", ID=" + ((SceneConnector)object3).getId() + "]");
            }
            if (n3 == n4) {
                throw new WCMException(I18NMessage.get(SceneXMLParser.class, "SceneXMLParser.label6", "\u8fde\u7ebf\u6709\u8bef\uff0c\u8d77\u59cb\u548c\u7ed3\u675f\u4e00\u6837![\u8fde\u7ebf\u540d\u79f0=") + ((SceneConnector)object3).getName() + ", ID=" + ((SceneConnector)object3).getId() + "]");
            }
            Integer n5 = new Integer(n4);
            SceneNode sceneNode2 = (SceneNode)hashMap.get(n5);
            if (sceneNode2 == null) continue;
            ((SceneConnector)object3).setNextNode(sceneNode2);
            arrayList.add(n5);
            sceneNode.addNextConnector((SceneConnector)object3);
        }
        n = 0;
        for (Object object3 : hashMap.keySet()) {
            if (arrayList.contains(object3)) continue;
            ++n;
            this.m_oFirstNode = (SceneNode)hashMap.get(object3);
        }
        if (n == 0) {
            throw new WCMException(I18NMessage.get(SceneXMLParser.class, "SceneXMLParser.label7", "\u6ca1\u6709\u7b2c\u4e00\u4e2a\u8282\u70b9\u6709\u591a\u4e2a\uff1f[arNotFirstNodeIds=") + arrayList + "]");
        }
        if (n > 1) {
            object3 = new StringBuffer();
            object2 = hashMap.keySet().iterator();
            int n6 = 0;
            while (object2.hasNext()) {
                string = object2.next();
                if (arrayList.contains(string)) continue;
                SceneNode sceneNode = (SceneNode)hashMap.get(string);
                ((StringBuffer)object3).append(I18NMessage.get(SceneXMLParser.class, "SceneXMLParser.label8", "\u8282\u70b9") + ++n6 + I18NMessage.get(SceneXMLParser.class, "SceneXMLParser.label9", "\u540d\u79f0=[") + sceneNode.getName() + "] Id=[" + sceneNode.getId() + "]");
            }
            throw new WCMException(I18NMessage.get(SceneXMLParser.class, "SceneXMLParser.label10", "\u7b2c\u4e00\u4e2a\u8282\u70b9\u6709\u591a\u4e2a\uff1f[Count=") + n + "]" + object3);
        }
    }

    private HashMap makeNodes(Element element) {
        SceneNode sceneNode;
        List list = element.elements("Rect");
        int n = list.size();
        HashMap<Integer, SceneNode> hashMap = new HashMap<Integer, SceneNode>(n + 10);
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)list.get(i);
            sceneNode = this.makeNode(element2);
            if (sceneNode == null) continue;
            hashMap.put(sceneNode.getKey(), sceneNode);
        }
        List list2 = element.elements("Shape");
        n = list2.size();
        for (int i = 0; i < n; ++i) {
            sceneNode = (Element)list2.get(i);
            SceneNode sceneNode2 = this.makeNode((Element)sceneNode);
            if (sceneNode2 == null) continue;
            hashMap.put(sceneNode2.getKey(), sceneNode2);
        }
        return hashMap;
    }

    private SceneNode makeNode(Element element) {
        String string = element.attributeValue("id");
        if (CMyString.isEmpty(string)) {
            return null;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        String string2 = element.attributeValue("label");
        SceneNode sceneNode = new SceneNode(n, string2);
        return sceneNode;
    }

    private SceneConnector makeConnector(Element element) {
        String string = element.attributeValue("id");
        if (CMyString.isEmpty(string)) {
            return null;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        String string2 = element.attributeValue("label");
        SceneConnector sceneConnector = new SceneConnector(n, string2);
        return sceneConnector;
    }
}

