/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyFile;
import com.trs.presentation.util.AppAutoParameter;
import com.trs.presentation.util.Parameter;
import com.trs.presentation.util.Parameters;
import java.util.Hashtable;

public class AppAutoParameters
extends Parameters {
    private Hashtable m_hParametersCache = new Hashtable();
    private static AppAutoParameters m_oAppAutoParameters = null;

    public AppAutoParameters() {
    }

    public AppAutoParameters(int n) {
        super(n);
    }

    public Parameter createParameterInstance() {
        return new AppAutoParameter();
    }

    public static AppAutoParameters getAppAutoParameters(String string) throws WCMException {
        if (m_oAppAutoParameters != null) {
            return m_oAppAutoParameters;
        }
        return AppAutoParameters.loadAppAutoParameters(string);
    }

    private static synchronized AppAutoParameters loadAppAutoParameters(String string) throws WCMException {
        System.out.println("Load App Auto XML parameters [" + string + "]...");
        if (string == null || string.trim().length() <= 0) {
            throw new WCMException(10, I18NMessage.get(AppAutoParameters.class, "AppAutoParameters.label1", "\u6ca1\u6709\u6307\u5b9a\u914d\u7f6e\u6587\u4ef6\uff01"));
        }
        if (m_oAppAutoParameters != null) {
            return m_oAppAutoParameters;
        }
        AppAutoParameters appAutoParameters = new AppAutoParameters();
        appAutoParameters.loadParametersFromXML(string);
        m_oAppAutoParameters = appAutoParameters;
        return m_oAppAutoParameters;
    }

    public static synchronized AppAutoParameters reloadAppAutoParameters(String string) throws WCMException {
        if (string == null || string.trim().length() <= 0) {
            throw new WCMException(10, I18NMessage.get(AppAutoParameters.class, "AppAutoParameters.label2", "\u6ca1\u6709\u6307\u5b9a\u914d\u7f6e\u6587\u4ef6\u4fe1\u606f\uff01"));
        }
        m_oAppAutoParameters = null;
        return AppAutoParameters.loadAppAutoParameters(string);
    }

    public boolean add(Parameter parameter) {
        boolean bl = super.add(parameter);
        if (this.m_hParametersCache == null) {
            this.m_hParametersCache = new Hashtable(1);
        }
        this.m_hParametersCache.put(((AppAutoParameter)parameter).getName().toUpperCase(), parameter);
        return bl;
    }

    public AppAutoParameter getAppAutoParameterByName(String string) {
        if (this.m_hParametersCache == null) {
            return null;
        }
        return (AppAutoParameter)this.m_hParametersCache.get(string.toUpperCase());
    }

    public void toXMLFile(String string) throws WCMException {
        this.toXMLFile(string, "model", null);
    }

    public static void main(String[] stringArray) {
        try {
            AppAutoParameter appAutoParameter;
            String string = "c:\\wcm_application_auto_create.xml";
            if (!CMyFile.fileExists(string)) {
                throw new WCMException(10, I18NMessage.get(AppAutoParameters.class, "AppAutoParameters.label3", "\u914d\u7f6e\u6587\u4ef6[") + string + I18NMessage.get(AppAutoParameters.class, "AppAutoParameters.label4", "]\u4e0d\u5b58\u5728!"));
            }
            System.out.println(I18NMessage.get(AppAutoParameters.class, "AppAutoParameters.label5", "\u6d4b\u8bd5 loadParametersFromXML \u63a5\u53e3..."));
            AppAutoParameters appAutoParameters = AppAutoParameters.loadAppAutoParameters(string);
            System.out.println(appAutoParameters.toString());
            for (int i = 0; i < appAutoParameters.size(); ++i) {
                appAutoParameter = (AppAutoParameter)appAutoParameters.get(i);
                if (appAutoParameter == null) continue;
                System.out.println("Name:" + appAutoParameter.getName());
                System.out.println("Element:" + appAutoParameter.getElement());
                System.out.println("Elements:" + appAutoParameter.getElements());
                System.out.println("OutlineFields:" + appAutoParameter.getOutlineFields());
                System.out.println("DetailFields:" + appAutoParameter.getDetailFields());
            }
            System.out.println(I18NMessage.get(AppAutoParameters.class, "AppAutoParameters.label6", "\u6d4b\u8bd5 getParametersOfPage(String) \u63a5\u53e3..."));
            appAutoParameters = AppAutoParameters.getAppAutoParameters(string);
            System.out.println(appAutoParameters.toString());
            System.out.println(I18NMessage.get(AppAutoParameters.class, "AppAutoParameters.label7", "\u6d4b\u8bd5 Cache \u673a\u5236..."));
            appAutoParameters = AppAutoParameters.getAppAutoParameters(string);
            System.out.println(appAutoParameters.toString());
            System.out.println(I18NMessage.get(AppAutoParameters.class, "AppAutoParameters.label8", "\u6d4b\u8bd5 reloadAppAutoParameters(String) \u63a5\u53e3"));
            appAutoParameters = AppAutoParameters.reloadAppAutoParameters(string);
            System.out.println(appAutoParameters.toString());
            String string2 = "c:\\dst.xml";
            appAutoParameter = (AppAutoParameter)appAutoParameters.get(0);
            appAutoParameter.setName(I18NMessage.get(AppAutoParameters.class, "AppAutoParameters.label9", "\u6211\u4fee\u6539\u4e00\u4e0b\u770b\u770b"));
            appAutoParameter.setDetailFields("test,test2");
            appAutoParameters.toXMLFile(string2, "model", null);
        }
        catch (Exception exception) {
            System.out.println(I18NMessage.get(AppAutoParameters.class, "AppAutoParameters.label10", "\u6d4b\u8bd5\u5931\u8d25\uff01"));
            exception.printStackTrace();
        }
    }
}

