/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.nav;

import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import java.io.ByteArrayOutputStream;
import java.util.List;

public class RadarTreeCreator {
    private static final char BLANK = ' ';
    private static String ENCODING = "GBK";
    private static final String CA_RADAR = "ca_radar_tree";
    private static final String TYPE_S = "s";
    private String userName;
    private int rightIndex;
    private String type;
    private int parentId;
    private int siteType = 0;
    private boolean addRoot = true;

    public RadarTreeCreator(String string, int n, String string2, int n2) {
        this.userName = string;
        this.rightIndex = n;
        this.type = string2;
        this.parentId = n2;
    }

    public void setAddRoot(boolean bl) {
        this.addRoot = bl;
    }

    public void setEncoding(String string) {
        ENCODING = string;
    }

    public void setSiteType(int n) {
        this.siteType = n;
    }

    public String getTreeInfo() throws Exception {
        if (CA_RADAR.equals(this.userName)) {
            return this.makeTree4Radar();
        }
        User user = User.findByName(this.userName);
        if (user == null) {
            throw new WCMException(200006, "user not found!usernmae=" + this.userName);
        }
        StringBuffer stringBuffer = null;
        if (this.parentId == 0) {
            WebSites webSites = new WebSites(null);
            WCMFilter wCMFilter = new WCMFilter("", "SITETYPE=" + this.siteType, "");
            webSites.open(wCMFilter);
            stringBuffer = new StringBuffer(256 * webSites.size() + 128);
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"");
            stringBuffer.append(ENCODING);
            stringBuffer.append("\"?>");
            if (this.addRoot) {
                stringBuffer.append("<ss>");
            }
            int n = webSites.size();
            for (int i = 0; i < n; ++i) {
                WebSite webSite = (WebSite)webSites.getAt(i);
                if (webSite == null || webSite.isDeleted()) continue;
                stringBuffer.append("<s n=\"");
                stringBuffer.append(CMyString.filterForXML(webSite.getName()));
                stringBuffer.append("\" id=\"");
                stringBuffer.append(webSite.getId());
                stringBuffer.append("\" folder=\"");
                stringBuffer.append(webSite.getChildrenSize(user) > 0);
                stringBuffer.append("\" type=\"");
                stringBuffer.append(webSite.getProperty("SITETYPE"));
                stringBuffer.append("\" />");
            }
            if (this.addRoot) {
                stringBuffer.append("</ss>");
            }
        } else {
            List list = null;
            BaseChannel baseChannel = null;
            baseChannel = TYPE_S.equals(this.type) ? WebSite.findById(this.parentId) : Channel.findById(this.parentId);
            if (baseChannel != null && !baseChannel.isDeleted()) {
                list = baseChannel.getAllChildren(null);
            }
            if (list != null) {
                stringBuffer = new StringBuffer(256 * list.size() + 128);
                stringBuffer.append("<?xml version=\"1.0\" encoding=\"");
                stringBuffer.append(ENCODING);
                stringBuffer.append("\"?>");
                if (this.addRoot) {
                    stringBuffer.append("<cs>");
                }
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    Channel channel = (Channel)list.get(i);
                    if (channel == null || channel.isDeleted() || !AuthServer.hasRight(user, (CMSObj)channel, 64)) continue;
                    stringBuffer.append("<c n=\"");
                    stringBuffer.append(CMyString.filterForXML(channel.getDesc()));
                    stringBuffer.append("\" id=\"");
                    stringBuffer.append(channel.getId());
                    stringBuffer.append("\" folder=\"");
                    stringBuffer.append(channel.getChildrenSize(user) > 0);
                    stringBuffer.append("\" type=\"");
                    stringBuffer.append(channel.getType());
                    stringBuffer.append("\" addable=\"");
                    stringBuffer.append(AuthServer.hasRight(user, (CMSObj)channel, this.rightIndex));
                    stringBuffer.append("\" />");
                }
                if (this.addRoot) {
                    stringBuffer.append("</cs>");
                }
            } else {
                stringBuffer = new StringBuffer(128);
                stringBuffer.append("<?xml version=\"1.0\" encoding=\"");
                stringBuffer.append(ENCODING);
                stringBuffer.append("\"?>");
                stringBuffer.append("<cs />");
            }
        }
        return RadarTreeCreator.encode(stringBuffer.toString());
    }

    private String makeTree4Radar() throws Exception {
        StringBuffer stringBuffer = null;
        if (this.parentId == 0) {
            WebSites webSites = new WebSites(null);
            WCMFilter wCMFilter = new WCMFilter("", "SITETYPE=" + this.siteType, "");
            webSites.open(wCMFilter);
            stringBuffer = new StringBuffer(256 * webSites.size() + 128);
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"");
            stringBuffer.append(ENCODING);
            stringBuffer.append("\"?>");
            stringBuffer.append("<WCMWEBSITES>");
            int n = webSites.size();
            for (int i = 0; i < n; ++i) {
                WebSite webSite = (WebSite)webSites.getAt(i);
                if (webSite == null || webSite.isDeleted()) continue;
                stringBuffer.append("<WCMWEBSITE><PROPERTIES><SITEID>");
                stringBuffer.append(webSite.getId());
                stringBuffer.append("</SITEID><SITENAME><![CDATA[");
                stringBuffer.append(CMyString.filterForXML(webSite.getName()));
                stringBuffer.append("]]></SITENAME><SITEDESC><![CDATA[");
                stringBuffer.append(CMyString.filterForXML(webSite.getDesc()));
                stringBuffer.append("]]></SITEDESC><FOLDER>");
                stringBuffer.append(webSite.getChildrenSize(null) > 0);
                stringBuffer.append("</FOLDER><TYPE>");
                stringBuffer.append(webSite.getProperty("SITETYPE"));
                stringBuffer.append("</TYPE></PROPERTIES></WCMWEBSITE>");
            }
            stringBuffer.append("</WCMWEBSITES>");
        } else {
            List list = null;
            BaseChannel baseChannel = null;
            baseChannel = TYPE_S.equals(this.type) ? WebSite.findById(this.parentId) : Channel.findById(this.parentId);
            if (baseChannel != null && !baseChannel.isDeleted()) {
                list = baseChannel.getAllChildren(null);
            }
            if (list != null) {
                stringBuffer = new StringBuffer(256 * list.size() + 128);
                stringBuffer.append("<?xml version=\"1.0\" encoding=\"");
                stringBuffer.append(ENCODING);
                stringBuffer.append("\"?>");
                stringBuffer.append("<WCMCHANNELS>");
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    Channel channel = (Channel)list.get(i);
                    if (channel == null || channel.isDeleted()) continue;
                    stringBuffer.append("<WCMCHANNEL><PROPERTIES><CHANNELID>");
                    stringBuffer.append(channel.getId());
                    stringBuffer.append("</CHANNELID><CHNLNAME><![CDATA[");
                    stringBuffer.append(CMyString.filterForXML(channel.getName()));
                    stringBuffer.append("]]></CHNLNAME><CHNLDESC><![CDATA[");
                    stringBuffer.append(CMyString.filterForXML(channel.getDesc()));
                    stringBuffer.append("]]></CHNLDESC><FOLDER>");
                    stringBuffer.append(channel.getChildrenSize(null) > 0);
                    stringBuffer.append("</FOLDER><TYPE>");
                    stringBuffer.append(channel.getType());
                    stringBuffer.append("</TYPE></PROPERTIES></WCMCHANNEL>");
                }
                stringBuffer.append("</WCMCHANNELS>");
            } else {
                stringBuffer = new StringBuffer(128);
                stringBuffer.append("<?xml version=\"1.0\" encoding=\"");
                stringBuffer.append(ENCODING);
                stringBuffer.append("\"?>");
                stringBuffer.append("<WCMCHANNELS />");
            }
        }
        return stringBuffer.toString();
    }

    static String encode(String string) throws Exception {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("no need to encode an empty string?");
        }
        byte[] byArray = string.getBytes(ENCODING);
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        byte[] byArray2 = new byte[3];
        int n = byArray.length;
        for (int i = 0; i < n; i += 3) {
            int n2;
            for (n2 = 0; n2 < 3 && i + n2 < n; ++n2) {
                byArray2[n2] = byArray[i + n2];
            }
            n2 = (byArray2[0] >>> 2 & 0x3F) + 32;
            int n3 = (byArray2[0] << 4 & 0x30 | byArray2[1] >>> 4 & 0xF) + 32;
            int n4 = (byArray2[1] << 2 & 0x3C | byArray2[2] >>> 6 & 3) + 32;
            int n5 = (byArray2[2] & 0x3F) + 32;
            stringBuffer.append((char)n2);
            stringBuffer.append((char)n3);
            stringBuffer.append((char)n4);
            stringBuffer.append((char)n5);
            for (int j = 0; j < 3; ++j) {
                byArray2[j] = 0;
            }
        }
        return stringBuffer.toString();
    }

    String standardEncode(String string) {
        byte[] byArray = string.getBytes();
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 5);
        int n = 0;
        int n2 = byArray.length;
        for (int i = 0; i < n2; i += 45) {
            int n3 = 0;
            n3 = i + 45 > n2 ? n2 - i : 45;
            stringBuffer.append((char)(n3 + 32));
            for (int j = 0; j < n3 && n < n2; j += 3) {
                byte by = 0;
                byte by2 = 0;
                byte by3 = 0;
                by = byArray[n++];
                if (n < n2) {
                    by2 = byArray[n++];
                }
                if (n < n2) {
                    by3 = byArray[n++];
                }
                int n4 = by >>> 2 & 0x3F;
                int n5 = by << 4 & 0x30 | by2 >>> 4 & 0xF;
                int n6 = by2 << 2 & 0x3C | by3 >>> 6 & 3;
                int n7 = by3 & 0x3F;
                stringBuffer.append((char)(n4 + 32));
                stringBuffer.append((char)(n5 + 32));
                stringBuffer.append((char)(n6 + 32));
                stringBuffer.append((char)(n7 + 32));
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String decode(String string) throws Exception {
        String string2;
        block10: {
            if (string == null || string.trim().length() == 0) {
                throw new IllegalArgumentException("no need to decode an empty string?");
            }
            byte[] byArray = string.getBytes();
            if (byArray.length % 4 > 0) {
                throw new IllegalArgumentException("Bad data!");
            }
            byte[] byArray2 = new byte[4];
            ByteArrayOutputStream byteArrayOutputStream = null;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                int n = byArray.length;
                for (int i = 0; i < n; i += 4) {
                    int n2;
                    for (n2 = 0; n2 < 4; ++n2) {
                        byArray2[n2] = (byte)(byArray[i + n2] - 32);
                    }
                    n2 = (byArray2[0] << 2 & 0xFC | byArray2[1] >>> 4 & 3) & 0xFF;
                    int n3 = (byArray2[1] << 4 & 0xF0 | byArray2[2] >>> 2 & 0xF) & 0xFF;
                    int n4 = (byArray2[2] << 6 & 0xC0 | byArray2[3] & 0x3F) & 0xFF;
                    byteArrayOutputStream.write(n2);
                    if (n3 > 0) {
                        byteArrayOutputStream.write(n3);
                    }
                    if (n4 <= 0) continue;
                    byteArrayOutputStream.write(n4);
                }
                byteArrayOutputStream.flush();
                string2 = new String(byteArrayOutputStream.toByteArray(), ENCODING);
                Object var10_10 = null;
                if (byteArrayOutputStream == null) break block10;
            }
            catch (Throwable throwable) {
                block11: {
                    Object var10_11 = null;
                    if (byteArrayOutputStream == null) break block11;
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            try {
                byteArrayOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string2;
    }
}

